/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.IllegalTimeValue;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GeoDate
extends Date
implements Serializable {
    private int[] max_day_ = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private boolean splitDone_;
    private int yearday_;
    private int dayofweek_;
    private int year_;
    private int month_;
    private int day_;
    private int hour_;
    private int minute_;
    private int second_;
    private int msec_;
    private int MSec_;
    private int JDay_;
    private boolean EPICTimeDone_;
    private boolean relativeTime_ = false;
    private static Calendar cal_ = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    public static final int DAYS = 1;
    public static final int MONTHS = 2;
    public static final int YEARS = 4;
    public static final int HOURS = 5;
    public static final int MINUTES = 6;
    public static final int SECONDS = 7;
    public static final int MSEC = 8;
    public static final long MSECS_IN_DAY = 86400000L;

    public GeoDate() {
    }

    public GeoDate(String string, String string2) throws IllegalTimeValue {
        ParsePosition parsePosition = new ParsePosition(0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setCalendar(cal_);
        Date date = ((DateFormat)simpleDateFormat).parse(string, parsePosition);
        if (date == null) {
            throw new IllegalTimeValue("Parse error: " + string + ", " + string2);
        }
        this.setTime(date.getTime());
    }

    public GeoDate(GeoDate geoDate) {
        super(geoDate.getTime());
    }

    public GeoDate(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalTimeValue {
        this.set(n, n2, n3, n4, n5, n6, n7);
    }

    public GeoDate(Date date) {
        this.setTime(date.getTime());
    }

    public GeoDate(int n, int n2) {
        this.set(n, n2);
    }

    public GeoDate(long l) {
        this.setTime(l);
    }

    public void setRelativeTime(boolean bl) {
        this.relativeTime_ = bl;
    }

    public boolean isRelativeTime() {
        return this.relativeTime_;
    }

    public void set(int n, int n2) {
        int n3;
        if (n > 2299161) {
            double d = ((double)(n - 1867216) - 0.25) / 36524.25;
            n3 = n + 1 + (int)d - (int)(0.25 * d);
        } else {
            n3 = n;
        }
        int n4 = n3 + 1524;
        int n5 = (int)(6680.0 + ((double)(n4 - 2439870) - 122.1) / 365.25);
        int n6 = (int)((double)(365 * n5) + 0.25 * (double)n5);
        int n7 = (int)((double)(n4 - n6) / 30.6001);
        int n8 = n4 - n6 - (int)(30.6001 * (double)n7);
        int n9 = n7 - 1;
        if (n9 > 12) {
            n9 -= 12;
        }
        int n10 = n5 - 4715;
        if (n9 > 2) {
            --n10;
        }
        if (n10 <= 0) {
            --n10;
        }
        n3 = n2 / 1000;
        int n11 = n3 / 3600;
        int n12 = (n3 - n11 * 3600) / 60;
        double d = (double)(n2 - (n11 * 3600 + n12 * 60) * 1000) / 1000.0;
        int n13 = (int)d;
        n2 = (int)(d * 1000.0) % 1000;
        try {
            this.set(n9, n8, n10, n11, n12, n13, n2);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalTimeValue {
        int n8 = n3 % 4 != 0 ? 0 : (n3 % 400 == 0 ? 1 : (n3 % 100 == 0 ? 0 : 1));
        this.max_day_[1] = 28 + n8;
        if (n > 12 || n < 1) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of month out of range");
        }
        if (n2 > this.max_day_[n - 1] || n2 < 1) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of day out of range");
        }
        if (n4 >= 24 || n4 < 0) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of hour out of range");
        }
        if (n5 >= 60 || n5 < 0) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of minute out of range");
        }
        if (n6 >= 60 || n6 < 0) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of second out of range");
        }
        if (n7 >= 1000 || n7 < 0) {
            this.setTime(0L);
            throw new IllegalTimeValue("value of msec out of range");
        }
        cal_.clear();
        cal_.set(n3, n - 1, n2, n4, n5, n6);
        this.setTime(cal_.getTime().getTime() + (long)n7);
        this.splitDone_ = false;
        this.EPICTimeDone_ = false;
    }

    public int getDaysInMonth() {
        int n = cal_.get(1);
        int n2 = n % 4 != 0 ? 0 : (n % 400 == 0 ? 1 : (n % 100 == 0 ? 0 : 1));
        this.max_day_[1] = 28 + n2;
        return this.max_day_[this.month_ - 1];
    }

    public void now() {
        Date date = new Date();
        this.setTime(date.getTime());
    }

    public GeoDate add(GeoDate geoDate) {
        GeoDate geoDate2 = new GeoDate();
        long l = this.getTime() + geoDate.getTime();
        geoDate2.splitDone_ = false;
        geoDate2.EPICTimeDone_ = false;
        geoDate2.setTime(l);
        return geoDate2;
    }

    public GeoDate subtract(GeoDate geoDate) {
        GeoDate geoDate2 = new GeoDate();
        long l = this.getTime() - geoDate.getTime();
        geoDate2.splitDone_ = false;
        geoDate2.EPICTimeDone_ = false;
        geoDate2.setTime(l);
        geoDate2.setRelativeTime(true);
        return geoDate2;
    }

    public GeoDate divide(double d) {
        GeoDate geoDate = new GeoDate();
        if (d == 0.0) {
            return null;
        }
        geoDate.setTime((long)((double)this.getTime() / d));
        geoDate.splitDone_ = false;
        geoDate.EPICTimeDone_ = false;
        geoDate.setRelativeTime(true);
        return geoDate;
    }

    void splitTimeFormat() {
        if (this.splitDone_) {
            return;
        }
        cal_.setTime(this);
        this.day_ = cal_.get(5);
        this.month_ = cal_.get(2) + 1;
        this.year_ = cal_.get(1);
        this.hour_ = cal_.get(11);
        this.minute_ = cal_.get(12);
        this.second_ = cal_.get(13);
        this.msec_ = cal_.get(14);
        this.dayofweek_ = cal_.get(7) - 1;
        this.yearday_ = cal_.get(6);
        this.splitDone_ = true;
    }

    public GeoDate increment(float f, int n) {
        return this.increment((double)f, n);
    }

    public GeoDate increment(double d, int n) {
        int n2 = (int)d;
        double d2 = d - (double)n2;
        long l = this.getTime();
        switch (n) {
            case 8: {
                this.setTime(l += (long)d);
                break;
            }
            case 7: {
                this.setTime(l += (long)(d * 1000.0));
                break;
            }
            case 6: {
                this.setTime(l += (long)(d * 60000.0));
                break;
            }
            case 5: {
                this.setTime(l += (long)(d * 3600000.0));
                break;
            }
            case 1: {
                this.setTime(l += (long)(d * 8.64E7));
                break;
            }
            case 2: {
                this.splitTimeFormat();
                this.month_ += n2;
                this.year_ += (this.month_ - 1) / 12;
                this.month_ -= (this.month_ - 1) / 12 * 12;
                if (this.month_ == 0) {
                    this.month_ = 1;
                }
                int n3 = this.year_ % 4 != 0 ? 0 : (this.year_ % 400 == 0 ? 1 : (this.year_ % 100 == 0 ? 0 : 1));
                this.max_day_[1] = 28 + n3;
                this.day_ += (int)(d2 * (double)this.max_day_[this.month_ - 1]);
                if (this.day_ > this.max_day_[this.month_ - 1]) {
                    this.day_ -= this.max_day_[this.month_ - 1];
                    ++this.month_;
                    this.year_ += (this.month_ - 1) / 12;
                    this.month_ -= (this.month_ - 1) / 12 * 12;
                    if (this.month_ == 0) {
                        this.month_ = 1;
                    }
                }
                try {
                    this.set(this.month_, this.day_, this.year_, this.hour_, this.minute_, this.second_, this.msec_);
                }
                catch (IllegalTimeValue illegalTimeValue) {
                    System.err.println(illegalTimeValue);
                }
                break;
            }
            case 4: {
                this.splitTimeFormat();
                this.year_ += n2;
                int n4 = this.year_ % 4 != 0 ? 0 : (this.year_ % 400 == 0 ? 1 : (this.year_ % 100 == 0 ? 0 : 1));
                this.max_day_[1] = 28 + n4;
                if (this.day_ > this.max_day_[this.month_ - 1]) {
                    this.day_ = this.max_day_[this.month_ - 1];
                }
                try {
                    this.set(this.month_, this.day_, this.year_, this.hour_, this.minute_, this.second_, this.msec_);
                }
                catch (IllegalTimeValue illegalTimeValue) {
                    System.err.println(illegalTimeValue);
                }
                this.setTime(this.getTime() + (long)(d2 * 365.25) * 86400000L);
            }
        }
        this.splitDone_ = false;
        this.EPICTimeDone_ = false;
        return this;
    }

    public GeoDate decrement(float f, int n) {
        return this.decrement((double)f, n);
    }

    public GeoDate decrement(double d, int n) {
        int n2 = (int)d;
        double d2 = d - (double)n2;
        long l = this.getTime();
        switch (n) {
            case 8: {
                this.setTime(l -= (long)d);
                break;
            }
            case 7: {
                this.setTime(l -= (long)(d * 1000.0));
                break;
            }
            case 6: {
                this.setTime(l -= (long)(d * 60000.0));
                break;
            }
            case 5: {
                this.setTime(l -= (long)(d * 3600000.0));
                break;
            }
            case 1: {
                this.setTime(l -= (long)(d * 8.64E7));
                break;
            }
            case 2: {
                this.splitTimeFormat();
                this.month_ -= n2;
                if (this.month_ <= 0) {
                    this.year_ -= (this.month_ - 1) / 12 + 1;
                    this.month_ += (this.month_ - 1) / 12 * 12 + 12;
                }
                if (this.month_ == 0) {
                    this.month_ = 12;
                }
                int n3 = this.year_ % 4 != 0 ? 0 : (this.year_ % 400 == 0 ? 1 : (this.year_ % 100 == 0 ? 0 : 1));
                this.max_day_[1] = 28 + n3;
                this.day_ -= (int)(d2 * (double)this.max_day_[this.month_ - 1]);
                if (this.day_ > this.max_day_[this.month_ - 1]) {
                    this.day_ -= this.max_day_[this.month_ - 1];
                    --this.month_;
                    if (this.month_ <= 0) {
                        this.year_ -= (this.month_ - 1) / 12 + 1;
                        this.month_ += (this.month_ - 1) / 12 * 12;
                    }
                    if (this.month_ == 0) {
                        this.month_ = 12;
                    }
                }
                try {
                    this.set(this.month_, this.day_, this.year_, this.hour_, this.minute_, this.second_, this.msec_);
                }
                catch (IllegalTimeValue illegalTimeValue) {
                    System.err.println(illegalTimeValue);
                }
                break;
            }
            case 4: {
                this.splitTimeFormat();
                this.year_ -= n2;
                int n4 = this.year_ % 4 != 0 ? 0 : (this.year_ % 400 == 0 ? 1 : (this.year_ % 100 == 0 ? 0 : 1));
                this.max_day_[1] = 28 + n4;
                if (this.day_ > this.max_day_[this.month_ - 1]) {
                    this.day_ = this.max_day_[this.month_ - 1];
                }
                try {
                    this.set(this.month_, this.day_, this.year_, this.hour_, this.minute_, this.second_, this.msec_);
                }
                catch (IllegalTimeValue illegalTimeValue) {
                    System.err.println(illegalTimeValue);
                }
                this.setTime(this.getTime() - (long)(d2 * 365.25) * 86400000L);
            }
        }
        this.splitDone_ = false;
        this.EPICTimeDone_ = false;
        return this;
    }

    public double offset(GeoDate geoDate) {
        double d = (double)(this.getTime() - geoDate.getTime()) / 8.64E7;
        return d;
    }

    public void setYearYearDay(int n, int n2) {
        try {
            this.set(1, 1, n, 0, 0, 0, 0);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            System.err.println(illegalTimeValue);
        }
        this.setTime(this.getTime() + (long)(n2 - 1) * 86400000L);
    }

    public Calendar getCalendar() {
        cal_.setTime(this);
        return cal_;
    }

    public int getYearday() {
        this.splitTimeFormat();
        return this.yearday_;
    }

    public int getYear() {
        this.splitTimeFormat();
        return this.year_;
    }

    public int getGMTYear() {
        this.splitTimeFormat();
        return this.year_;
    }

    public int getMonth() {
        this.splitTimeFormat();
        return this.month_;
    }

    public int getGMTMonth() {
        this.splitTimeFormat();
        return this.month_;
    }

    public int getDay() {
        this.splitTimeFormat();
        return this.day_;
    }

    public int getGMTDay() {
        this.splitTimeFormat();
        return this.day_;
    }

    public int getHours() {
        this.splitTimeFormat();
        return this.hour_;
    }

    public int getGMTHours() {
        this.splitTimeFormat();
        return this.hour_;
    }

    public int getMinutes() {
        this.splitTimeFormat();
        return this.minute_;
    }

    public int getGMTMinutes() {
        this.splitTimeFormat();
        return this.minute_;
    }

    public double getSecondss() {
        this.splitTimeFormat();
        return this.second_;
    }

    public double getGMTSeconds() {
        this.splitTimeFormat();
        return this.second_;
    }

    public int getJDay() {
        this.splitTimeFormat();
        this.computeEPICTime();
        return this.JDay_;
    }

    public int getMSec() {
        this.splitTimeFormat();
        this.computeEPICTime();
        return this.MSec_;
    }

    private void computeEPICTime() {
        int n;
        int n2;
        boolean bl;
        if (this.EPICTimeDone_) {
            return;
        }
        int n3 = 588829;
        int n4 = this.year_;
        int n5 = this.month_;
        int n6 = this.day_;
        int n7 = this.hour_;
        int n8 = this.minute_;
        int n9 = this.second_;
        int n10 = this.msec_;
        boolean bl2 = n4 % 4 != 0 ? false : (n4 % 400 == 0 ? true : (bl = n4 % 100 != 0));
        if (n4 < 0) {
            ++n4;
        }
        if (n5 > 2) {
            n2 = n4;
            n = n5 + 1;
        } else {
            n2 = n4 - 1;
            n = n5 + 13;
        }
        int n11 = (int)(Math.floor(365.25 * (double)n2) + Math.floor(30.6001 * (double)n) + (double)n6 + 1720995.0);
        if ((long)n6 + 31L * ((long)n5 + 12L * (long)n4) >= (long)n3) {
            int n12 = (int)(0.01 * (double)n2);
            n11 += 2 - n12 + (int)(0.25 * (double)n12);
        }
        this.JDay_ = n11;
        this.MSec_ = (int)(((long)n7 * 3600L + (long)n8 * 60L) * 1000L + (long)n9 * 1000L + (long)n10);
        this.EPICTimeDone_ = true;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        simpleDateFormat.setCalendar(cal_);
        return simpleDateFormat.format(this);
    }

    public String toString(String string) {
        if (string.equals("decade")) {
            this.splitTimeFormat();
            return Integer.toString(this.year_ / 10 * 10);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setCalendar(cal_);
        return simpleDateFormat.format(this);
    }

    public boolean isMissing() {
        return this.getTime() == Long.MIN_VALUE;
    }

    public int compareTo(GeoDate geoDate) {
        if (this.getTime() < geoDate.getTime()) {
            return -1;
        }
        if (this.getTime() == geoDate.getTime()) {
            return 0;
        }
        return 1;
    }
}

