/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.AxisNotFoundException;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.LineKey;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Logo;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.swing.JGraphicLayout;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Domain;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.Units;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Enumeration;

public class JLineProfileLayout
extends JGraphicLayout {
    Logo logo_;
    LineKey lineKey_;
    int layerCount_;
    boolean zUp_ = true;
    Layer firstLayer_;
    boolean inZoom_ = false;
    double xSize_ = XSIZE_;
    double xMin_ = XMIN_;
    double xMax_ = XMAX_;
    double ySize_ = YSIZE_;
    double yMin_ = YMIN_;
    double yMax_ = YMAX_;
    double mainTitleHeight_ = MAIN_TITLE_HEIGHT_;
    double titleHeight_ = TITLE_HEIGHT_;
    double labelHeight_ = LABEL_HEIGHT_;
    double warnHeight_ = WARN_HEIGHT_;
    double keyHeight_ = KEY_HEIGHT_;
    double xKeySize_ = XKEYSIZE_;
    double yKeySize_ = YKEYSIZE_;
    Color paneColor_ = PANE_COLOR;
    Color keyPaneColor_ = KEYPANE_COLOR;
    private static final Color[] colorList_ = new Color[]{Color.blue, Color.cyan, Color.green, Color.orange.darker(), Color.red, Color.magenta, Color.black, Color.gray};
    private static final int[] markList_ = new int[]{1, 2, 9, 15, 10, 24, 11, 44};

    public JLineProfileLayout() {
        this("", null, false);
    }

    public JLineProfileLayout(String string, Image image, boolean bl) {
        super(string, image, new Dimension(400, 300));
        int n;
        double d;
        Layer layer;
        this.setOpaque(true);
        this.setLayout(new StackedLayout());
        this.setBackground(this.paneColor_);
        this.firstLayer_ = layer = new Layer("Layer 1", new Dimension2D(this.xSize_, this.ySize_));
        this.add((Component)layer, 0);
        this.lineKey_ = new LineKey();
        this.lineKey_.setSelectable(false);
        this.lineKey_.setId("Line Key");
        this.lineKey_.setVAlign(0);
        if (bl) {
            this.lineKey_.setHAlign(0);
            this.lineKey_.setBorderStyle(2);
            this.lineKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
            int n2 = 400;
            int n3 = (int)((double)n2 / this.xKeySize_ * this.yKeySize_);
            this.keyPane_ = new JPane("KeyPane", new Dimension(n2, n3));
            this.keyPane_.setOpaque(true);
            this.keyPane_.setLayout(new StackedLayout());
            this.keyPane_.setBackground(this.keyPaneColor_);
            Layer layer2 = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
            this.keyPane_.add(layer2);
            layer2.addChild(this.lineKey_);
        } else {
            this.lineKey_.setHAlign(2);
            this.lineKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.01, this.ySize_));
            layer.addChild(this.lineKey_);
        }
        if (this.iconImage_ != null) {
            this.logo_ = new Logo(new Point2D.Double(0.0, this.ySize_), 0, 0);
            this.logo_.setImage(this.iconImage_);
            layer.addChild(this.logo_);
            Rectangle rectangle = this.logo_.getBounds();
            d = layer.getXDtoP(rectangle.x + rectangle.width) + 0.05;
            n = 0;
        } else {
            d = (this.xMin_ + this.xMax_) * 0.5;
            n = 1;
        }
        double d2 = this.ySize_ - (double)1.2f * this.mainTitleHeight_;
        Font font = new Font("Helvetica", 1, 14);
        this.mainTitle_ = new SGLabel("Line Profile Title", "Profile Plot", this.mainTitleHeight_, new Point2D.Double(d, d2), 2, n);
        this.mainTitle_.setFont(font);
        layer.addChild(this.mainTitle_);
        Font font2 = new Font("Helvetica", 0, 10);
        this.title2_ = new SGLabel("Warning", "Warning: Browse image only", this.warnHeight_, new Point2D.Double(d, d2 -= (double)1.2f * this.warnHeight_), 2, n);
        this.title2_.setFont(font2);
        layer.addChild(this.title2_);
        this.title3_ = new SGLabel("Warning 2", "Verify accuracy of plot before research use", this.warnHeight_, new Point2D.Double(d, d2 -= (double)1.1f * this.warnHeight_), 2, n);
        this.title3_.setFont(font2);
        layer.addChild(this.title3_);
        this.title3_.setSelectable(false);
        this.layerCount_ = 0;
        CartesianGraph cartesianGraph = new CartesianGraph("Profile Graph 1");
        LinearTransform linearTransform = new LinearTransform(this.xMin_, this.xMax_, 10.0, 20.0);
        LinearTransform linearTransform2 = new LinearTransform(this.yMin_, this.yMax_, 400.0, 0.0);
        cartesianGraph.setXTransform(linearTransform);
        cartesianGraph.setYTransform(linearTransform2);
        Font font3 = new Font("Helvetica", 2, 14);
        PlainAxis plainAxis = new PlainAxis("Bottom Axis");
        plainAxis.setRangeU(new Range2D(10.0, 20.0));
        plainAxis.setDeltaU(2.0);
        plainAxis.setNumberSmallTics(0);
        plainAxis.setLabelHeightP(this.labelHeight_);
        plainAxis.setLocationU(new Point2D.Double(10.0, 400.0));
        plainAxis.setLabelFont(font3);
        cartesianGraph.addXAxis(plainAxis);
        PlainAxis plainAxis2 = new PlainAxis("Left Axis");
        plainAxis2.setRangeU(new Range2D(400.0, 0.0));
        plainAxis2.setDeltaU(-50.0);
        plainAxis2.setNumberSmallTics(0);
        plainAxis2.setLabelHeightP(this.labelHeight_);
        plainAxis2.setLocationU(new Point2D.Double(10.0, 400.0));
        plainAxis2.setLabelFont(font3);
        cartesianGraph.addYAxis(plainAxis2);
        layer.setGraph(cartesianGraph);
    }

    public String getLocationSummary(SGTData sGTData) {
        return "";
    }

    public void addData(Collection collection) {
        this.addData(collection, null);
    }

    public void addData(Collection collection, String string) {
        for (int i = 0; i < collection.size(); ++i) {
            SGTLine sGTLine = (SGTLine)collection.elementAt(i);
            this.addData(sGTLine, sGTLine.getTitle());
        }
    }

    public void addData(SGTData sGTData) {
        this.addData(sGTData, null);
    }

    public void addData(SGTData sGTData, String string) {
        PlainAxis plainAxis = null;
        PlainAxis plainAxis2 = null;
        Range2D range2D = null;
        Range2D range2D2 = null;
        Point2D.Double double_ = null;
        boolean bl = true;
        if (this.data_.size() == 0) {
            this.setBaseUnit(Units.getBaseUnit(((SGTLine)sGTData).getXMetaData()));
        }
        sGTData = Units.convertToBaseUnit(sGTData, this.getBaseUnit(), 0);
        if (this.data_.size() == 0) {
            Serializable serializable;
            Layer layer;
            super.addData(sGTData);
            SGTData sGTData2 = (SGTData)this.data_.firstElement();
            Range2D range2D3 = this.findRange((SGTLine)sGTData2, 1);
            Range2D range2D4 = this.findRange((SGTLine)sGTData2, 2);
            this.zUp_ = ((SGTLine)sGTData2).getYMetaData().isReversed();
            if (Double.isNaN(range2D3.start) || Double.isNaN(range2D4.start)) {
                bl = false;
            }
            if (bl) {
                if (!this.zUp_) {
                    double d = range2D4.end;
                    range2D4.end = range2D4.start;
                    range2D4.start = d;
                }
                range2D = Graph.computeRange(range2D3, 6);
                range2D2 = Graph.computeRange(range2D4, 6);
                double_ = new Point2D.Double(range2D.start, range2D2.start);
            }
            String string2 = " (" + ((SGTLine)sGTData2).getXMetaData().getUnits() + ")";
            String string3 = " (" + ((SGTLine)sGTData2).getYMetaData().getUnits() + ")";
            try {
                layer = this.getLayer("Layer 1");
            }
            catch (LayerNotFoundException layerNotFoundException) {
                return;
            }
            CartesianGraph cartesianGraph = (CartesianGraph)layer.getGraph();
            try {
                serializable = new Font("Helvetica", 0, 14);
                plainAxis = (PlainAxis)cartesianGraph.getXAxis("Bottom Axis");
                if (bl) {
                    plainAxis.setRangeU(range2D);
                    plainAxis.setDeltaU(range2D.delta);
                    plainAxis.setLocationU(double_);
                }
                SGLabel sGLabel = new SGLabel("xaxis title", string2, new Point2D.Double(0.0, 0.0));
                sGLabel.setFont((Font)serializable);
                sGLabel.setHeightP(this.titleHeight_);
                plainAxis.setTitle(sGLabel);
                plainAxis2 = (PlainAxis)cartesianGraph.getYAxis("Left Axis");
                if (bl) {
                    plainAxis2.setRangeU(range2D2);
                    plainAxis2.setDeltaU(range2D2.delta);
                    plainAxis2.setLocationU(double_);
                }
                SGLabel sGLabel2 = new SGLabel("yaxis title", string3, new Point2D.Double(0.0, 0.0));
                sGLabel2.setFont((Font)serializable);
                sGLabel2.setHeightP(this.titleHeight_);
                plainAxis2.setTitle(sGLabel2);
            }
            catch (AxisNotFoundException axisNotFoundException) {
                // empty catch block
            }
            if (bl) {
                LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
                linearTransform.setRangeU(range2D);
                LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getYTransform();
                linearTransform2.setRangeU(range2D2);
            }
            LineAttribute lineAttribute = ((SGTLine)sGTData2).getYArray().length >= 2 ? new LineAttribute(0, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]) : new LineAttribute(4, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]);
            cartesianGraph.setData(sGTData2, lineAttribute);
            SGLabel sGLabel = string == null ? new SGLabel("line title", string2, new Point2D.Double(0.0, 0.0)) : new SGLabel("line title", string, new Point2D.Double(0.0, 0.0));
            sGLabel.setHeightP(this.keyHeight_);
            this.lineKey_.addLineGraph((LineCartesianRenderer)cartesianGraph.getRenderer(), sGLabel);
            if (this.keyPane_ != null) {
                serializable = this.keyPane_.getVisibleRect();
                int n = ((Rectangle)serializable).height / this.lineKey_.getRowHeight();
                this.keyPane_.setScrollableUnitIncrement(1, this.lineKey_.getRowHeight());
                this.keyPane_.setScrollableBlockIncrement(((Rectangle)serializable).width, this.lineKey_.getRowHeight() * n);
            }
        } else {
            Object object;
            if (((SGTLine)sGTData).getYMetaData().isReversed() != this.zUp_) {
                object = this.flipZ(sGTData);
                sGTData = object;
            }
            super.addData(sGTData);
            bl = false;
            ++this.layerCount_;
            if (this.isOverlayed()) {
                SGLabel sGLabel;
                Range2D range2D5;
                Layer layer;
                try {
                    layer = this.getLayer("Layer 1");
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    return;
                }
                CartesianGraph cartesianGraph = (CartesianGraph)layer.getGraph();
                LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
                LinearTransform linearTransform3 = (LinearTransform)cartesianGraph.getYTransform();
                try {
                    plainAxis = (PlainAxis)cartesianGraph.getXAxis("Bottom Axis");
                    plainAxis2 = (PlainAxis)cartesianGraph.getYAxis("Left Axis");
                }
                catch (AxisNotFoundException axisNotFoundException) {
                    // empty catch block
                }
                if (!this.inZoom_) {
                    object = new Range2D();
                    range2D5 = new Range2D();
                    boolean bl2 = true;
                    Enumeration enumeration = this.data_.elements();
                    while (enumeration.hasMoreElements()) {
                        SGTData sGTData3 = (SGTData)enumeration.nextElement();
                        Range2D range2D6 = this.findRange((SGTLine)sGTData3, 1);
                        Range2D range2D7 = this.findRange((SGTLine)sGTData3, 2);
                        if (!((SGTLine)sGTData3).getYMetaData().isReversed()) {
                            double d = range2D7.start;
                            range2D7.start = range2D7.end;
                            range2D7.end = d;
                        }
                        if (bl2) {
                            if (Double.isNaN(range2D6.start) || Double.isNaN(range2D7.start)) {
                                bl2 = true;
                                continue;
                            }
                            bl2 = false;
                            bl = true;
                            object = new Range2D(range2D6.start, range2D6.end);
                            range2D5 = new Range2D(range2D7.start, range2D7.end);
                            continue;
                        }
                        if (Double.isNaN(range2D6.start) || Double.isNaN(range2D7.start)) continue;
                        bl = true;
                        ((Range2D)object).start = Math.min(((Range2D)object).start, range2D6.start);
                        ((Range2D)object).end = Math.max(((Range2D)object).end, range2D6.end);
                        if (!((SGTLine)sGTData3).getYMetaData().isReversed()) {
                            range2D5.start = Math.max(range2D5.start, range2D7.start);
                            range2D5.end = Math.min(range2D5.end, range2D7.end);
                            continue;
                        }
                        range2D5.start = Math.min(range2D5.start, range2D7.start);
                        range2D5.end = Math.max(range2D5.end, range2D7.end);
                    }
                    if (bl) {
                        range2D = Graph.computeRange((Range2D)object, 6);
                        range2D2 = Graph.computeRange(range2D5, 6);
                        double_ = new Point2D.Double(range2D.start, range2D2.start);
                        plainAxis.setRangeU(range2D);
                        plainAxis.setDeltaU(range2D.delta);
                        plainAxis.setLocationU(double_);
                        plainAxis2.setRangeU(range2D2);
                        plainAxis2.setDeltaU(range2D2.delta);
                        plainAxis2.setLocationU(double_);
                    }
                    if (bl) {
                        linearTransform.setRangeU(range2D);
                        linearTransform3.setRangeU(range2D2);
                    }
                }
                Layer layer2 = new Layer("Layer " + (this.layerCount_ + 1), new Dimension2D(this.xSize_, this.ySize_));
                CartesianGraph cartesianGraph2 = new CartesianGraph("Graph " + (this.layerCount_ + 1), linearTransform, linearTransform3);
                if (this.inZoom_) {
                    object = plainAxis.getRangeU();
                    range2D5 = plainAxis2.getRangeU();
                    cartesianGraph2.setClip(((Range2D)object).start, ((Range2D)object).end, range2D5.start, range2D5.end);
                    cartesianGraph2.setClipping(true);
                }
                this.add((Component)layer2, 0);
                layer2.setGraph(cartesianGraph2);
                layer2.invalidate();
                this.validate();
                LineAttribute lineAttribute = ((SGTLine)sGTData).getXArray().length >= 2 ? new LineAttribute(0, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]) : new LineAttribute(4, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]);
                cartesianGraph2.setData(sGTData, lineAttribute);
                if (string == null) {
                    String string4 = ((SGTLine)sGTData).getXMetaData().getName();
                    sGLabel = new SGLabel("line title", string4, new Point2D.Double(0.0, 0.0));
                } else {
                    sGLabel = new SGLabel("line title", string, new Point2D.Double(0.0, 0.0));
                }
                sGLabel.setHeightP(this.keyHeight_);
                this.lineKey_.addLineGraph((LineCartesianRenderer)cartesianGraph2.getRenderer(), sGLabel);
                if (this.keyPane_ != null) {
                    object = this.keyPane_.getVisibleRect();
                    int n = ((Rectangle)object).height / this.lineKey_.getRowHeight();
                    this.keyPane_.setScrollableUnitIncrement(1, this.lineKey_.getRowHeight());
                    this.keyPane_.setScrollableBlockIncrement(((Rectangle)object).width, this.lineKey_.getRowHeight() * n);
                }
            }
        }
    }

    private SGTData flipZ(SGTData sGTData) {
        SimpleLine simpleLine = null;
        SGTLine sGTLine = (SGTLine)sGTData;
        double[] dArray = sGTLine.getYArray();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = -dArray[i];
        }
        simpleLine = new SimpleLine(sGTLine.getXArray(), dArray2, sGTLine.getTitle());
        SGTMetaData sGTMetaData = sGTLine.getYMetaData();
        SGTMetaData sGTMetaData2 = new SGTMetaData(sGTMetaData.getName(), sGTMetaData.getUnits(), !sGTMetaData.isReversed(), sGTMetaData.isModulo());
        sGTMetaData2.setModuloValue(sGTMetaData.getModuloValue());
        sGTMetaData2.setModuloTime(sGTMetaData.getModuloTime());
        simpleLine.setXMetaData(sGTLine.getXMetaData());
        simpleLine.setYMetaData(sGTMetaData2);
        return simpleLine;
    }

    public void resetZoom() {
        boolean bl = false;
        this.inZoom_ = false;
        Range2D range2D = new Range2D();
        Range2D range2D2 = new Range2D();
        boolean bl2 = true;
        Enumeration enumeration = this.data_.elements();
        while (enumeration.hasMoreElements()) {
            SGTData sGTData = (SGTData)enumeration.nextElement();
            Range2D range2D3 = this.findRange((SGTLine)sGTData, 1);
            Range2D range2D4 = this.findRange((SGTLine)sGTData, 2);
            if (!((SGTLine)sGTData).getYMetaData().isReversed()) {
                double d = range2D4.start;
                range2D4.start = range2D4.end;
                range2D4.end = d;
            }
            if (bl2) {
                if (Double.isNaN(range2D3.start) || Double.isNaN(range2D4.start)) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                bl = true;
                range2D = new Range2D(range2D3.start, range2D3.end);
                range2D2 = new Range2D(range2D4.start, range2D4.end);
                continue;
            }
            if (Double.isNaN(range2D3.start) || Double.isNaN(range2D4.start)) continue;
            bl = true;
            range2D.start = Math.min(range2D.start, range2D3.start);
            range2D.end = Math.max(range2D.end, range2D3.end);
            if (!((SGTLine)sGTData).getYMetaData().isReversed()) {
                range2D2.start = Math.max(range2D2.start, range2D4.start);
                range2D2.end = Math.min(range2D2.end, range2D4.end);
                continue;
            }
            range2D2.start = Math.min(range2D2.start, range2D4.start);
            range2D2.end = Math.max(range2D2.end, range2D4.end);
        }
        if (bl) {
            try {
                this.setRange(new Domain(range2D, range2D2), false);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.out.println("zoom reset denied! " + propertyVetoException);
            }
        }
    }

    public void setRange(Domain domain) throws PropertyVetoException {
        this.setRange(domain, true);
    }

    public void setRange(Domain domain, boolean bl) throws PropertyVetoException {
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
        LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getYTransform();
        Domain domain2 = new Domain(linearTransform.getRangeU(), linearTransform2.getRangeU());
        if (!domain.equals(domain2)) {
            this.setBatch(true, "JLineProfileLayout: setRange");
            this.vetos_.fireVetoableChange("domainRange", domain2, domain);
            this.inZoom_ = true;
            if (!domain.isXTime()) {
                this.setXRange(domain.getXRange());
            }
            if (!domain.isYTime()) {
                this.setYRange(domain.getYRange(), bl);
            }
            this.changes_.firePropertyChange("domainRange", domain2, domain);
            this.setBatch(false, "JLineProfileLayout: setRange");
        }
    }

    public void setRangeNoVeto(Domain domain) {
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
        LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getYTransform();
        Domain domain2 = new Domain(linearTransform.getRangeU(), linearTransform2.getRangeU());
        this.setBatch(true, "JLineProfileLayout: setRangeNoVeto");
        this.inZoom_ = true;
        this.setClipping(true);
        if (!domain.isXTime()) {
            this.setXRange(domain.getXRange());
        }
        if (!domain.isYTime()) {
            this.setYRange(domain.getYRange(), false);
        }
        this.setBatch(false, "JLineProfileLayout: setRangeNoVeto");
    }

    void setXRange(Range2D range2D) {
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
        Range2D range2D2 = Graph.computeRange(range2D, 6);
        linearTransform.setRangeU(range2D2);
        try {
            PlainAxis plainAxis = (PlainAxis)cartesianGraph.getXAxis("Bottom Axis");
            PlainAxis plainAxis2 = (PlainAxis)cartesianGraph.getYAxis("Left Axis");
            plainAxis.setRangeU(range2D2);
            plainAxis.setDeltaU(range2D2.delta);
            Range2D range2D3 = plainAxis.getRangeU();
            Range2D range2D4 = plainAxis2.getRangeU();
            Point2D.Double double_ = new Point2D.Double(range2D3.start, range2D4.start);
            plainAxis.setLocationU(double_);
            plainAxis2.setLocationU(double_);
            if (this.clipping_) {
                this.setAllClip(range2D3.start, range2D3.end, range2D4.start, range2D4.end);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    void setYRange(Range2D range2D) {
        this.setYRange(range2D, true);
    }

    void setYRange(Range2D range2D, boolean bl) {
        SGTData sGTData;
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getYTransform();
        if (bl && this.data_.size() > 0 && !((SGTLine)(sGTData = (SGTData)this.data_.elements().nextElement())).getYMetaData().isReversed()) {
            double d = range2D.end;
            range2D.end = range2D.start;
            range2D.start = d;
        }
        Range2D range2D2 = Graph.computeRange(range2D, 6);
        linearTransform.setRangeU(range2D2);
        try {
            PlainAxis plainAxis = (PlainAxis)cartesianGraph.getXAxis("Bottom Axis");
            PlainAxis plainAxis2 = (PlainAxis)cartesianGraph.getYAxis("Left Axis");
            plainAxis2.setRangeU(range2D2);
            plainAxis2.setDeltaU(range2D2.delta);
            Range2D range2D3 = plainAxis.getRangeU();
            Range2D range2D4 = plainAxis2.getRangeU();
            Point2D.Double double_ = new Point2D.Double(range2D3.start, range2D4.start);
            plainAxis2.setLocationU(double_);
            plainAxis.setLocationU(double_);
            if (this.clipping_) {
                this.setAllClip(range2D3.start, range2D3.end, range2D4.start, range2D4.end);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    private void setAllClip(JPane jPane, double d, double d2, double d3, double d4) {
        Component[] componentArray = jPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer)) continue;
            Layer layer = (Layer)componentArray[i];
            ((CartesianGraph)layer.getGraph()).setClip(d, d2, d3, d4);
        }
    }

    private void setAllClipping(JPane jPane, boolean bl) {
        Component[] componentArray = jPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer)) continue;
            Layer layer = (Layer)componentArray[i];
            ((CartesianGraph)layer.getGraph()).setClipping(bl);
        }
    }

    public void clear() {
        this.data_.removeAllElements();
        ((CartesianGraph)this.firstLayer_.getGraph()).setRenderer(null);
        this.removeAll();
        this.add((Component)this.firstLayer_, 0);
        this.lineKey_.clearAll();
        this.inZoom_ = false;
    }

    public void clear(String string) {
        Layer layer = null;
        try {
            layer = this.getLayerFromDataId(string);
            this.remove(layer);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        Enumeration enumeration = this.data_.elements();
        while (enumeration.hasMoreElements()) {
            SGTData sGTData = (SGTData)enumeration.nextElement();
            if (!sGTData.getId().equals(string)) continue;
            this.data_.removeElement(sGTData);
        }
        this.lineKey_.clear(string);
        if (this.getComponentCount() <= 0 || layer.equals(this.firstLayer_)) {
            ((CartesianGraph)this.firstLayer_.getGraph()).setRenderer(null);
            this.add((Component)this.firstLayer_, 0);
        }
    }

    public void setKeyBoundsP(Rectangle2D.Double double_) {
        if (this.lineKey_ != null) {
            this.lineKey_.setBoundsP(double_);
        }
    }

    public Rectangle2D.Double getKeyBoundsP() {
        if (this.lineKey_ == null) {
            return null;
        }
        return this.lineKey_.getBoundsP();
    }

    public Dimension2D getLayerSizeP() {
        return new Dimension2D(this.xSize_, this.ySize_);
    }

    public Layer getFirstLayer() {
        return this.firstLayer_;
    }

    public void setLayerSizeP(Dimension2D dimension2D) {
        double d;
        Component[] componentArray = this.getComponents();
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getYTransform();
        LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getXTransform();
        this.xMax_ = dimension2D.width - (this.xSize_ - this.xMax_);
        this.yMax_ = dimension2D.height - (this.ySize_ - this.yMax_);
        this.xSize_ = dimension2D.width;
        this.ySize_ = dimension2D.height;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer)) continue;
            ((Layer)componentArray[i]).setSizeP(dimension2D);
        }
        linearTransform.setRangeP(new Range2D(this.yMin_, this.yMax_));
        linearTransform2.setRangeP(new Range2D(this.xMin_, this.xMax_));
        if (this.iconImage_ != null) {
            Rectangle rectangle = this.logo_.getBounds();
            d = this.firstLayer_.getXDtoP(rectangle.x + rectangle.width) + 0.05;
        } else {
            d = (this.xMin_ + this.xMax_) * 0.5;
        }
        double d2 = this.ySize_ - (double)1.2f * this.mainTitleHeight_;
        this.mainTitle_.setLocationP(new Point2D.Double(d, d2));
        this.title2_.setLocationP(new Point2D.Double(d, d2 -= (double)1.2f * this.warnHeight_));
        this.title3_.setLocationP(new Point2D.Double(d, d2 -= (double)1.1f * this.warnHeight_));
        if (this.keyPane_ == null) {
            this.lineKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.01, this.ySize_));
        }
    }
}

