/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTTuple;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class SimpleTuple
implements Cloneable,
SGTTuple,
Cartesian,
Serializable {
    private boolean xTime_ = false;
    private boolean yTime_ = false;
    private String title_ = null;
    private SGLabel keyTitle_ = null;
    private String id_ = null;
    private double[] xArray_ = null;
    private double[] yArray_ = null;
    private GeoDateArray tArray_ = null;
    private double[] zArray_ = null;
    private double[] assocArray_ = null;
    protected SGTMetaData xMetaData_ = null;
    protected SGTMetaData yMetaData_ = null;
    protected SGTMetaData zMetaData_ = null;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private Range2D zRange_ = null;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public SimpleTuple(double[] dArray, double[] dArray2, String string) {
        this.xArray_ = dArray;
        this.yArray_ = dArray2;
        this.xTime_ = false;
        this.yTime_ = false;
        this.title_ = string;
        this.xRange_ = this.computeSoTRange(dArray);
        this.yRange_ = this.computeSoTRange(dArray2);
    }

    public SimpleTuple(GeoDate[] geoDateArray, double[] dArray, String string) {
        this.tArray_ = new GeoDateArray(geoDateArray);
        this.yArray_ = dArray;
        this.xTime_ = true;
        this.yTime_ = false;
        this.title_ = string;
        this.xRange_ = this.computeSoTRange(this.tArray_);
        this.yRange_ = this.computeSoTRange(dArray);
    }

    public SimpleTuple(double[] dArray, GeoDate[] geoDateArray, String string) {
        this.xArray_ = dArray;
        this.tArray_ = new GeoDateArray(geoDateArray);
        this.xTime_ = false;
        this.yTime_ = true;
        this.title_ = string;
        this.xRange_ = this.computeSoTRange(dArray);
        this.yRange_ = this.computeSoTRange(this.tArray_);
    }

    public SimpleTuple(double[] dArray, double[] dArray2, double[] dArray3, String string) {
        this.xArray_ = dArray;
        this.yArray_ = dArray2;
        this.zArray_ = dArray3;
        this.xTime_ = false;
        this.yTime_ = false;
        this.title_ = string;
        this.xRange_ = this.computeSoTRange(dArray);
        this.yRange_ = this.computeSoTRange(dArray2);
        this.zRange_ = this.computeRange2D(dArray3);
    }

    public SimpleTuple(GeoDate[] geoDateArray, double[] dArray, double[] dArray2, String string) {
        this.tArray_ = new GeoDateArray(geoDateArray);
        this.yArray_ = dArray;
        this.zArray_ = dArray2;
        this.xTime_ = true;
        this.yTime_ = false;
        this.title_ = string;
        this.xRange_ = this.computeSoTRange(this.tArray_);
        this.yRange_ = this.computeSoTRange(dArray);
        this.zRange_ = this.computeRange2D(dArray2);
    }

    public SimpleTuple(double[] dArray, GeoDate[] geoDateArray, double[] dArray2, String string) {
        this.xArray_ = dArray;
        this.tArray_ = new GeoDateArray(geoDateArray);
        this.zArray_ = dArray2;
        this.xTime_ = false;
        this.yTime_ = true;
        this.title_ = string;
        this.xRange_ = this.computeSoTRange(dArray);
        this.yRange_ = this.computeSoTRange(this.tArray_);
        this.zRange_ = this.computeRange2D(dArray2);
    }

    public SimpleTuple() {
        this.xTime_ = false;
        this.yTime_ = false;
    }

    public double[] getXArray() {
        return this.xArray_;
    }

    public void setXArray(double[] dArray) {
        this.xArray_ = dArray;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setXArray(GeoDate[] geoDateArray) {
        this.setXArray(new GeoDateArray(geoDateArray));
    }

    public void setXArray(GeoDateArray geoDateArray) {
        this.tArray_ = geoDateArray;
        this.xTime_ = true;
        this.xArray_ = null;
        this.xRange_ = this.computeSoTRange(geoDateArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(geoDateArray.getLength()));
    }

    public double[] getYArray() {
        return this.yArray_;
    }

    public void setYArray(double[] dArray) {
        this.yArray_ = dArray;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setYArray(GeoDate[] geoDateArray) {
        this.setYArray(new GeoDateArray(geoDateArray));
    }

    public void setYArray(GeoDateArray geoDateArray) {
        this.tArray_ = geoDateArray;
        this.yTime_ = true;
        this.yArray_ = null;
        this.yRange_ = this.computeSoTRange(geoDateArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(geoDateArray.getLength()));
    }

    public double[] getZArray() {
        return this.zArray_;
    }

    public void setZArray(double[] dArray) {
        this.zArray_ = dArray;
        this.zRange_ = this.computeRange2D(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public int getSize() {
        if (this.xTime_) {
            return this.tArray_.getLength();
        }
        return this.xArray_.length;
    }

    public GeoDate[] getTimeArray() {
        return this.tArray_.getGeoDate();
    }

    public GeoDateArray getGeoDateArray() {
        return this.tArray_;
    }

    public double[] getAssociatedData() {
        return this.assocArray_;
    }

    public void setAssociatedData(double[] dArray) {
        this.assocArray_ = dArray;
    }

    public boolean hasAssociatedData() {
        return this.assocArray_ != null;
    }

    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    public void setZMetaData(SGTMetaData sGTMetaData) {
        this.zMetaData_ = sGTMetaData;
    }

    public String getTitle() {
        return this.title_;
    }

    public void setTitle(String string) {
        this.title_ = string;
    }

    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    public void setKeyTitle(SGLabel sGLabel) {
        this.keyTitle_ = sGLabel;
    }

    public String getId() {
        return this.id_;
    }

    public void setId(String string) {
        this.id_ = string;
    }

    public SGTData copy() {
        SGTTuple sGTTuple;
        try {
            sGTTuple = (SGTTuple)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            sGTTuple = new SimpleTuple();
        }
        return sGTTuple;
    }

    public boolean isXTime() {
        return this.xTime_;
    }

    public boolean isYTime() {
        return this.yTime_;
    }

    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    public void setXMetaData(SGTMetaData sGTMetaData) {
        this.xMetaData_ = sGTMetaData;
    }

    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    public void setYMetaData(SGTMetaData sGTMetaData) {
        this.yMetaData_ = sGTMetaData;
    }

    public SoTRange getXRange() {
        return this.xRange_;
    }

    public SoTRange getYRange() {
        return this.yRange_;
    }

    public Range2D getZRange() {
        return this.zRange_;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    private SoTRange computeSoTRange(double[] dArray) {
        Range2D range2D = this.computeRange2D(dArray);
        return new SoTRange.Double(range2D.start, range2D.end);
    }

    private SoTRange computeSoTRange(GeoDateArray geoDateArray) {
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        long[] lArray = geoDateArray.getTime();
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == Long.MAX_VALUE) continue;
            l = Math.min(l, lArray[i]);
            l2 = Math.max(l2, lArray[i]);
            ++n;
        }
        if (n == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(l, l2);
    }

    private Range2D computeRange2D(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            d = Math.min(d, dArray[i]);
            d2 = Math.max(d2, dArray[i]);
            ++n;
        }
        if (n == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(d, d2);
    }
}

