/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.TimeRange;

public class TestData {
    public static final int PROFILE = 1;
    public static final int X_SERIES = 2;
    public static final int Y_SERIES = 3;
    public static final int TIME_SERIES = 4;
    public static final int XY_GRID = 5;
    public static final int XZ_GRID = 6;
    public static final int YZ_GRID = 7;
    public static final int ZT_GRID = 10;
    public static final int LOG_LOG = 11;
    public static final int SINE = 1;
    public static final int RANDOM = 2;
    public static final int SINE_RAMP = 3;
    private int dataType_;
    private SGTData data_;
    private Collection coll_;

    public TestData() {
        this(1, new Range2D(0.0, 100.0, 10.0), 1, 1.0f, 0.0f, 25.0f);
    }

    public TestData(int n, Range2D range2D, int n2, float f, float f2, float f3) {
        SimpleLine simpleLine;
        SGTMetaData sGTMetaData;
        SGTMetaData sGTMetaData2;
        double[] dArray;
        double[] dArray2;
        GeoDate[] geoDateArray = new GeoDate[1];
        double[] dArray3 = new double[1];
        geoDateArray[0] = new GeoDate();
        dArray3[0] = 0.0;
        geoDateArray[0].now();
        if (n != 11) {
            int n3 = (int)((range2D.end - range2D.start) / range2D.delta) + 1;
            dArray2 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                dArray2[i] = range2D.start + (double)i * range2D.delta;
            }
            dArray = this.getValues(dArray2, n3, n2, f, f2, f3);
        } else {
            int n4;
            double d = Math.log(10.0);
            double d2 = Math.log(range2D.end) / d;
            double d3 = Math.log(range2D.start) / d;
            double d4 = Math.log(range2D.delta) / d;
            float f4 = (float)(Math.log(f) / d);
            float f5 = (float)(Math.log(f2) / d);
            float f6 = (float)(Math.log(f3) / d);
            int n5 = (int)((d2 - d3) / d4) + 1;
            dArray2 = new double[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                dArray2[n4] = d3 + (double)n4 * d4;
            }
            dArray = this.getValues(dArray2, n5, n2, f4, f5, f6);
            for (n4 = 0; n4 < n5; ++n4) {
                dArray2[n4] = Math.pow(10.0, dArray2[n4]);
                dArray[n4] = Math.pow(10.0, dArray[n4]);
            }
        }
        SGLabel sGLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        sGLabel.setHeightP(0.16);
        switch (n) {
            case 2: {
                sGLabel.setText("X series ts data");
                sGTMetaData2 = new SGTMetaData("lon", "degE");
                sGTMetaData = new SGTMetaData("ts", "m s-1");
                simpleLine = new SimpleLine(dArray2, dArray, "Test Series");
                break;
            }
            case 3: {
                sGLabel.setText("Y series ts data");
                sGTMetaData2 = new SGTMetaData("lat", "deg");
                sGTMetaData = new SGTMetaData("ts", "m s-1");
                simpleLine = new SimpleLine(dArray2, dArray, "Test Series");
                break;
            }
            default: {
                sGLabel.setText("Profile ts data");
                sGTMetaData2 = new SGTMetaData("ts", "m s-1");
                sGTMetaData = new SGTMetaData("depth", "m");
                simpleLine = new SimpleLine(dArray, dArray2, "Test Series");
                break;
            }
            case 11: {
                sGLabel.setText("Log/Log diameters");
                sGTMetaData2 = new SGTMetaData("diameter", "m");
                sGTMetaData = new SGTMetaData("count", "");
                simpleLine = new SimpleLine(dArray2, dArray, "Test Log-Log Series");
            }
        }
        simpleLine.setXMetaData(sGTMetaData2);
        simpleLine.setYMetaData(sGTMetaData);
        simpleLine.setKeyTitle(sGLabel);
        this.data_ = simpleLine;
    }

    public TestData(int n, Range2D range2D, Range2D range2D2, int n2, float f, float f2, float f3) {
        SimpleGrid simpleGrid;
        SGTMetaData sGTMetaData;
        SGTMetaData sGTMetaData2;
        int n3;
        GeoDate[] geoDateArray = new GeoDate[1];
        double[] dArray = new double[1];
        geoDateArray[0] = new GeoDate();
        dArray[0] = 0.0;
        geoDateArray[0].now();
        int n4 = (int)((range2D.end - range2D.start) / range2D.delta) + 1;
        double[] dArray2 = new double[n4];
        int n5 = (int)((range2D2.end - range2D2.start) / range2D2.delta) + 1;
        double[] dArray3 = new double[n5];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray2[n3] = range2D.start + (double)n3 * range2D.delta;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            dArray3[n3] = range2D2.start + (double)n3 * range2D2.delta;
        }
        double[] dArray4 = this.getValues(dArray2, n4, dArray3, n5, n2, f, f2, f3);
        SGLabel sGLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        sGLabel.setHeightP(0.16);
        SGTMetaData sGTMetaData3 = new SGTMetaData("ts", "m s-1");
        switch (n) {
            case 5: {
                sGLabel.setText("XY test grid");
                sGTMetaData2 = new SGTMetaData("lon", "degE");
                sGTMetaData = new SGTMetaData("lat", "deg");
                simpleGrid = new SimpleGrid(dArray4, dArray2, dArray3, "Test Series");
                break;
            }
            case 6: {
                sGLabel.setText("XZ test grid");
                sGTMetaData2 = new SGTMetaData("lon", "degE");
                sGTMetaData = new SGTMetaData("depth", "m");
                simpleGrid = new SimpleGrid(dArray4, dArray2, dArray3, "Test Series");
                break;
            }
            default: {
                sGLabel.setText("YZ test grid");
                sGTMetaData2 = new SGTMetaData("lat", "deg");
                sGTMetaData = new SGTMetaData("depth", "m");
                simpleGrid = new SimpleGrid(dArray4, dArray2, dArray3, "Test Series");
            }
        }
        simpleGrid.setXMetaData(sGTMetaData2);
        simpleGrid.setYMetaData(sGTMetaData);
        simpleGrid.setZMetaData(sGTMetaData3);
        simpleGrid.setKeyTitle(sGLabel);
        this.data_ = simpleGrid;
    }

    public TestData(int n, TimeRange timeRange, float f, int n2, float f2, float f3, float f4) {
        double[] dArray = new double[]{0.0};
        double d = timeRange.end.offset(timeRange.start);
        int n3 = (int)(d / (double)f) + 1;
        long[] lArray = new long[n3];
        long l = timeRange.start.getTime();
        long l2 = (long)f * 86400000L;
        for (int i = 0; i < n3; ++i) {
            lArray[i] = l + (long)i * l2;
        }
        GeoDateArray geoDateArray = new GeoDateArray(lArray);
        double[] dArray2 = this.getValues(geoDateArray, n3, n2, f2, f3, f4);
        SGLabel sGLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        sGLabel.setHeightP(0.16);
        sGLabel.setText("Time series ts");
        SGTMetaData sGTMetaData = new SGTMetaData("time", "");
        SGTMetaData sGTMetaData2 = new SGTMetaData("ts", "m s-1");
        SimpleLine simpleLine = new SimpleLine(geoDateArray, dArray2, "Test Series");
        simpleLine.setXMetaData(sGTMetaData);
        simpleLine.setYMetaData(sGTMetaData2);
        simpleLine.setKeyTitle(sGLabel);
        this.data_ = simpleLine;
    }

    public TestData(int n, Range2D range2D, TimeRange timeRange, float f, int n2, float f2, float f3, float f4) {
        int n3;
        double[] dArray = new double[]{0.0};
        double d = timeRange.end.offset(timeRange.start);
        int n4 = (int)(d / (double)f) + 1;
        GeoDate[] geoDateArray = new GeoDate[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            geoDateArray[n3] = new GeoDate(timeRange.start);
            geoDateArray[n3].increment(f * (float)n3, 1);
        }
        int n5 = (int)((range2D.end - range2D.start) / range2D.delta) + 1;
        double[] dArray2 = new double[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            dArray2[n3] = range2D.start + (double)n3 * range2D.delta;
        }
        double[] dArray3 = this.getValues(dArray2, n5, geoDateArray, n4, n2, f2, f3, f4);
        SGLabel sGLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        sGLabel.setHeightP(0.16);
        sGLabel.setText("time-depth grid");
        SGTMetaData sGTMetaData = new SGTMetaData("time", "");
        SGTMetaData sGTMetaData2 = new SGTMetaData("depth", "m");
        SGTMetaData sGTMetaData3 = new SGTMetaData("ts", "m s-1");
        SimpleGrid simpleGrid = new SimpleGrid(dArray3, geoDateArray, dArray2, "Test Series");
        simpleGrid.setXMetaData(sGTMetaData);
        simpleGrid.setYMetaData(sGTMetaData2);
        simpleGrid.setZMetaData(sGTMetaData3);
        simpleGrid.setKeyTitle(sGLabel);
        this.data_ = simpleGrid;
    }

    public TestData(Range2D range2D, Range2D range2D2, int n) {
        this.coll_ = new Collection("Test Points", n);
        double d = range2D.end - range2D.start;
        double d2 = range2D.start;
        double d3 = range2D2.end - range2D2.start;
        double d4 = range2D2.start;
        for (int i = 0; i < n; ++i) {
            double d5 = d * Math.random() + d2;
            double d6 = d3 * Math.random() + d4;
            String string = "point" + i;
            SimplePoint simplePoint = new SimplePoint(d5, d6, string);
            this.coll_.addElement(simplePoint);
        }
    }

    public Collection getCollection() {
        return this.coll_;
    }

    public SGTData getSGTData() {
        return this.data_;
    }

    private double[] getValues(double[] dArray, int n, int n2, float f, float f2, float f3) {
        double[] dArray2 = new double[n];
        switch (n2) {
            default: {
                for (int i = 0; i < n; ++i) {
                    dArray2[i] = (double)f * Math.random() + (double)f2;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n; ++i) {
                    dArray2[i] = (double)f * Math.sin(dArray[i] / (double)f3) + (double)f2;
                }
            }
        }
        return dArray2;
    }

    private double[] getValues(double[] dArray, int n, double[] dArray2, int n2, int n3, float f, float f2, float f3) {
        double[] dArray3 = new double[n * n2];
        switch (n3) {
            default: {
                for (int i = 0; i < n * n2; ++i) {
                    dArray3[i] = (double)f * Math.random() + (double)f2;
                }
                break;
            }
            case 1: {
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        dArray3[n4] = (double)f * Math.sin(dArray[i] / (double)f3) * Math.sin(dArray2[j] / (double)f3) + (double)f2;
                        ++n4;
                    }
                }
                break;
            }
            case 3: {
                int n5 = 0;
                double d = 0.08 * Math.abs(dArray[0] - dArray[n - 1]) / Math.max(Math.abs(dArray[0]), Math.abs(dArray[n - 1]));
                double d2 = 0.08 * Math.abs(dArray2[0] - dArray2[n2 - 1]) / Math.max(Math.abs(dArray2[0]), Math.abs(dArray2[n2 - 1]));
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        dArray3[n5] = (double)f * Math.sin(dArray[i] / (double)f3) * Math.sin(dArray2[j] / (double)f3) + (double)f2 + (double)f * (d * (double)i - d2 * (double)j);
                        ++n5;
                    }
                }
            }
        }
        return dArray3;
    }

    private double[] getValues(GeoDate[] geoDateArray, int n, int n2, float f, float f2, float f3) {
        double[] dArray = new double[n];
        switch (n2) {
            default: {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = (double)f * Math.random() + (double)f2;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n; ++i) {
                    double d = geoDateArray[i].offset(geoDateArray[0]) / (double)f3;
                    dArray[i] = (double)f * Math.sin(d) + (double)f2;
                }
            }
        }
        return dArray;
    }

    private double[] getValues(GeoDateArray geoDateArray, int n, int n2, float f, float f2, float f3) {
        float f4 = f3 * 8.64E7f;
        long[] lArray = geoDateArray.getTime();
        double[] dArray = new double[n];
        switch (n2) {
            default: {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = (double)f * Math.random() + (double)f2;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n; ++i) {
                    double d = (float)(lArray[i] - lArray[0]) / f4;
                    dArray[i] = (double)f * Math.sin(d) + (double)f2;
                }
            }
        }
        return dArray;
    }

    private double[] getValues(double[] dArray, int n, GeoDate[] geoDateArray, int n2, int n3, float f, float f2, float f3) {
        double[] dArray2 = new double[n2 * n];
        switch (n3) {
            default: {
                for (int i = 0; i < n2 * n; ++i) {
                    dArray2[i] = (double)f * Math.random() + (double)f2;
                }
                break;
            }
            case 1: {
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    double d = geoDateArray[i].offset(geoDateArray[0]) / (double)f3;
                    for (int j = 0; j < n; ++j) {
                        dArray2[n4] = (double)f * Math.sin(d) * Math.sin(dArray[j] / (double)f3) + (double)f2;
                        ++n4;
                    }
                }
            }
        }
        return dArray2;
    }
}

