/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.contour;

import gov.noaa.pmel.sgt.dm.SGTGrid;

class GridFlag {
    public static final int LESS_THAN_ZC = -1;
    public static final int MISSING = 10;
    public static final int GREATER_THAN_ZC = 1;
    private double[] array_;
    private double[] mask_ = null;
    private byte[] value_;
    private int nx_;
    private int ny_;

    public GridFlag(SGTGrid sGTGrid, double d) {
        this(sGTGrid, null, d);
    }

    public GridFlag(SGTGrid sGTGrid, SGTGrid sGTGrid2, double d) {
        this.nx_ = sGTGrid.isXTime() ? sGTGrid.getTSize() : sGTGrid.getXSize();
        this.ny_ = sGTGrid.isYTime() ? sGTGrid.getTSize() : sGTGrid.getYSize();
        this.value_ = new byte[this.nx_ * this.ny_];
        this.array_ = sGTGrid.getZArray();
        this.setLevel(d);
        if (sGTGrid2 != null) {
            this.setMask(sGTGrid2);
        }
    }

    public void setMask(SGTGrid sGTGrid) {
        this.mask_ = sGTGrid.getZArray();
        this.applyMask();
    }

    void applyMask() {
        if (this.mask_ == null) {
            return;
        }
        for (int i = 0; i < this.nx_ * this.ny_; ++i) {
            if (!Double.isNaN(this.mask_[i]) && this.mask_[i] == 0.0) continue;
            this.value_[i] = 10;
        }
    }

    public void setLevel(double d) {
        for (int i = 0; i < this.nx_ * this.ny_; ++i) {
            if (!Double.isNaN(this.array_[i])) {
                if (this.array_[i] <= d) {
                    this.value_[i] = -1;
                    continue;
                }
                this.value_[i] = 1;
                continue;
            }
            this.value_[i] = 10;
        }
        this.applyMask();
    }

    int index(int n, int n2) {
        return n2 + this.ny_ * n;
    }

    public boolean isMissing(int n, int n2) {
        int n3 = this.index(n, n2);
        return this.value_[n3] == 10;
    }

    public boolean isGreater(int n, int n2) {
        int n3 = this.index(n, n2);
        return this.value_[n3] == 1;
    }

    public int getValue(int n, int n2) {
        int n3 = this.index(n, n2);
        return this.value_[n3];
    }
}

