/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.PanelModel;
import java.awt.Color;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelHolder
implements ChangeListener,
Serializable {
    private String id = "";
    private Rectangle bounds = new Rectangle(0, 0, 100, 50);
    private Map labels_ = new HashMap(5);
    private Map dataGroups_ = new HashMap(2);
    private Map legends_ = new HashMap(1);
    private transient PanelModel pModel_ = null;
    private transient ChangeEvent changeEvent_ = new ChangeEvent(this);
    private transient Vector changeListeners;
    private boolean visible = true;
    private transient boolean instantiated = false;
    private Border border = new LineBorder(Color.gray, 2);
    private Color background = Color.white;
    private boolean usePageBackground = true;
    static /* synthetic */ Class class$gov$noaa$pmel$sgt$beans$PanelHolder;

    public PanelHolder() {
        this(null, null);
    }

    public PanelHolder(String string, PanelModel panelModel) {
        this.id = string;
        this.pModel_ = panelModel;
    }

    public PanelHolder(String string, PanelModel panelModel, Rectangle rectangle, Map map, Map map2, Map map3) {
        this.id = string;
        this.pModel_ = panelModel;
        this.bounds = rectangle;
        if (map != null) {
            this.labels_ = new HashMap(map);
        }
        if (map2 != null) {
            this.dataGroups_ = new HashMap(map2);
        }
        if (map3 != null) {
            this.legends_ = new HashMap(map3);
        }
    }

    public void setPanelModel(PanelModel panelModel) {
        if (this.pModel_ != null) {
            this.removeChangeListener(this.pModel_);
        }
        this.pModel_ = panelModel;
        this.addChangeListener(this.pModel_);
    }

    public PanelModel getPanelModel() {
        return this.pModel_;
    }

    public void addLabel(Label label) {
        label.addChangeListener(this);
        label.setPanelHolder(this);
        this.labels_.put(label.getId(), label);
        this.fireStateChanged();
    }

    public void removeLabel(Label label) {
        label.removeAllChangeListeners();
        this.labels_.remove(label.getId());
        this.fireStateChanged();
    }

    public void addDataGroup(DataGroup dataGroup) {
        dataGroup.addChangeListener(this);
        this.dataGroups_.put(dataGroup.getId(), dataGroup);
        this.fireStateChanged();
    }

    public void removeDataGroup(DataGroup dataGroup) {
        dataGroup.removeAllChangeListeners();
        dataGroup.getXAxisHolder().removeAllChangeListeners();
        dataGroup.getYAxisHolder().removeAllChangeListeners();
        this.dataGroups_.remove(dataGroup.getId());
        this.fireStateChanged();
    }

    public void addLegend(Legend legend) {
        legend.addChangeListener(this);
        legend.setPanelHolder(this);
        this.legends_.put(legend.getId(), legend);
        this.fireStateChanged();
    }

    public void removeLegend(Legend legend) {
        legend.removeAllChangeListeners();
        this.legends_.remove(legend.getId());
        this.fireStateChanged();
    }

    public void setId(String string) {
        String string2 = this.id;
        this.id = string;
        if (string2 == null || !string2.equals(this.id)) {
            this.fireStateChanged();
        }
    }

    public String getId() {
        return this.id;
    }

    public int getLabelSize() {
        return this.labels_.size();
    }

    public int getDataGroupSize() {
        return this.dataGroups_.size();
    }

    public int getLegendSize() {
        return this.legends_.size();
    }

    public Iterator labelIterator() {
        return this.labels_.values().iterator();
    }

    public Iterator dataGroupIterator() {
        return this.dataGroups_.values().iterator();
    }

    public Iterator legendIterator() {
        return this.legends_.values().iterator();
    }

    public void setBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.bounds;
        this.bounds = rectangle;
        this.fireStateChanged();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void removeAllChangeListeners() {
        this.changeListeners = null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.changeListeners != null) {
            Vector vector = this.changeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ChangeListener)vector.elementAt(i)).stateChanged(changeEvent);
            }
        }
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null && this.changeListeners.contains(changeListener)) {
            Vector vector = (Vector)this.changeListeners.clone();
            vector.removeElement(changeListener);
            this.changeListeners = vector;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        Vector vector;
        Vector vector2 = vector = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!vector.contains(changeListener)) {
            vector.addElement(changeListener);
            this.changeListeners = vector;
        }
    }

    public synchronized void removeDesignChangeListeners() {
        if (this.changeListeners != null) {
            Vector vector = (Vector)this.changeListeners.clone();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DesignListener)) continue;
                this.changeListeners.removeElement(e);
            }
        }
    }

    protected void fireStateChanged() {
        if (this.changeListeners != null) {
            Vector vector = this.changeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ChangeListener)vector.elementAt(i)).stateChanged(this.changeEvent_);
            }
        }
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.visible;
        this.visible = bl;
        if (bl2 != this.visible) {
            this.fireStateChanged();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setInstantiated(boolean bl) {
        this.instantiated = bl;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    public DataGroup findDataGroup(String string) {
        return (DataGroup)this.dataGroups_.get(string);
    }

    public Label findLabel(String string) {
        return (Label)this.labels_.get(string);
    }

    public Legend findLegend(String string) {
        return (Legend)this.legends_.get(string);
    }

    public boolean hasDataGroup(String string) {
        return this.dataGroups_.containsKey(string);
    }

    public boolean hasLabel(String string) {
        return this.labels_.containsKey(string);
    }

    public boolean hasLegend(String string) {
        return this.legends_.containsKey(string);
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        if (border2 == null || !border2.equals(this.border)) {
            this.fireStateChanged();
        }
    }

    public Map getLabels() {
        return this.labels_;
    }

    public void setLabels(Map map) {
        this.labels_ = map;
        Iterator iterator = this.labelIterator();
        while (iterator.hasNext()) {
            ((Label)iterator.next()).addChangeListener(this);
        }
        this.fireStateChanged();
    }

    public Map getLegends() {
        return this.legends_;
    }

    public void setLegends(Map map) {
        this.legends_ = map;
        Iterator iterator = this.legendIterator();
        while (iterator.hasNext()) {
            ((Legend)iterator.next()).addChangeListener(this);
        }
        this.fireStateChanged();
    }

    public Map getDataGroups() {
        return this.dataGroups_;
    }

    public void setDataGroups(Map map) {
        this.dataGroups_ = map;
        Iterator iterator = this.dataGroupIterator();
        while (iterator.hasNext()) {
            ((DataGroup)iterator.next()).addChangeListener(this);
        }
        this.fireStateChanged();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        Color color2 = this.background;
        this.background = color;
        if (!color2.equals(this.background)) {
            this.fireStateChanged();
        }
    }

    public boolean isUsePageBackground() {
        return this.usePageBackground;
    }

    public void setUsePageBackground(boolean bl) {
        boolean bl2 = this.usePageBackground;
        this.usePageBackground = bl;
        if (bl2 != this.usePageBackground) {
            this.fireStateChanged();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(class$gov$noaa$pmel$sgt$beans$PanelHolder == null ? (class$gov$noaa$pmel$sgt$beans$PanelHolder = PanelHolder.class$("gov.noaa.pmel.sgt.beans.PanelHolder")) : class$gov$noaa$pmel$sgt$beans$PanelHolder);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.getName().equals("instantiated")) {
                    propertyDescriptor.setValue("transient", Boolean.TRUE);
                    continue;
                }
                if (!propertyDescriptor.getName().equals("panelModel")) continue;
                propertyDescriptor.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }
}

