/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.AxisHolderDragBox;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataGroupDragBox;
import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.DragBox;
import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.LabelDragBox;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.LegendDragBox;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelHolderDragBox;
import gov.noaa.pmel.sgt.beans.PanelModel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DesignPanel
extends JComponent
implements MouseListener,
MouseMotionListener,
ChangeListener,
DesignListener,
PropertyChangeListener {
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 1;
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int JUSTIFY_VERTICAL = 4;
    public static final int JUSTIFY_HORIZONTAL = 5;
    private Map pDragBoxes_ = new HashMap();
    private Vector selectedBoxes_ = new Vector();
    private boolean inMove_ = false;
    private DragBox dragBox_ = null;
    private int dragState_ = -1;
    private Point move_ref_ = null;
    private PanelModel model_ = null;
    private DataGroup selectedDG_ = null;
    private Dimension size = new Dimension(100, 100);
    private int selectCount_ = 0;
    private Point firstSelectedPoint_ = new Point(-1, -1);
    private DragBox[] selectList_ = null;
    private static int SELECT_DISTANCE = 2;

    public DesignPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DesignPanel(PanelModel panelModel) {
        this();
        this.setPanelModel(panelModel);
    }

    void jbInit() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMaximumSize() {
        return this.size;
    }

    public Dimension getWorkSize() {
        return this.size;
    }

    public void setPanelModel(PanelModel panelModel) {
        this.pDragBoxes_.clear();
        this.selectedBoxes_.clear();
        if (panelModel != null) {
            panelModel.removeChangeListener(this);
        }
        this.model_ = panelModel;
        if (this.model_ == null) {
            return;
        }
        this.model_.addChangeListener(this);
        Page page = this.model_.getPage();
        if (page == null) {
            this.size = this.model_.getPageSize();
            System.out.println("No page found!: size = " + this.size);
            this.setSize(this.size);
        } else {
            this.size = page.getSize();
            this.setSize(this.size);
        }
        Iterator iterator = this.model_.panelIterator();
        while (iterator.hasNext()) {
            PanelHolder panelHolder = (PanelHolder)iterator.next();
            panelHolder.addChangeListener(this);
            PanelHolderDragBox panelHolderDragBox = new PanelHolderDragBox(panelHolder);
            this.pDragBoxes_.put(panelHolder, panelHolderDragBox);
        }
        this.repaint();
    }

    public PanelModel getPanelModel() {
        return this.model_;
    }

    public void addPanel(PanelHolderDragBox panelHolderDragBox) {
        panelHolderDragBox.getPanelHolder().addChangeListener(this);
        this.pDragBoxes_.put(panelHolderDragBox.getPanelHolder(), panelHolderDragBox);
    }

    public void addDataGroup(DataGroup dataGroup) {
        PanelHolder panelHolder = this.getSelectedPanel();
        if (panelHolder == null) {
            return;
        }
        PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)this.pDragBoxes_.get(panelHolder);
        if (panelHolderDragBox == null) {
            return;
        }
        if (panelHolder.getDataGroupSize() >= 1) {
            dataGroup.getXAxisHolder().setAxisPosition(0);
            dataGroup.getYAxisHolder().setAxisPosition(3);
        }
        panelHolderDragBox.addDragBox(dataGroup);
        panelHolder.addDataGroup(dataGroup);
    }

    public void addLabel(Label label) {
        PanelHolder panelHolder = this.getSelectedPanel();
        if (panelHolder == null) {
            return;
        }
        PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)this.pDragBoxes_.get(panelHolder);
        if (panelHolderDragBox == null) {
            return;
        }
        panelHolderDragBox.addDragBox(label);
        panelHolder.addLabel(label);
    }

    public void addLegend(Legend legend) {
        PanelHolder panelHolder = this.getSelectedPanel();
        if (panelHolder == null) {
            return;
        }
        PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)this.pDragBoxes_.get(panelHolder);
        panelHolderDragBox.addDragBox(legend);
        panelHolder.addLegend(legend);
    }

    public void alignBoxes(int n) {
        int n2 = this.getSelectedCount();
        if (n2 < 0) {
            return;
        }
        PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)this.selectedBoxes_.firstElement();
        Rectangle rectangle = panelHolderDragBox.getBounds();
        switch (n) {
            case 0: {
                if (n2 <= 1) {
                    return;
                }
                int n3 = rectangle.y;
                for (int i = 1; i < n2; ++i) {
                    PanelHolderDragBox panelHolderDragBox2 = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                    panelHolderDragBox2.setLocation(panelHolderDragBox2.getLocation().x, n3);
                }
                break;
            }
            case 1: {
                if (n2 <= 1) {
                    return;
                }
                int n4 = rectangle.y + rectangle.height;
                for (int i = 1; i < n2; ++i) {
                    PanelHolderDragBox panelHolderDragBox3 = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                    int n5 = n4 - panelHolderDragBox3.getBounds().height;
                    panelHolderDragBox3.setLocation(panelHolderDragBox3.getLocation().x, n5);
                }
                break;
            }
            case 2: {
                if (n2 <= 1) {
                    return;
                }
                int n6 = rectangle.x;
                for (int i = 1; i < n2; ++i) {
                    PanelHolderDragBox panelHolderDragBox4 = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                    panelHolderDragBox4.setLocation(n6, panelHolderDragBox4.getLocation().y);
                }
                break;
            }
            case 3: {
                if (n2 <= 1) {
                    return;
                }
                int n7 = rectangle.x + rectangle.width;
                for (int i = 1; i < n2; ++i) {
                    PanelHolderDragBox panelHolderDragBox5 = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                    int n8 = n7 - panelHolderDragBox5.getBounds().width;
                    panelHolderDragBox5.setLocation(n8, panelHolderDragBox5.getLocation().y);
                }
                break;
            }
            case 4: {
                if (n2 >= 2) {
                    for (int i = 1; i < n2; ++i) {
                        PanelHolderDragBox panelHolderDragBox6 = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                        Rectangle rectangle2 = panelHolderDragBox6.getBounds();
                        rectangle2.y = rectangle.y;
                        rectangle2.height = rectangle.height;
                        panelHolderDragBox6.setBounds(rectangle2);
                    }
                    break;
                }
                Dimension dimension = this.getWorkSize();
                rectangle.y = 0;
                rectangle.height = dimension.height;
                panelHolderDragBox.setBounds(rectangle);
                break;
            }
            case 5: {
                if (n2 >= 2) {
                    for (int i = 1; i < n2; ++i) {
                        PanelHolderDragBox panelHolderDragBox7 = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                        Rectangle rectangle3 = panelHolderDragBox7.getBounds();
                        rectangle3.x = rectangle.x;
                        rectangle3.width = rectangle.width;
                        panelHolderDragBox7.setBounds(rectangle3);
                    }
                    break;
                }
                Dimension dimension = this.getWorkSize();
                rectangle.x = 0;
                rectangle.width = dimension.width;
                panelHolderDragBox.setBounds(rectangle);
            }
        }
        this.repaint();
    }

    public void removeSelected() {
        if (this.selectedBoxes_.size() == 1) {
            PanelHolder panelHolder;
            PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)this.selectedBoxes_.firstElement();
            panelHolderDragBox.getPanelHolder().removeAllChangeListeners();
            DragBox[] dragBoxArray = panelHolderDragBox.getDragBoxArray();
            for (int i = 0; i < dragBoxArray.length; ++i) {
                Serializable serializable;
                panelHolder = panelHolderDragBox.getPanelHolder();
                if (dragBoxArray[i] instanceof DataGroupDragBox) {
                    serializable = ((DataGroupDragBox)dragBoxArray[i]).getDataGroup();
                    panelHolder.removeDataGroup((DataGroup)serializable);
                    panelHolderDragBox.removeDragBox((DataGroupDragBox)dragBoxArray[i]);
                    continue;
                }
                if (dragBoxArray[i] instanceof LegendDragBox) {
                    serializable = ((LegendDragBox)dragBoxArray[i]).getLegend();
                    panelHolder.removeLegend((Legend)serializable);
                    panelHolderDragBox.removeDragBox((LegendDragBox)dragBoxArray[i]);
                    continue;
                }
                if (!(dragBoxArray[i] instanceof LabelDragBox)) continue;
                serializable = ((LabelDragBox)dragBoxArray[i]).getLabel();
                panelHolder.removeLabel((Label)serializable);
                panelHolderDragBox.removeDragBox((LabelDragBox)dragBoxArray[i]);
            }
            panelHolder = panelHolderDragBox.getPanelHolder();
            this.pDragBoxes_.remove(panelHolder);
            this.model_.removePanel(panelHolder);
            panelHolder.removeAllChangeListeners();
        } else {
            Iterator iterator = this.pDragBoxes_.values().iterator();
            block1: while (iterator.hasNext()) {
                PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)iterator.next();
                Iterator iterator2 = panelHolderDragBox.getDragBoxIterator();
                while (iterator2.hasNext()) {
                    Serializable serializable;
                    DragBox dragBox = (DragBox)iterator2.next();
                    if (!dragBox.isSelected()) continue;
                    PanelHolder panelHolder = panelHolderDragBox.getPanelHolder();
                    if (dragBox instanceof DataGroupDragBox) {
                        serializable = ((DataGroupDragBox)dragBox).getDataGroup();
                        panelHolder.removeDataGroup((DataGroup)serializable);
                        panelHolderDragBox.removeDragBox((DataGroupDragBox)dragBox);
                        continue block1;
                    }
                    if (dragBox instanceof LegendDragBox) {
                        serializable = ((LegendDragBox)dragBox).getLegend();
                        panelHolder.removeLegend((Legend)serializable);
                        panelHolderDragBox.removeDragBox((LegendDragBox)dragBox);
                        continue block1;
                    }
                    if (!(dragBox instanceof LabelDragBox)) continue block1;
                    serializable = ((LabelDragBox)dragBox).getLabel();
                    panelHolder.removeLabel((Label)serializable);
                    panelHolderDragBox.removeDragBox((LabelDragBox)dragBox);
                    continue block1;
                }
            }
        }
        this.repaint();
    }

    boolean isAxisHolderDragBoxSelected() {
        Iterator iterator = this.pDragBoxes_.values().iterator();
        while (iterator.hasNext()) {
            PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)iterator.next();
            Iterator iterator2 = panelHolderDragBox.getDragBoxIterator();
            while (iterator2.hasNext()) {
                DragBox dragBox = (DragBox)iterator2.next();
                if (!dragBox.isSelected() || !(dragBox instanceof AxisHolderDragBox)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isChildDragBoxSelected() {
        Iterator iterator = this.pDragBoxes_.values().iterator();
        while (iterator.hasNext()) {
            PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)iterator.next();
            Iterator iterator2 = panelHolderDragBox.getDragBoxIterator();
            while (iterator2.hasNext()) {
                DragBox dragBox = (DragBox)iterator2.next();
                if (!dragBox.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    int getSelectedCount() {
        return this.selectedBoxes_.size();
    }

    PanelHolder getSelectedPanel() {
        if (this.selectedBoxes_.size() != 1) {
            return null;
        }
        return ((PanelHolderDragBox)this.selectedBoxes_.firstElement()).getPanelHolder();
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.model_.getPageBackgroundColor());
        graphics.fillRect(0, 0, this.size.width, this.size.height);
        Iterator iterator = this.pDragBoxes_.values().iterator();
        while (iterator.hasNext()) {
            ((PanelHolderDragBox)iterator.next()).draw(graphics);
        }
    }

    void clearAllSelections() {
        Iterator iterator = this.pDragBoxes_.values().iterator();
        while (iterator.hasNext()) {
            PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)iterator.next();
            panelHolderDragBox.setSelected(false);
            Iterator iterator2 = panelHolderDragBox.getDragBoxIterator();
            while (iterator2.hasNext()) {
                ((DragBox)iterator2.next()).setSelected(false);
            }
        }
    }

    private DragBox[] dragBoxesThatContain(Point point) {
        Vector<DragBox> vector = new Vector<DragBox>(4);
        Iterator iterator = this.pDragBoxes_.values().iterator();
        while (iterator.hasNext()) {
            PanelHolderDragBox panelHolderDragBox = (PanelHolderDragBox)iterator.next();
            if (!panelHolderDragBox.contains(point)) continue;
            Iterator iterator2 = panelHolderDragBox.getDragBoxIterator();
            while (iterator2.hasNext()) {
                DragBox dragBox = (DragBox)iterator2.next();
                if (!dragBox.contains(point)) continue;
                vector.add(dragBox);
            }
            vector.add(panelHolderDragBox);
        }
        return vector.toArray(new DragBox[vector.size()]);
    }

    private void resetSelect() {
        this.selectList_ = null;
        this.selectCount_ = 0;
        this.firstSelectedPoint_.setLocation(-1, -1);
    }

    private boolean newSelectPoint(Point point) {
        int n = Math.abs(point.x - this.firstSelectedPoint_.x);
        int n2 = Math.abs(point.y - this.firstSelectedPoint_.y);
        return n > SELECT_DISTANCE || n2 > SELECT_DISTANCE;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        DragBox dragBox = null;
        boolean bl2 = mouseEvent.getClickCount() >= 2;
        int n = mouseEvent.getModifiers();
        Point point = mouseEvent.getPoint();
        boolean bl3 = bl = (n & 2) != 0 || (n & 1) != 0;
        if (this.selectList_ == null || this.newSelectPoint(point)) {
            this.selectList_ = this.dragBoxesThatContain(point);
            if (this.selectList_.length <= 0) {
                this.resetSelect();
                this.clearAllSelections();
                int n2 = this.getSelectedCount();
                this.selectedBoxes_.removeAllElements();
                this.repaint();
                this.firePropertyChange("allUnselected", null, null);
                this.inMove_ = false;
                this.dragState_ = -1;
                return;
            }
            this.selectCount_ = 0;
            this.firstSelectedPoint_.setLocation(point);
            dragBox = this.selectList_[this.selectCount_];
        } else {
            ++this.selectCount_;
            if (this.selectCount_ >= this.selectList_.length) {
                this.selectCount_ = 0;
            }
            dragBox = this.selectList_[this.selectCount_];
        }
        if (dragBox instanceof PanelHolderDragBox) {
            if (!bl && !dragBox.isSelected()) {
                this.clearAllSelections();
                this.selectedBoxes_.removeAllElements();
            }
            dragBox.setSelected(!dragBox.isSelected());
            if (dragBox.isSelected()) {
                this.selectedBoxes_.add(dragBox);
            } else {
                this.selectedBoxes_.remove(dragBox);
            }
            this.repaint();
            this.firePropertyChange("panelSelected", null, dragBox);
            return;
        }
        this.clearAllSelections();
        this.selectedBoxes_.removeAllElements();
        dragBox.setSelected(true);
        this.repaint();
        if (dragBox instanceof DataGroupDragBox) {
            this.firePropertyChange("dataGroupSelected", null, dragBox);
        } else if (dragBox instanceof AxisHolderDragBox) {
            this.firePropertyChange("axisSelected", null, dragBox);
        } else if (dragBox instanceof LabelDragBox) {
            this.firePropertyChange("labelSelected", null, dragBox);
        } else if (dragBox instanceof LegendDragBox) {
            this.firePropertyChange("legendSelected", null, dragBox);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        PanelHolderDragBox panelHolderDragBox = null;
        DragBox dragBox = null;
        this.dragState_ = -1;
        Iterator iterator = this.pDragBoxes_.values().iterator();
        block0: while (iterator.hasNext()) {
            panelHolderDragBox = (PanelHolderDragBox)iterator.next();
            if (panelHolderDragBox.isSelected() && panelHolderDragBox.handlesContain(mouseEvent.getPoint())) {
                this.dragBox_ = panelHolderDragBox;
                this.dragState_ = this.dragBox_.getSelectedHandle();
                this.inMove_ = true;
                this.move_ref_ = new Point(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            Iterator iterator2 = panelHolderDragBox.getDragBoxIterator();
            while (iterator2.hasNext()) {
                dragBox = (DragBox)iterator2.next();
                if (!dragBox.isSelected() || !dragBox.handlesContain(mouseEvent.getPoint())) continue;
                this.dragBox_ = dragBox;
                this.dragState_ = this.dragBox_.getSelectedHandle();
                this.inMove_ = true;
                this.move_ref_ = new Point(mouseEvent.getX(), mouseEvent.getY());
                continue block0;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.inMove_ = false;
        this.dragState_ = -1;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.resetSelect();
        Object var2_2 = null;
        Object var3_3 = null;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.inMove_) {
            int n3 = n - this.move_ref_.x;
            int n4 = n2 - this.move_ref_.y;
            this.dragBox_.mouseOperation(this.dragState_, n3, n4);
            this.repaint();
            this.move_ref_ = new Point(n, n2);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.size = this.model_.getPageSize();
        this.repaint();
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("pageSize")) {
            this.size = this.model_.getPageSize();
            this.setSize(this.size);
            this.repaint();
        }
    }
}

