/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.AxisHolder;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DragBox;
import gov.noaa.pmel.sgt.beans.Margin;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AxisHolderDragBox
extends DragBox
implements ChangeListener {
    private static int TIC_LENGTH = 10;
    private static int TIC_SPACE = 5;
    private static int TIC_INCREMENT = 25;
    private static int TITLE_HEIGHT = 10;
    private static int TITLE_SPACE = 5;
    public static final int ORIGIN = 0;
    public static final int SIZE = 1;
    public static final int DUMMY_ORIGIN = 2;
    public static final int DUMMY_SIZE = 3;
    private AxisHolder axHolder_;
    private Rectangle boundsD_ = null;
    private Point originD_ = null;
    private String id_ = null;
    private DataGroup dg_ = null;
    private static int exCount_ = 0;

    public AxisHolderDragBox(AxisHolder axisHolder, DataGroup dataGroup, PanelHolder panelHolder) {
        super(panelHolder);
        Rectangle2D.Double double_;
        this.axHolder_ = axisHolder;
        this.axHolder_.addChangeListener(this);
        this.dg_ = dataGroup;
        this.dg_.addChangeListener(this);
        for (int i = 0; i < this.handles_.length; ++i) {
            this.handles_[i] = new Rectangle(0, 0, 0, 0);
        }
        this.id_ = this.axHolder_.getDataGroup().getId() + (this.axHolder_.getAxisOrientation() == 0 ? "_X" : "_Y");
        Point2D.Double double_2 = this.axHolder_.getAxisOriginP();
        if (double_2 != null) {
            this.originD_ = this.toLocation(double_2);
        }
        if ((double_ = (Rectangle2D.Double)this.axHolder_.getBoundsP()) != null) {
            this.boundsD_ = this.toRectangle(double_);
        }
        this.update("AxisHolderDragBox.new()");
    }

    public AxisHolder getAxisHolder() {
        return this.axHolder_;
    }

    public void setBounds(Rectangle rectangle) {
        this.boundsD_ = rectangle;
        this.axHolder_.setBoundsP(this.toRectangle(rectangle));
        this.computeHandles();
    }

    public void setOrigin(Point point) {
        this.originD_ = point;
        this.axHolder_.setAxisOriginP(this.toLocation(this.originD_));
        this.computeHandles();
    }

    public Point getOrigin() {
        return (Point)this.originD_.clone();
    }

    public Point getLocation() {
        return new Point(this.boundsD_.x, this.boundsD_.y);
    }

    public void setId(String string) {
    }

    public void draw(Graphics graphics) {
        int n;
        Color color = graphics.getColor();
        if (this.selected_) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.darkGray);
        }
        Rectangle rectangle = this.computeDataGroupBounds();
        if (this.axHolder_.getAxisOrientation() == 0) {
            int n2;
            int n3;
            int n4;
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        n4 = rectangle.y + rectangle.height;
                        break;
                    }
                    case 0: {
                        n4 = rectangle.y;
                        break;
                    }
                }
            } else {
                n4 = this.originD_.y;
            }
            switch (this.axHolder_.getTicPosition()) {
                default: {
                    n3 = n4;
                    n2 = n4 + TIC_LENGTH;
                    break;
                }
                case 0: {
                    n3 = n4 - TIC_LENGTH;
                    n2 = n4;
                    break;
                }
                case 2: {
                    n3 = n4 - TIC_LENGTH;
                    n2 = n4 + TIC_LENGTH;
                }
            }
            if (this.axHolder_.isVisible()) {
                graphics.drawRect(this.boundsD_.x, this.boundsD_.y, this.boundsD_.width, this.boundsD_.height);
                graphics.drawLine(this.boundsD_.x, n4, this.boundsD_.x + this.boundsD_.width, n4);
                for (n = this.boundsD_.x; n < this.boundsD_.x + this.boundsD_.width; n += TIC_INCREMENT) {
                    graphics.drawLine(n, n3, n, n2);
                }
            }
        } else {
            int n5;
            int n6;
            int n7;
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        n7 = rectangle.x;
                        break;
                    }
                    case 3: {
                        n7 = rectangle.x + rectangle.width;
                        break;
                    }
                }
            } else {
                n7 = this.originD_.x;
            }
            switch (this.axHolder_.getTicPosition()) {
                default: {
                    n6 = n7;
                    n5 = n7 - TIC_LENGTH;
                    break;
                }
                case 0: {
                    n6 = n7 + TIC_LENGTH;
                    n5 = n7;
                    break;
                }
                case 2: {
                    n6 = n7 - TIC_LENGTH;
                    n5 = n7 + TIC_LENGTH;
                }
            }
            if (this.axHolder_.isVisible()) {
                graphics.drawRect(this.boundsD_.x, this.boundsD_.y, this.boundsD_.width, this.boundsD_.height);
                graphics.drawLine(n7, this.boundsD_.y, n7, this.boundsD_.y + this.boundsD_.height);
                for (n = this.boundsD_.y; n < this.boundsD_.y + this.boundsD_.height; n += TIC_INCREMENT) {
                    graphics.drawLine(n6, n, n5, n);
                }
            }
        }
        if (this.selected_) {
            for (n = 0; n < this.handles_.length; ++n) {
                Rectangle rectangle2 = this.handles_[n];
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            }
        }
        graphics.setColor(color);
    }

    private Rectangle computeDataGroupBounds() {
        Rectangle rectangle = this.pHolder_.getBounds();
        Margin margin = this.dg_.getMargin();
        float f = this.pHolder_.getPanelModel().getDpi();
        int n = (int)(margin.left * f);
        int n2 = (int)(margin.right * f);
        int n3 = (int)(margin.top * f);
        int n4 = (int)(margin.bottom * f);
        return new Rectangle(rectangle.x + n, rectangle.y + n3, rectangle.width - (n + n2), rectangle.height - (n3 + n4));
    }

    public void update(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 1;
        int n8 = 1;
        Rectangle rectangle = this.computeDataGroupBounds();
        if (this.axHolder_.getAxisOrientation() == 0) {
            n6 = rectangle.width;
            n5 = rectangle.x;
            n7 = this.axHolder_.getTicPosition();
            n8 = this.axHolder_.getLabelPosition();
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        n4 = rectangle.y + rectangle.height;
                        break;
                    }
                    case 0: {
                        n4 = rectangle.y;
                        break;
                    }
                }
            } else {
                n4 = this.originD_.y;
                n5 = this.boundsD_.x;
                n6 = this.boundsD_.width;
            }
            n3 = n5;
            n2 = n4;
            n = TIC_SPACE + TITLE_SPACE;
            switch (n8) {
                case 1: {
                    n += TITLE_HEIGHT;
                    break;
                }
                case 0: {
                    n += TITLE_HEIGHT;
                    n4 -= TITLE_HEIGHT + TITLE_SPACE;
                    break;
                }
            }
            switch (n7) {
                case 1: {
                    n += TIC_LENGTH;
                    break;
                }
                case 0: {
                    n += TIC_LENGTH;
                    n4 -= TIC_LENGTH + TIC_SPACE;
                    break;
                }
                case 2: {
                    n += 2 * TIC_LENGTH + TIC_SPACE;
                    n4 -= TIC_LENGTH + TIC_SPACE;
                }
            }
        } else {
            n = rectangle.height;
            n4 = rectangle.y;
            n7 = this.axHolder_.getTicPosition();
            n8 = this.axHolder_.getLabelPosition();
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        n5 = rectangle.x;
                        break;
                    }
                    case 3: {
                        n5 = rectangle.x + rectangle.width;
                        break;
                    }
                }
            } else {
                n5 = this.originD_.x;
                n4 = this.boundsD_.y;
                n = this.boundsD_.height;
            }
            n3 = n5;
            n2 = n4;
            n6 = TIC_SPACE + TITLE_SPACE;
            switch (n8) {
                case 1: {
                    n6 += TITLE_HEIGHT;
                    n5 -= TITLE_HEIGHT + TITLE_SPACE;
                    break;
                }
                case 0: {
                    n6 += TITLE_HEIGHT;
                    break;
                }
            }
            switch (n7) {
                case 1: {
                    n6 += TIC_LENGTH;
                    n5 -= TIC_LENGTH + TIC_SPACE;
                    break;
                }
                case 0: {
                    n6 += TIC_LENGTH;
                    break;
                }
                case 2: {
                    n6 += 2 * TIC_LENGTH + TIC_SPACE;
                    n5 -= TIC_LENGTH + TIC_SPACE;
                }
            }
        }
        this.setOrigin(new Point(n3, n2));
        this.setBounds(new Rectangle(n5, n4, n6, n));
        this.computeHandles();
    }

    public void setLocation(Point point) {
        this.boundsD_.x = point.x;
        this.boundsD_.y = point.y;
        this.axHolder_.setBoundsP(this.toRectangle(this.boundsD_));
        this.computeHandles();
    }

    public Rectangle getBounds() {
        return (Rectangle)this.boundsD_.clone();
    }

    public String getId() {
        return this.id_;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.update("AxisHolderDragBox.stateChanged()");
    }

    private Rectangle2D getBoundsP() {
        return null;
    }

    protected void computeHandles() {
        if (this.boundsD_ == null) {
            return;
        }
        int n = this.axHolder_.getTicPosition();
        Rectangle rectangle = this.computeDataGroupBounds();
        if (this.axHolder_.getAxisOrientation() == 0) {
            int n2;
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        n2 = rectangle.y + rectangle.height;
                        break;
                    }
                    case 0: {
                        n2 = rectangle.y;
                        break;
                    }
                }
            } else {
                n2 = this.originD_.y;
            }
            if (n == 0 || n == 2) {
                n2 -= handleSize_ + 1;
            }
            this.handles_[0].setBounds(this.boundsD_.x + 1, n2, handleSize_, handleSize_);
            this.handles_[1].setBounds(this.boundsD_.x + this.boundsD_.width - handleSize_ + 1, this.boundsD_.y + (this.boundsD_.height - handleSize_) / 2, handleSize_, handleSize_);
        } else {
            int n3;
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        n3 = rectangle.x;
                        break;
                    }
                    case 3: {
                        n3 = rectangle.x + rectangle.width;
                        break;
                    }
                }
            } else {
                n3 = this.originD_.x;
            }
            if (n == 1 || n == 2) {
                n3 -= handleSize_;
            }
            this.handles_[0].setBounds(n3, this.boundsD_.y + this.boundsD_.height - handleSize_ + 1, handleSize_, handleSize_);
            this.handles_[1].setBounds(this.boundsD_.x + (this.boundsD_.width - handleSize_) / 2, this.boundsD_.y + 1, handleSize_, handleSize_);
        }
    }

    public void mouseOperation(int n, int n2, int n3) {
        if (n == -1) {
            return;
        }
        switch (n) {
            case 0: {
                Point point = this.getLocation();
                point.x += n2;
                point.y += n3;
                this.setLocation(point);
                point = this.getOrigin();
                point.x += n2;
                point.y += n3;
                this.setOrigin(point);
                break;
            }
            case 1: {
                Rectangle rectangle = this.getBounds();
                if (this.axHolder_.getAxisOrientation() == 0) {
                    rectangle.width += n2;
                } else {
                    rectangle.height -= n3;
                    rectangle.y += n3;
                }
                this.setBounds(rectangle);
                break;
            }
        }
        this.axHolder_.setAxisPosition(4);
    }
}

