/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.LabelDrawer;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class LabelDrawer1
implements LabelDrawer,
Cloneable {
    private String label_;
    private Color clr_;
    private Font font_;
    private transient Layer layer_;
    private int orient_;
    private int halign_;
    private int valign_;
    private Point dorigin_;
    private Rectangle dbounds_;
    private Point2D.Double porigin_;
    private Rectangle2D.Double pbounds_;
    private Polygon dpolygon_;
    private double angle_;
    private double sinthta_;
    private double costhta_;
    private double height_;
    private boolean visible_;
    private Rectangle savedBounds_ = null;
    private Point savedLoc_ = null;

    public LabelDrawer1(String string, double d, Point2D.Double double_, int n, int n2) {
        this.label_ = string;
        this.height_ = d;
        this.porigin_ = double_;
        this.valign_ = n;
        this.halign_ = n2;
        this.dbounds_ = new Rectangle();
        this.dorigin_ = new Point(0, 0);
        this.pbounds_ = new Rectangle2D.Double();
    }

    public LabelDrawer copy() {
        LabelDrawer labelDrawer = null;
        return labelDrawer;
    }

    public void draw(Graphics graphics) throws LayerNotFoundException {
        if (this.label_.length() <= 0 || !this.visible_ || graphics == null) {
            return;
        }
        if (this.layer_ == (Layer)null) {
            throw new LayerNotFoundException();
        }
        this.computeBoundsD(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.clr_ == null) {
            graphics.setColor(this.layer_.getPane().getComponent().getForeground());
        } else {
            graphics.setColor(this.clr_);
        }
        if (this.orient_ == 0) {
            int n = this.dbounds_.x;
            int n2 = this.dbounds_.y + fontMetrics.getMaxAscent();
            graphics.drawString(this.label_, n, n2);
        } else if (this.orient_ == 1) {
            if (this.dbounds_.height < 1) {
                this.dbounds_.height = 1;
            }
            if (this.dbounds_.width < 1) {
                this.dbounds_.width = 1;
            }
            Image image = this.layer_.getPane().getComponent().createImage(this.dbounds_.height, this.dbounds_.width);
            Graphics graphics2 = image.getGraphics();
            graphics2.setFont(graphics.getFont());
            graphics2.setColor(this.layer_.getPane().getComponent().getBackground());
            graphics2.fillRect(0, 0, this.dbounds_.height, this.dbounds_.width);
            if (this.clr_ == null) {
                graphics2.setColor(this.layer_.getPane().getComponent().getForeground());
            } else {
                graphics2.setColor(this.clr_);
            }
            graphics2.drawString(this.label_, 0, fontMetrics.getMaxAscent());
            int[] nArray = new int[this.dbounds_.width * this.dbounds_.height];
            int[] nArray2 = new int[this.dbounds_.width * this.dbounds_.height];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.dbounds_.height, this.dbounds_.width, nArray, 0, this.dbounds_.height);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
            for (int i = 0; i < this.dbounds_.height; ++i) {
                for (int j = 0; j < this.dbounds_.width; ++j) {
                    nArray2[j + (this.dbounds_.height - i - 1) * this.dbounds_.width] = nArray[i + j * this.dbounds_.height];
                }
            }
            ColorModel colorModel = ColorModel.getRGBdefault();
            Image image2 = this.layer_.getPane().getComponent().createImage(new MemoryImageSource(this.dbounds_.width, this.dbounds_.height, colorModel, nArray2, 0, this.dbounds_.width));
            graphics.setPaintMode();
            graphics.drawImage(image2, this.dbounds_.x, this.dbounds_.y, this.layer_.getPane().getComponent());
        } else {
            int n;
            if (this.dbounds_.height < 1 || this.dbounds_.width < 1) {
                return;
            }
            int[] nArray = this.dpolygon_.xpoints;
            int[] nArray3 = this.dpolygon_.ypoints;
            int n3 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int n4 = fontMetrics.stringWidth(this.label_);
            Image image = this.layer_.getPane().getComponent().createImage(n4, n3);
            Graphics graphics3 = image.getGraphics();
            graphics3.setFont(graphics.getFont());
            graphics3.setColor(this.layer_.getPane().getComponent().getBackground());
            graphics3.fillRect(0, 0, n4, n3);
            if (this.clr_ == null) {
                graphics3.setColor(this.layer_.getPane().getComponent().getForeground());
            } else {
                graphics3.setColor(this.clr_);
            }
            graphics3.drawString(this.label_, 0, fontMetrics.getMaxAscent());
            int[] nArray4 = new int[n4 * n3];
            int[] nArray5 = new int[this.dbounds_.width * this.dbounds_.height];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n4, n3, nArray4, 0, n4);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
            int n5 = 0;
            int n6 = 0;
            for (n = 1; n < 4; ++n) {
                n5 = Math.min(n5, nArray[n] - nArray[0]);
                n6 = Math.min(n6, nArray3[n] - nArray3[0]);
            }
            n5 = -n5;
            n6 = -n6;
            double[] dArray = new double[]{0.0, 0.5};
            double[] dArray2 = new double[]{0.0, 0.5};
            for (int i = 0; i < n3; ++i) {
                for (n = 0; n < n4; ++n) {
                    for (int j = 0; j < dArray.length; ++j) {
                        double d = (double)n + dArray[j];
                        double d2 = (double)i + dArray2[j];
                        int n7 = nArray4[n + i * n4];
                        if (n7 == -1) continue;
                        int n8 = (int)(d * this.costhta_ + d2 * this.sinthta_ + 0.5) + n5;
                        int n9 = (int)(d2 * this.costhta_ - d * this.sinthta_ + 0.5) + n6;
                        if (n8 < 0) {
                            n8 = 0;
                        }
                        if (n8 >= this.dbounds_.width) {
                            n8 = this.dbounds_.width - 1;
                        }
                        if (n9 < 0) {
                            n9 = 0;
                        }
                        if (n9 >= this.dbounds_.height) {
                            n9 = this.dbounds_.height - 1;
                        }
                        nArray5[n8 + n9 * this.dbounds_.width] = n7;
                    }
                }
            }
            ColorModel colorModel = ColorModel.getRGBdefault();
            Image image3 = this.layer_.getPane().getComponent().createImage(new MemoryImageSource(this.dbounds_.width, this.dbounds_.height, colorModel, nArray5, 0, this.dbounds_.width));
            graphics.setPaintMode();
            graphics.drawImage(image3, this.dbounds_.x, this.dbounds_.y, this.layer_.getPane().getComponent());
        }
    }

    public void setText(String string) {
        this.label_ = string;
    }

    public String getText() {
        return this.label_;
    }

    public void setColor(Color color) {
        this.clr_ = color;
    }

    public Color getColor() {
        return this.clr_;
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public Font getFont() {
        return this.font_;
    }

    public void setLayer(Layer layer) {
        this.layer_ = layer;
        if (this.savedBounds_ != null) {
            this.setBounds(this.savedBounds_.x, this.savedBounds_.y, this.savedBounds_.width, this.savedBounds_.height);
            this.savedBounds_ = null;
        }
        if (this.savedLoc_ != null) {
            this.setLocation(this.savedLoc_);
            this.savedLoc_ = null;
        }
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public void setOrientation(int n) {
        if (this.orient_ != n) {
            if (n == 0) {
                this.costhta_ = 1.0;
                this.sinthta_ = 0.0;
            } else if (n == 1) {
                this.costhta_ = 0.0;
                this.sinthta_ = 1.0;
            }
            this.orient_ = n;
        }
    }

    public int getOrientation() {
        return this.orient_;
    }

    public void setHAlign(int n) {
        this.halign_ = n;
    }

    public int getHAlign() {
        return this.halign_;
    }

    public void setVAlign(int n) {
        this.valign_ = n;
    }

    public int getVAlign() {
        return this.valign_;
    }

    public void setLocation(Point point) {
        if (this.layer_ == null) {
            this.savedLoc_ = new Point(point);
            return;
        }
        this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
        this.setBounds(point.x, point.y, this.dbounds_.width, this.dbounds_.height);
    }

    public Point getLocation() {
        if (this.savedLoc_ != null) {
            return this.savedLoc_;
        }
        return this.dorigin_;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.layer_ == null) {
            this.savedBounds_ = new Rectangle(n, n2, n3, n4);
            return;
        }
        Graphics graphics = this.layer_.getPane().getComponent().getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setFont(this.font_);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n7 = fontMetrics.getAscent();
        if (this.orient_ == 0) {
            int n8 = n3;
            n6 = n;
            n5 = n2 - fontMetrics.getMaxDescent() + n4;
            switch (this.valign_) {
                case 0: {
                    n5 -= n7;
                    break;
                }
                case 1: {
                    n5 -= n7 / 2;
                    break;
                }
            }
            switch (this.halign_) {
                case 2: {
                    n6 += n8;
                    break;
                }
                case 1: {
                    n6 += n8 / 2;
                    break;
                }
            }
        } else {
            int n9 = n4;
            n5 = n2 + n4;
            n6 = n + fontMetrics.getMaxAscent();
            switch (this.valign_) {
                case 0: {
                    n6 -= n7;
                    break;
                }
                case 1: {
                    n6 -= n7 / 2;
                    break;
                }
            }
            switch (this.halign_) {
                case 2: {
                    n5 -= n9;
                    break;
                }
                case 1: {
                    n5 -= n9 / 2;
                    break;
                }
            }
        }
        if (this.dorigin_.x != n6 || this.dorigin_.y != n5) {
            this.dorigin_.x = n6;
            this.dorigin_.y = n5;
            this.porigin_.x = this.layer_.getXDtoP(n6);
            this.porigin_.y = this.layer_.getYDtoP(n5);
        }
    }

    public Rectangle getBounds() {
        if (this.savedBounds_ != null) {
            return this.savedBounds_;
        }
        if (this.layer_ != null) {
            this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
        }
        return this.dbounds_;
    }

    public void setLocationP(Point2D.Double double_) {
        this.porigin_ = double_;
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    public Rectangle2D.Double getBoundsP() {
        this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
        return this.pbounds_;
    }

    public void setAngle(double d) {
        this.angle_ = d;
        double d2 = this.angle_ * Math.PI / 180.0;
        if (Math.abs(d2) < 0.001) {
            this.orient_ = 0;
            this.costhta_ = 1.0;
            this.sinthta_ = 0.0;
        } else if (Math.abs(d2 - 90.0) < 0.001) {
            this.orient_ = 1;
            this.costhta_ = 0.0;
            this.sinthta_ = 1.0;
        } else {
            this.orient_ = 2;
            this.costhta_ = Math.cos(d2);
            this.sinthta_ = Math.sin(d2);
        }
    }

    public double getAngle() {
        return this.angle_;
    }

    public void setHeightP(double d) {
        this.height_ = d;
    }

    public double getHeightP() {
        return this.height_;
    }

    public void setVisible(boolean bl) {
        this.visible_ = bl;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    private void computeBoundsD(Graphics graphics) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        if (graphics == null) {
            return;
        }
        this.font_ = this.computeFontSize(graphics);
        graphics.setFont(this.font_);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.label_);
        int n2 = fontMetrics.getAscent();
        int n3 = this.layer_.getXPtoD(this.porigin_.x);
        int n4 = this.layer_.getYPtoD(this.porigin_.y);
        this.dorigin_.x = n3;
        this.dorigin_.y = n4;
        int n5 = n3;
        int n6 = n4;
        switch (this.valign_) {
            case 0: {
                n4 += n2;
                break;
            }
            case 1: {
                n4 += n2 / 2;
                break;
            }
        }
        switch (this.halign_) {
            case 2: {
                n3 -= n;
                break;
            }
            case 1: {
                n3 -= n / 2;
                break;
            }
        }
        nArray[0] = n3;
        nArray[1] = nArray[0];
        nArray[2] = nArray[0] + n;
        nArray[3] = nArray[2];
        int n7 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        nArray2[0] = n4 + fontMetrics.getMaxDescent() - n7;
        nArray2[1] = nArray2[0] + n7;
        nArray2[2] = nArray2[1];
        nArray2[3] = nArray2[0];
        for (int i = 0; i < 4; ++i) {
            nArray3[i] = (int)((double)(nArray[i] - n5) * this.costhta_ + (double)(nArray2[i] - n6) * this.sinthta_) + n5;
            nArray4[i] = (int)((double)(nArray2[i] - n6) * this.costhta_ - (double)(nArray[i] - n5) * this.sinthta_) + n6;
        }
        this.dpolygon_ = new Polygon(nArray3, nArray4, 4);
        this.dbounds_ = this.dpolygon_.getBounds();
        this.pbounds_.x = this.layer_.getXDtoP(this.dbounds_.x);
        this.pbounds_.y = this.layer_.getYDtoP(this.dbounds_.y);
        this.pbounds_.width = this.layer_.getXDtoP(this.dbounds_.x + this.dbounds_.width) - this.pbounds_.x;
        this.pbounds_.height = this.pbounds_.y - this.layer_.getYDtoP(this.dbounds_.y + this.dbounds_.height);
    }

    Font computeFontSize(Graphics graphics) {
        if (graphics == null) {
            return this.font_;
        }
        int n = this.layer_.getXPtoD(this.height_) - this.layer_.getXPtoD(0.0);
        int n2 = n - 3;
        Font font = new Font(this.font_.getName(), this.font_.getStyle(), n2);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n = fontMetrics.getAscent() + fontMetrics.getDescent();
        double d = this.layer_.getXDtoP(n) - this.layer_.getXDtoP(0);
        n2 = font.getSize();
        int n3 = (int)((double)n2 * (this.height_ / d));
        for (int i = 1; n2 != n3 && i < 5; ++i) {
            font = new Font(this.font_.getName(), this.font_.getStyle(), n3);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.getAscent() + fontMetrics.getDescent();
            double d2 = this.layer_.getXDtoP(n) - this.layer_.getXDtoP(0);
            double d3 = Math.abs(this.height_ - d);
            double d4 = Math.abs(this.height_ - d2);
            if (Math.abs(n2 - n3) <= 1 && d3 > d4) {
                return font;
            }
            n2 = n3;
            d = d2;
            n3 = (int)((double)n2 * (this.height_ / d));
        }
        return font;
    }

    public float getStringWidth(Graphics graphics) {
        if (graphics == null) {
            return 0.0f;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font_);
        return fontMetrics.stringWidth(this.label_);
    }

    public float getStringHeight(Graphics graphics) {
        if (graphics == null) {
            return 0.0f;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font_);
        return (float)((double)fontMetrics.getAscent() * 0.75) + 1.0f;
    }
}

