/*
 * Decompiled with CFR 0.152.
 */
package edu.cwru.bam.io.serialization;

import edu.cwru.bam.io.serialization.Group;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeSet;

public class Session
implements Serializable {
    public SessionMenuFile menuFile;
    public SessionMenuGraph menuGraph;
    public SessionBaselinePanel baselinePanel;
    public SessionRun run;
    private static final long globalUID = 300L;
    private static final long serialVersionUID = 300L;

    public Session(boolean bl2) throws BushSucksb {
        this.menuFile = new SessionMenuFile(bl2);
        this.menuGraph = new SessionMenuGraph(bl2);
        this.baselinePanel = new SessionBaselinePanel(bl2);
        this.run = new SessionRun();
    }

    public class SessionRun
    implements Serializable {
        public int kHat = BushSucksq.m().i();
        public int colorSet = BushSucksq.m().b();
        public int varianceSet = BushSucksq.m().d();
        public int accuracySet = BushSucksq.m().c();
        public int clusterSet = BushSucksq.m().e();
        public int randomSet = BushSucksq.m().f();
        private static final long serialVersionUID = 300L;
    }

    public class SessionBaselinePanel
    implements Serializable {
        public int baselineValue;
        private static final long serialVersionUID = 300L;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SessionBaselinePanel(boolean bl2) throws BushSucksb {
            if (bl2) {
                this.baselineValue = BushSucksg.n().h();
                return;
            }
            this.baselineValue = BushSucksp.b();
        }
    }

    public class SessionMenuGraph
    implements Serializable {
        public TreeSet trackerSet;
        private static final long serialVersionUID = 300L;

        public SessionMenuGraph(boolean bl2) {
            this.trackerSet = bl2 ? new TreeSet() : BushSuckss.g().f();
        }
    }

    public class SessionMenuFile
    implements Serializable {
        public File inputFile;
        public SessionInputData inputData;
        private static final long serialVersionUID = 300L;

        /*
         * Enabled aggressive block sorting
         */
        public SessionMenuFile(boolean bl2) throws BushSucksb {
            this.inputFile = bl2 ? BushSucksg.n().i() : BushSucksaf.c().a();
            this.inputData = new SessionInputData(bl2);
        }

        public class SessionInputData
        implements Serializable {
            public int geneCount;
            public int gArrayCount;
            public String[] geneLabel;
            public double[] dataMatrix;
            public ArrayList<Group> bamChipList;
            public ArrayList<Group> bamBaselineList;
            private static final long serialVersionUID = 300L;

            public SessionInputData(boolean bl2) throws BushSucksb {
                BushSucksk bushSucksk;
                if (bl2) {
                    BushSucksg.n();
                    bushSucksk = BushSucksg.f;
                } else {
                    BushSucksaf.c();
                    bushSucksk = BushSucksaf.a;
                }
                this.geneCount = bushSucksk.f();
                this.gArrayCount = bushSucksk.g();
                this.geneLabel = bushSucksk.i();
                this.dataMatrix = bushSucksk.h();
                this.bamChipList = bushSucksk.k();
                this.bamBaselineList = bushSucksk.l();
            }
        }
    }
}

