/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.Domain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import java.io.Serializable;

public class SoTDomain
implements Serializable {
    SoTRange xRange_ = null;
    SoTRange yRange_ = null;
    boolean xReversed_ = false;
    boolean yReversed_ = false;

    public SoTDomain() {
    }

    public SoTDomain(Domain domain) {
        this.xRange_ = domain.isXTime() ? new SoTRange.Time(domain.getTimeRange()) : new SoTRange.Double(domain.getXRange());
        this.yRange_ = domain.isYTime() ? new SoTRange.Time(domain.getTimeRange()) : new SoTRange.Double(domain.getYRange());
        this.xReversed_ = domain.isXReversed();
        this.yReversed_ = domain.isYReversed();
    }

    public SoTDomain(SoTDomain soTDomain) {
        this.xRange_ = soTDomain.getXRange();
        this.yRange_ = soTDomain.getYRange();
        this.xReversed_ = soTDomain.isXReversed();
        this.yReversed_ = soTDomain.isYReversed();
    }

    public SoTDomain(SoTRange soTRange, SoTRange soTRange2) {
        this.xRange_ = soTRange;
        this.yRange_ = soTRange2;
        this.xReversed_ = false;
        this.yReversed_ = false;
    }

    public SoTDomain(SoTRange soTRange, SoTRange soTRange2, boolean bl, boolean bl2) {
        this.xRange_ = soTRange;
        this.yRange_ = soTRange2;
        this.xReversed_ = bl;
        this.yReversed_ = bl2;
    }

    public void setXRange(SoTRange soTRange) {
        this.xRange_ = soTRange;
    }

    public SoTRange getXRange() {
        return this.xRange_;
    }

    public void setYRange(SoTRange soTRange) {
        this.yRange_ = soTRange;
    }

    public SoTRange getYRange() {
        return this.yRange_;
    }

    public boolean isXTime() {
        return this.xRange_.isTime();
    }

    public boolean isYTime() {
        return this.yRange_.isTime();
    }

    public SoTPoint getCenter() {
        SoTValue soTValue = null;
        SoTValue soTValue2 = null;
        soTValue = this.isXTime() ? new SoTValue.Time((this.xRange_.getStart().getLongTime() + this.xRange_.getEnd().getLongTime()) / 2L) : new SoTValue.Double((((Number)this.xRange_.getStart().getObjectValue()).doubleValue() + ((Number)this.xRange_.getEnd().getObjectValue()).doubleValue()) / 2.0);
        soTValue2 = this.isYTime() ? new SoTValue.Time((this.yRange_.getStart().getLongTime() + this.yRange_.getEnd().getLongTime()) / 2L) : new SoTValue.Double((((Number)this.yRange_.getStart().getObjectValue()).doubleValue() + ((Number)this.yRange_.getEnd().getObjectValue()).doubleValue()) / 2.0);
        return new SoTPoint(soTValue, soTValue2);
    }

    public boolean equals(SoTDomain soTDomain) {
        if (!this.xRange_.equals(soTDomain.getXRange())) {
            return false;
        }
        if (!this.yRange_.equals(soTDomain.getYRange())) {
            return false;
        }
        if (this.xReversed_ != soTDomain.isXReversed()) {
            return false;
        }
        return this.yReversed_ == soTDomain.isYReversed();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("x=");
        stringBuffer.append(this.xRange_).append(",y=");
        stringBuffer.append(this.yRange_);
        stringBuffer.append(", xRev=").append(this.xReversed_);
        stringBuffer.append(", yRev=").append(this.yReversed_);
        return stringBuffer.toString();
    }

    public void setXReversed(boolean bl) {
        this.xReversed_ = bl;
    }

    public boolean isXReversed() {
        return this.xReversed_;
    }

    public void setYReversed(boolean bl) {
        this.yReversed_ = bl;
    }

    public boolean isYReversed() {
        return this.yReversed_;
    }
}

