/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.sgt.Transform;
import gov.noaa.pmel.util.Range2D;
import java.beans.PropertyChangeListener;

public class LinearTransform
implements Transform {
    Range2D mPhysRange = null;
    Range2D mUserRange = null;
    double mPUSlope;
    double mPUYintercept;
    double mUPSlope;
    double mUPYintercept;

    public LinearTransform(double d, double d2, double d3, double d4) {
        this.setRangeP(d, d2);
        this.setRangeU(d3, d4);
        this.computeTransforms();
    }

    public LinearTransform(Range2D range2D, Range2D range2D2) {
        this.setRangeP(range2D);
        this.setRangeU(range2D2);
        this.computeTransforms();
    }

    public LinearTransform() {
    }

    public void setRangeP(double d, double d2) {
        this.mPhysRange = new Range2D(d, d2);
    }

    public void setRangeP(Range2D range2D) {
        this.mPhysRange = null;
        this.mPhysRange = new Range2D();
        this.mPhysRange.add(range2D);
    }

    public Range2D getRangeP() {
        return this.mPhysRange;
    }

    public void setRangeU(double d, double d2) {
        this.mUserRange = new Range2D(d, d2);
    }

    public void setRangeU(Range2D range2D) {
        this.mUserRange = null;
        this.mUserRange = new Range2D();
        this.mUserRange.add(range2D);
        this.computeTransforms();
    }

    public Range2D getRangeU() {
        return this.mUserRange;
    }

    public double getTransP(double d) {
        return this.mUPSlope * d + this.mUPYintercept;
    }

    public double getTransU(double d) {
        return this.mPUSlope * d + this.mPUYintercept;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void computeTransforms() {
        this.computePULine();
        this.computeUPLine();
    }

    private void computePULine() {
        double d = this.mPhysRange.start - this.mPhysRange.end;
        double d2 = this.mUserRange.start - this.mUserRange.end;
        this.mPUSlope = d2 / d;
        this.mPUYintercept = this.mUserRange.start - this.mPUSlope * this.mPhysRange.start;
    }

    private void computeUPLine() {
        double d = this.mPhysRange.start - this.mPhysRange.end;
        double d2 = this.mUserRange.start - this.mUserRange.end;
        this.mUPSlope = d / d2;
        this.mUPYintercept = this.mPhysRange.start - this.mPUSlope * this.mUserRange.start;
    }
}

