/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

public class GeographicValue {
    protected int degrees;
    protected int minutes;
    protected int seconds;
    protected int sign;
    protected float decimalValue;

    public GeographicValue() {
        this.decimalValue = 0.0f;
        this.decimalToDegMinSec();
    }

    public GeographicValue(float f) {
        this.decimalValue = f;
        this.decimalToDegMinSec();
    }

    public void decimalToDegMinSec() {
        this.sign = 1;
        if (this.decimalValue < 0.0f) {
            this.sign = -1;
        }
        float f = Math.abs(this.decimalValue);
        this.degrees = new Double(f).intValue();
        float f2 = Math.abs(f - (float)this.degrees);
        float f3 = f2 * 60.0f;
        float f4 = Math.abs(f3);
        this.minutes = new Double(Math.floor(new Double(f4))).intValue();
        float f5 = Math.abs(f4 - (float)this.minutes);
        double d = f5 * 60.0f;
        this.seconds = new Long(Math.round(d)).intValue();
        if (this.seconds == 60) {
            this.seconds = 0;
            ++this.minutes;
        }
    }

    public void degMinSecToDecimal() {
        float f = this.minutes;
        float f2 = this.degrees;
        float f3 = this.seconds;
        if (this.seconds == 0) {
            f3 = 0.1f;
        }
        f2 += (f += f3 / 60.0f) / 60.0f;
        this.decimalValue = f2 *= (float)this.sign;
    }

    public void setDegrees(int n) {
        this.degrees = n;
    }

    public void setMinutes(int n) {
        this.minutes = n;
    }

    public void setSeconds(int n) {
        this.seconds = n;
    }

    public void setSign(int n) {
        this.sign = n;
    }

    public void setDecimalValue(float f) {
        this.decimalValue = f;
        this.decimalToDegMinSec();
    }

    public int getDegrees() {
        return this.degrees;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getSign() {
        return this.sign;
    }

    public float getDecimalValue() {
        return this.decimalValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ----------------------------:  \n degrees: " + this.degrees + " \n minutes: " + this.minutes + " \n seconds: " + this.seconds + " \n decimalValue: " + this.decimalValue);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        GeographicValue geographicValue = new GeographicValue(-154.70027f);
        System.out.println(" toString: " + geographicValue.toString());
    }
}

