/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.JSlider2;
import gov.noaa.pmel.util.Range2D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JSlider2Double
extends JComponent
implements Serializable {
    boolean twoHandles_;
    Range2D range_;
    double minValue_;
    double oldMinValue_;
    double maxValue_;
    double oldMaxValue_;
    double scale_;
    String format_ = "";
    DecimalFormat form_;
    boolean indexed_ = false;
    double[] values_;
    double[] scaled_;
    JSlider2 slider_;
    JLabel minLabel_;
    JTextField minField_;
    JLabel maxLabel_;
    JTextField maxField_;
    JPanel panel_;
    GridBagLayout layout_;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public JSlider2Double() {
        this(true);
    }

    public JSlider2Double(boolean bl) {
        this.twoHandles_ = bl;
        this.setLayout(new BorderLayout(0, 0));
        this.panel_ = new JPanel();
        this.layout_ = new GridBagLayout();
        this.panel_.setLayout(this.layout_);
        this.panel_.setBounds(12, 12, 384, 156);
        this.slider_ = new JSlider2();
        this.slider_.setBounds(5, 20, 374, 49);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.layout_.setConstraints(this.slider_, gridBagConstraints);
        this.panel_.add(this.slider_);
        this.minLabel_ = new JLabel("Minimum:", 4);
        this.minLabel_.setBounds(6, 79, 68, 23);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.layout_.setConstraints(this.minLabel_, gridBagConstraints);
        this.panel_.add(this.minLabel_);
        this.minField_ = new JTextField();
        this.minField_.setBounds(80, 79, 299, 23);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.layout_.setConstraints(this.minField_, gridBagConstraints);
        this.panel_.add(this.minField_);
        this.maxLabel_ = new JLabel("Maximum:", 4);
        this.maxLabel_.setBounds(5, 112, 70, 23);
        this.maxField_ = new JTextField();
        this.maxField_.setBounds(80, 112, 299, 23);
        if (this.twoHandles_) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 10, 5);
            this.layout_.setConstraints(this.maxLabel_, gridBagConstraints);
            this.panel_.add(this.maxLabel_);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 10, 5);
            this.layout_.setConstraints(this.maxField_, gridBagConstraints);
            this.panel_.add(this.maxField_);
        } else {
            this.minLabel_.setText("Value:");
        }
        this.add("Center", this.panel_);
        SymPropertyChange symPropertyChange = new SymPropertyChange();
        this.slider_.addPropertyChangeListener(symPropertyChange);
        SymAction symAction = new SymAction();
        this.minField_.addActionListener(symAction);
        this.maxField_.addActionListener(symAction);
        this.form_ = new DecimalFormat(this.format_);
        this.form_.setGroupingUsed(false);
        this.range_ = new Range2D(0.0, 1.0);
        this.setRange(this.range_);
    }

    public void setRange(double d, double d2) {
        this.setRange(new Range2D(d, d2));
    }

    public void setRange(Range2D range2D) {
        this.range_ = range2D;
        this.scale_ = this.range_.end - this.range_.start;
        this.slider_.setMinLabel(this.form_.format(this.range_.start));
        this.slider_.setMaxLabel(this.form_.format(this.range_.end));
        this.oldMinValue_ = this.minValue_ = this.range_.start;
        double d = (this.minValue_ - this.range_.start) / this.scale_;
        this.slider_.setMinValue(d);
        this.minField_.setText(this.form_.format(this.minValue_));
        this.oldMaxValue_ = this.maxValue_ = this.range_.end;
        double d2 = (this.maxValue_ - this.range_.start) / this.scale_;
        this.slider_.setMaxValue(d2);
        this.maxField_.setText(this.form_.format(this.maxValue_));
        if (this.indexed_) {
            for (int i = 0; i < this.values_.length; ++i) {
                this.scaled_[i] = (this.values_[i] - this.range_.start) / this.scale_;
            }
            this.slider_.setIndexValues(this.scaled_);
        }
    }

    public Range2D getRange() {
        return this.range_;
    }

    public void setMinRange(double d) {
        this.range_.start = d;
        this.setRange(this.range_);
    }

    public double getMinRange() {
        return this.range_.start;
    }

    public void setMaxRange(double d) {
        this.range_.end = d;
        this.setRange(this.range_);
    }

    public double getMaxRange() {
        return this.range_.end;
    }

    public void reset() {
        this.slider_.reset();
    }

    public void setIndexValues(double[] dArray) {
        this.values_ = dArray;
        this.indexed_ = true;
        this.scaled_ = new double[this.values_.length];
        this.setRange(this.range_);
    }

    public void setTwoHandles(boolean bl) {
        this.twoHandles_ = bl;
        this.slider_.setTwoHandles(bl);
        if (this.twoHandles_) {
            GridBagConstraints gridBagConstraints;
            if (!this.panel_.isAncestorOf(this.maxLabel_)) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(5, 5, 10, 5);
                this.layout_.setConstraints(this.maxLabel_, gridBagConstraints);
                this.panel_.add(this.maxLabel_);
            }
            if (!this.panel_.isAncestorOf(this.maxField_)) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(5, 0, 10, 5);
                this.layout_.setConstraints(this.maxField_, gridBagConstraints);
                this.panel_.add(this.maxField_);
            }
            this.minLabel_.setText("Minimum:");
            this.panel_.invalidate();
        } else {
            this.minLabel_.setText("Value:");
            if (this.panel_.isAncestorOf(this.maxLabel_)) {
                this.panel_.remove(this.maxLabel_);
            }
            if (this.panel_.isAncestorOf(this.maxField_)) {
                this.panel_.remove(this.maxField_);
            }
            this.panel_.invalidate();
        }
        this.slider_.setDoubleBuffered(true);
    }

    public boolean getTwoHandles() {
        return this.twoHandles_;
    }

    public boolean isTwoHandles() {
        return this.twoHandles_;
    }

    public void setFormat(String string) {
        this.format_ = string;
        this.form_ = new DecimalFormat(this.format_);
        this.form_.setGroupingUsed(false);
        this.setRange(this.range_);
    }

    public String getFormat() {
        return this.format_;
    }

    public double getStartValue() {
        this.minValue_ = this.range_.start > this.range_.end ? Math.min(Double.valueOf(this.minField_.getText()), this.range_.start) : Math.max(Double.valueOf(this.minField_.getText()), this.range_.start);
        return this.minValue_;
    }

    public double getEndValue() {
        this.maxValue_ = this.range_.start > this.range_.end ? Math.max(Double.valueOf(this.maxField_.getText()), this.range_.end) : Math.min(Double.valueOf(this.maxField_.getText()), this.range_.end);
        return this.maxValue_;
    }

    public void setStartValue(double d) {
        this.minValue_ = this.range_.start > this.range_.end ? Math.min(d, this.range_.start) : Math.max(d, this.range_.start);
        d = (this.minValue_ - this.range_.start) / this.scale_;
        this.slider_.setMinValue(d);
    }

    public void setEndValue(double d) {
        this.maxValue_ = this.range_.start > this.range_.end ? Math.max(d, this.range_.end) : Math.min(d, this.range_.end);
        d = (this.maxValue_ - this.range_.start) / this.scale_;
        this.slider_.setMaxValue(d);
    }

    public double getMinValue() {
        this.minValue_ = Math.max(Double.valueOf(this.minField_.getText()), this.range_.start);
        this.minValue_ = Math.min(this.minValue_, this.maxValue_);
        return this.minValue_;
    }

    public void setMinValue(double d) {
        this.minValue_ = d;
        this.minValue_ = Math.min(this.minValue_, this.maxValue_);
        d = (this.minValue_ - this.range_.start) / this.scale_;
        this.slider_.setMinValue(d);
    }

    public double getMaxValue() {
        this.maxValue_ = Math.min(Double.valueOf(this.maxField_.getText()), this.range_.end);
        this.maxValue_ = Math.max(this.maxValue_, this.minValue_);
        return this.maxValue_;
    }

    public void setMaxValue(double d) {
        this.maxValue_ = d;
        this.maxValue_ = Math.max(this.maxValue_, this.minValue_);
        d = (this.maxValue_ - this.range_.start) / this.scale_;
        this.slider_.setMaxValue(d);
    }

    public void setShowBorder(boolean bl) {
        this.slider_.setShowBorder(bl);
    }

    public boolean getShowBorder() {
        return this.slider_.getShowBorder();
    }

    public void setHandleSize(int n) {
        this.slider_.setHandleSize(n);
    }

    public int getHandleSize() {
        return this.slider_.getHandleSize();
    }

    public void setAlwaysPost(boolean bl) {
        this.slider_.setAlwaysPost(bl);
    }

    public boolean getAlwaysPost() {
        return this.slider_.getAlwaysPost();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public Dimension getMinimumSize() {
        int n = this.twoHandles_ ? 135 : 105;
        return new Dimension(180, n);
    }

    public Dimension getPreferredSize() {
        int n = this.twoHandles_ ? 135 : 105;
        return new Dimension(384, n);
    }

    public boolean isIndexed() {
        return this.indexed_;
    }

    public void setIndexed(boolean bl) {
        this.indexed_ = bl;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.validate();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.validate();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    void slider_propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("minValue")) {
            this.minValue_ = this.range_.start + this.slider_.getMinValue() * this.scale_;
            this.minField_.setText(this.form_.format(this.minValue_));
            this.testMin();
        } else if (propertyChangeEvent.getPropertyName().equals("maxValue")) {
            this.maxValue_ = this.range_.start + this.slider_.getMaxValue() * this.scale_;
            this.maxField_.setText(this.form_.format(this.maxValue_));
            this.testMax();
        }
    }

    void minField_EnterHit(ActionEvent actionEvent) {
        this.minValue_ = Math.max(Double.valueOf(this.minField_.getText()), this.range_.start);
        this.minValue_ = Math.min(this.minValue_, this.maxValue_);
        double d = (this.minValue_ - this.range_.start) / this.scale_;
        this.slider_.setMinValue(d);
    }

    void maxField_EnterHit(ActionEvent actionEvent) {
        this.maxValue_ = Math.min(Double.valueOf(this.maxField_.getText()), this.range_.end);
        this.maxValue_ = Math.max(this.maxValue_, this.minValue_);
        double d = (this.maxValue_ - this.range_.start) / this.scale_;
        this.slider_.setMaxValue(d);
    }

    void testMax() {
        if (this.oldMaxValue_ != this.maxValue_) {
            Double d = new Double(this.oldMaxValue_);
            this.oldMaxValue_ = this.maxValue_;
            this.changes.firePropertyChange("maxValue", d, new Double(this.maxValue_));
        }
    }

    void testMin() {
        if (this.oldMinValue_ != this.minValue_) {
            Double d = new Double(this.oldMinValue_);
            this.oldMinValue_ = this.minValue_;
            this.changes.firePropertyChange("minValue", d, new Double(this.minValue_));
        }
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{-20.0, -10.0, -5.0, -2.5, 0.0, 2.5, 5.0, 10.0, 15.0, 20.0};
        JFrame jFrame = new JFrame("JSlider2Double Test");
        jFrame.setSize(400, 200);
        jFrame.getContentPane().setLayout(new BorderLayout());
        JSlider2Double jSlider2Double = new JSlider2Double();
        jSlider2Double.setRange(new Range2D(-20.0, 20.0));
        jSlider2Double.setStartValue(-10.0);
        jSlider2Double.setEndValue(15.0);
        jSlider2Double.setIndexValues(dArray);
        jSlider2Double.setAlwaysPost(true);
        jFrame.getContentPane().add((Component)jSlider2Double, "Center");
        jFrame.setVisible(true);
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JSlider2Double.this.minField_) {
                JSlider2Double.this.minField_EnterHit(actionEvent);
            } else if (object == JSlider2Double.this.maxField_) {
                JSlider2Double.this.maxField_EnterHit(actionEvent);
            }
        }
    }

    class SymPropertyChange
    implements PropertyChangeListener {
        SymPropertyChange() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object == JSlider2Double.this.slider_) {
                JSlider2Double.this.slider_propertyChange(propertyChangeEvent);
            }
        }
    }
}

