/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.beans.SliderHandle;
import gov.noaa.pmel.util.Range;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.EtchedBorder;

public class JSlider2
extends JComponent
implements Serializable {
    protected Range rawRange_;
    protected int handleSize_;
    protected Dimension size_;
    protected int yval_;
    boolean showBorder_;
    boolean twoHandles_;
    boolean alwaysPost_;
    SliderHandle minHandle_;
    SliderHandle maxHandle_;
    int min_;
    int max_;
    double scale_;
    double minValue_;
    double maxValue_;
    double minOld_;
    double maxOld_;
    String minLabel_;
    String maxLabel_;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    boolean indexed_ = false;
    double[] values_;
    int[] pixels_;
    private EtchedBorder eBorder_ = null;

    public JSlider2() {
        this(true);
        this.setSize(40, 40);
    }

    public JSlider2(boolean bl) {
        SymMouse symMouse = new SymMouse();
        this.addMouseListener(symMouse);
        SymMouseMotion symMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(symMouseMotion);
        MyComponent myComponent = new MyComponent();
        this.addComponentListener(myComponent);
        this.twoHandles_ = bl;
        this.showBorder_ = true;
        this.eBorder_ = new EtchedBorder();
        this.setBorder(this.eBorder_);
        this.handleSize_ = 6;
        this.alwaysPost_ = false;
        this.size_ = new Dimension(175, 50);
        this.rawRange_ = new Range(this.handleSize_ + 1, this.size_.width - this.handleSize_ - 1);
        this.reset();
        this.minLabel_ = Double.toString(this.minValue_);
        this.maxLabel_ = Double.toString(this.maxValue_);
        this.minHandle_ = new SliderHandle(this.handleSize_, Color.green, SliderHandle.LEFT);
        this.maxHandle_ = new SliderHandle(this.handleSize_, Color.red, SliderHandle.RIGHT);
        if (!this.twoHandles_) {
            this.minHandle_.setStyle(SliderHandle.SINGLE);
        }
    }

    public void setMinValue(double d) {
        this.minValue_ = Math.max(d, 0.0);
        if (this.minOld_ != this.minValue_) {
            Double d2 = new Double(this.minOld_);
            this.minOld_ = this.minValue_;
            this.changes.firePropertyChange("minValue", d2, new Double(this.minValue_));
        }
        this.repaint();
    }

    public double getMinValue() {
        return this.minValue_;
    }

    public void setMaxValue(double d) {
        this.maxValue_ = Math.min(d, 1.0);
        if (this.maxOld_ != this.maxValue_) {
            Double d2 = new Double(this.maxOld_);
            this.maxOld_ = this.maxValue_;
            this.changes.firePropertyChange("maxValue", d2, new Double(this.maxValue_));
        }
        this.repaint();
    }

    public double getMaxValue() {
        return this.maxValue_;
    }

    public void reset() {
        this.maxValue_ = 1.0;
        this.minValue_ = 0.0;
        this.maxOld_ = 1.0;
        this.minOld_ = 0.0;
    }

    public void setMinLabel(String string) {
        this.minLabel_ = string;
        this.repaint();
    }

    public String getMinLabel() {
        return this.minLabel_;
    }

    public void setMaxLabel(String string) {
        this.maxLabel_ = string;
        this.repaint();
    }

    public String getMaxLabel() {
        return this.maxLabel_;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void setTwoHandles(boolean bl) {
        this.twoHandles_ = bl;
        if (this.twoHandles_) {
            this.minHandle_.setStyle(SliderHandle.LEFT);
        } else {
            this.minHandle_.setStyle(SliderHandle.SINGLE);
        }
        this.repaint();
    }

    public boolean isTwoHandles() {
        return this.twoHandles_;
    }

    public boolean getTwoHandles() {
        return this.twoHandles_;
    }

    public void setShowBorder(boolean bl) {
        this.showBorder_ = bl;
        if (!this.showBorder_) {
            this.setBorder(null);
        }
        this.repaint();
    }

    public boolean isShowBorder() {
        return this.showBorder_;
    }

    public boolean getShowBorder() {
        return this.showBorder_;
    }

    public void setHandleSize(int n) {
        if (this.handleSize_ != n) {
            this.handleSize_ = n;
            this.minHandle_ = new SliderHandle(this.handleSize_, Color.green);
            this.maxHandle_ = new SliderHandle(this.handleSize_, Color.red);
            this.repaint();
        }
    }

    public int getHandleSize() {
        return this.handleSize_;
    }

    public void setAlwaysPost(boolean bl) {
        this.alwaysPost_ = bl;
    }

    public boolean isAlwaysPost() {
        return this.alwaysPost_;
    }

    public boolean getAlwaysPost() {
        return this.alwaysPost_;
    }

    public Range getRawRange() {
        return this.rawRange_;
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.invalidate();
        this.doCompute();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.invalidate();
        this.doCompute();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.invalidate();
        this.doCompute();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.invalidate();
        this.doCompute();
    }

    public void setIndexed(boolean bl) {
        this.indexed_ = bl;
    }

    public boolean isIndexed() {
        return this.indexed_;
    }

    public void paintComponent(Graphics graphics) {
        this.min_ = this.rawRange_.start + (int)(this.minValue_ * this.scale_);
        this.max_ = this.rawRange_.start + (int)(this.maxValue_ * this.scale_);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.size_.width, this.size_.height);
        graphics.setColor(Color.black);
        graphics.setColor(Color.black);
        graphics.drawLine(this.rawRange_.start, this.yval_ - 3, this.rawRange_.end, this.yval_ - 3);
        graphics.setColor(Color.gray);
        graphics.drawLine(this.rawRange_.start, this.yval_ - 2, this.rawRange_.end, this.yval_ - 2);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.yval_ - 8;
        int n2 = this.rawRange_.start;
        graphics.drawString(this.minLabel_, n2, n);
        int n3 = fontMetrics.stringWidth(this.maxLabel_);
        n2 = this.rawRange_.end - n3;
        graphics.drawString(this.maxLabel_, n2, n);
        this.minHandle_.draw(graphics, this.min_, this.yval_);
        if (this.twoHandles_) {
            this.maxHandle_.draw(graphics, this.max_, this.yval_);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(96, 57);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 57);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MIN_VALUE);
    }

    public void setIndexValues(double[] dArray) {
        this.values_ = dArray;
        this.indexed_ = true;
        this.pixels_ = new int[this.values_.length];
        this.doCompute();
    }

    void doCompute() {
        this.size_ = this.getSize();
        this.rawRange_.start = 2 * this.handleSize_ + 1;
        this.rawRange_.end = this.size_.width - 2 * this.handleSize_ - 1;
        this.yval_ = this.size_.height - 3 * this.handleSize_ - 10;
        this.scale_ = this.rawRange_.end - this.rawRange_.start;
        if (this.indexed_) {
            for (int i = 0; i < this.values_.length; ++i) {
                this.pixels_[i] = this.rawRange_.start + (int)(this.values_[i] * this.scale_);
            }
        }
    }

    void doMove(int n, boolean bl) {
        double d;
        int n2;
        int n3;
        if (n > this.rawRange_.end) {
            n = this.rawRange_.end;
        }
        if (n < this.rawRange_.start) {
            n = this.rawRange_.start;
        }
        if (this.indexed_ && bl) {
            n3 = 0;
            if (n <= this.pixels_[0]) {
                n3 = 0;
            } else if (n >= this.pixels_[this.pixels_.length - 1]) {
                n3 = this.pixels_.length - 1;
            } else {
                for (n2 = 0; n2 < this.pixels_.length - 1; ++n2) {
                    if (n < this.pixels_[n2] || n >= this.pixels_[n2 + 1]) continue;
                    if (n - this.pixels_[n2] < this.pixels_[n2 + 1] - n) {
                        n3 = n2;
                        break;
                    }
                    n3 = n2 + 1;
                    break;
                }
            }
            d = this.values_[n3];
            n = this.pixels_[n3];
        } else {
            d = (double)(n - this.rawRange_.start) / this.scale_;
        }
        if (this.twoHandles_) {
            n3 = n - this.min_;
            n2 = n - this.max_;
            if (n3 < 0) {
                this.minValue_ = d;
            } else if (n2 > 0) {
                this.maxValue_ = d;
            } else if (n3 < -n2) {
                this.minValue_ = d;
            } else {
                this.maxValue_ = d;
            }
        } else {
            this.minValue_ = d;
        }
        if (bl || this.alwaysPost_) {
            if (this.minOld_ != this.minValue_) {
                Double d2 = new Double(this.minOld_);
                this.minOld_ = this.minValue_;
                this.changes.firePropertyChange("minValue", d2, new Double(this.minValue_));
            }
            if (this.maxOld_ != this.maxValue_) {
                Double d3 = new Double(this.maxOld_);
                this.maxOld_ = this.maxValue_;
                this.changes.firePropertyChange("maxValue", d3, new Double(this.maxValue_));
            }
        }
        this.paint(this.getGraphics());
    }

    void JSlider2_MouseClick(MouseEvent mouseEvent) {
        this.doMove(mouseEvent.getX(), true);
    }

    void JSlider2_resized(ComponentEvent componentEvent) {
        this.doCompute();
    }

    void JSlider2_MouseDrag(MouseEvent mouseEvent) {
        this.doMove(mouseEvent.getX(), false);
    }

    void JSlider2_MouseRelease(MouseEvent mouseEvent) {
        this.doMove(mouseEvent.getX(), true);
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        JFrame jFrame = new JFrame("JSlider2 Test");
        jFrame.setSize(400, 100);
        jFrame.getContentPane().setLayout(new BorderLayout());
        JSlider2 jSlider2 = new JSlider2();
        jSlider2.setDoubleBuffered(true);
        jSlider2.setMinValue(0.2);
        jSlider2.setMaxValue(0.8);
        jSlider2.setIndexValues(dArray);
        jSlider2.setMinLabel("-20 stuff");
        jSlider2.setMaxLabel("20 stuff");
        jFrame.getContentPane().add((Component)jSlider2, "Center");
        jFrame.setVisible(true);
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == JSlider2.this) {
                JSlider2.this.JSlider2_MouseDrag(mouseEvent);
            }
        }
    }

    class MyComponent
    extends ComponentAdapter {
        MyComponent() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == JSlider2.this) {
                JSlider2.this.JSlider2_resized(componentEvent);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == JSlider2.this) {
                JSlider2.this.JSlider2_MouseRelease(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == JSlider2.this) {
                JSlider2.this.JSlider2_MouseClick(mouseEvent);
            }
        }
    }
}

