/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.swing.PlotMarkIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;

public class PlotMarkDialog
extends JDialog {
    private static final int numMarks = 51;
    private int result_;
    private int mark_;
    private JToggleButton[] buttons_ = new JToggleButton[51];
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JPanel mainPanel = new JPanel();

    public PlotMarkDialog(Frame frame) {
        super(frame);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(288, 201);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.setBounds(0, 162, 288, 39);
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.okButton.setBounds(79, 7, 51, 25);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.setBounds(135, 7, 73, 25);
        this.mainPanel.setLayout(new GridLayout(4, 11, 0, 0));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setBounds(0, 0, 288, 162);
        this.setTitle("Select a Mark");
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymAction symAction = new SymAction();
        this.cancelButton.addActionListener(symAction);
        this.okButton.addActionListener(symAction);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public PlotMarkDialog(String string) {
        this();
        this.setTitle(string);
    }

    public PlotMarkDialog() {
        this((Frame)null);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    void PlotMarkDialog_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.result_ = CANCEL_RESPONSE;
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.result_ = OK_RESPONSE;
        for (int i = 0; i < 51; ++i) {
            if (!this.buttons_[i].isSelected()) continue;
            this.mark_ = i + 1;
        }
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        PlotMarkDialog plotMarkDialog = new PlotMarkDialog();
        plotMarkDialog.setTitle("Test PlotMark Dialog");
        plotMarkDialog.setVisible(true);
    }

    public int showDialog(int n) {
        this.mark_ = n;
        this.createButtons();
        this.result_ = CANCEL_RESPONSE;
        this.setModal(true);
        super.setVisible(true);
        return this.result_;
    }

    public void setMark(int n) {
        this.mark_ = n;
    }

    public int getMark() {
        return this.mark_;
    }

    private void createButtons() {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < 51; ++i) {
            PlotMarkIcon plotMarkIcon = new PlotMarkIcon(i + 1);
            this.buttons_[i] = new JToggleButton(plotMarkIcon);
            this.buttons_[i].setName(Integer.toString(i + 1));
            buttonGroup.add(this.buttons_[i]);
            this.mainPanel.add(this.buttons_[i]);
        }
        this.buttons_[this.mark_ - 1].setSelected(true);
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PlotMarkDialog.this.cancelButton) {
                PlotMarkDialog.this.cancelButton_actionPerformed(actionEvent);
            } else if (object == PlotMarkDialog.this.okButton) {
                PlotMarkDialog.this.okButton_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == PlotMarkDialog.this) {
                PlotMarkDialog.this.PlotMarkDialog_WindowClosing(windowEvent);
            }
        }
    }
}

