/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLineAttribute;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.IndexedColor;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.swing.ColorSwatchIcon;
import gov.noaa.pmel.sgt.swing.prop.ContourLineAttributeDialog;
import gov.noaa.pmel.sgt.swing.prop.DefaultContourLineAttributeDialog;
import gov.noaa.pmel.sgt.swing.prop.GridBagConstraints;
import gov.noaa.pmel.sgt.swing.prop.NewLevelsDialog;
import gov.noaa.pmel.util.Range2D;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class GridAttributeDialog
extends JDialog {
    private GridAttribute attr_;
    private ContourLevels conLevels_;
    private ColorMap colorMap_;
    private JPane[] paneList_ = null;
    private int contourLevelIndex_ = 0;
    private int colorMapIndex_ = 1;
    private JTable conLevelTable_;
    private ConLevelTableModel conLevelModel_;
    private SGTGrid grid_ = null;
    private JToggleButton[] colorButtons_ = new JToggleButton[256];
    boolean fComponentsAdjusted = false;
    JTabbedPane TabbedPane = new JTabbedPane();
    JPanel ContourLevelsPanel = new JPanel();
    JScrollPane gridScrollPane = new JScrollPane();
    JPanel controlPanel = new JPanel();
    JPanel JPanel1 = new JPanel();
    JButton editButton = new JButton();
    JButton aboveButton = new JButton();
    JButton belowButton = new JButton();
    JButton deleteButton = new JButton();
    JPanel JPanel4 = new JPanel();
    JButton defaultButton = new JButton();
    JButton sortButton = new JButton();
    JButton newConLevelButton = new JButton();
    JPanel ColorMapPanel = new JPanel();
    JPanel colorControlPanel = new JPanel();
    JPanel colorMapPanel = new JPanel();
    JButton newColorMapButton = new JButton();
    JButton loadColorMapButton = new JButton();
    JButton saveColorMapButton = new JButton();
    JPanel colorPanel = new JPanel();
    JPanel CLIndexedPanel = new JPanel();
    JPanel CLTransformPanel = new JPanel();
    JPanel IndexedPanel = new JPanel();
    JPanel colorButtonsPanel = new JPanel();
    JPanel TransformPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    JPanel mainPanel = new JPanel();
    JLabel JLabel5 = new JLabel();
    JComboBox gridStyleComboBox = new JComboBox();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    DefaultComboBoxModel stringComboBoxModel1 = new DefaultComboBoxModel();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    TitledBorder titledBorder1 = new TitledBorder("Contour Level");
    EmptyBorder emptyBorder1 = new EmptyBorder(5, 0, 0, 0);
    TitledBorder titledBorder4 = new TitledBorder("Default Attributes");
    TitledBorder titledBorder2 = new TitledBorder("Color Map");

    public GridAttributeDialog(Frame frame) {
        super(frame);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(516, 374);
        this.setVisible(false);
        this.mainPanel.setPreferredSize(new Dimension(516, 36));
        this.getContentPane().add((Component)this.TabbedPane, "Center");
        this.ContourLevelsPanel.setLayout(new BorderLayout(0, 0));
        this.TabbedPane.add((Component)this.ContourLevelsPanel, "ContourLevelsPanel");
        this.ContourLevelsPanel.setBounds(2, 27, 511, 271);
        this.ContourLevelsPanel.setVisible(false);
        this.ContourLevelsPanel.add((Component)this.gridScrollPane, "Center");
        this.controlPanel.setLayout(new GridBagLayout());
        this.ContourLevelsPanel.add((Component)this.controlPanel, "East");
        this.JPanel1.setBorder(this.titledBorder1);
        this.JPanel1.setLayout(new GridBagLayout());
        this.controlPanel.add((Component)this.JPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.editButton.setToolTipText("Edit attribute of selected level.");
        this.editButton.setText("Edit Attribute");
        this.editButton.setActionCommand("Change Value");
        this.JPanel1.add((Component)this.editButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.aboveButton.setToolTipText("Insert level above selected level.");
        this.aboveButton.setText("Insert Level Above");
        this.aboveButton.setActionCommand("Before Item");
        this.JPanel1.add((Component)this.aboveButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
        this.belowButton.setToolTipText("Insert level below selected level.");
        this.belowButton.setText("Insert Level Below");
        this.belowButton.setActionCommand("After Item");
        this.JPanel1.add((Component)this.belowButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
        this.deleteButton.setToolTipText("Delete the selected level.");
        this.deleteButton.setText("Delete Level");
        this.deleteButton.setActionCommand("Delete Item");
        this.JPanel1.add((Component)this.deleteButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.JPanel4.setBorder(this.titledBorder4);
        this.JPanel4.setLayout(new GridBagLayout());
        this.controlPanel.add((Component)this.JPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.defaultButton.setToolTipText("Edit default attributes.");
        this.defaultButton.setText("Edit Default Attributes");
        this.defaultButton.setActionCommand("Edit Default Attributes");
        this.JPanel4.add((Component)this.defaultButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.sortButton.setToolTipText("Sort levels by value.");
        this.sortButton.setText("Sort Levels");
        this.sortButton.setActionCommand("Sort");
        this.controlPanel.add((Component)this.sortButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newConLevelButton.setToolTipText("Create new contour level set.");
        this.newConLevelButton.setText("New...");
        this.newConLevelButton.setActionCommand("New...");
        this.controlPanel.add((Component)this.newConLevelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.ColorMapPanel.setLayout(new BorderLayout(0, 0));
        this.TabbedPane.add((Component)this.ColorMapPanel, "ColorMapPanel");
        this.ColorMapPanel.setBounds(2, 27, 511, 271);
        this.ColorMapPanel.setVisible(false);
        this.colorControlPanel.setLayout(new GridBagLayout());
        this.ColorMapPanel.add((Component)this.colorControlPanel, "East");
        this.colorMapPanel.setBorder(this.titledBorder2);
        this.colorMapPanel.setLayout(new GridBagLayout());
        this.colorControlPanel.add((Component)this.colorMapPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.newColorMapButton.setToolTipText("Create new color map.");
        this.newColorMapButton.setText("New...");
        this.newColorMapButton.setActionCommand("New...");
        this.colorMapPanel.add((Component)this.newColorMapButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.loadColorMapButton.setToolTipText("Load color map from disk.");
        this.loadColorMapButton.setText("Load...");
        this.loadColorMapButton.setActionCommand("Load...");
        this.colorMapPanel.add((Component)this.loadColorMapButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.saveColorMapButton.setToolTipText("Save color map to disk.");
        this.saveColorMapButton.setText("Save...");
        this.saveColorMapButton.setActionCommand("Save...");
        this.colorMapPanel.add((Component)this.saveColorMapButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.colorPanel.setLayout(new CardLayout(0, 0));
        this.ColorMapPanel.add((Component)this.colorPanel, "Center");
        this.CLIndexedPanel.setLayout(new FlowLayout(1, 5, 5));
        this.colorPanel.add("CLIndexed", this.CLIndexedPanel);
        this.CLTransformPanel.setLayout(new FlowLayout(1, 5, 5));
        this.colorPanel.add("CLTransform", this.CLTransformPanel);
        this.CLTransformPanel.setVisible(false);
        this.IndexedPanel.setLayout(new GridBagLayout());
        this.colorPanel.add("Indexed", this.IndexedPanel);
        this.IndexedPanel.setVisible(false);
        this.colorButtonsPanel.setLayout(new GridLayout(16, 16, 1, 1));
        this.IndexedPanel.add((Component)this.colorButtonsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.TransformPanel.setLayout(new FlowLayout(1, 5, 5));
        this.colorPanel.add("Transform", this.TransformPanel);
        this.TransformPanel.setVisible(false);
        this.TabbedPane.setSelectedComponent(this.ContourLevelsPanel);
        this.TabbedPane.setSelectedIndex(0);
        this.TabbedPane.setTitleAt(0, "Contour Levels");
        this.TabbedPane.setTitleAt(1, "Color Map");
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.applyButton.setText("Apply");
        this.applyButton.setActionCommand("Apply");
        this.buttonPanel.add(this.applyButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, "North");
        this.JLabel5.setText("Grid Style:");
        this.mainPanel.add((Component)this.JLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.gridStyleComboBox.setModel(this.stringComboBoxModel1);
        this.mainPanel.add((Component)this.gridStyleComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        Object object = new String[]{"RASTER", "AREA_FILL", "CONTOUR", "RASTER_CONTOUR", "AREA_FILL_CONTOUR"};
        for (int i = 0; i < ((String[])object).length; ++i) {
            this.stringComboBoxModel1.addElement(object[i]);
        }
        this.gridStyleComboBox.setSelectedIndex(0);
        this.setTitle("GridAttribute Properties");
        object = new SymWindow();
        this.addWindowListener((WindowListener)object);
        SymAction symAction = new SymAction();
        this.cancelButton.addActionListener(symAction);
        this.okButton.addActionListener(symAction);
        this.applyButton.addActionListener(symAction);
        this.gridStyleComboBox.addActionListener(symAction);
        this.newConLevelButton.addActionListener(symAction);
        this.newColorMapButton.addActionListener(symAction);
        this.loadColorMapButton.addActionListener(symAction);
        this.editButton.addActionListener(symAction);
        this.aboveButton.addActionListener(symAction);
        this.belowButton.addActionListener(symAction);
        this.deleteButton.addActionListener(symAction);
        this.sortButton.addActionListener(symAction);
        this.saveColorMapButton.addActionListener(symAction);
        this.defaultButton.addActionListener(symAction);
        this.makeColorToggleButtons();
    }

    private void makeColorToggleButtons() {
        Insets insets = new Insets(0, 0, 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        ColorSwatchIcon colorSwatchIcon = null;
        for (int i = 0; i < 256; ++i) {
            JToggleButton jToggleButton = new JToggleButton("");
            if (System.getProperty("mrj.version") == null || !UIManager.getSystemLookAndFeelClassName().equals(UIManager.getLookAndFeel().getClass().getName())) {
                jToggleButton.setMargin(insets);
            }
            colorSwatchIcon = new ColorSwatchIcon(Color.white, 8, 8);
            jToggleButton.setIcon(colorSwatchIcon);
            this.colorButtons_[i] = jToggleButton;
            this.colorButtonsPanel.add(jToggleButton);
            buttonGroup.add(jToggleButton);
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public GridAttributeDialog(String string) {
        this();
        this.setTitle(string);
    }

    public GridAttributeDialog() {
        this((Frame)null);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    void GridAttributeDialog_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.updateGridAttribute();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent actionEvent) {
        this.updateGridAttribute();
    }

    public void setJPane(JPane jPane) {
        this.paneList_ = new JPane[1];
        this.paneList_[0] = jPane;
    }

    public JPane getJPane() {
        if (this.paneList_ != null) {
            return this.paneList_[0];
        }
        return null;
    }

    public void setJPaneList(JPane[] jPaneArray) {
        this.paneList_ = jPaneArray;
    }

    public JPane[] getJPaneList() {
        return this.paneList_;
    }

    public void setGridCartesianRenderer(GridCartesianRenderer gridCartesianRenderer) {
        this.grid_ = gridCartesianRenderer.getGrid();
        this.setGridAttribute((GridAttribute)gridCartesianRenderer.getAttribute());
    }

    public void setGridAttribute(GridAttribute gridAttribute) {
        this.attr_ = gridAttribute;
        this.colorMap_ = gridAttribute.getColorMap();
        this.conLevels_ = gridAttribute.getContourLevels();
        int n = this.attr_.getStyle();
        this.gridStyleComboBox.setSelectedIndex(n);
        this.enableContourLevels(n);
        this.initContourLevels();
        this.enableColorMap(n);
        this.initColorMap();
        this.setCurrentTab();
    }

    private void enableContourLevels(int n) {
        boolean bl = n == 2 || n == 3 || n == 4;
        this.TabbedPane.setEnabledAt(this.contourLevelIndex_, bl);
        Component[] componentArray = this.ContourLevelsPanel.getComponents();
        boolean bl2 = this.conLevels_ != null;
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl2);
        }
        this.newConLevelButton.setEnabled(true);
    }

    private void enableColorMap(int n) {
        boolean bl = n != 2;
        this.TabbedPane.setEnabledAt(this.colorMapIndex_, bl);
        Component[] componentArray = this.ColorMapPanel.getComponents();
        boolean bl2 = this.colorMap_ != null;
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl2);
        }
        this.newColorMapButton.setEnabled(true);
    }

    private void setCurrentTab() {
        if (!this.TabbedPane.isEnabledAt(this.TabbedPane.getSelectedIndex())) {
            if (this.TabbedPane.getSelectedIndex() == this.colorMapIndex_) {
                this.TabbedPane.setSelectedIndex(this.contourLevelIndex_);
            } else {
                this.TabbedPane.setSelectedIndex(this.colorMapIndex_);
            }
        }
    }

    private void initContourLevels() {
        this.createConLevelTable();
    }

    private void initColorMap() {
        if (this.colorMap_ instanceof IndexedColor) {
            ColorSwatchIcon colorSwatchIcon;
            int n;
            int n2 = ((IndexedColor)((Object)this.colorMap_)).getMaximumIndex();
            for (n = 0; n <= n2; ++n) {
                colorSwatchIcon = new ColorSwatchIcon((IndexedColor)((Object)this.colorMap_), n, 8);
                this.colorButtons_[n].setIcon(colorSwatchIcon);
                this.colorButtons_[n].setEnabled(true);
            }
            for (n = n2 + 1; n < 256; ++n) {
                colorSwatchIcon = new ColorSwatchIcon(Color.white, 8, 8);
                this.colorButtons_[n].setIcon(colorSwatchIcon);
                this.colorButtons_[n].setEnabled(false);
            }
            ((CardLayout)this.colorPanel.getLayout()).show(this.colorPanel, "Indexed");
        }
    }

    void updateGridAttribute() {
        int n;
        if (this.paneList_ != null) {
            for (n = 0; n < this.paneList_.length; ++n) {
                this.paneList_[n].setBatch(true, "GridAttributeDialog");
            }
        }
        this.updateConLevels();
        this.attr_.setContourLevels(this.conLevels_);
        this.attr_.setColorMap(this.colorMap_);
        this.attr_.setStyle(this.gridStyleComboBox.getSelectedIndex());
        if (this.paneList_ != null) {
            for (n = 0; n < this.paneList_.length; ++n) {
                this.paneList_[n].setBatch(false, "GridAttributeDialog");
            }
        }
    }

    public static void main(String[] stringArray) {
        Range2D range2D = new Range2D(-20.0, 45.0, 5.0);
        ContourLevels contourLevels = ContourLevels.getDefault(range2D);
        GridAttribute gridAttribute = new GridAttribute(contourLevels);
        GridAttributeDialog gridAttributeDialog = new GridAttributeDialog();
        gridAttributeDialog.setGridAttribute(gridAttribute);
        gridAttributeDialog.setTitle("Test GridAttribute Dialog");
        gridAttributeDialog.setVisible(true);
    }

    void gridStyleComboBox_actionPerformed(ActionEvent actionEvent) {
        int n = this.gridStyleComboBox.getSelectedIndex();
        this.enableContourLevels(n);
        this.enableColorMap(n);
        this.setCurrentTab();
    }

    void newConLevelButton_actionPerformed(ActionEvent actionEvent) {
        NewLevelsDialog newLevelsDialog = new NewLevelsDialog();
        int n = newLevelsDialog.showDialog(this.grid_);
        if (n == NewLevelsDialog.OK_RESPONSE) {
            Range2D range2D = newLevelsDialog.getRange();
            this.conLevels_ = ContourLevels.getDefault(range2D);
            this.initContourLevels();
        }
    }

    void newColorMapButton_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] nArray3 = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.colorMap_ = new IndexedColorMap(nArray, nArray2, nArray3);
        ((IndexedColorMap)this.colorMap_).setTransform(new LinearTransform(0.0, (double)nArray.length, 0.0, 1.0));
        this.initColorMap();
    }

    void loadColorMapButton_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        int n = -1;
        File file = null;
        StreamTokenizer streamTokenizer = null;
        JFileChooser jFileChooser = new JFileChooser("C:/local/pal");
        int n2 = jFileChooser.showOpenDialog(this);
        if (n2 == 0) {
            Object object;
            file = jFileChooser.getSelectedFile();
            try {
                object = new BufferedReader(new FileReader(file));
                streamTokenizer = new StreamTokenizer((Reader)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException);
                return;
            }
            try {
                streamTokenizer.nextToken();
                while (streamTokenizer.ttype != -1) {
                    ++n;
                    if (streamTokenizer.ttype == -2) {
                        nArray[n] = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        nArray2[n] = (int)streamTokenizer.nval;
                        streamTokenizer.nextToken();
                        nArray3[n] = (int)streamTokenizer.nval;
                    }
                    if (streamTokenizer.nextToken() != 10) continue;
                    streamTokenizer.nextToken();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            object = new int[n + 1];
            int[] nArray4 = new int[n + 1];
            int[] nArray5 = new int[n + 1];
            for (int i = 0; i <= n; ++i) {
                object[i] = nArray[i];
                nArray4[i] = nArray2[i];
                nArray5[i] = nArray3[i];
            }
            this.colorMap_ = new IndexedColorMap((int[])object, nArray4, nArray5);
            ((IndexedColorMap)this.colorMap_).setTransform(new LinearTransform(0.0, (double)((Object)object).length, 0.0, 1.0));
            this.initColorMap();
        }
    }

    void editButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.conLevelTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        ContourLineAttributeDialog contourLineAttributeDialog = new ContourLineAttributeDialog();
        ContourLineAttribute contourLineAttribute = (ContourLineAttribute)((ContourLineAttribute)this.conLevelModel_.getValueAt(n, 1)).copy();
        int n2 = contourLineAttributeDialog.showDialog(contourLineAttribute);
        if (n2 == ContourLineAttributeDialog.OK_RESPONSE) {
            contourLineAttribute = contourLineAttributeDialog.getContourLineAttribute();
            this.conLevelModel_.setValueAt(contourLineAttribute, n, 1);
        }
    }

    void aboveButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.conLevelTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.conLevelModel_.insert(n, new Double(0.0), new ContourLineAttribute(0));
    }

    void belowButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.conLevelTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.conLevelModel_.insert(n + 1, new Double(0.0), new ContourLineAttribute(0));
    }

    void deleteButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.conLevelTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.conLevelModel_.remove(n);
    }

    void sortButton_actionPerformed(ActionEvent actionEvent) {
        this.conLevelModel_.sort();
    }

    void defaultButton_actionPerformed(ActionEvent actionEvent) {
        DefaultContourLineAttributeDialog defaultContourLineAttributeDialog = new DefaultContourLineAttributeDialog();
        DefaultContourLineAttribute defaultContourLineAttribute = this.conLevels_.getDefaultContourLineAttribute();
        int n = defaultContourLineAttributeDialog.showDialog((DefaultContourLineAttribute)defaultContourLineAttribute.copy());
        if (n == DefaultContourLineAttributeDialog.OK_RESPONSE) {
            defaultContourLineAttribute = defaultContourLineAttributeDialog.getDefaultContourLineAttribute();
            this.conLevels_.setDefaultContourLineAttribute(defaultContourLineAttribute);
        }
    }

    void saveColorMapButton_actionPerformed(ActionEvent actionEvent) {
    }

    void createConLevelTable() {
        this.conLevelModel_ = new ConLevelTableModel();
        this.conLevelTable_ = new JTable(this.conLevelModel_);
        this.conLevelTable_.setSize(1000, 1000);
        ListSelectionModel listSelectionModel = this.conLevelTable_.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        TableColumn tableColumn = this.conLevelTable_.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.conLevelTable_.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(750);
        this.gridScrollPane.getViewport().add(this.conLevelTable_);
        if (this.conLevels_ == null) {
            return;
        }
        int n = this.conLevels_.size();
        for (int i = 0; i < n; ++i) {
            try {
                Double d = new Double(this.conLevels_.getLevel(i));
                ContourLineAttribute contourLineAttribute = this.conLevels_.getContourLineAttribute(i);
                this.conLevelModel_.add(d, contourLineAttribute);
                continue;
            }
            catch (ContourLevelNotFoundException contourLevelNotFoundException) {
                System.out.println(contourLevelNotFoundException);
            }
        }
    }

    private void updateConLevels() {
        if (this.conLevels_ == null) {
            return;
        }
        ContourLevels contourLevels = new ContourLevels();
        this.conLevelModel_.sort();
        int n = this.conLevelModel_.getRowCount();
        for (int i = 0; i < n; ++i) {
            Double d = (Double)this.conLevelModel_.getValueAt(i, 0);
            ContourLineAttribute contourLineAttribute = (ContourLineAttribute)this.conLevelModel_.getValueAt(i, 1);
            contourLevels.addLevel(d, contourLineAttribute);
        }
        contourLevels.setDefaultContourLineAttribute(this.conLevels_.getDefaultContourLineAttribute());
        this.conLevels_ = contourLevels;
    }

    class ConLevelTableModel
    extends AbstractTableModel {
        Vector values = new Vector();
        Vector attr = new Vector();
        String[] titles = new String[]{"Value", "Attribute"};

        ConLevelTableModel() {
        }

        public void add(Double d, ContourLineAttribute contourLineAttribute) {
            this.values.addElement(d);
            this.attr.addElement(contourLineAttribute);
        }

        public void insert(int n, Double d, ContourLineAttribute contourLineAttribute) {
            this.values.insertElementAt(d, n);
            this.attr.insertElementAt(contourLineAttribute, n);
            this.fireTableChanged(new TableModelEvent(this, n, n, -1, 1));
        }

        public void remove(int n) {
            this.values.removeElementAt(n);
            this.attr.removeElementAt(n);
            this.fireTableChanged(new TableModelEvent(this, n, n, -1, -1));
        }

        public void sort() {
            int n;
            int n2 = this.values.size();
            int[] nArray = new int[n2];
            boolean bl = true;
            for (n = 0; n < n2; ++n) {
                nArray[n] = n;
            }
            while (bl) {
                bl = false;
                for (n = 0; n < n2 - 1; ++n) {
                    Double d = (Double)this.values.elementAt(nArray[n]);
                    Double d2 = (Double)this.values.elementAt(nArray[n + 1]);
                    if (!(d > d2)) continue;
                    int n3 = nArray[n];
                    nArray[n] = nArray[n + 1];
                    nArray[n + 1] = n3;
                    bl = true;
                }
            }
            Vector vector = this.values;
            Vector vector2 = this.attr;
            this.values = new Vector(n2);
            this.attr = new Vector(n2);
            for (n = 0; n < n2; ++n) {
                this.values.addElement(vector.elementAt(nArray[n]));
                this.attr.addElement(vector2.elementAt(nArray[n]));
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.values.elementAt(n);
            }
            return this.attr.elementAt(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (object instanceof Double) {
                    this.values.setElementAt(object, n);
                } else if (object instanceof String) {
                    this.values.setElementAt(new Double((String)object), n);
                }
            } else {
                this.attr.setElementAt(object, n);
            }
            this.fireTableCellUpdated(n, n2);
        }

        public int getRowCount() {
            return this.values.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.titles[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == GridAttributeDialog.this.cancelButton) {
                GridAttributeDialog.this.cancelButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.okButton) {
                GridAttributeDialog.this.okButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.applyButton) {
                GridAttributeDialog.this.applyButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.gridStyleComboBox) {
                GridAttributeDialog.this.gridStyleComboBox_actionPerformed(actionEvent);
            }
            if (object == GridAttributeDialog.this.newConLevelButton) {
                GridAttributeDialog.this.newConLevelButton_actionPerformed(actionEvent);
            }
            if (object == GridAttributeDialog.this.newColorMapButton) {
                GridAttributeDialog.this.newColorMapButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.loadColorMapButton) {
                GridAttributeDialog.this.loadColorMapButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.editButton) {
                GridAttributeDialog.this.editButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.aboveButton) {
                GridAttributeDialog.this.aboveButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.belowButton) {
                GridAttributeDialog.this.belowButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.deleteButton) {
                GridAttributeDialog.this.deleteButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.sortButton) {
                GridAttributeDialog.this.sortButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.saveColorMapButton) {
                GridAttributeDialog.this.saveColorMapButton_actionPerformed(actionEvent);
            } else if (object == GridAttributeDialog.this.defaultButton) {
                GridAttributeDialog.this.defaultButton_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == GridAttributeDialog.this) {
                GridAttributeDialog.this.GridAttributeDialog_WindowClosing(windowEvent);
            }
        }
    }
}

