/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.util.GeoDate;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class GeoDateDialog
extends JDialog
implements ItemListener,
PropertyChangeListener,
ActionListener {
    private GeoDate initialDate = new GeoDate();
    private GeoDate earliestDateAllowed = new GeoDate();
    private GeoDate latestDateAllowed = new GeoDate();
    private boolean earliestCheckingEnabled = false;
    private boolean latestCheckingEnabled = false;
    private Font regularFont;
    private Font boldFont;
    private Color panelBackground;
    private Color calBackground;
    private Color selectedButnBackground;
    private static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] daysOfMonth = new String[]{" 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private static final String[] hours = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    private static final String[] minutes = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    private static final int numWeeks = 6;
    private GregorianCalendar cal;
    private SimpleDateFormat dateFormatter;
    private SimpleDateFormat sdf;
    private SimpleDateFormat tsdf = new SimpleDateFormat("dd MMM yyyy ");
    private static TimeZone tz = TimeZone.getTimeZone("GMT");
    private int result_;
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    private JPanel mainPanel_;
    private JPanel calPanel;
    private JPanel okPanel;
    private JPanel selectionPanel;
    private Box box;
    private Box theBox;
    private Box timeBox;
    private Box monthYearBox;
    private Box okBox;
    private Box labelBox;
    private Box hrMinBox;
    private JButton subYearButn;
    private JButton subMonthButn;
    private JButton addMonthButn;
    private JButton addYearButn;
    private JButton addHourButn;
    private JButton subHourButn;
    private JButton addMinButn;
    private JButton subMinButn;
    private JButton cancelButn;
    private JButton okButn;
    private JToggleButton[] calButtons;
    private JLabel yearLabel;
    private JLabel hourLabel;
    private JLabel minLabel;
    private JLabel hourMinLabel;
    private JLabel selectionLabel;
    private Choice monthChoice;
    private Choice yearChoice;
    private JComboBox monthList;
    private JComboBox minList;
    private JTextField hourText;
    private JTextField yearText;
    private Component caller;
    private ButtonGroup calButtonGroup;
    private GeoDate liquidDate;
    private int lastDaySel;
    private int lastButnSel = 1;
    private int xloc;
    private int yloc;
    private String title;
    private boolean hideTime;
    private static CompoundBorder cp = new CompoundBorder(new BevelBorder(0), new EmptyBorder(2, 2, 2, 2));
    public static final int DATE = 5;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int MINUTE = 12;
    public static final int HOUR_OF_DAY = 11;
    private boolean TRACE = false;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void setEarliestDateAllowed(GeoDate geoDate) {
        this.earliestDateAllowed = geoDate;
        this.earliestCheckingEnabled = true;
        System.out.println("Earliest date allowed: " + geoDate);
    }

    public void setLatestDateAllowed(GeoDate geoDate) {
        this.latestDateAllowed = geoDate;
        this.latestCheckingEnabled = true;
        System.out.println("Latest date allowed: " + geoDate);
    }

    public GeoDate getEarliestDateAllowed() {
        return this.earliestDateAllowed;
    }

    public GeoDate getLatestDateAllowed() {
        return this.latestDateAllowed;
    }

    public void setOutputDateFormatter(SimpleDateFormat simpleDateFormat) {
        this.sdf = simpleDateFormat;
    }

    public void setInitialDate(GeoDate geoDate) {
        this.initialDate = geoDate;
        this.liquidDate = new GeoDate(this.initialDate);
        this.setTitle(this.composeTimeLabel(this.liquidDate));
    }

    public void setGeoDate(GeoDate geoDate) {
        if (this.TRACE) {
            System.out.println("setDate entered");
        }
        this.liquidDate = new GeoDate(geoDate);
        if (this.liquidDateWithinBounds()) {
            this.updateGUIAfterLiquidDateChange();
            this.setTitle(this.composeTimeLabel(this.liquidDate));
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public GeoDate getInitialDate() {
        return this.initialDate;
    }

    public void setRegularFont(Font font) {
        this.regularFont = font;
    }

    public Font getRegularFont() {
        return this.regularFont;
    }

    public void setBoldFont(Font font) {
        this.boldFont = font;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public void setPanelBackground(Color color) {
        this.panelBackground = color;
    }

    public Color getPanelBackground() {
        return this.panelBackground;
    }

    public void setCalBackground(Color color) {
        this.calBackground = color;
    }

    public Color getCalBackground() {
        return this.calBackground;
    }

    public void setSelectedButnBackground(Color color) {
        this.selectedButnBackground = color;
    }

    public Color getSelectedButnBackground() {
        return this.selectedButnBackground;
    }

    public void setHideTime(boolean bl) {
        this.hideTime = bl;
        if (bl) {
            this.removeTime();
        }
    }

    public boolean getHideTime() {
        return this.hideTime;
    }

    public GeoDateDialog(GeoDate geoDate) {
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects();
        this.setInitialDate(geoDate);
        this.finishConstruction();
    }

    public GeoDateDialog(GeoDate geoDate, GeoDate geoDate2, GeoDate geoDate3, int n, int n2) {
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects();
        this.xloc = n;
        this.yloc = n2;
        this.setInitialDate(geoDate);
        this.setEarliestDateAllowed(geoDate2);
        this.setLatestDateAllowed(geoDate3);
        this.finishConstruction();
    }

    public GeoDateDialog() {
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects();
        GeoDate geoDate = new GeoDate();
        this.cal.setTime(geoDate);
        this.computeFields(this.cal);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        geoDate = new GeoDate(this.cal.getTime());
        this.setInitialDate(geoDate);
        this.finishConstruction();
    }

    void finishConstruction() {
        this.mainPanel_ = new JPanel();
        this.addPropertyChangeListener(this);
        this.regularFont = new Font("Dialog", 0, 10);
        this.boldFont = new Font("Dialog", 1, 10);
        this.setSelectedButnBackground(new Color(240, 240, 240));
        this.setCalBackground(new Color(200, 200, 200));
        this.createCalendarPanel();
        this.createMonthYearPanel();
        this.createTimePanel();
        this.createOkPanel();
        this.createSelectionPanel();
        GeoDateDialog geoDateDialog = this;
        this.theBox = geoDateDialog.box.createVerticalBox();
        this.theBox.add(this.monthYearBox);
        this.theBox.add(this.calPanel);
        this.theBox.add(this.timeBox);
        this.theBox.add(Box.createVerticalStrut(1));
        this.theBox.add(this.selectionPanel);
        this.theBox.add(this.okPanel);
        GeoDateDialog geoDateDialog2 = this;
        this.theBox.add(geoDateDialog2.box.createVerticalGlue());
        this.theBox.validate();
        this.theBox.setBackground(this.panelBackground);
        this.theBox.setBackground(Color.white);
        this.theBox.repaint();
        this.mainPanel_.add(this.theBox);
        this.theBox.setLocation(10, 10);
        this.mainPanel_.setLocation(this.xloc, this.yloc);
        this.getContentPane().add(this.mainPanel_);
        this.validate();
        this.repaint();
        this.cal.setTime(this.getInitialDate());
        this.computeFields(this.cal);
        this.lastDaySel = this.cal.get(5);
        this.resetCalendarPanel(this.initialDate);
        this.softwareDayOfMonthClick(this.initialDate);
        this.minList.setSelectedIndex(this.cal.get(12) / 5);
        this.hourText.setText(new String(String.valueOf(this.cal.get(11))));
        this.monthList.setSelectedIndex(this.cal.get(2));
    }

    public int showDialog(GeoDate geoDate, int n, int n2) {
        this.setSize(220, 323);
        this.setLocation(n, n2);
        this.setInitialDate(geoDate);
        this.setGeoDate(geoDate);
        this.result_ = CANCEL_RESPONSE;
        this.setModal(true);
        this.setVisible(true);
        return this.result_;
    }

    void removeTime() {
        this.theBox.remove(this.timeBox);
        this.createDateFormatter();
        this.updateDateLabel();
        this.setSize(220, 260);
    }

    void setTimeZoneForTimeObjects() {
        if (this.TRACE) {
            System.out.println("setTimeZoneForTimeObjects entered");
        }
        if (this.dateFormatter != null) {
            this.dateFormatter.setTimeZone(tz);
        }
        if (this.cal != null) {
            this.cal.setTimeZone(tz);
        }
    }

    void createDateFormatter() {
        if (this.TRACE) {
            System.out.println("createDateFormatter entered");
        }
        this.dateFormatter = new SimpleDateFormat(" dd MMM yyyy HH:mm ");
        if (this.hideTime) {
            this.dateFormatter = new SimpleDateFormat("dd MMM yyyy ");
        }
        this.dateFormatter.setTimeZone(tz);
    }

    void createCalendarPanel() {
        if (this.TRACE) {
            System.out.println("createCalendarPanel entered");
        }
        this.calPanel = new JPanel();
        this.calPanel.setLayout(new GridLayout(7, 7, 2, 1));
        JLabel jLabel = new JLabel("Sun", 0);
        jLabel.setFont(this.boldFont);
        this.calPanel.add(jLabel);
        jLabel = new JLabel("Mon", 0);
        jLabel.setFont(this.boldFont);
        this.calPanel.add(jLabel);
        jLabel = new JLabel("Tue", 0);
        jLabel.setFont(this.boldFont);
        this.calPanel.add(jLabel);
        jLabel = new JLabel("Wed", 0);
        jLabel.setFont(this.boldFont);
        this.calPanel.add(jLabel);
        jLabel = new JLabel("Thu", 0);
        jLabel.setFont(this.boldFont);
        this.calPanel.add(jLabel);
        jLabel = new JLabel("Fri", 0);
        jLabel.setFont(this.boldFont);
        this.calPanel.add(jLabel);
        jLabel = new JLabel("Sat", 0);
        jLabel.setFont(this.boldFont);
        this.calPanel.add(jLabel);
        this.calPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.calButtonGroup = new ButtonGroup();
        this.calButtons = new JToggleButton[42];
        for (int i = 0; i < 42; ++i) {
            this.calButtons[i] = new JToggleButton("  ");
            this.calButtons[i].setBorder(cp);
            this.calButtons[i].setContentAreaFilled(true);
            this.calButtons[i].addActionListener(this);
            this.calButtons[i].setFont(this.regularFont);
            this.calPanel.add(this.calButtons[i]);
            this.calButtonGroup.add(this.calButtons[i]);
            this.calButtons[i].setMinimumSize(new Dimension(17, 21));
            this.calButtons[i].setMaximumSize(new Dimension(17, 21));
            this.calButtons[i].setSize(new Dimension(17, 21));
        }
    }

    void resetCalendarPanel(GeoDate geoDate) {
        int n;
        int n2;
        if (this.TRACE) {
            System.out.println("resetCalendarPanel entered");
        }
        String[][] stringArray = new String[7][6];
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(tz);
        for (n2 = 0; n2 < 7; ++n2) {
            for (n = 0; n < 6; ++n) {
                stringArray[n2][n] = "  ";
            }
        }
        gregorianCalendar.setTime(geoDate);
        this.computeFields(gregorianCalendar);
        gregorianCalendar.set(5, 1);
        Date date = gregorianCalendar.getTime();
        gregorianCalendar.setTime(date);
        this.computeFields(gregorianCalendar);
        n2 = gregorianCalendar.get(7) - 1;
        if (gregorianCalendar.get(2) + 1 == 13) {
            gregorianCalendar.set(2, 0);
            gregorianCalendar.set(1, gregorianCalendar.get(1) + 1);
        } else {
            gregorianCalendar.set(2, gregorianCalendar.get(2) + 1);
        }
        Date date2 = gregorianCalendar.getTime();
        long l = date2.getTime();
        gregorianCalendar.setTime(date);
        this.computeFields(gregorianCalendar);
        n = 0;
        int n3 = 1;
        for (long i = date.getTime(); i < l; i += 86400000L) {
            if (n3 != 32) {
                stringArray[n2][n] = daysOfMonth[n3 - 1];
            }
            ++n3;
            if (++n2 <= 6) continue;
            n2 = 0;
            ++n;
        }
        int n4 = 0;
        for (n = 0; n < 6; ++n) {
            for (n2 = 0; n2 < 7; ++n2) {
                if (stringArray[n2][n].equals("  ")) {
                    this.calButtons[n4].setText("  ");
                    this.calButtons[n4].setVisible(false);
                } else {
                    this.calButtons[n4].setText(stringArray[n2][n]);
                    this.calButtons[n4].setVisible(true);
                }
                ++n4;
            }
        }
    }

    void closeDown() {
        this.setVisible(false);
    }

    public GeoDate getGeoDate() {
        return this.liquidDate;
    }

    void softwareDayOfMonthClick(GeoDate geoDate) {
        if (this.TRACE) {
            System.out.println("softwareDayOfMonthClick entered");
        }
        this.cal.setTime(geoDate);
        this.computeFields(this.cal);
        int n = this.cal.get(5);
        boolean bl = false;
        for (int i = 0; i < this.calButtons.length; ++i) {
            if (!this.calButtons[i].getText().equals(daysOfMonth[n - 1])) continue;
            this.calButtons[i].doClick();
        }
    }

    void selectDay(int n) {
        if (this.TRACE) {
            System.out.println("selectDay entered");
        }
        if (this.calButtons != null) {
            for (int i = 0; i < this.calButtons.length; ++i) {
                if (!this.calButtons[i].getText().equals(daysOfMonth[n - 1])) continue;
                this.lastButnSel = i;
                this.lastDaySel = n;
                break;
            }
        }
    }

    String composeTimeLabel(GeoDate geoDate) {
        return this.dateFormatter.format(geoDate);
    }

    void computeFields(Calendar calendar) {
        int n = calendar.get(1);
    }

    void updateDateLabel() {
        this.selectionLabel.setText(this.composeTimeLabel(this.liquidDate));
    }

    void createMonthYearPanel() {
        if (this.TRACE) {
            System.out.println("createMonthYearPanel entered");
        }
        this.subMonthButn = new JButton("<<");
        this.subMonthButn.setFont(this.regularFont);
        this.subMonthButn.setBorder(cp);
        this.subMonthButn.addActionListener(this);
        this.subMonthButn.setBackground(this.calBackground);
        this.subMonthButn.setAlignmentY(0.5f);
        this.addMonthButn = new JButton(">>");
        this.addMonthButn.setFont(this.regularFont);
        this.addMonthButn.setBorder(cp);
        this.addMonthButn.addActionListener(this);
        this.addMonthButn.setBackground(this.calBackground);
        this.addMonthButn.setAlignmentY(0.5f);
        this.monthList = new JComboBox<String>(months);
        this.monthList.setFont(this.regularFont);
        this.monthList.addItemListener(this);
        this.monthList.setAlignmentY(0.5f);
        this.yearText = new JTextField(new String(String.valueOf(this.cal.get(1))));
        this.yearText.setBackground(this.calBackground);
        this.yearText.addActionListener(this);
        this.yearText.setFont(this.regularFont);
        int n = this.subMonthButn.getPreferredSize().width * 3;
        int n2 = this.subMonthButn.getPreferredSize().height;
        this.yearText.setPreferredSize(new Dimension(n, n2));
        this.yearText.setMaximumSize(new Dimension(n, n2));
        this.yearText.setAlignmentY(0.5f);
        this.subYearButn = new JButton("<<");
        this.subYearButn.setFont(this.regularFont);
        this.subYearButn.setBorder(cp);
        this.subYearButn.addActionListener(this);
        this.subYearButn.setBackground(this.calBackground);
        this.subYearButn.setAlignmentY(0.5f);
        this.addYearButn = new JButton(">>");
        this.addYearButn.setFont(this.regularFont);
        this.addYearButn.setBorder(cp);
        this.addYearButn.addActionListener(this);
        this.addYearButn.setBackground(this.calBackground);
        this.addYearButn.setAlignmentY(0.5f);
        GeoDateDialog geoDateDialog = this;
        this.monthYearBox = geoDateDialog.box.createHorizontalBox();
        GeoDateDialog geoDateDialog2 = this;
        this.monthYearBox.add(geoDateDialog2.box.createHorizontalGlue());
        this.monthYearBox.add(this.subMonthButn);
        this.monthYearBox.add(this.addMonthButn);
        this.monthYearBox.add(this.monthList);
        this.monthYearBox.add(Box.createHorizontalStrut(1));
        this.monthYearBox.add(this.yearText);
        this.monthYearBox.add(this.subYearButn);
        this.monthYearBox.add(this.addYearButn);
        GeoDateDialog geoDateDialog3 = this;
        this.monthYearBox.add(geoDateDialog3.box.createHorizontalGlue());
    }

    public void resetMonthYearPanel(GeoDate geoDate) {
        if (this.TRACE) {
            System.out.println("resetMonthYearPanel entered");
        }
        this.cal.setTime(geoDate);
        this.computeFields(this.cal);
        int n = this.cal.get(2);
        Integer n2 = new Integer(this.cal.get(1));
        this.monthList.setVisible(false);
        this.monthList.setSelectedIndex(n);
        this.monthList.setVisible(true);
        int n3 = Integer.parseInt(this.yearText.getText().trim());
        if (n2 != n3) {
            this.yearText.setText(n2.toString());
        }
    }

    void createTimePanel() {
        if (this.TRACE) {
            System.out.println("createTimePanel entered");
        }
        this.hourLabel = new JLabel("Hour(0-23)        ");
        this.hourLabel.setFont(this.boldFont);
        this.minLabel = new JLabel("Minute    ");
        this.minLabel.setFont(this.boldFont);
        JLabel jLabel = new JLabel(":");
        Font font = new Font("Dialog", 1, 12);
        jLabel.setFont(font);
        this.subHourButn = new JButton("<<");
        this.subHourButn.setFont(this.regularFont);
        this.subHourButn.setBorder(cp);
        this.subHourButn.addActionListener(this);
        this.subHourButn.setBackground(this.calBackground);
        this.subHourButn.setAlignmentY(0.5f);
        this.addHourButn = new JButton(">>");
        this.addHourButn.setFont(this.regularFont);
        this.addHourButn.setBorder(cp);
        this.addHourButn.addActionListener(this);
        this.addHourButn.setBackground(this.calBackground);
        this.addHourButn.setAlignmentY(0.5f);
        this.hourText = new JTextField();
        this.hourText.setText("     00");
        this.hourText.setFont(this.regularFont);
        this.hourText.setBackground(this.calBackground);
        this.hourText.addActionListener(this);
        this.hourText.setHorizontalAlignment(4);
        int n = this.addHourButn.getPreferredSize().width * 2;
        int n2 = this.addHourButn.getPreferredSize().height;
        this.hourText.setPreferredSize(new Dimension(n, n2));
        this.hourText.setMaximumSize(this.hourText.getPreferredSize());
        this.hourText.setSize(this.hourText.getPreferredSize());
        this.hourText.setAlignmentY(0.5f);
        this.minList = new JComboBox<String>(minutes);
        this.minList.addItemListener(this);
        this.minList.setFont(this.regularFont);
        n = this.addHourButn.getPreferredSize().width * 2;
        n2 = this.addHourButn.getPreferredSize().height;
        this.minList.setPreferredSize(new Dimension(n, n2));
        this.minList.setMaximumSize(this.minList.getPreferredSize());
        this.minList.setSize(this.minList.getPreferredSize());
        this.minList.setAlignmentY(0.5f);
        this.subMinButn = new JButton("<<");
        this.subMinButn.setFont(this.regularFont);
        this.subMinButn.setBorder(cp);
        this.subMinButn.addActionListener(this);
        this.subMinButn.setBackground(this.calBackground);
        this.subMinButn.setAlignmentY(0.5f);
        this.addMinButn = new JButton(">>");
        this.addMinButn.setFont(this.regularFont);
        this.addMinButn.setBorder(cp);
        this.addMinButn.addActionListener(this);
        this.addMinButn.setBackground(this.calBackground);
        this.addMinButn.setAlignmentY(0.5f);
        GeoDateDialog geoDateDialog = this;
        this.labelBox = geoDateDialog.box.createHorizontalBox();
        GeoDateDialog geoDateDialog2 = this;
        this.labelBox.add(geoDateDialog2.box.createHorizontalGlue());
        this.labelBox.add(this.hourLabel);
        this.labelBox.add(Box.createHorizontalStrut(1));
        this.labelBox.add(this.minLabel);
        GeoDateDialog geoDateDialog3 = this;
        this.labelBox.add(geoDateDialog3.box.createHorizontalGlue());
        GeoDateDialog geoDateDialog4 = this;
        this.hrMinBox = geoDateDialog4.box.createHorizontalBox();
        GeoDateDialog geoDateDialog5 = this;
        this.hrMinBox.add(geoDateDialog5.box.createHorizontalGlue());
        this.hrMinBox.add(this.subHourButn);
        this.hrMinBox.add(this.addHourButn);
        this.hrMinBox.add(this.hourText);
        this.hrMinBox.add(Box.createHorizontalStrut(5));
        this.hrMinBox.add(this.minList);
        this.hrMinBox.add(this.subMinButn);
        this.hrMinBox.add(this.addMinButn);
        GeoDateDialog geoDateDialog6 = this;
        this.hrMinBox.add(geoDateDialog6.box.createHorizontalGlue());
        GeoDateDialog geoDateDialog7 = this;
        this.timeBox = geoDateDialog7.box.createVerticalBox();
        GeoDateDialog geoDateDialog8 = this;
        this.timeBox.add(geoDateDialog8.box.createVerticalGlue());
        this.timeBox.add(this.labelBox);
        this.timeBox.add(this.hrMinBox);
        GeoDateDialog geoDateDialog9 = this;
        this.timeBox.add(geoDateDialog9.box.createVerticalGlue());
    }

    void createSelectionPanel() {
        if (this.TRACE) {
            System.out.println("createSelectionPanel entered");
        }
        this.selectionLabel = new JLabel("ddd mmm dd hh:mm yyyy");
        this.selectionLabel.setBackground(Color.red);
        this.selectionLabel.setForeground(Color.black);
        this.selectionPanel = new JPanel();
        this.selectionPanel.add(this.selectionLabel);
        int n = this.selectionPanel.getPreferredSize().width;
        int n2 = 15;
        this.updateDateLabel();
    }

    void createOkPanel() {
        if (this.TRACE) {
            System.out.println("createOkPanel entered");
        }
        this.okButn = new JButton("OK");
        this.okButn.addActionListener(this);
        this.okButn.setBackground(this.calBackground);
        this.okButn.setMinimumSize(new Dimension(51, 25));
        this.okButn.setMaximumSize(new Dimension(51, 25));
        this.cancelButn = new JButton("Cancel");
        this.cancelButn.addActionListener(this);
        this.cancelButn.setBackground(this.calBackground);
        this.cancelButn.setMinimumSize(new Dimension(73, 25));
        this.cancelButn.setMaximumSize(new Dimension(73, 25));
        this.okPanel = new JPanel();
        this.okPanel.setLayout(new GridLayout(1, 2));
        this.okPanel.add(this.okButn);
        this.okPanel.add(this.cancelButn);
    }

    void handleHourChange() {
        if (this.TRACE) {
            System.out.println("handleHourChange entered");
        }
        try {
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            int n = this.cal.get(11);
            int n2 = Integer.parseInt(this.hourText.getText().trim());
            n2 = this.validateHours(n2);
            this.hourText.setText(new Integer(n2).toString());
            this.cal.set(11, n2);
            this.liquidDate = new GeoDate(this.cal.getTime());
            if (!this.liquidDateWithinBounds()) {
                this.cal.set(11, n);
                this.liquidDate = new GeoDate(this.cal.getTime());
                this.hourText.setText(new Integer(n).toString());
            }
            this.updateDateLabel();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void handleYearChange() {
        if (this.TRACE) {
            System.out.println("handleYearChange entered");
        }
        try {
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            int n = this.cal.get(1);
            int n2 = Integer.parseInt(this.yearText.getText().trim());
            this.yearText.setText(new Integer(n2).toString());
            this.cal.set(1, n2);
            this.liquidDate = new GeoDate(this.cal.getTime());
            if (!this.liquidDateWithinBounds()) {
                this.cal.set(1, n);
                this.liquidDate = new GeoDate(this.cal.getTime());
                this.yearText.setText(new Integer(n).toString());
            } else {
                this.updateGUIAfterLiquidDateChange();
            }
            this.updateDateLabel();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    int validateHours(int n) {
        if (this.TRACE) {
            System.out.println("validateHours entered");
        }
        if (n < 0) {
            return 0;
        }
        if (n > 23) {
            return 23;
        }
        return n;
    }

    boolean liquidDateWithinBounds() {
        if (this.TRACE) {
            System.out.println("liquidDateWithinBounds entered");
        }
        if (this.earliestCheckingEnabled) {
            System.out.println("liquidDate is: " + this.liquidDate);
            System.out.println("earliestDateAllowed is: " + this.earliestDateAllowed);
            if (this.liquidDate.getTime() < this.earliestDateAllowed.getTime()) {
                this.lowerBoundMsg();
                return false;
            }
        }
        if (this.latestCheckingEnabled && this.liquidDate.getTime() > this.latestDateAllowed.getTime()) {
            this.upperBoundMsg();
            return false;
        }
        return true;
    }

    void lowerBoundMsg() {
        if (this.TRACE) {
            System.out.println("lowerBoundMsg entered");
        }
        JOptionPane.showMessageDialog(this, new String("Lower bound restricted to " + this.composeTimeLabel(this.getEarliestDateAllowed())), "Calendar Bounds Exception", 2);
    }

    void upperBoundMsg() {
        if (this.TRACE) {
            System.out.println("upperBoundMsg entered");
        }
        JOptionPane.showMessageDialog(this, new String("Upper bound restricted to " + this.composeTimeLabel(this.getLatestDateAllowed())), "Calendar Bounds Exception", 2);
    }

    void attemptToAddOrSubtractAYear(int n) {
        if (this.TRACE) {
            System.out.println("attemptToAddOrSubtractAYear entered");
        }
        this.cal.setTime(this.liquidDate);
        this.computeFields(this.cal);
        int n2 = this.cal.get(1) + n;
        this.cal.set(1, n2);
        this.liquidDate = new GeoDate(this.cal.getTime());
        if (this.liquidDateWithinBounds()) {
            this.updateGUIAfterLiquidDateChange();
        } else {
            this.cal.set(1, this.cal.get(1) - n);
            this.liquidDate = new GeoDate(this.cal.getTime());
        }
    }

    void updateGUIAfterLiquidDateChange() {
        if (this.TRACE) {
            System.out.println("updateGUIAfterLIquidDateChange entered");
        }
        this.resetMonthYearPanel(this.liquidDate);
        this.resetCalendarPanel(this.liquidDate);
        this.softwareDayOfMonthClick(this.liquidDate);
        this.updateDateLabel();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.TRACE) {
            System.out.println("itemStateChanged entered");
        }
        if (itemEvent.getSource() == this.monthList) {
            int n = this.monthList.getSelectedIndex();
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            int n2 = this.cal.get(2);
            if (n2 != n) {
                this.cal.set(2, n);
                this.liquidDate = new GeoDate(this.cal.getTime());
                if (!this.liquidDateWithinBounds()) {
                    this.cal.set(2, n2);
                    this.liquidDate = new GeoDate(this.cal.getTime());
                }
                this.updateGUIAfterLiquidDateChange();
            }
        } else if (itemEvent.getSource() == this.minList) {
            int n = Integer.parseInt((String)this.minList.getSelectedItem());
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            int n3 = this.cal.get(12);
            this.cal.set(12, n);
            this.liquidDate = new GeoDate(this.cal.getTime());
            if (!this.liquidDateWithinBounds()) {
                this.cal.set(12, n3);
                this.liquidDate = new GeoDate(this.cal.getTime());
                this.minList.setVisible(false);
                this.minList.setSelectedIndex(n3 / 5);
                this.minList.setVisible(true);
            }
            this.updateDateLabel();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.TRACE) {
            System.out.println("actionPerformed entered");
        }
        Object object = actionEvent.getSource();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        if (object == this.okButn) {
            this.handleHourChange();
            if (this.sdf != null) {
                this.pcs.firePropertyChange("FormattedDateTime", this.sdf.format(this.getInitialDate()), this.sdf.format(this.liquidDate));
            }
            this.pcs.firePropertyChange("DateTime", this.getInitialDate(), this.liquidDate);
            this.result_ = OK_RESPONSE;
            this.closeDown();
        } else if (object == this.cancelButn) {
            this.result_ = CANCEL_RESPONSE;
            this.closeDown();
        } else if (object == this.subYearButn) {
            this.attemptToAddOrSubtractAYear(-1);
        } else if (object == this.addYearButn) {
            this.attemptToAddOrSubtractAYear(1);
        } else if (object == this.subMonthButn) {
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            n = this.cal.get(2) - 1;
            if (n == -1) {
                n = 11;
                this.cal.set(2, n);
                n2 = this.cal.get(1) - 1;
                this.cal.set(1, n2);
                this.liquidDate = new GeoDate(this.cal.getTime());
                if (!this.liquidDateWithinBounds()) {
                    n2 = this.cal.get(1) + 1;
                    this.cal.set(1, n2);
                    this.liquidDate = new GeoDate(this.cal.getTime());
                }
            }
            this.cal.set(2, n);
            this.liquidDate = new GeoDate(this.cal.getTime());
            if (!this.liquidDateWithinBounds()) {
                if (++n == 12) {
                    n = 0;
                }
                this.cal.set(2, n);
                this.liquidDate = new GeoDate(this.cal.getTime());
            }
            this.updateGUIAfterLiquidDateChange();
        } else if (object == this.addMonthButn) {
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            n = this.cal.get(2) + 1;
            if (n == 12) {
                n = 0;
                this.cal.set(2, 0);
                n2 = this.cal.get(1) + 1;
                this.cal.set(1, n2);
                this.liquidDate = new GeoDate(this.cal.getTime());
                if (!this.liquidDateWithinBounds()) {
                    this.cal.set(1, this.cal.get(1) - 1);
                    this.liquidDate = new GeoDate(this.cal.getTime());
                }
            }
            this.cal.set(2, n);
            this.liquidDate = new GeoDate(this.cal.getTime());
            if (!this.liquidDateWithinBounds()) {
                if (--n == -1) {
                    n = 11;
                }
                this.cal.set(2, n);
                this.liquidDate = new GeoDate(this.cal.getTime());
            }
            this.updateGUIAfterLiquidDateChange();
        } else if (object == this.hourText) {
            this.handleHourChange();
        } else if (object == this.yearText) {
            this.handleYearChange();
        } else if (object == this.subHourButn) {
            try {
                this.handleHourChange();
                int n3 = Integer.parseInt(this.hourText.getText().trim());
                if (--n3 == -1) {
                    n3 = 23;
                }
                this.hourText.setText(new Integer(n3).toString());
                this.handleHourChange();
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.addHourButn) {
            try {
                this.handleHourChange();
                int n4 = Integer.parseInt(this.hourText.getText().trim());
                if (++n4 == 24) {
                    n4 = 0;
                }
                this.hourText.setText(new Integer(n4).toString());
                this.handleHourChange();
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.subMinButn) {
            try {
                int n5 = Integer.parseInt((String)this.minList.getSelectedItem());
                if ((n5 -= 5) == -5) {
                    n5 = 55;
                }
                this.cal.setTime(this.liquidDate);
                this.computeFields(this.cal);
                int n6 = this.cal.get(12);
                this.cal.set(12, n5);
                this.liquidDate = new GeoDate(this.cal.getTime());
                if (!this.liquidDateWithinBounds()) {
                    this.cal.set(12, n6);
                    this.liquidDate = new GeoDate(this.cal.getTime());
                    n5 = n6;
                }
                this.minList.setVisible(false);
                this.minList.setSelectedIndex(n5 / 5);
                this.minList.setVisible(true);
                this.updateDateLabel();
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.addMinButn) {
            try {
                int n7 = Integer.parseInt((String)this.minList.getSelectedItem());
                if ((n7 += 5) == 60) {
                    n7 = 0;
                }
                this.cal.setTime(this.liquidDate);
                this.computeFields(this.cal);
                int n8 = this.cal.get(12);
                this.cal.set(12, n7);
                this.liquidDate = new GeoDate(this.cal.getTime());
                if (!this.liquidDateWithinBounds()) {
                    this.cal.set(12, n8);
                    this.liquidDate = new GeoDate(this.cal.getTime());
                    n7 = n8;
                }
                this.minList.setVisible(false);
                this.minList.setSelectedIndex(n7 / 5);
                this.minList.setVisible(true);
                this.updateDateLabel();
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object != this.monthList) {
            try {
                int n9 = Integer.parseInt(actionEvent.getActionCommand().trim());
                this.cal.setTime(this.liquidDate);
                this.computeFields(this.cal);
                int n10 = this.cal.get(5);
                this.cal.set(5, n9);
                this.liquidDate = new GeoDate(this.cal.getTime());
                if (this.liquidDateWithinBounds()) {
                    this.selectDay(n9);
                    this.updateDateLabel();
                } else {
                    this.cal.set(5, n10);
                    this.liquidDate = new GeoDate(this.cal.getTime());
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(" !!! Trouble with " + actionEvent.getActionCommand());
            }
        }
    }

    public GeoDate getDate() {
        return this.liquidDate;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.TRACE) {
            System.out.println("propertyChange entered");
        }
        Object object = propertyChangeEvent.getSource();
        this.setTitle(this.composeTimeLabel(this.liquidDate));
        if (propertyChangeEvent.getPropertyName().equals("DateTime") || propertyChangeEvent.getPropertyName().equals("FormattedDateTime")) {
            // empty if block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static void main(String[] stringArray) {
        GeoDateDialog geoDateDialog = new GeoDateDialog();
        geoDateDialog.setOutputDateFormatter(new SimpleDateFormat(" dd MMM yyyy HH:mm "));
        int n = geoDateDialog.showDialog(new GeoDate(), 200, 200);
        System.out.println("Result = " + n);
        System.out.println("Date = " + geoDateDialog.getGeoDate().toString());
        geoDateDialog.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("FormattedDateTime")) {
                    System.out.println(" MAIN Property Change, old value: " + (String)propertyChangeEvent.getOldValue() + " new value: " + (String)propertyChangeEvent.getNewValue());
                }
            }
        });
    }
}

