/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.swing.prop.GridBagConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;

public class FontDialog
extends JDialog {
    private int result_;
    private Font font_;
    private String[] fontNames_;
    private int[] styles_ = new int[]{0, 1, 2, 3};
    private String[] styleNames_ = new String[]{"plain", "bold", "italic", "bold-italic"};
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JPanel mainPanel = new JPanel();
    JComboBox fontComboBox = new JComboBox();
    JToggleButton boldButton = new JToggleButton();
    JToggleButton italicButton = new JToggleButton();
    JLabel fontLabel = new JLabel();

    public FontDialog(Frame frame) {
        super(frame);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(450, 141);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.italicButton.setMnemonic('0');
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.fontComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 1), 0, 0));
        this.boldButton.setText("Bold");
        this.mainPanel.add((Component)this.boldButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 1, 5, 2), 0, 0));
        this.italicButton.setText("Italic");
        this.mainPanel.add((Component)this.italicButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 2, 5, 5), 0, 0));
        this.italicButton.setFont(new Font("Dialog", 3, 12));
        this.fontLabel.setText("Font Name in font.");
        this.mainPanel.add((Component)this.fontLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setTitle("Select a Mark");
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymAction symAction = new SymAction();
        this.cancelButton.addActionListener(symAction);
        this.okButton.addActionListener(symAction);
        this.fontComboBox.addActionListener(symAction);
        this.boldButton.addActionListener(symAction);
        this.italicButton.addActionListener(symAction);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public FontDialog(String string) {
        this();
        this.setTitle(string);
    }

    public FontDialog() {
        this((Frame)null);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    void FontDialog_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.result_ = CANCEL_RESPONSE;
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.result_ = OK_RESPONSE;
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        FontDialog fontDialog = new FontDialog();
        fontDialog.setFont(null);
        fontDialog.setTitle("Test Font Dialog");
        fontDialog.setVisible(true);
    }

    public int showDialog(Font font) {
        this.fontNames_ = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < this.fontNames_.length; ++i) {
            this.fontComboBox.addItem(this.fontNames_[i]);
        }
        this.setDefaultFont(font);
        this.result_ = CANCEL_RESPONSE;
        this.setModal(true);
        super.setVisible(true);
        return this.result_;
    }

    public void setDefaultFont(Font font) {
        int n = 0;
        this.font_ = font;
        if (this.font_ == null) {
            this.font_ = super.getFont();
        }
        for (int i = 0; i < this.fontNames_.length; ++i) {
            if (!this.font_.getName().equals(this.fontNames_[i])) continue;
            n = i;
            break;
        }
        this.boldButton.setSelected(this.font_.isBold());
        this.italicButton.setSelected(this.font_.isItalic());
        this.fontComboBox.setSelectedIndex(n);
        this.fontLabel.setText(this.fontString());
        this.fontLabel.setFont(this.font_);
    }

    public String fontString() {
        int n = (this.boldButton.isSelected() ? 1 : 0) + (this.italicButton.isSelected() ? 2 : 0);
        return this.font_.getName() + " " + this.styleNames_[n];
    }

    public Font getFont() {
        return this.font_;
    }

    void fontComboBox_actionPerformed(ActionEvent actionEvent) {
        this.updateFont();
    }

    void boldButton_actionPerformed(ActionEvent actionEvent) {
        this.updateFont();
    }

    void italicButton_actionPerformed(ActionEvent actionEvent) {
        this.updateFont();
    }

    void updateFont() {
        Font font;
        int n = (this.boldButton.isSelected() ? 1 : 0) + (this.italicButton.isSelected() ? 2 : 0);
        this.font_ = font = new Font(this.fontNames_[this.fontComboBox.getSelectedIndex()], this.styles_[n], 12);
        this.fontLabel.setText(this.fontString());
        this.fontLabel.setFont(this.font_);
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == FontDialog.this.cancelButton) {
                FontDialog.this.cancelButton_actionPerformed(actionEvent);
            } else if (object == FontDialog.this.okButton) {
                FontDialog.this.okButton_actionPerformed(actionEvent);
            } else if (object == FontDialog.this.fontComboBox) {
                FontDialog.this.fontComboBox_actionPerformed(actionEvent);
            } else if (object == FontDialog.this.boldButton) {
                FontDialog.this.boldButton_actionPerformed(actionEvent);
            } else if (object == FontDialog.this.italicButton) {
                FontDialog.this.italicButton_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == FontDialog.this) {
                FontDialog.this.FontDialog_WindowClosing(windowEvent);
            }
        }
    }
}

