/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLineAttribute;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.swing.prop.ContourLineAttributeDialog;
import gov.noaa.pmel.sgt.swing.prop.DefaultContourLineAttributeDialog;
import gov.noaa.pmel.sgt.swing.prop.GridBagConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ContourLevelsDialog
extends JDialog {
    private ContourLevels conLevels_;
    private JTable table_;
    private ConLevelTableModel model_;
    private int result_;
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JPanel controlPanel = new JPanel();
    JPanel JPanel1 = new JPanel();
    JButton editButton = new JButton();
    JButton aboveButton = new JButton();
    JButton belowButton = new JButton();
    JButton deleteButton = new JButton();
    JPanel JPanel4 = new JPanel();
    JButton defaultButton = new JButton();
    JButton sortButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JScrollPane gridScrollPane = new JScrollPane();
    TitledBorder titledBorder1 = new TitledBorder("Contour Levels");
    EmptyBorder emptyBorder1 = new EmptyBorder(5, 0, 0, 0);
    CompoundBorder compoundBorder1 = new CompoundBorder(this.emptyBorder1, this.etchedBorder1);
    TitledBorder titledBorder4 = new TitledBorder("Default Attributes");

    public ContourLevelsDialog(Frame frame) {
        super(frame);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(529, 307);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.gridScrollPane.setMinimumSize(new Dimension(350, 283));
        this.gridScrollPane.setPreferredSize(new Dimension(350, 283));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.controlPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.controlPanel, "East");
        this.JPanel1.setBorder(this.titledBorder1);
        this.JPanel1.setLayout(new GridBagLayout());
        this.controlPanel.add((Component)this.JPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.editButton.setToolTipText("Edit attribute of selected level.");
        this.editButton.setText("Edit Attribute");
        this.editButton.setActionCommand("Change Value");
        this.JPanel1.add((Component)this.editButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.aboveButton.setToolTipText("Insert level above selected level.");
        this.aboveButton.setText("Insert Level Above");
        this.aboveButton.setActionCommand("Before Item");
        this.JPanel1.add((Component)this.aboveButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.belowButton.setToolTipText("Insert level below selected level.");
        this.belowButton.setText("Insert Level Below");
        this.belowButton.setActionCommand("After Item");
        this.JPanel1.add((Component)this.belowButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.deleteButton.setToolTipText("Delete the selected level.");
        this.deleteButton.setText("Delete Level");
        this.deleteButton.setActionCommand("Delete Item");
        this.JPanel1.add((Component)this.deleteButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.JPanel4.setBorder(this.titledBorder4);
        this.JPanel4.setLayout(new GridBagLayout());
        this.controlPanel.add((Component)this.JPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.defaultButton.setToolTipText("Edit default attributes.");
        this.defaultButton.setText("Edit Default Attributes");
        this.JPanel4.add((Component)this.defaultButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.sortButton.setToolTipText("Sort levels by value.");
        this.sortButton.setText("Sort Levels");
        this.sortButton.setActionCommand("Sort");
        this.controlPanel.add((Component)this.sortButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.gridScrollPane.setBorder(this.compoundBorder1);
        this.getContentPane().add((Component)this.gridScrollPane, "Center");
        this.setTitle("Edit Contour Levels");
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymAction symAction = new SymAction();
        this.cancelButton.addActionListener(symAction);
        this.okButton.addActionListener(symAction);
        this.editButton.addActionListener(symAction);
        this.aboveButton.addActionListener(symAction);
        this.belowButton.addActionListener(symAction);
        this.deleteButton.addActionListener(symAction);
        this.sortButton.addActionListener(symAction);
        this.defaultButton.addActionListener(symAction);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public ContourLevelsDialog(String string) {
        this();
        this.setTitle(string);
    }

    public ContourLevelsDialog() {
        this((Frame)null);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    void ContourLevelsDialog_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.result_ = CANCEL_RESPONSE;
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.update();
        this.result_ = OK_RESPONSE;
        this.setVisible(false);
    }

    private void update() {
        ContourLevels contourLevels = new ContourLevels();
        int n = this.model_.getRowCount();
        for (int i = 0; i < n; ++i) {
            Double d = (Double)this.model_.getValueAt(i, 0);
            ContourLineAttribute contourLineAttribute = (ContourLineAttribute)this.model_.getValueAt(i, 1);
            contourLevels.addLevel(d, contourLineAttribute);
        }
        contourLevels.setDefaultContourLineAttribute(this.conLevels_.getDefaultContourLineAttribute());
        this.conLevels_ = contourLevels;
    }

    public static void main(String[] stringArray) {
        ContourLevelsDialog contourLevelsDialog = new ContourLevelsDialog();
        contourLevelsDialog.setTitle("Test ContourLevels Dialog");
        contourLevelsDialog.setVisible(true);
    }

    public int showDialog(ContourLevels contourLevels) {
        this.conLevels_ = contourLevels;
        this.result_ = CANCEL_RESPONSE;
        this.createTable();
        this.setModal(true);
        super.setVisible(true);
        return this.result_;
    }

    void createTable() {
        int n = this.conLevels_.size();
        this.model_ = new ConLevelTableModel();
        for (int i = 0; i < n; ++i) {
            try {
                Double d = new Double(this.conLevels_.getLevel(i));
                ContourLineAttribute contourLineAttribute = this.conLevels_.getContourLineAttribute(i);
                this.model_.add(d, contourLineAttribute);
                continue;
            }
            catch (ContourLevelNotFoundException contourLevelNotFoundException) {
                System.out.println(contourLevelNotFoundException);
            }
        }
        this.table_ = new JTable(this.model_);
        this.table_.setSize(1000, 1000);
        ListSelectionModel listSelectionModel = this.table_.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        TableColumn tableColumn = this.table_.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table_.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(750);
        this.gridScrollPane.getViewport().add(this.table_);
    }

    public ContourLevels getContourLevels() {
        return this.conLevels_;
    }

    void editButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.table_.getSelectedRow();
        if (n < 0) {
            return;
        }
        ContourLineAttributeDialog contourLineAttributeDialog = new ContourLineAttributeDialog();
        ContourLineAttribute contourLineAttribute = (ContourLineAttribute)((ContourLineAttribute)this.model_.getValueAt(n, 1)).copy();
        int n2 = contourLineAttributeDialog.showDialog(contourLineAttribute);
        if (n2 == ContourLineAttributeDialog.OK_RESPONSE) {
            contourLineAttribute = contourLineAttributeDialog.getContourLineAttribute();
            this.model_.setValueAt(contourLineAttribute, n, 1);
        }
    }

    void aboveButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.table_.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.model_.insert(n, new Double(0.0), new ContourLineAttribute(0));
    }

    void belowButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.table_.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.model_.insert(n + 1, new Double(0.0), new ContourLineAttribute(0));
    }

    void deleteButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.table_.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.model_.remove(n);
    }

    void sortButton_actionPerformed(ActionEvent actionEvent) {
        this.model_.sort();
    }

    void defaultButton_actionPerformed(ActionEvent actionEvent) {
        DefaultContourLineAttributeDialog defaultContourLineAttributeDialog = new DefaultContourLineAttributeDialog();
        DefaultContourLineAttribute defaultContourLineAttribute = this.conLevels_.getDefaultContourLineAttribute();
        int n = defaultContourLineAttributeDialog.showDialog((DefaultContourLineAttribute)defaultContourLineAttribute.copy());
        if (n == DefaultContourLineAttributeDialog.OK_RESPONSE) {
            defaultContourLineAttribute = defaultContourLineAttributeDialog.getDefaultContourLineAttribute();
            this.conLevels_.setDefaultContourLineAttribute(defaultContourLineAttribute);
        }
    }

    class ConLevelTableModel
    extends AbstractTableModel {
        Vector values = new Vector();
        Vector attr = new Vector();
        String[] titles = new String[]{"Value", "Attribute"};

        ConLevelTableModel() {
        }

        public void add(Double d, ContourLineAttribute contourLineAttribute) {
            this.values.addElement(d);
            this.attr.addElement(contourLineAttribute);
        }

        public void insert(int n, Double d, ContourLineAttribute contourLineAttribute) {
            this.values.insertElementAt(d, n);
            this.attr.insertElementAt(contourLineAttribute, n);
            this.fireTableChanged(new TableModelEvent(this, n, n, -1, 1));
        }

        public void remove(int n) {
            this.values.removeElementAt(n);
            this.attr.removeElementAt(n);
            this.fireTableChanged(new TableModelEvent(this, n, n, -1, -1));
        }

        public void sort() {
            int n;
            int n2 = this.values.size();
            int[] nArray = new int[n2];
            boolean bl = true;
            for (n = 0; n < n2; ++n) {
                nArray[n] = n;
            }
            while (bl) {
                bl = false;
                for (n = 0; n < n2 - 1; ++n) {
                    Double d = (Double)this.values.elementAt(nArray[n]);
                    Double d2 = (Double)this.values.elementAt(nArray[n + 1]);
                    if (!(d > d2)) continue;
                    int n3 = nArray[n];
                    nArray[n] = nArray[n + 1];
                    nArray[n + 1] = n3;
                    bl = true;
                }
            }
            Vector vector = this.values;
            Vector vector2 = this.attr;
            this.values = new Vector(n2);
            this.attr = new Vector(n2);
            for (n = 0; n < n2; ++n) {
                this.values.addElement(vector.elementAt(nArray[n]));
                this.attr.addElement(vector2.elementAt(nArray[n]));
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.values.elementAt(n);
            }
            return this.attr.elementAt(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (object instanceof Double) {
                    this.values.setElementAt(object, n);
                } else if (object instanceof String) {
                    this.values.setElementAt(new Double((String)object), n);
                }
            } else {
                this.attr.setElementAt(object, n);
            }
            this.fireTableCellUpdated(n, n2);
        }

        public int getRowCount() {
            return this.values.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.titles[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ContourLevelsDialog.this.cancelButton) {
                ContourLevelsDialog.this.cancelButton_actionPerformed(actionEvent);
            } else if (object == ContourLevelsDialog.this.okButton) {
                ContourLevelsDialog.this.okButton_actionPerformed(actionEvent);
            } else if (object == ContourLevelsDialog.this.editButton) {
                ContourLevelsDialog.this.editButton_actionPerformed(actionEvent);
            } else if (object == ContourLevelsDialog.this.aboveButton) {
                ContourLevelsDialog.this.aboveButton_actionPerformed(actionEvent);
            } else if (object == ContourLevelsDialog.this.belowButton) {
                ContourLevelsDialog.this.belowButton_actionPerformed(actionEvent);
            }
            if (object == ContourLevelsDialog.this.deleteButton) {
                ContourLevelsDialog.this.deleteButton_actionPerformed(actionEvent);
            } else if (object == ContourLevelsDialog.this.sortButton) {
                ContourLevelsDialog.this.sortButton_actionPerformed(actionEvent);
            } else if (object == ContourLevelsDialog.this.defaultButton) {
                ContourLevelsDialog.this.defaultButton_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == ContourLevelsDialog.this) {
                ContourLevelsDialog.this.ContourLevelsDialog_WindowClosing(windowEvent);
            }
        }
    }
}

