/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGT3DGrid;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class ThreeDGrid
implements SGT3DGrid,
Cartesian,
Cloneable,
Serializable {
    protected double[] xloc_;
    protected double[] yloc_;
    protected double[] zloc_;
    protected GeoDate[] tloc_;
    protected double[] grid_;
    protected double[] xEdges_;
    protected double[] yEdges_;
    protected double[] zEdges_;
    protected GeoDate[] tEdges_;
    protected boolean hasXEdges_;
    protected boolean hasYEdges_;
    protected boolean hasZEdges_;
    protected String title_;
    protected SGLabel keyTitle_ = null;
    protected String id_ = null;
    protected boolean xTime_;
    protected boolean yTime_;
    protected boolean zTime_;
    protected SGTMetaData xMetaData_ = null;
    protected SGTMetaData yMetaData_ = null;
    protected SGTMetaData zMetaData_ = null;
    protected SGTMetaData valMetaData_ = null;
    protected SGTGrid associatedData_;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private SoTRange zRange_ = null;
    private SoTRange xEdgesRange_ = null;
    private SoTRange yEdgesRange_ = null;
    private SoTRange zEdgesRange_ = null;
    private Range2D valRange_ = null;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public ThreeDGrid() {
    }

    public ThreeDGrid(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, String string) {
        this.grid_ = dArray;
        this.xloc_ = dArray2;
        this.yloc_ = dArray3;
        this.zloc_ = dArray4;
        this.title_ = string;
        this.xTime_ = false;
        this.yTime_ = false;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(dArray2);
        this.yRange_ = this.computeSoTRange(dArray3);
        this.zRange_ = this.computeSoTRange(dArray3);
        this.valRange_ = this.computeRange2D(dArray);
    }

    public ThreeDGrid(double[] dArray, GeoDate[] geoDateArray, double[] dArray2, double[] dArray3, String string) {
        this.grid_ = dArray;
        this.tloc_ = geoDateArray;
        this.yloc_ = dArray2;
        this.zloc_ = dArray3;
        this.title_ = string;
        this.xTime_ = true;
        this.yTime_ = false;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(geoDateArray);
        this.yRange_ = this.computeSoTRange(dArray2);
        this.zRange_ = this.computeSoTRange(dArray3);
        this.valRange_ = this.computeRange2D(dArray);
    }

    public ThreeDGrid(double[] dArray, double[] dArray2, GeoDate[] geoDateArray, double[] dArray3, String string) {
        this.grid_ = dArray;
        this.xloc_ = dArray2;
        this.tloc_ = geoDateArray;
        this.zloc_ = dArray3;
        this.title_ = string;
        this.xTime_ = false;
        this.yTime_ = true;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(dArray2);
        this.yRange_ = this.computeSoTRange(geoDateArray);
        this.zRange_ = this.computeSoTRange(dArray3);
        this.valRange_ = this.computeRange2D(dArray);
    }

    public ThreeDGrid(double[] dArray, double[] dArray2, double[] dArray3, GeoDate[] geoDateArray, String string) {
        this.grid_ = dArray;
        this.xloc_ = dArray2;
        this.yloc_ = dArray3;
        this.tloc_ = geoDateArray;
        this.title_ = string;
        this.xTime_ = false;
        this.yTime_ = false;
        this.zTime_ = true;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(dArray2);
        this.yRange_ = this.computeSoTRange(dArray3);
        this.zRange_ = this.computeSoTRange(geoDateArray);
        this.valRange_ = this.computeRange2D(dArray);
    }

    public SGTData copy() {
        SGT3DGrid sGT3DGrid;
        try {
            sGT3DGrid = (SGT3DGrid)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            sGT3DGrid = new ThreeDGrid();
        }
        return sGT3DGrid;
    }

    public double[] getXArray() {
        return this.xloc_;
    }

    public int getXSize() {
        return this.xloc_.length;
    }

    public double[] getYArray() {
        return this.yloc_;
    }

    public int getYSize() {
        return this.yloc_.length;
    }

    public double[] getZArray() {
        return this.zloc_;
    }

    public int getZSize() {
        return this.zloc_.length;
    }

    public double[] getValArray() {
        return this.grid_;
    }

    public int getValArraySize() {
        return this.grid_.length;
    }

    public GeoDate[] getTimeArray() {
        return this.tloc_;
    }

    public int getTSize() {
        return this.tloc_.length;
    }

    public boolean isXTime() {
        return this.xTime_;
    }

    public boolean isYTime() {
        return this.yTime_;
    }

    public boolean isZTime() {
        return this.zTime_;
    }

    public void setXTime(boolean bl) {
        this.xTime_ = bl;
    }

    public void setYTime(boolean bl) {
        this.yTime_ = bl;
    }

    public void setZTime(boolean bl) {
        this.zTime_ = bl;
    }

    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    public SGTMetaData getValMetaData() {
        return this.valMetaData_;
    }

    public String getTitle() {
        return this.title_;
    }

    public void setAssociatedData(SGTGrid sGTGrid) {
        this.associatedData_ = sGTGrid;
        this.changes_.firePropertyChange("associatedDataModified", null, sGTGrid);
    }

    public SGTGrid getAssociatedData() {
        return this.associatedData_;
    }

    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    public boolean hasXEdges() {
        return this.hasXEdges_;
    }

    public double[] getXEdges() {
        return this.xEdges_;
    }

    public boolean hasZEdges() {
        return this.hasZEdges_;
    }

    public void setZEdges(double[] dArray) {
        this.zEdges_ = dArray;
        this.hasZEdges_ = true;
        this.zEdgesRange_ = this.computeSoTRange(dArray);
    }

    public double[] getZEdges() {
        return this.zEdges_;
    }

    public void setXEdges(double[] dArray) {
        this.xEdges_ = dArray;
        this.hasXEdges_ = true;
        this.xEdgesRange_ = this.computeSoTRange(dArray);
    }

    public boolean hasYEdges() {
        return this.hasYEdges_;
    }

    public double[] getYEdges() {
        return this.yEdges_;
    }

    public void setYEdges(double[] dArray) {
        this.yEdges_ = dArray;
        this.hasYEdges_ = true;
        this.yEdgesRange_ = this.computeSoTRange(dArray);
    }

    public GeoDate[] getTimeEdges() {
        return this.tEdges_;
    }

    public void setTimeEdges(GeoDate[] geoDateArray) {
        this.tEdges_ = geoDateArray;
        if (this.xTime_) {
            this.hasXEdges_ = true;
            this.xEdgesRange_ = this.computeSoTRange(geoDateArray);
        } else if (this.yTime_) {
            this.hasYEdges_ = true;
            this.yEdgesRange_ = this.computeSoTRange(geoDateArray);
        } else if (this.zTime_) {
            this.hasZEdges_ = true;
            this.zEdgesRange_ = this.computeSoTRange(geoDateArray);
        }
    }

    public void setXMetaData(SGTMetaData sGTMetaData) {
        this.xMetaData_ = sGTMetaData;
    }

    public void setYMetaData(SGTMetaData sGTMetaData) {
        this.yMetaData_ = sGTMetaData;
    }

    public void setZMetaData(SGTMetaData sGTMetaData) {
        this.zMetaData_ = sGTMetaData;
    }

    public void setValMetaData(SGTMetaData sGTMetaData) {
        this.valMetaData_ = sGTMetaData;
    }

    public void setTitle(String string) {
        this.title_ = string;
    }

    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    public void setKeyTitle(SGLabel sGLabel) {
        this.keyTitle_ = sGLabel;
    }

    public String getId() {
        return this.id_;
    }

    public void setId(String string) {
        this.id_ = string;
    }

    public void setXArray(double[] dArray) {
        this.xloc_ = dArray;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setYArray(double[] dArray) {
        this.yloc_ = dArray;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setZArray(double[] dArray) {
        this.zloc_ = dArray;
        this.zTime_ = false;
        this.zRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setValArray(double[] dArray) {
        this.grid_ = dArray;
        this.valRange_ = this.computeRange2D(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setTimeArray(GeoDate[] geoDateArray) {
        this.tloc_ = geoDateArray;
        if (this.xTime_) {
            this.xRange_ = this.computeSoTRange(geoDateArray);
        } else if (this.yTime_) {
            this.yRange_ = this.computeSoTRange(geoDateArray);
        } else if (this.zTime_) {
            this.zRange_ = this.computeSoTRange(geoDateArray);
        }
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(geoDateArray.length));
    }

    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    public SoTRange getYRange() {
        return this.yRange_.copy();
    }

    public SoTRange getZRange() {
        return this.zRange_.copy();
    }

    public Range2D getValRange() {
        return this.valRange_;
    }

    public SoTRange getXEdgesRange() {
        return this.xEdgesRange_;
    }

    public SoTRange getYEdgesRange() {
        return this.yEdgesRange_;
    }

    public SoTRange getZEdgesRange() {
        return this.zEdgesRange_;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    private SoTRange computeSoTRange(double[] dArray) {
        Range2D range2D = this.computeRange2D(dArray);
        return new SoTRange.Double(range2D.start, range2D.end);
    }

    private SoTRange computeSoTRange(GeoDate[] geoDateArray) {
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        int n = 0;
        for (int i = 0; i < geoDateArray.length; ++i) {
            if (geoDateArray[i] == null || geoDateArray[i].isMissing()) continue;
            long l3 = geoDateArray[i].getTime();
            l = Math.min(l, l3);
            l2 = Math.max(l2, l3);
            ++n;
        }
        if (n == 0) {
            return new SoTRange.GeoDate(new GeoDate(Long.MIN_VALUE), new GeoDate(Long.MAX_VALUE));
        }
        return new SoTRange.GeoDate(new GeoDate(l), new GeoDate(l2));
    }

    private Range2D computeRange2D(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            d = Math.min(d, dArray[i]);
            d2 = Math.max(d2, dArray[i]);
            ++n;
        }
        if (n == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(d, d2);
    }
}

