/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.SoTRange;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class SimpleLine
implements SGTLine,
Cartesian,
Serializable,
Cloneable {
    protected double[] xloc_;
    protected double[] yloc_;
    protected GeoDateArray tloc_;
    protected boolean xTime_;
    protected boolean yTime_;
    protected String title_;
    protected SGLabel keyTitle_ = null;
    protected String id_ = null;
    protected SGTMetaData xMetaData_ = null;
    protected SGTMetaData yMetaData_ = null;
    protected SGTLine associatedData_ = null;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public SimpleLine() {
        this((double[])null, (double[])null, "");
    }

    public SimpleLine(double[] dArray, double[] dArray2, String string) {
        this.xloc_ = dArray;
        this.yloc_ = dArray2;
        this.title_ = string;
        this.xTime_ = false;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(dArray);
        this.yRange_ = this.computeSoTRange(dArray2);
    }

    public SimpleLine(GeoDate[] geoDateArray, double[] dArray, String string) {
        this.tloc_ = new GeoDateArray(geoDateArray);
        this.yloc_ = dArray;
        this.title_ = string;
        this.xTime_ = true;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(dArray);
    }

    public SimpleLine(GeoDateArray geoDateArray, double[] dArray, String string) {
        this.tloc_ = geoDateArray;
        this.yloc_ = dArray;
        this.title_ = string;
        this.xTime_ = true;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(dArray);
    }

    public SimpleLine(double[] dArray, GeoDateArray geoDateArray, String string) {
        this.xloc_ = dArray;
        this.tloc_ = geoDateArray;
        this.title_ = string;
        this.xTime_ = false;
        this.yTime_ = true;
        this.xRange_ = this.computeSoTRange(dArray);
        this.yRange_ = this.computeSoTRange(this.tloc_);
    }

    public SimpleLine(double[] dArray, GeoDate[] geoDateArray, String string) {
        this.xloc_ = dArray;
        this.tloc_ = new GeoDateArray(geoDateArray);
        this.title_ = string;
        this.xTime_ = false;
        this.yTime_ = true;
        this.xRange_ = this.computeSoTRange(dArray);
        this.yRange_ = this.computeSoTRange(this.tloc_);
    }

    public SGTData copy() {
        SGTLine sGTLine;
        try {
            sGTLine = (SGTLine)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            sGTLine = new SimpleLine();
        }
        return sGTLine;
    }

    public double[] getXArray() {
        return this.xloc_;
    }

    public double[] getYArray() {
        return this.yloc_;
    }

    public GeoDate[] getTimeArray() {
        return this.tloc_.getGeoDate();
    }

    public GeoDateArray getGeoDateArray() {
        return this.tloc_;
    }

    public boolean isXTime() {
        return this.xTime_;
    }

    public boolean isYTime() {
        return this.yTime_;
    }

    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    public String getTitle() {
        return this.title_;
    }

    public String getId() {
        return this.id_;
    }

    public void setId(String string) {
        this.id_ = string;
    }

    public void setAssociatedData(SGTLine sGTLine) {
        this.associatedData_ = sGTLine;
        this.changes_.firePropertyChange("associatedDataModified", null, sGTLine);
    }

    public SGTLine getAssociatedData() {
        return this.associatedData_;
    }

    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    public void setXMetaData(SGTMetaData sGTMetaData) {
        this.xMetaData_ = sGTMetaData;
    }

    public void setYMetaData(SGTMetaData sGTMetaData) {
        this.yMetaData_ = sGTMetaData;
    }

    public void setTitle(String string) {
        this.title_ = string;
    }

    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    public void setKeyTitle(SGLabel sGLabel) {
        this.keyTitle_ = sGLabel;
    }

    public void setXArray(double[] dArray) {
        this.xloc_ = dArray;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setYArray(double[] dArray) {
        this.yloc_ = dArray;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setTimeArray(GeoDate[] geoDateArray) {
        this.setTimeArray(new GeoDateArray(geoDateArray));
    }

    public void setTimeArray(GeoDateArray geoDateArray) {
        this.tloc_ = geoDateArray;
        if (this.xTime_) {
            this.xRange_ = this.computeSoTRange(geoDateArray);
        } else if (this.yTime_) {
            this.yRange_ = this.computeSoTRange(geoDateArray);
        }
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(geoDateArray.getLength()));
    }

    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    public SoTRange getYRange() {
        return this.yRange_.copy();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    private SoTRange computeSoTRange(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            d = Math.min(d, dArray[i]);
            d2 = Math.max(d2, dArray[i]);
            ++n;
        }
        if (n == 0) {
            return new SoTRange.Double(Double.NaN, Double.NaN);
        }
        return new SoTRange.Double(d, d2);
    }

    private SoTRange computeSoTRange(GeoDateArray geoDateArray) {
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        long[] lArray = geoDateArray.getTime();
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == Long.MAX_VALUE) continue;
            l = Math.min(l, lArray[i]);
            l2 = Math.max(l2, lArray[i]);
            ++n;
        }
        if (n == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(l, l2);
    }
}

