/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.sgt.swing.prop.VectorAttributeDialog;
import gov.noaa.pmel.util.Range2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class JVectorDemo
extends JApplet {
    static JPlotLayout rpl_;
    private VectorAttribute vectorAttr_;
    JButton edit_;
    JButton space_ = null;
    JButton tree_;
    JButton print_ = null;

    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.setSize(600, 430);
        JPanel jPanel = new JPanel();
        rpl_ = this.makeGraph();
        JPanel jPanel2 = this.makeButtonPanel(false);
        rpl_.setBatch(true);
        jPanel.add((Component)rpl_, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        rpl_.setBatch(false);
    }

    JPanel makeButtonPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        MyAction myAction = new MyAction();
        if (bl) {
            this.print_ = new JButton("Print...");
            this.print_.addActionListener(myAction);
            jPanel.add(this.print_);
        }
        this.tree_ = new JButton("Tree View");
        this.tree_.addActionListener(myAction);
        jPanel.add(this.tree_);
        this.edit_ = new JButton("Edit VectorAttribute");
        this.edit_.addActionListener(myAction);
        jPanel.add(this.edit_);
        if (bl) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            jPanel.add(this.space_);
        }
        return jPanel;
    }

    public static void main(String[] stringArray) {
        JVectorDemo jVectorDemo = new JVectorDemo();
        JFrame jFrame = new JFrame("Vector Demo");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jFrame.setSize(600, 400);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        JPanel jPanel2 = jVectorDemo.makeButtonPanel(true);
        rpl_ = jVectorDemo.makeGraph();
        rpl_.setBatch(true);
        jPanel.add((Component)rpl_, "Center");
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.getContentPane().add((Component)jPanel2, "South");
        jFrame.pack();
        rpl_.setBatch(false);
        jFrame.setVisible(true);
    }

    void print_actionPerformed(ActionEvent actionEvent) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(rpl_);
        printerJob.setJobName("Vector Demo");
        if (printerJob.printDialog()) {
            try {
                Color color = rpl_.getBackground();
                if (!color.equals(Color.white)) {
                    rpl_.setBackground(Color.white);
                }
                rpl_.setPageAlign(0, 1);
                RepaintManager repaintManager = RepaintManager.currentManager(rpl_);
                repaintManager.setDoubleBufferingEnabled(false);
                printerJob.print();
                repaintManager.setDoubleBufferingEnabled(true);
                rpl_.setBackground(color);
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + printerException);
            }
        }
    }

    void edit_actionPerformed(ActionEvent actionEvent) {
        VectorAttributeDialog vectorAttributeDialog = new VectorAttributeDialog();
        vectorAttributeDialog.setJPane(rpl_);
        vectorAttributeDialog.setVectorAttribute(this.vectorAttr_);
        vectorAttributeDialog.setVisible(true);
    }

    void tree_actionPerformed(ActionEvent actionEvent) {
        JClassTree jClassTree = new JClassTree();
        jClassTree.setModal(false);
        jClassTree.setJPane(rpl_);
        jClassTree.show();
    }

    JPlotLayout makeGraph() {
        Range2D range2D = new Range2D(190.0, 250.0, 3.0);
        Range2D range2D2 = new Range2D(0.0, 45.0, 3.0);
        TestData testData = new TestData(5, range2D, range2D2, 3, 20.0f, 10.0f, 5.0f);
        SGTGrid sGTGrid = (SGTGrid)testData.getSGTData();
        testData = new TestData(5, range2D, range2D2, 3, 20.0f, 0.0f, 3.0f);
        SGTGrid sGTGrid2 = (SGTGrid)testData.getSGTData();
        SGTVector sGTVector = new SGTVector(sGTGrid, sGTGrid2);
        JPlotLayout jPlotLayout = new JPlotLayout(3, false, false, "test layout", null, false);
        jPlotLayout.setEditClasses(false);
        this.vectorAttr_ = new VectorAttribute(0.0075, Color.red);
        this.vectorAttr_.setHeadScale(0.5);
        jPlotLayout.addData(sGTVector, (Attribute)this.vectorAttr_, "First Data");
        jPlotLayout.setTitles("Vector Plot Demo", "using a JPlotLayout", "");
        jPlotLayout.setSize(new Dimension(600, 400));
        return jPlotLayout;
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JVectorDemo.this.edit_) {
                JVectorDemo.this.edit_actionPerformed(actionEvent);
            } else if (object == JVectorDemo.this.space_) {
                System.out.println("  <<Mark>>");
            } else if (object == JVectorDemo.this.tree_) {
                JVectorDemo.this.tree_actionPerformed(actionEvent);
            } else if (object == JVectorDemo.this.print_) {
                JVectorDemo.this.print_actionPerformed(actionEvent);
            }
        }
    }
}

