/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.demo.JDesktopDemo_resetButton_actionAdapter;
import gov.noaa.pmel.sgt.demo.JDesktopDemo_startButton_actionAdapter;
import gov.noaa.pmel.sgt.demo.JDesktopDemo_stopButton_actionAdapter;
import gov.noaa.pmel.sgt.demo.PseudoRealTimeData;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class JDesktopDemo
extends JApplet
implements PropertyChangeListener {
    PseudoRealTimeData rtData_;
    JPane pane_;
    Layer layer_;
    TimeAxis xbot_;
    PlainAxis yleft_;
    LinearTransform xt_;
    LinearTransform yt_;
    boolean isStandalone = false;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JButton startButton = new JButton();
    JButton stopButton = new JButton();
    JButton resetButton = new JButton();

    public void init() {
        this.rtData_ = new PseudoRealTimeData("rtDataSource", "Sea Level");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.rtData_.addPropertyChangeListener(this);
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(800, 440));
        this.getContentPane().setLayout(this.borderLayout1);
        this.startButton.setText("start");
        this.startButton.addActionListener(new JDesktopDemo_startButton_actionAdapter(this));
        this.stopButton.setText("stop");
        this.stopButton.addActionListener(new JDesktopDemo_stopButton_actionAdapter(this));
        this.resetButton.setText("reset");
        this.resetButton.addActionListener(new JDesktopDemo_resetButton_actionAdapter(this));
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.startButton, null);
        this.buttonPanel.add((Component)this.stopButton, null);
        this.buttonPanel.add((Component)this.resetButton, null);
        this.pane_ = new JPane("Real Time Data Demo", new Dimension(800, 400));
        this.pane_.setBatch(true);
        this.pane_.setLayout(new StackedLayout());
        this.pane_.setBackground(Color.white);
        double d = 6.0;
        double d2 = 0.6;
        double d3 = 5.5;
        double d4 = 3.0;
        double d5 = 0.6;
        double d6 = 2.75;
        SoTRange.GeoDate geoDate = (SoTRange.GeoDate)this.rtData_.getXRange();
        SoTRange.Double double_ = (SoTRange.Double)this.rtData_.getYRange();
        this.xt_ = new LinearTransform(d2, d3, geoDate.start, geoDate.end);
        this.yt_ = new LinearTransform(d5, d6, double_.start, double_.end);
        this.layer_ = new Layer("Layer 1", new Dimension2D(d, d4));
        this.pane_.add(this.layer_);
        SGLabel sGLabel = new SGLabel("title", "Real Time Demo", new Point2D.Double((d2 + d3) / 2.0, d4 - 0.05));
        sGLabel.setAlign(0, 1);
        sGLabel.setFont(new Font("Serif", 0, 14));
        sGLabel.setHeightP(0.25);
        sGLabel.setColor(Color.blue.darker());
        this.layer_.addChild(sGLabel);
        CartesianGraph cartesianGraph = new CartesianGraph("Time Graph");
        this.layer_.setGraph(cartesianGraph);
        cartesianGraph.setXTransform(this.xt_);
        cartesianGraph.setYTransform(this.yt_);
        SoTPoint soTPoint = new SoTPoint(geoDate.start, double_.start);
        this.xbot_ = new TimeAxis("Botton Axis", 0);
        this.xbot_.setRangeU(geoDate);
        this.xbot_.setLocationU(soTPoint);
        Font font = new Font("Helvetica", 0, 14);
        this.xbot_.setLabelFont(font);
        cartesianGraph.addXAxis(this.xbot_);
        String string = "Latitude";
        this.yleft_ = new PlainAxis("Left Axis");
        this.yleft_.setRangeU(double_);
        this.yleft_.setLocationU(soTPoint);
        this.yleft_.setLabelFont(font);
        SGLabel sGLabel2 = new SGLabel("yaxis title", string, new Point2D.Double(0.0, 0.0));
        Font font2 = new Font("Helvetica", 0, 14);
        sGLabel2.setFont(font2);
        sGLabel2.setHeightP(0.2);
        this.yleft_.setTitle(sGLabel2);
        cartesianGraph.addYAxis(this.yleft_);
        LineAttribute lineAttribute = new LineAttribute();
        cartesianGraph.setData(this.rtData_, lineAttribute);
        this.getContentPane().add((Component)this.pane_, "Center");
        if (!this.isStandalone) {
            this.pane_.setBatch(false);
        }
    }

    public void start() {
    }

    public void stop() {
        this.rtData_.stopData();
    }

    public void destroy() {
        this.rtData_.stopData();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Desktop Demo");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.setSize(850, 500);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation((dimension.width - jFrame.getSize().width) / 2, (dimension.height - jFrame.getSize().height) / 2);
        JDesktopPane jDesktopPane = new JDesktopPane();
        jFrame.getContentPane().add((Component)jDesktopPane, "Center");
        JDesktopDemo jDesktopDemo = new JDesktopDemo();
        jDesktopDemo.isStandalone = true;
        JInternalFrame jInternalFrame = new JInternalFrame("Real Time Data Demo", false, false, false, true);
        jInternalFrame.getContentPane().add((Component)jDesktopDemo, "Center");
        jDesktopDemo.init();
        jDesktopDemo.start();
        jInternalFrame.setSize(800, 440);
        jDesktopPane.add(jInternalFrame);
        jDesktopDemo.pane_.setBatch(false);
        jFrame.setVisible(true);
        jInternalFrame.setVisible(true);
    }

    void startButton_actionPerformed(ActionEvent actionEvent) {
        this.rtData_.startData();
    }

    void stopButton_actionPerformed(ActionEvent actionEvent) {
        this.rtData_.stopData();
    }

    void resetButton_actionPerformed(ActionEvent actionEvent) {
        this.rtData_.stopData();
        this.rtData_.resetData();
        this.resetRange();
    }

    private void resetRange() {
        this.pane_.setBatch(true);
        SoTRange.GeoDate geoDate = (SoTRange.GeoDate)this.rtData_.getXRange();
        SoTRange.Double double_ = (SoTRange.Double)this.rtData_.getYRange();
        SoTPoint soTPoint = new SoTPoint(geoDate.start, double_.start);
        this.xt_.setRangeU(geoDate);
        this.yt_.setRangeU(double_);
        this.xbot_.setRangeU(geoDate);
        this.xbot_.setLocationU(soTPoint);
        this.yleft_.setRangeU(double_);
        this.yleft_.setLocationU(soTPoint);
        this.pane_.setBatch(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("rangeModified".equals(propertyChangeEvent.getPropertyName())) {
            this.resetRange();
        }
    }
}

