/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataModel;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelModel;
import gov.noaa.pmel.sgt.beans.PanelModelEditor;
import gov.noaa.pmel.sgt.demo.AddDataFrame;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.swing.JSystemPropertiesDialog;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.TimeRange;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

class BeanDemoFrame
extends JFrame {
    private Page page = new Page();
    private PanelModel panelModel = new PanelModel();
    private DataModel dataModel = new DataModel();
    private SGTData timeSeries;
    private Attribute timeSeriesAttr;
    private SGTData grid;
    private Attribute gridAttr;
    private SGTData line;
    private Attribute lineAttr;
    private JPanel contentPane;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenuFile = new JMenu();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JMenu jMenuView = new JMenu();
    private JMenuItem jMenuViewReset = new JMenuItem();
    private JMenuItem jMenuViewTree = new JMenuItem();
    private JPanel pagePanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JMenuItem jMenuHelpProps = new JMenuItem();
    private JMenu jMenuEdit = new JMenu();
    private JMenuItem jMenuEditData = new JMenuItem();
    private JMenuItem jMenuEditPM = new JMenuItem();
    private JMenuItem jMenuFilePrint = new JMenuItem();
    private JMenuItem jMenuFilePage = new JMenuItem();
    private PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();

    public BeanDemoFrame() {
        this.enableEvents(64L);
        this.page.getJPane().setBackground(Color.lightGray);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.createGraphic();
        this.pack();
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setTitle("SGT Bean Demo");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuFileExit_actionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuHelpAbout_actionPerformed(actionEvent);
            }
        });
        this.jMenuView.setText("View");
        this.jMenuViewReset.setText("Reset All Zoom");
        this.jMenuViewReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuViewReset_actionPerformed(actionEvent);
            }
        });
        this.jMenuViewTree.setText("Class Tree...");
        this.jMenuViewTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuViewTree_actionPerformed(actionEvent);
            }
        });
        this.pagePanel.setLayout(this.borderLayout2);
        this.jMenuHelpProps.setText("System Properties...");
        this.jMenuHelpProps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuHelpProps_actionPerformed(actionEvent);
            }
        });
        this.jMenuEdit.setText("Edit");
        this.jMenuEditData.setText("Add Data...");
        this.jMenuEditData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuEditData_actionPerformed(actionEvent);
            }
        });
        this.jMenuEditPM.setText("PanelModel");
        this.jMenuEditPM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuEditPM_actionPerformed(actionEvent);
            }
        });
        this.jMenuFilePrint.setText("Print...");
        this.jMenuFilePrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuFilePrint_actionPerformed(actionEvent);
            }
        });
        this.jMenuFilePage.setText("Page Layout...");
        this.jMenuFilePage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanDemoFrame.this.jMenuFilePage_actionPerformed(actionEvent);
            }
        });
        this.jMenuFile.add(this.jMenuFilePage);
        this.jMenuFile.add(this.jMenuFilePrint);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpProps);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuView.add(this.jMenuViewReset);
        this.jMenuView.add(this.jMenuViewTree);
        this.contentPane.add((Component)this.pagePanel, "Center");
        this.jMenuEdit.add(this.jMenuEditData);
        this.jMenuEdit.add(this.jMenuEditPM);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "BeanDemo: SGT version 3.0", "About BeanDemo", 1);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    private void createGraphic() {
        this.pagePanel.add((Component)this.page, "Center");
        this.page.setDataModel(this.dataModel);
        try {
            this.panelModel = PanelModel.loadFromXML(this.getClass().getResource("BeanDemoPanelModel.xml").openStream());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.page.setPanelModel(this.panelModel);
        PanelHolder panelHolder = this.panelModel.findPanelHolder("UpperLeft");
        DataGroup dataGroup = panelHolder.findDataGroup("Grid");
        Legend legend = panelHolder.findLegend("ColorKey");
        this.createGrid();
        this.dataModel.addData(this.grid, this.gridAttr, panelHolder, dataGroup, legend);
        PanelHolder panelHolder2 = this.panelModel.findPanelHolder("UpperRight");
        DataGroup dataGroup2 = panelHolder2.findDataGroup("Random");
        this.createLine();
        this.dataModel.addData(this.line, this.lineAttr, panelHolder2, dataGroup2, null);
        PanelHolder panelHolder3 = this.panelModel.findPanelHolder("Bottom");
        DataGroup dataGroup3 = panelHolder3.findDataGroup("TimeSeries");
        this.createTimeSeries();
        this.dataModel.addData(this.timeSeries, this.timeSeriesAttr, panelHolder3, dataGroup3, null);
    }

    private void createTimeSeries() {
        int n = 4;
        int n2 = 2;
        GeoDate geoDate = null;
        GeoDate geoDate2 = null;
        String string = "yyyy-MM-dd HH:mm";
        String string2 = "2001-02-12 00:00";
        String string3 = "2001-06-10 00:00";
        try {
            geoDate = new GeoDate(string2, string);
            geoDate2 = new GeoDate(string3, string);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            String string4 = "Illegal time string '" + string2 + "' or '" + string3 + "'" + "\nshould be of the form " + string;
            JOptionPane.showMessageDialog(this, string4, "Error in Time Value", 0);
            return;
        }
        float f = 2.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 5.0f;
        TestData testData = new TestData(n, new TimeRange(geoDate, geoDate2), f, n2, f2, f3, f4);
        this.timeSeries = testData.getSGTData();
        this.timeSeriesAttr = new LineAttribute(0, Color.blue.brighter());
    }

    void createLine() {
        int n = 2;
        int n2 = 2;
        double d = 0.0;
        double d2 = 10.0;
        double d3 = 0.5;
        Range2D range2D = new Range2D(d, d2, d3);
        float f = 1.0f;
        float f2 = 0.0f;
        float f3 = 5.0f;
        TestData testData = new TestData(n, range2D, n2, f, f2, f3);
        this.line = testData.getSGTData();
        this.lineAttr = new LineAttribute(0, Color.blue);
    }

    void createGrid() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] nArray3 = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int n = 5;
        int n2 = 1;
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 0.02;
        Range2D range2D = new Range2D(d, d2, d3);
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = 0.02;
        Range2D range2D2 = new Range2D(d4, d5, d6);
        float f = 0.5f;
        float f2 = 0.5f;
        float f3 = 0.2f;
        TestData testData = new TestData(n, range2D, range2D2, n2, f, f2, f3);
        this.grid = testData.getSGTData();
        IndexedColorMap indexedColorMap = new IndexedColorMap(nArray, nArray2, nArray3);
        LinearTransform linearTransform = new LinearTransform(0.0, (double)nArray.length, 0.0, 1.0);
        indexedColorMap.setTransform(linearTransform);
        this.gridAttr = new GridAttribute(0, indexedColorMap);
    }

    void jMenuViewReset_actionPerformed(ActionEvent actionEvent) {
        this.page.resetZoom();
    }

    void jMenuViewTree_actionPerformed(ActionEvent actionEvent) {
        JClassTree jClassTree = new JClassTree();
        jClassTree.setModal(false);
        jClassTree.setJPane(this.page.getJPane());
        jClassTree.show();
    }

    void jMenuEditData_actionPerformed(ActionEvent actionEvent) {
        AddDataFrame addDataFrame = new AddDataFrame(this.page);
        addDataFrame.setVisible(true);
    }

    void jMenuEditPM_actionPerformed(ActionEvent actionEvent) {
        PanelModelEditor panelModelEditor = new PanelModelEditor(this.panelModel);
        panelModelEditor.setVisible(true);
    }

    void jMenuHelpProps_actionPerformed(ActionEvent actionEvent) {
        JSystemPropertiesDialog jSystemPropertiesDialog = new JSystemPropertiesDialog(this, "System Properties", false);
        jSystemPropertiesDialog.show();
    }

    void jMenuFilePrint_actionPerformed(ActionEvent actionEvent) {
        JPane jPane = this.page.getJPane();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.page, this.pageFormat);
        printerJob.setJobName("BeanDemo");
        if (printerJob.printDialog()) {
            try {
                RepaintManager repaintManager = RepaintManager.currentManager(jPane);
                repaintManager.setDoubleBufferingEnabled(false);
                printerJob.print();
                repaintManager.setDoubleBufferingEnabled(true);
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + printerException);
            }
        }
    }

    void jMenuFilePage_actionPerformed(ActionEvent actionEvent) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.pageFormat = printerJob.pageDialog(this.pageFormat);
    }
}

