/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.contour;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.ContourLineAttribute;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StrokeDrawer;
import gov.noaa.pmel.sgt.contour.ContourLabel;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Point2D;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class ContourLine
extends Vector {
    private StrokeDrawer stroke_ = null;
    private boolean closed_ = false;
    private double level_;
    private GeoDate timeRef_ = null;
    private boolean xTime_ = false;
    private boolean yTime_ = false;
    private int kmax_;
    private ContourLineAttribute attr_ = null;
    private DefaultContourLineAttribute defaultAttr_ = null;
    private Vector conLabels_ = new Vector();
    private ContourLabel lnkContourLabel;
    private CartesianGraph cg_;

    public ContourLine() {
        this.stroke_ = JPane.getStrokeDrawer();
    }

    public ContourLine(int n, int n2) {
        super(n, n2);
        this.stroke_ = JPane.getStrokeDrawer();
    }

    public ContourLine(int n) {
        super(n);
        this.stroke_ = JPane.getStrokeDrawer();
    }

    public void setCartesianGraph(CartesianGraph cartesianGraph) {
        this.cg_ = cartesianGraph;
    }

    public void setAttributes(DefaultContourLineAttribute defaultContourLineAttribute, ContourLineAttribute contourLineAttribute) {
        this.defaultAttr_ = defaultContourLineAttribute;
        this.attr_ = contourLineAttribute;
    }

    public void setContourLineAttribute(ContourLineAttribute contourLineAttribute) {
        this.attr_ = contourLineAttribute;
    }

    public ContourLineAttribute getContourLineAttribute() {
        return this.attr_;
    }

    public void setDefaultContourLineAttribute(DefaultContourLineAttribute defaultContourLineAttribute) {
        this.defaultAttr_ = defaultContourLineAttribute;
    }

    public DefaultContourLineAttribute getDefaultContourLineAttribute() {
        return this.defaultAttr_;
    }

    void setClosed(boolean bl) {
        this.closed_ = bl;
    }

    public boolean isClosed() {
        return this.closed_;
    }

    public double getLevel() {
        return this.level_;
    }

    void setLevel(double d) {
        this.level_ = d;
    }

    void addPoint(double d, double d2) {
        this.addElement(new Point2D.Double(d, d2));
    }

    void addPoint(Point2D.Double double_) {
        this.addElement(double_);
    }

    void setKmax(int n) {
        this.kmax_ = n;
    }

    public int getKmax() {
        return this.kmax_;
    }

    void setTime(GeoDate geoDate, boolean bl, boolean bl2) {
        this.timeRef_ = geoDate;
        this.xTime_ = bl;
        this.yTime_ = bl2;
    }

    void setReferenceTime(GeoDate geoDate) {
        this.timeRef_ = geoDate;
    }

    public GeoDate getReferenceTime() {
        return this.timeRef_;
    }

    void setXTime(boolean bl) {
        this.xTime_ = bl;
    }

    public boolean isXTime() {
        return this.xTime_;
    }

    void setYTime(boolean bl) {
        this.yTime_ = bl;
    }

    public boolean isYTime() {
        return this.yTime_;
    }

    void reverseElements(int n) {
        int n2 = 1 + n / 2;
        for (int i = 1; i < n2; ++i) {
            int n3 = n + 1 - i;
            Point2D.Double double_ = (Point2D.Double)this.elementAt(i);
            this.setElementAt(this.elementAt(n3), i);
            this.setElementAt(double_, n3);
        }
    }

    public void addLabel(int n, SGLabel sGLabel, double d, double d2) {
        ContourLabel contourLabel = new ContourLabel(n, sGLabel, d, d2);
        this.conLabels_.addElement(contourLabel);
    }

    public void removeAllLabels() {
        this.conLabels_.removeAllElements();
    }

    public void draw(Graphics graphics) {
        double[] dArray = new double[this.kmax_ + 1];
        double[] dArray2 = new double[this.kmax_ + 1];
        this.defaultAttr_.setContourLineAttribute(this.attr_);
        Color color = this.defaultAttr_.getColor();
        dArray = this.getXArrayP();
        dArray2 = this.getYArrayP();
        int n = 1;
        Enumeration enumeration = this.conLabels_.elements();
        while (enumeration.hasMoreElements()) {
            double d;
            double d2;
            int n2;
            double d3;
            double d4;
            double d5;
            int n3;
            ContourLabel contourLabel = (ContourLabel)enumeration.nextElement();
            int n4 = contourLabel.getIndex();
            double d6 = contourLabel.getWidth();
            double d7 = contourLabel.getHeight() * 0.5;
            SGLabel sGLabel = contourLabel.getLabel();
            graphics.setColor(color);
            this.drawLine(graphics, dArray, dArray2, n, n4);
            n = n4;
            for (n3 = n2 = n + 1; n3 <= this.kmax_ && !((d5 = Math.sqrt((d4 = dArray[n3] - dArray[n]) * d4 + (d3 = dArray2[n3] - dArray2[n]) * d3)) >= d6); ++n3) {
            }
            double d8 = dArray[n3 - 1] - dArray[n];
            double d9 = dArray[n3] - dArray[n3 - 1];
            double d10 = dArray2[n3 - 1] - dArray2[n];
            double d11 = dArray2[n3] - dArray2[n3 - 1];
            double d12 = d9 * d9 + d11 * d11;
            double d13 = d8 * d9 + d10 * d11;
            double d14 = d8 * d8 + d10 * d10 - d6 * d6;
            double d15 = (-d13 + Math.sqrt(d13 * d13 - d12 * d14)) / d12;
            d4 = d8 + d9 * d15;
            d3 = d10 + d11 * d15;
            double d16 = dArray[n] + d4;
            double d17 = dArray2[n] + d3;
            double d18 = 90.0;
            if (d3 < 0.0) {
                d18 = -90.0;
            }
            if (d4 != 0.0) {
                d18 = Math.atan(d3 / d4) * 180.0 / Math.PI;
            }
            if (d4 >= 0.0) {
                d2 = dArray[n] + d7 * (0.5 * d4 + d3) / d6;
                d = dArray2[n] + d7 * (0.5 * d3 - d4) / d6;
            } else {
                d2 = d16 - d7 * (0.5 * d4 + d3) / d6;
                d = d17 - d7 * (0.5 * d3 - d4) / d6;
            }
            sGLabel.setAngle(d18);
            sGLabel.setLocationP(new Point2D.Double(d2, d));
            try {
                sGLabel.draw(graphics);
            }
            catch (LayerNotFoundException layerNotFoundException) {
                System.out.println(layerNotFoundException);
            }
            graphics.setColor(color);
            this.drawLineSegment(graphics, d16, d17, dArray[n3], dArray2[n3]);
            n = n3;
        }
        if (n < this.kmax_) {
            graphics.setColor(color);
            this.drawLine(graphics, dArray, dArray2, n, this.kmax_);
        }
    }

    private void drawLine(Graphics graphics, double[] dArray, double[] dArray2, int n, int n2) {
        int n3 = n2 - n + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 <= n2) {
            nArray[n4] = this.cg_.getLayer().getXPtoD(dArray[n5]);
            nArray2[n4] = this.cg_.getLayer().getYPtoD(dArray2[n5]);
            ++n5;
            ++n4;
        }
        switch (this.defaultAttr_.getStyle()) {
            case 3: {
                this.stroke_.drawHighlight(graphics, nArray, nArray2, n3, this.defaultAttr_);
                break;
            }
            case 2: {
                this.stroke_.drawHeavy(graphics, nArray, nArray2, n3, this.defaultAttr_);
                break;
            }
            case 1: {
                this.stroke_.drawDashed(graphics, nArray, nArray2, n3, this.defaultAttr_);
                break;
            }
            case 6: {
                this.stroke_.drawStroke(graphics, nArray, nArray2, n3, this.defaultAttr_);
                break;
            }
            default: {
                graphics.drawPolyline(nArray, nArray2, n3);
            }
        }
    }

    private void drawLineSegment(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = 2;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        nArray[0] = this.cg_.getLayer().getXPtoD(d);
        nArray2[0] = this.cg_.getLayer().getYPtoD(d2);
        nArray[1] = this.cg_.getLayer().getXPtoD(d3);
        nArray2[1] = this.cg_.getLayer().getYPtoD(d4);
        switch (this.defaultAttr_.getStyle()) {
            case 3: {
                this.stroke_.drawHighlight(graphics, nArray, nArray2, n, this.defaultAttr_);
                break;
            }
            case 2: {
                this.stroke_.drawHeavy(graphics, nArray, nArray2, n, this.defaultAttr_);
                break;
            }
            case 1: {
                this.stroke_.drawDashed(graphics, nArray, nArray2, n, this.defaultAttr_);
                break;
            }
            case 6: {
                this.stroke_.drawStroke(graphics, nArray, nArray2, n, this.defaultAttr_);
                break;
            }
            default: {
                graphics.drawPolyline(nArray, nArray2, n);
            }
        }
    }

    public double[] getXArrayP() {
        double[] dArray = null;
        if (this.cg_ != null) {
            dArray = new double[this.kmax_ + 1];
            for (int i = 0; i <= this.kmax_; ++i) {
                Point2D.Double double_ = (Point2D.Double)this.elementAt(i);
                if (this.isXTime()) {
                    GeoDate geoDate = new GeoDate(this.timeRef_).increment(double_.x, 1);
                    dArray[i] = this.cg_.getXUtoP(geoDate);
                    continue;
                }
                dArray[i] = this.cg_.getXUtoP(double_.x);
            }
        }
        return dArray;
    }

    public double[] getYArrayP() {
        double[] dArray = null;
        if (this.cg_ != null) {
            dArray = new double[this.kmax_ + 1];
            for (int i = 0; i <= this.kmax_; ++i) {
                Point2D.Double double_ = (Point2D.Double)this.elementAt(i);
                if (this.isYTime()) {
                    GeoDate geoDate = new GeoDate(this.timeRef_).increment(double_.x, 1);
                    dArray[i] = this.cg_.getYUtoP(geoDate);
                    continue;
                }
                dArray[i] = this.cg_.getYUtoP(double_.y);
            }
        }
        return dArray;
    }
}

