/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.PanelModel;
import gov.noaa.pmel.sgt.beans.PropertyPanel;
import gov.noaa.pmel.sgt.swing.prop.ColorDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

class PanelModelPropertyPanel
extends PropertyPanel
implements PropertyChangeListener,
ActionListener {
    private boolean expert_ = false;
    private PanelModel pModel_ = null;
    private String[] pNames_ = new String[]{"DPI", "Page Color", "Page Size", "Panels", "Print Borders", "Print HAlign", "Print Origin", "Print Scale Mode", "Print VAlign", "Print White"};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private String[] vAlignItems = new String[]{"Top", "Middle", "Bottom", "Specified Location"};
    private String[] hAlignItems = new String[]{"Left", "Center", "Right", "Specified Location"};
    private String[] sModeItems = new String[]{"Default", "To Fit", "Shrink To Fit"};

    public PanelModelPropertyPanel(PanelModel panelModel) {
        this.pModel_ = panelModel;
        this.pModel_.addPropertyChangeListener(this);
        this.create();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.update();
    }

    void create() {
        int n = -1;
        int n2 = -1;
        this.comps_[++n] = this.createLabel(Float.toString(this.pModel_.getDpi()));
        this.comps_[++n] = this.createColor(this.pModel_.getPageBackgroundColor(), this.pNames_[n], this);
        this.comps_[++n] = this.createTextField(this.format(this.pModel_.getPageSize(), false), this.pNames_[n], this, true);
        this.comps_[++n] = this.createLabel(this.pModel_.getPanelCount());
        this.comps_[++n] = this.createCheckBox(this.pModel_.isPrintBorders(), this.pNames_[n], this);
        switch (this.pModel_.getPrintHAlign()) {
            case 0: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case -1: {
                n2 = 3;
            }
        }
        this.comps_[++n] = this.createComboBox(this.hAlignItems, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createTextField(this.format(this.pModel_.getPrintOrigin(), false), this.pNames_[n], this, true);
        switch (this.pModel_.getPrintScaleMode()) {
            default: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        this.comps_[++n] = this.createComboBox(this.sModeItems, n2, this.pNames_[n], (ActionListener)this, true);
        switch (this.pModel_.getPrintVAlign()) {
            default: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case -1: {
                n2 = 3;
            }
        }
        this.comps_[++n] = this.createComboBox(this.vAlignItems, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createCheckBox(this.pModel_.isPrintWhitePage(), this.pNames_[n], this);
        for (n = 0; n < this.comps_.length; ++n) {
            this.addProperty(n + 1, this.pNames_[n], this.comps_[n], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    void update() {
        int n = -1;
        int n2 = -1;
        ((JLabel)this.comps_[++n]).setText(Float.toString(this.pModel_.getDpi()));
        this.updateColor((JButton)this.comps_[++n], this.pModel_.getPageBackgroundColor());
        ((JTextField)this.comps_[++n]).setText(this.format(this.pModel_.getPageSize(), false));
        ((JLabel)this.comps_[++n]).setText(Integer.toString(this.pModel_.getPanelCount()));
        ((JCheckBox)this.comps_[++n]).setSelected(this.pModel_.isPrintBorders());
        switch (this.pModel_.getPrintHAlign()) {
            case 0: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case -1: {
                n2 = 3;
            }
        }
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        ((JTextField)this.comps_[++n]).setText(this.format(this.pModel_.getPrintOrigin(), false));
        switch (this.pModel_.getPrintScaleMode()) {
            default: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        switch (this.pModel_.getPrintVAlign()) {
            default: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case -1: {
                n2 = 3;
            }
        }
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        ((JCheckBox)this.comps_[++n]).setSelected(this.pModel_.isPrintWhitePage());
    }

    private void processEvent(Object object, String string) {
        int n = -1;
        if (string.equals("Page Size")) {
            Dimension dimension = this.parseDimension(((JTextField)object).getText());
            this.pModel_.setPageSize(dimension);
            if (this.pModel_.getPage() != null) {
                this.pModel_.getPage().setSize(dimension);
            }
        } else if (string.equals("Page Color")) {
            ColorDialog colorDialog = new ColorDialog(this.getFrame(), "Select Axis Color", true);
            colorDialog.setColor(this.pModel_.getPageBackgroundColor());
            colorDialog.setVisible(true);
            Color color = colorDialog.getColor();
            if (color != null) {
                this.pModel_.setPageBackgroundColor(color);
                this.updateColor((JButton)object, color);
            }
        } else if (string.equals("Print Borders")) {
            this.pModel_.setPrintBorders(((JCheckBox)object).isSelected());
        } else if (string.equals("Print HAlign")) {
            String string2 = (String)((JComboBox)object).getSelectedItem();
            n = -1;
            if (string2.equals("Left")) {
                n = 0;
            } else if (string2.equals("Center")) {
                n = 1;
            } else if (string2.equals("Right")) {
                n = 2;
            } else if (string2.equals("Specified Location")) {
                n = -1;
            }
            this.pModel_.setPrintHAlign(n);
        } else if (string.equals("Print Origin")) {
            Point point = this.parsePoint(((JTextField)object).getText());
            if (point != null) {
                this.pModel_.setPrintOrigin(point);
            }
        } else if (string.equals("Print Scale Mode")) {
            String string3 = (String)((JComboBox)object).getSelectedItem();
            n = -1;
            if (string3.equals("Default")) {
                n = 1;
            } else if (string3.equals("To Fit")) {
                n = 0;
            } else if (string3.equals("Shrink To Fit")) {
                n = 2;
            }
            this.pModel_.setPrintScaleMode(n);
        } else if (string.equals("Print VAlign")) {
            String string4 = (String)((JComboBox)object).getSelectedItem();
            n = -1;
            if (string4.equals("Top")) {
                n = 0;
            } else if (string4.equals("Middle")) {
                n = 1;
            } else if (string4.equals("Bottom")) {
                n = 2;
            } else if (string4.equals("Specified Location")) {
                n = -1;
            }
            this.pModel_.setPrintVAlign(n);
        } else if (string.equals("Print White")) {
            this.pModel_.setPrintWhitePage(((JCheckBox)object).isSelected());
        }
    }

    void resetFields() {
    }

    public void setExpert(boolean bl) {
        this.expert_ = bl;
    }

    public boolean isExpert() {
        return this.expert_;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        this.processEvent(object, string);
    }
}

