/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.PanelModel;
import gov.noaa.pmel.sgt.beans.PanelModelCustomizer;
import gov.noaa.pmel.util.SimpleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InvalidObjectException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class PanelModelEditor
extends JFrame {
    private PanelModel panelModel_ = null;
    private static boolean isApp_ = false;
    private boolean throwClosing = true;
    private String openPath_ = null;
    private static String title_ = "Panel Model Editor";
    private JFileChooser fileChooser_ = null;
    private JPanel pmcPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JMenuBar menuBar = new JMenuBar();
    private JButton okButton = new JButton();
    private PanelModelCustomizer pmc = new PanelModelCustomizer();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JMenu fileMenu = new JMenu();
    private JMenuItem openFileMI = new JMenuItem();
    private JMenuItem saveFileMI = new JMenuItem();
    private JMenuItem exitFileMI = new JMenuItem();
    private JMenuItem saveAsFileMI = new JMenuItem();
    private JMenuItem newFileMI = new JMenuItem();

    public PanelModelEditor(PanelModel panelModel) {
        this();
        this.setPanelModel(panelModel);
    }

    public PanelModelEditor() {
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        isApp_ = true;
        PanelModelEditor panelModelEditor = new PanelModelEditor(new PanelModel());
        panelModelEditor.setTitle(title_);
        panelModelEditor.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelModelEditor.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.pmcPanel.setLayout(this.borderLayout1);
        this.fileMenu.setText("File");
        this.openFileMI.setActionCommand("Open");
        this.openFileMI.setText("Open...");
        this.openFileMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelModelEditor.this.openFileMI_actionPerformed(actionEvent);
            }
        });
        this.saveFileMI.setActionCommand("Save");
        this.saveFileMI.setText("Save");
        this.saveFileMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelModelEditor.this.saveFileMI_actionPerformed(actionEvent);
            }
        });
        this.exitFileMI.setText("Exit");
        this.exitFileMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelModelEditor.this.exitFileMI_actionPerformed(actionEvent);
            }
        });
        this.saveAsFileMI.setActionCommand("SaveAs");
        this.saveAsFileMI.setText("Save As...");
        this.saveAsFileMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelModelEditor.this.saveAsFileMI_actionPerformed(actionEvent);
            }
        });
        if (isApp_) {
            this.setJMenuBar(this.menuBar);
        }
        this.newFileMI.setText("New");
        this.newFileMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelModelEditor.this.newFileMI_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.pmcPanel, "Center");
        if (!isApp_) {
            this.getContentPane().add((Component)this.buttonPanel, "South");
        }
        this.buttonPanel.add((Component)this.okButton, null);
        this.pmcPanel.add((Component)this.pmc, "Center");
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.newFileMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openFileMI);
        this.fileMenu.add(this.saveFileMI);
        this.fileMenu.add(this.saveAsFileMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitFileMI);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (PanelModelEditor.this.throwClosing) {
                    PanelModelEditor.this.pmf_windowClosing(windowEvent);
                }
            }
        });
        Dimension dimension = this.pmc.getPreferredSize();
        this.setSize(new Dimension(473, 354));
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.getSize();
        if (dimension3.height > dimension2.height) {
            dimension3.height = dimension2.height;
        }
        if (dimension3.width > dimension2.width) {
            dimension3.width = dimension2.width;
        }
        this.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
    }

    void pmf_windowClosing(WindowEvent windowEvent) {
        this.throwClosing = false;
        this.setVisible(false);
        if (this.panelModel_ != null) {
            this.panelModel_.setBatch(false);
        }
        this.dispose();
        if (isApp_) {
            System.exit(0);
        }
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.throwClosing = false;
        this.pmf_windowClosing(null);
    }

    public PanelModel getPanelModel() {
        return this.panelModel_;
    }

    public void setPanelModel(PanelModel panelModel) {
        this.panelModel_ = panelModel;
        if (this.panelModel_ != null) {
            this.panelModel_.setBatch(true);
            this.pmc.setObject(this.panelModel_);
        }
    }

    void openFileMI_actionPerformed(ActionEvent actionEvent) {
        PanelModel panelModel = null;
        String[] stringArray = new String[]{".xml"};
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray, "XML Serialized Bean");
        if (this.fileChooser_ == null) {
            this.fileChooser_ = new JFileChooser();
        }
        this.fileChooser_.setFileFilter(this.fileChooser_.getAcceptAllFileFilter());
        this.fileChooser_.resetChoosableFileFilters();
        this.fileChooser_.addChoosableFileFilter(simpleFileFilter);
        this.fileChooser_.setFileFilter(simpleFileFilter);
        int n = this.fileChooser_.showOpenDialog(this);
        if (n == 0) {
            File file = this.fileChooser_.getSelectedFile();
            this.openPath_ = file.getPath();
            this.setTitle(title_ + ": " + this.openPath_);
            try {
                panelModel = PanelModel.loadFromXML(new BufferedInputStream(new FileInputStream(this.openPath_)));
                this.setPanelModel(panelModel);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, "Error openning file", "File Open Error", 0);
            }
            catch (InvalidObjectException invalidObjectException) {
                JOptionPane.showMessageDialog(this, "File does not contain a PanelModel", "PanelModel Not Found", 0);
            }
        }
    }

    void saveAsFileMI_actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = new String[]{".xml"};
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray, "XML Serialized Bean");
        if (this.fileChooser_ == null) {
            this.fileChooser_ = new JFileChooser();
        }
        this.fileChooser_.setFileFilter(this.fileChooser_.getAcceptAllFileFilter());
        this.fileChooser_.resetChoosableFileFilters();
        this.fileChooser_.addChoosableFileFilter(simpleFileFilter);
        this.fileChooser_.setFileFilter(simpleFileFilter);
        int n = this.fileChooser_.showSaveDialog(this);
        if (n == 0) {
            File file = this.fileChooser_.getSelectedFile();
            FileFilter fileFilter = this.fileChooser_.getFileFilter();
            String string = file.getPath();
            if (fileFilter instanceof SimpleFileFilter) {
                String string2 = ((SimpleFileFilter)fileFilter).getExtension();
                String string3 = file.getName().toLowerCase();
                if (!string3.endsWith(string2)) {
                    string = string + string2;
                }
            }
            if (new File(string).exists()) {
                JOptionPane.showMessageDialog(this, "File already exists, rename and try again", "File Save Error", 0);
                return;
            }
            try {
                this.panelModel_.saveToXML(new BufferedOutputStream(new FileOutputStream(string, false)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, "Error creating file, rename and try again", "File Save Error", 0);
                return;
            }
        }
    }

    void saveFileMI_actionPerformed(ActionEvent actionEvent) {
        if (this.openPath_ == null) {
            return;
        }
        try {
            this.panelModel_.saveToXML(new BufferedOutputStream(new FileOutputStream(this.openPath_, false)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Error creating file, rename and try again", "File Save Error", 0);
            return;
        }
    }

    void exitFileMI_actionPerformed(ActionEvent actionEvent) {
        this.throwClosing = false;
        this.pmf_windowClosing(null);
    }

    void newFileMI_actionPerformed(ActionEvent actionEvent) {
        this.setPanelModel(new PanelModel());
    }
}

