/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelModel
implements Serializable,
ChangeListener,
ComponentListener,
PropertyChangeListener {
    private transient PropertyChangeSupport support_ = new PropertyChangeSupport(this);
    private Map panelList = new HashMap(4);
    private float dpi = 72.0f;
    private Dimension pageSize = new Dimension(400, 300);
    private Color pageBackgroundColor = Color.white;
    private int printHAlign = 1;
    private int printVAlign = 0;
    private int printMode = 1;
    private Point printOrigin = new Point(0, 0);
    private boolean printBorders = false;
    private boolean printWhitePage = true;
    private transient boolean batch = false;
    private transient boolean modified = false;
    private transient ChangeEvent changeEvent_ = new ChangeEvent(this);
    private transient Vector changeListeners;
    private transient Page page;

    public static PanelModel loadFromXML(InputStream inputStream) throws InvalidObjectException {
        PanelModel panelModel = null;
        XMLDecoder xMLDecoder = new XMLDecoder(inputStream);
        Object object = xMLDecoder.readObject();
        xMLDecoder.close();
        if (!(object instanceof PanelModel)) {
            throw new InvalidObjectException("XML file does not contain a PanelModel");
        }
        panelModel = (PanelModel)object;
        panelModel.repair();
        return panelModel;
    }

    public void saveToXML(OutputStream outputStream) {
        XMLEncoder xMLEncoder = new XMLEncoder(outputStream);
        xMLEncoder.writeObject(this);
        xMLEncoder.close();
    }

    public void addPanel(String string, Rectangle rectangle, Map map, Map map2, Map map3) {
        PanelHolder panelHolder = new PanelHolder(string, this, rectangle, map, map2, map3);
        this.addPanel(panelHolder);
    }

    public void addPanel(PanelHolder panelHolder) {
        int n = this.panelList.size();
        panelHolder.addChangeListener(this);
        this.panelList.put(panelHolder.getId(), panelHolder);
        this.firePropertyChange("panelList", n, this.panelList.size());
    }

    public void removePanel(PanelHolder panelHolder) {
        int n = this.panelList.size();
        panelHolder.removeChangeListener(this);
        this.panelList.remove(panelHolder.getId());
        this.firePropertyChange("panelList", n, this.panelList.size());
    }

    public Iterator panelIterator() {
        return this.panelList.values().iterator();
    }

    public int getPanelCount() {
        return this.panelList.size();
    }

    public boolean hasPanelHolder(String string) {
        return this.findPanelHolder(string) != null;
    }

    public PanelHolder findPanelHolder(String string) {
        return (PanelHolder)this.panelList.get(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support_.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support_.removePropertyChangeListener(string, propertyChangeListener);
    }

    public float getDpi() {
        return this.dpi;
    }

    public void setDpi(float f) {
        float f2 = this.dpi;
        this.dpi = f;
        if (f2 != this.dpi) {
            this.firePropertyChange("dpi", new Float(f2), new Float(this.dpi));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        this.firePropertyChange("panel", null, object);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        if (this.batch) {
            this.modified = true;
        } else {
            this.support_.firePropertyChange(string, object, object2);
        }
    }

    private void firePropertyChange(String string, int n, int n2) {
        if (this.batch) {
            this.modified = true;
        } else {
            this.support_.firePropertyChange(string, n, n2);
        }
    }

    public void setBatch(boolean bl) {
        this.batch = bl;
        if (!this.batch && this.modified) {
            this.modified = false;
            this.support_.firePropertyChange("batch", null, null);
        }
    }

    private void repair() {
        Iterator iterator = this.panelIterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            PanelHolder panelHolder = (PanelHolder)iterator.next();
            panelHolder.removeAllChangeListeners();
            panelHolder.addChangeListener(this);
            panelHolder.setPanelModel(this);
            Iterator iterator2 = panelHolder.dataGroupIterator();
            while (iterator2.hasNext()) {
                object2 = (DataGroup)iterator2.next();
                ((DataGroup)object2).removeAllChangeListeners();
                ((DataGroup)object2).addChangeListener(panelHolder);
                ((DataGroup)object2).setPanelHolder(panelHolder);
                ((DataGroup)object2).getXAxisHolder().removeAllChangeListeners();
                ((DataGroup)object2).getXAxisHolder().addChangeListener((ChangeListener)object2);
                ((DataGroup)object2).getXAxisHolder().setDataGroup((DataGroup)object2);
                ((DataGroup)object2).getYAxisHolder().removeAllChangeListeners();
                ((DataGroup)object2).getYAxisHolder().addChangeListener((ChangeListener)object2);
                ((DataGroup)object2).getYAxisHolder().setDataGroup((DataGroup)object2);
            }
            object2 = panelHolder.labelIterator();
            while (object2.hasNext()) {
                object = (Label)object2.next();
                ((Label)object).removeAllChangeListeners();
                ((Label)object).addChangeListener(panelHolder);
                ((Label)object).setPanelHolder(panelHolder);
            }
            object = panelHolder.legendIterator();
            while (object.hasNext()) {
                Legend legend = (Legend)object.next();
                legend.removeAllChangeListeners();
                legend.addChangeListener(panelHolder);
                legend.setPanelHolder(panelHolder);
            }
        }
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setPage(Page page) {
        if (this.page != null) {
            this.removePropertyChangeListener(this.page);
        }
        this.page = page;
        this.addPropertyChangeListener(this.page);
        page.addComponentListener(this);
        page.addPropertyChangeListener(this);
        this.pageSize = page.getSize();
    }

    public Page getPage() {
        return this.page;
    }

    public Map getPanelList() {
        return this.panelList;
    }

    public void setPanelList(Map map) {
        this.panelList = map;
        Iterator iterator = this.panelIterator();
        while (iterator.hasNext()) {
            PanelHolder panelHolder = (PanelHolder)iterator.next();
            panelHolder.addChangeListener(this);
        }
        this.firePropertyChange("panelList", 0, map.size());
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Dimension dimension) {
        Dimension dimension2 = this.pageSize;
        this.pageSize = dimension;
        if (!dimension2.equals(this.pageSize)) {
            this.firePropertyChange("pageSize", dimension2, dimension);
            this.fireStateChanged();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.pageSize = this.page.getSize();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public Color getPageBackgroundColor() {
        return this.pageBackgroundColor;
    }

    public void setPageBackgroundColor(Color color) {
        Color color2 = this.pageBackgroundColor;
        this.pageBackgroundColor = color;
        if (!color2.equals(this.pageBackgroundColor)) {
            this.firePropertyChange("pageBackgroundColor", color2, this.pageBackgroundColor);
            this.fireStateChanged();
        }
    }

    public boolean isPrintBorders() {
        return this.printBorders;
    }

    public boolean isPrintWhitePage() {
        return this.printWhitePage;
    }

    public void setPrintBorders(boolean bl) {
        boolean bl2 = this.printBorders;
        this.printBorders = bl;
        if (bl2 != this.printBorders) {
            this.firePropertyChange("printBorders", new Boolean(bl2), new Boolean(this.printBorders));
        }
    }

    public void setPrintWhitePage(boolean bl) {
        boolean bl2 = this.printWhitePage;
        this.printWhitePage = bl;
        if (bl2 != this.printWhitePage) {
            this.firePropertyChange("printWhitePage", new Boolean(bl2), new Boolean(this.printWhitePage));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null && this.changeListeners.contains(changeListener)) {
            Vector vector = (Vector)this.changeListeners.clone();
            vector.removeElement(changeListener);
            this.changeListeners = vector;
        }
    }

    public synchronized void removeDesignChangeListeners() {
        if (this.changeListeners != null) {
            Vector vector = (Vector)this.changeListeners.clone();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DesignListener)) continue;
                this.changeListeners.removeElement(e);
            }
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        Vector vector;
        Vector vector2 = vector = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!vector.contains(changeListener)) {
            vector.addElement(changeListener);
            this.changeListeners = vector;
        }
    }

    protected void fireStateChanged() {
        if (this.changeListeners != null) {
            Vector vector = this.changeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ChangeListener)vector.elementAt(i)).stateChanged(this.changeEvent_);
            }
        }
    }

    public int getPrintHAlign() {
        return this.printHAlign;
    }

    public void setPrintHAlign(int n) {
        int n2 = this.printHAlign;
        this.printHAlign = n;
        if (n2 != this.printHAlign) {
            this.firePropertyChange("printHAlign", n2, this.printHAlign);
        }
    }

    public void setPrintOrigin(Point point) {
        Point point2 = this.printOrigin;
        this.printOrigin = point;
        if (!point2.equals(this.printOrigin)) {
            this.firePropertyChange("printOrigin", point2, this.printOrigin);
        }
    }

    public Point getPrintOrigin() {
        return this.printOrigin;
    }

    public int getPrintVAlign() {
        return this.printVAlign;
    }

    public void setPrintVAlign(int n) {
        int n2 = this.printVAlign;
        this.printVAlign = n;
        if (n2 != this.printVAlign) {
            this.firePropertyChange("printVAlign", n2, this.printVAlign);
        }
    }

    public int getPrintScaleMode() {
        return this.printMode;
    }

    public void setPrintScaleMode(int n) {
        int n2 = this.printMode;
        this.printMode = n;
        if (n2 != this.printMode) {
            this.firePropertyChange("printScaleMode", n2, this.printMode);
        }
    }
}

