/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.beans.DataHolder;
import gov.noaa.pmel.sgt.beans.DataModel;
import gov.noaa.pmel.sgt.beans.DataTargetMismatchException;
import gov.noaa.pmel.sgt.beans.Panel;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class Page
extends JComponent
implements PropertyChangeListener,
Serializable,
Printable {
    public static final boolean DEBUG = false;
    private DataModel dataModel;
    private PanelModel panelModel;
    private JPane pane_;
    private String name;
    private transient boolean isDesignTime_ = Beans.isDesignTime();

    public Page() {
        this.pane_ = new JPane("SGT Bean Pane", new Dimension(200, 200));
        this.pane_.addPropertyChangeListener(this);
        this.pane_.setBackground(Color.white);
        this.pane_.setOpaque(true);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.add((Component)this.pane_, "Center");
        this.pane_.addMouseListener(new PageMouse());
    }

    public JPane getJPane() {
        return this.pane_;
    }

    public Dimension getJPaneSize() {
        return this.pane_.getSize();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        DataModel dataModel2 = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removePropertyChangeListener(this);
        }
        if (dataModel != null) {
            dataModel.addPropertyChangeListener(this);
        }
        this.dataModel = dataModel;
        this.dataModel.setPage(this);
        if (this.isDesignTime_) {
            this.repaint();
        }
        this.firePropertyChange("dataModel", dataModel2, this.dataModel);
    }

    public PanelModel getPanelModel() {
        return this.panelModel;
    }

    public void setPanelModel(PanelModel panelModel) {
        PanelModel panelModel2 = this.panelModel;
        this.setSize(panelModel.getPageSize());
        this.setBackground(panelModel.getPageBackgroundColor());
        this.setPreferredSize(panelModel.getPageSize());
        this.panelModel = panelModel;
        this.panelModel.setPage(this);
        this.updatePanels();
        if (this.isDesignTime_) {
            this.repaint();
        }
        this.firePropertyChange("panelModel", panelModel2, this.panelModel);
    }

    public String getName() {
        return this.name;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.pane_.setBackground(color);
    }

    public void setName(String string) {
        this.firePropertyChange("name", this.name, string);
        this.name = string;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (object instanceof PanelModel) {
            this.updatePanels();
        } else if (object instanceof DataModel) {
            Object object2 = propertyChangeEvent.getNewValue();
            if (object2 instanceof DataHolder) {
                try {
                    this.pane_.setBatch(true);
                    ((DataHolder)object2).notifyPanel();
                    this.pane_.setModified(true, "Page");
                    this.pane_.setBatch(false);
                }
                catch (DataTargetMismatchException dataTargetMismatchException) {
                    dataTargetMismatchException.printStackTrace();
                }
            }
        } else if (object != this.pane_ || string.equals("objectSelected") || string.equals("zoomRectangle")) {
            // empty if block
        }
    }

    private void updatePanels() {
        Object object;
        this.setSize(this.panelModel.getPageSize());
        this.setBackground(this.panelModel.getPageBackgroundColor());
        this.setPrintHAlign(this.panelModel.getPrintHAlign());
        this.setPrintVAlign(this.panelModel.getPrintVAlign());
        this.setPrintOrigin(this.panelModel.getPrintOrigin());
        this.setPrintScaleMode(this.panelModel.getPrintScaleMode());
        this.pane_.setBatch(true);
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Panel) || this.panelModel.hasPanelHolder(((Component)(object = (Panel)componentArray[i])).getName())) continue;
            this.pane_.remove((Component)object);
        }
        Panel panel = null;
        object = this.panelModel.panelIterator();
        while (object.hasNext()) {
            PanelHolder panelHolder = (PanelHolder)object.next();
            panel = this.findPanel(panelHolder);
            if (panel == null) {
                panel = new Panel(panelHolder);
                panelHolder.setInstantiated(true);
                this.pane_.add(panel);
                continue;
            }
            panel.update();
        }
        this.validate();
        this.pane_.setModified(true, "Page");
        this.pane_.setBatch(false);
    }

    public Panel findPanel(PanelHolder panelHolder) {
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Panel) || !((Panel)componentArray[i]).getName().equals(panelHolder.getId())) continue;
            return (Panel)componentArray[i];
        }
        return null;
    }

    private void pageMousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isControlDown()) {
            return;
        }
        this.pane_.setBatch(true);
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Panel)) continue;
            Panel panel = (Panel)componentArray[i];
            panel.resetZoom(mouseEvent.getX(), mouseEvent.getY());
        }
        this.pane_.setBatch(false);
    }

    public void resetZoom() {
        this.pane_.setBatch(true);
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Panel)) continue;
            Panel panel = (Panel)componentArray[i];
            panel.resetZoom();
        }
        this.pane_.setBatch(false);
    }

    private void pageMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            System.out.println("Page.pageMouseClicked(): isPopupTrigger()");
        }
        Object object = this.pane_.getSelectedObject();
        if ((mouseEvent.getModifiers() & 4) != 0) {
            System.out.println("Page.pageMouseClicked(): Button3!");
        }
    }

    private void pageMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        Rectangle rectangle = this.pane_.getZoomBounds();
        Point point = this.pane_.getZoomStart();
        if (rectangle.width <= 1 || rectangle.height <= 1) {
            return;
        }
        this.pane_.setBatch(true);
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Panel)) continue;
            Panel panel = (Panel)componentArray[i];
            panel.zoomTo(point, rectangle);
        }
        this.pane_.setBatch(false);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = 1;
        Color color = this.getBackground();
        if (this.panelModel.isPrintWhitePage()) {
            this.setBackground(Color.white);
        }
        if ((n2 = this.pane_.print(graphics, pageFormat, n)) == 0 && this.panelModel.isPrintBorders()) {
            Component[] componentArray = this.pane_.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Panel)) continue;
                Panel panel = (Panel)componentArray[i];
                Rectangle rectangle = panel.getBounds();
                Border border = panel.getBorder();
                border.paintBorder(panel, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        this.setBackground(color);
        return n2;
    }

    public void setPrintScaleMode(int n) {
        this.pane_.setPageScaleMode(n);
    }

    public int getPrintScaleMode() {
        return this.pane_.getPageScaleMode();
    }

    public void setPrintVAlign(int n) {
        this.pane_.setPageVAlign(n);
    }

    public void setPrintHAlign(int n) {
        this.pane_.setPageHAlign(n);
    }

    public int getPrintVAlign() {
        return this.pane_.getPageVAlign();
    }

    public int getPrintHAlign() {
        return this.pane_.getPageHAlign();
    }

    public void setPrintOrigin(Point point) {
        this.pane_.setPageOrigin(point);
    }

    public Point getPrintOrigin() {
        return this.pane_.getPageOrigin();
    }

    class PageMouse
    extends MouseAdapter {
        PageMouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!Page.this.pane_.isMouseEventsEnabled()) {
                return;
            }
            Page.this.pageMousePressed(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!Page.this.pane_.isMouseEventsEnabled()) {
                return;
            }
            Page.this.pageMouseClicked(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!Page.this.pane_.isMouseEventsEnabled()) {
                return;
            }
            Page.this.pageMouseReleased(mouseEvent);
        }
    }
}

