/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.PropertyPanel;
import gov.noaa.pmel.sgt.swing.prop.ColorDialog;
import gov.noaa.pmel.sgt.swing.prop.FontDialog;
import gov.noaa.pmel.util.Point2D;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class LabelPropertyPanel
extends PropertyPanel
implements ActionListener,
ChangeListener,
FocusListener {
    private boolean expert_ = false;
    private Label label_;
    private static DecimalFormat format_ = new DecimalFormat("#.###");
    private String[] pNames_ = new String[]{"Color", "Font", "Height", "Id", "Justification", "Location", "Orientation", "Selectable", "Text", "Visible", "Width"};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private String[] justType = new String[]{"Left", "Center", "Right"};
    private String[] orientType = new String[]{"Horizontal", "Vertical"};

    public LabelPropertyPanel(Label label, boolean bl) {
        this.label_ = label;
        this.label_.addChangeListener(this);
        this.expert_ = bl;
        this.create();
    }

    public void setLabel(Label label, boolean bl) {
        if (this.label_ != null) {
            this.label_.removeChangeListener(this);
        }
        this.label_ = label;
        this.label_.addChangeListener(this);
        this.expert_ = bl;
        this.reset();
    }

    void update() {
        int n = -1;
        int n2 = -1;
        this.updateColor((JButton)this.comps_[++n2], this.label_.getColor());
        this.updateFont((JButton)this.comps_[++n2], this.label_.getFont());
        ((JTextField)this.comps_[++n2]).setText(this.format(this.label_.getHeightP(), format_));
        ((JTextField)this.comps_[++n2]).setText(this.label_.getId());
        switch (this.label_.getJustification()) {
            default: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
            }
        }
        ((JComboBox)this.comps_[++n2]).setSelectedIndex(n);
        ((JLabel)this.comps_[++n2]).setText(this.format(this.label_.getLocationP(), true));
        switch (this.label_.getOrientation()) {
            default: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
            }
        }
        ((JComboBox)this.comps_[++n2]).setSelectedIndex(n);
        ((JCheckBox)this.comps_[++n2]).setSelected(this.label_.isSelectable());
        ((JTextField)this.comps_[++n2]).setText(this.label_.getText());
        ((JCheckBox)this.comps_[++n2]).setSelected(this.label_.isVisible());
        ((JTextField)this.comps_[++n2]).setText(this.format(this.label_.getWidthP(), format_));
    }

    void create() {
        int n = -1;
        int n2 = -1;
        this.comps_[++n] = this.createColor(this.label_.getColor(), this.pNames_[n], this);
        this.comps_[++n] = this.createFont(this.label_.getFont(), this.pNames_[n], this);
        this.comps_[++n] = this.createTextField(this.format(this.label_.getHeightP(), format_), this.pNames_[n], this, true);
        String string = this.pNames_[++n];
        this.comps_[n] = this.createTextField(this.label_.getId(), string, this, !this.label_.isInstantiated());
        switch (this.label_.getJustification()) {
            default: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        this.comps_[++n] = this.createComboBox(this.justType, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createLabel(this.format(this.label_.getLocationP(), true));
        switch (this.label_.getOrientation()) {
            default: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
            }
        }
        this.comps_[++n] = this.createComboBox(this.orientType, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createCheckBox(this.label_.isSelectable(), this.pNames_[n], this);
        this.comps_[++n] = this.createTextField(this.label_.getText(), this.pNames_[n], this, true);
        this.comps_[++n] = this.createCheckBox(this.label_.isVisible(), this.pNames_[n], this);
        this.comps_[++n] = this.createTextField(this.format(this.label_.getWidthP(), format_), this.pNames_[n], this, true);
        for (n = 0; n < this.comps_.length; ++n) {
            this.addProperty(n + 1, this.pNames_[n], this.comps_[n], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    private void processEvent(Object object, String string) {
        if (string.equals("Id")) {
            String string2 = this.label_.getId();
            this.label_.getPanelHolder().getLabels().remove(string2);
            this.label_.setId(((JTextField)object).getText());
            this.label_.getPanelHolder().getLabels().put(this.label_.getId(), this.label_);
        } else if (string.equals("Justification")) {
            String string3 = (String)((JComboBox)object).getSelectedItem();
            int n = -1;
            if (string3.equals("Left")) {
                n = 0;
            } else if (string3.equals("Center")) {
                n = 1;
            } else if (string3.equals("Right")) {
                n = 2;
            }
            this.label_.setJustification(n);
        } else if (string.equals("Text")) {
            this.label_.setText(((JTextField)object).getText());
        } else if (string.equals("Location")) {
            this.label_.setLocationP(this.parsePoint2D(((JTextField)object).getText()));
        } else if (string.equals("Height")) {
            this.label_.setHeightP(Float.parseFloat(((JTextField)object).getText()));
        } else if (string.equals("Width")) {
            this.label_.setWidthP(Float.parseFloat(((JTextField)object).getText()));
        } else if (string.equals("Visible")) {
            this.label_.setVisible(((JCheckBox)object).isSelected());
        } else if (string.equals("Color")) {
            ColorDialog colorDialog = new ColorDialog(this.getFrame(), "Select Label Color", true);
            colorDialog.setColor(this.label_.getColor());
            colorDialog.setVisible(true);
            Color color = colorDialog.getColor();
            if (color != null) {
                this.label_.setColor(color);
            }
        } else if (string.equals("Font")) {
            FontDialog fontDialog = new FontDialog("Label Font");
            int n = fontDialog.showDialog(this.label_.getFont());
            if (n == FontDialog.OK_RESPONSE) {
                this.label_.setFont(fontDialog.getFont());
            }
        } else if (string.equals("Orientation")) {
            int n = this.label_.getOrientation();
            String string4 = (String)((JComboBox)object).getSelectedItem();
            int n2 = -1;
            if (string4.equals("Horizontal")) {
                n2 = 0;
            } else if (string4.equals("Vertical")) {
                n2 = 1;
            }
            this.label_.setOrientation(n2);
            if (n != n2) {
                double d;
                double d2;
                Point2D.Double double_ = this.label_.getLocationP();
                double d3 = this.label_.getWidthP();
                double d4 = this.label_.getHeightP();
                this.label_.setWidthP(this.label_.getHeightP());
                this.label_.setHeightP(d3);
                switch (this.label_.getJustification()) {
                    case 1: {
                        if (n2 == 1) {
                            d2 = double_.x + d3 * 0.5 - d4;
                            d = double_.y - d3 * 0.5;
                            break;
                        }
                        d2 = double_.x - d4 * 0.5 + d3;
                        d = double_.y + d4 * 0.5;
                        break;
                    }
                    default: {
                        if (n2 == 1) {
                            d2 = double_.x - d4;
                            d = double_.y;
                            break;
                        }
                        d2 = double_.x + d3;
                        d = double_.y;
                        break;
                    }
                    case 2: {
                        if (n2 == 1) {
                            d2 = double_.x + d3 - d4;
                            d = double_.y - d3;
                            break;
                        }
                        d2 = double_.x - d4 + d3;
                        d = double_.y + d4;
                    }
                }
                this.label_.setLocationP(new Point2D.Double(d2, d));
            }
        } else if (string.equals("Selectable")) {
            this.label_.setSelectable(((JCheckBox)object).isSelected());
        }
    }

    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        this.processEvent(object, string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.update();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            JTextField jTextField = (JTextField)object;
            String string = jTextField.getName();
            this.processEvent(object, string);
        }
    }

    public void setExpert(boolean bl) {
        this.expert_ = bl;
    }

    public boolean isExpert() {
        return this.expert_;
    }
}

