/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

abstract class DragBox
implements DesignListener {
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_RIGHT = 1;
    public static final int LOWER_LEFT = 2;
    public static final int LOWER_RIGHT = 3;
    public static final int CENTER = 4;
    protected static int handleSize_ = 8;
    protected Rectangle[] handles_ = new Rectangle[5];
    protected int selectedHandle_ = -1;
    protected boolean selected_ = false;
    protected Color selectedColor_ = Color.red;
    protected Color unSelectedColor_;
    protected Color color_ = this.unSelectedColor_ = Color.darkGray;
    protected PanelHolder pHolder_;

    public DragBox(PanelHolder panelHolder) {
        this.pHolder_ = panelHolder;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
        this.color_ = this.selected_ ? this.selectedColor_ : this.unSelectedColor_;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public boolean handlesContain(Point point) {
        for (int i = 0; i < this.handles_.length; ++i) {
            if (!this.handles_[i].contains(point)) continue;
            this.selectedHandle_ = i;
            return true;
        }
        this.selectedHandle_ = -1;
        return false;
    }

    protected void computeHandles() {
        Rectangle rectangle = this.getBounds();
        this.handles_[0].setBounds(rectangle.x, rectangle.y, handleSize_, handleSize_);
        this.handles_[1].setBounds(rectangle.x + rectangle.width - handleSize_, rectangle.y, handleSize_, handleSize_);
        this.handles_[2].setBounds(rectangle.x, rectangle.y + rectangle.height - handleSize_, handleSize_, handleSize_);
        this.handles_[3].setBounds(rectangle.x + rectangle.width - handleSize_, rectangle.y + rectangle.height - handleSize_, handleSize_, handleSize_);
        this.handles_[4].setBounds(rectangle.x + (rectangle.width - handleSize_) / 2, rectangle.y + (rectangle.height - handleSize_) / 2, handleSize_, handleSize_);
    }

    public void mouseOperation(int n, int n2, int n3) {
        if (n == -1) {
            return;
        }
        if (n == 4) {
            Point point = this.getLocation();
            point.x += n2;
            point.y += n3;
            this.setLocation(point);
        } else {
            Rectangle rectangle = this.getBounds();
            int n4 = rectangle.x + rectangle.width;
            int n5 = rectangle.y + rectangle.height;
            switch (n) {
                case 0: {
                    rectangle.x += n2;
                    rectangle.y += n3;
                    break;
                }
                case 1: {
                    n4 += n2;
                    rectangle.y += n3;
                    break;
                }
                case 2: {
                    rectangle.x += n2;
                    n5 += n3;
                    break;
                }
                case 3: {
                    n4 += n2;
                    n5 += n3;
                }
            }
            rectangle.width = n4 - rectangle.x;
            rectangle.height = n5 - rectangle.y;
            this.setBounds(rectangle);
        }
    }

    public boolean contains(Point point) {
        return this.getBounds().contains(point);
    }

    public int getSelectedHandle() {
        return this.selectedHandle_;
    }

    Point2D.Double toLocation(Point point) {
        return new Point2D.Double(this.toXLocation(point.x), this.toYLocation(point.y));
    }

    Point toLocation(Point2D.Double double_) {
        return new Point(this.toXLocation(double_.x), this.toYLocation(double_.y));
    }

    Rectangle2D.Double toRectangle(Rectangle rectangle) {
        return new Rectangle2D.Double(this.toXLocation(rectangle.x), this.toYLocation(rectangle.y + rectangle.height), this.transform(rectangle.width), this.transform(rectangle.height));
    }

    Rectangle toRectangle(Rectangle2D.Double double_) {
        int n = this.transform(double_.height);
        return new Rectangle(this.toXLocation(double_.x), this.toYLocation(double_.y) - n, this.transform(double_.width), n);
    }

    double toXLocation(int n) {
        return (float)(n - this.pHolder_.getBounds().x) / this.pHolder_.getPanelModel().getDpi();
    }

    double toYLocation(int n) {
        return (float)(this.pHolder_.getBounds().height - n + this.pHolder_.getBounds().y) / this.pHolder_.getPanelModel().getDpi();
    }

    int toXLocation(double d) {
        return (int)(d * (double)this.pHolder_.getPanelModel().getDpi() + 0.5) + this.pHolder_.getBounds().x;
    }

    int toYLocation(double d) {
        return this.pHolder_.getBounds().height - (int)(d * (double)this.pHolder_.getPanelModel().getDpi() + 0.5) + this.pHolder_.getBounds().y;
    }

    double transform(int n) {
        return (float)n / this.pHolder_.getPanelModel().getDpi();
    }

    int transform(double d) {
        return (int)(d * (double)this.pHolder_.getPanelModel().getDpi() + 0.5);
    }

    public abstract void draw(Graphics var1);

    public abstract void update(String var1);

    public abstract void setId(String var1);

    public abstract String getId();

    public abstract void setBounds(Rectangle var1);

    public abstract Rectangle getBounds();

    public abstract void setLocation(Point var1);

    public abstract Point getLocation();
}

