/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisNotFoundException;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLevelsAccess;
import gov.noaa.pmel.sgt.DataKey;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.LogAxis;
import gov.noaa.pmel.sgt.LogTransform;
import gov.noaa.pmel.sgt.PaneNotFoundException;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.Selectable;
import gov.noaa.pmel.sgt.SpaceAxis;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.TransformAccess;
import gov.noaa.pmel.sgt.beans.AxisHolder;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataTargetMismatchException;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.Margin;
import gov.noaa.pmel.sgt.beans.Panel;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTDomain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DataGroupLayer
extends Layer {
    private List dataLayers_ = new Vector();
    private DataGroup dg_ = null;
    private PanelHolder pHolder_ = null;
    private Panel panel_ = null;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private boolean clipping_ = false;
    private SoTDomain clipDomain_ = null;
    private SoTRange xZoomRange_ = null;
    private SoTRange yZoomRange_ = null;
    private boolean inZoom_ = false;
    private SGLabel xLabel_ = null;
    private SGLabel yLabel_ = null;

    public DataGroupLayer() {
        this((Panel)null, (DataGroup)null);
    }

    public DataGroupLayer(Panel panel, DataGroup dataGroup) {
        this.panel_ = panel;
        this.setPane(panel.getPane());
        this.pHolder_ = dataGroup.getPanelHolder();
        this.setGraph(new CartesianGraph("Graph"));
        this.dg_ = dataGroup;
        this.setId(this.dg_.getId());
        this.update();
    }

    public Panel getPanel() {
        return this.panel_;
    }

    public DataGroup getDataGroup() {
        return this.dg_;
    }

    public Iterator getLayerIterator() {
        return this.dataLayers_.iterator();
    }

    public List getLayerList() {
        return this.dataLayers_;
    }

    private String getNextLayerId() {
        int n = this.dataLayers_.size() + 1;
        return this.getId() + "_" + n;
    }

    public void addData(SGTData sGTData, Attribute attribute, DataKey dataKey) throws DataTargetMismatchException {
        Object object;
        Serializable serializable;
        Object object2 = (CartesianGraph)this.getGraph();
        if (((CartesianGraph)object2).getXTransform().isTime() != sGTData.isXTime() || ((CartesianGraph)object2).getYTransform().isTime() != sGTData.isYTime()) {
            JOptionPane.showMessageDialog(this, "Added data does not have the\nsame axis types as the DataGroup\n\nTime or Space axis does not match.", "DataGroup Error", 0);
            throw new DataTargetMismatchException("Data - Axis Mismatch");
        }
        CartesianRenderer cartesianRenderer = ((CartesianGraph)object2).getRenderer();
        if (cartesianRenderer == null) {
            this.xRange_ = sGTData.getXRange();
            this.yRange_ = sGTData.getYRange();
            ((CartesianGraph)object2).setData(sGTData, attribute);
            this.dataLayers_.add(this);
            serializable = new StringBuffer(sGTData.getXMetaData().getName());
            object = sGTData.getXMetaData().getUnits();
            if (object != null && ((String)object).length() > 0) {
                ((StringBuffer)serializable).append(" (").append((String)object).append(")");
            }
            this.xLabel_ = new SGLabel("X Axis Label", ((StringBuffer)serializable).toString(), new Point2D.Double(0.0, 0.0));
            serializable = new StringBuffer(sGTData.getYMetaData().getName());
            object = sGTData.getYMetaData().getUnits();
            if (object != null && ((String)object).length() > 0) {
                ((StringBuffer)serializable).append(" (").append((String)object).append(")");
            }
            this.yLabel_ = new SGLabel("Y Axis Label", ((StringBuffer)serializable).toString(), new Point2D.Double(0.0, 0.0));
        } else {
            this.xRange_.add(sGTData.getXRange());
            this.yRange_.add(sGTData.getYRange());
            serializable = new Layer(this.getNextLayerId());
            object = new CartesianGraph("Graph_" + ((Layer)serializable).getId(), ((CartesianGraph)object2).getXTransform(), ((CartesianGraph)object2).getYTransform());
            ((Layer)serializable).setPane(this.getPane());
            ((Layer)serializable).setSizeP(this.getSizeP());
            ((Layer)serializable).setBounds(this.getBounds());
            ((Layer)serializable).setGraph((Graph)object);
            ((CartesianGraph)object).setData(sGTData, attribute);
            this.dataLayers_.add(serializable);
            if (this.clipping_) {
                ((CartesianGraph)object).setClip(this.clipDomain_.getXRange(), this.clipDomain_.getYRange());
            }
            object2 = object;
        }
        if (this.dg_.isZAutoScale() && attribute != null && attribute instanceof GridAttribute) {
            serializable = ((SGTGrid)sGTData).getZRange();
            object = ((GridAttribute)attribute).getColorMap();
            if (object instanceof TransformAccess) {
                ((TransformAccess)object).setRange((Range2D)serializable);
            } else if (object instanceof ContourLevelsAccess) {
                ContourLevels contourLevels = ((ContourLevelsAccess)object).getContourLevels();
                int n = this.dg_.getNumberAutoContourLevels();
                Range2D range2D = Graph.computeRange((Range2D)serializable, n);
                ((ContourLevelsAccess)object).setContourLevels(ContourLevels.getDefault(range2D));
            }
        }
        if (dataKey != null) {
            cartesianRenderer = ((CartesianGraph)object2).getRenderer();
            serializable = this.getLabel(sGTData, dataKey);
            dataKey.addGraph(cartesianRenderer, (SGLabel)serializable);
        }
        this.update();
    }

    private SGLabel getLabel(SGTData sGTData, DataKey dataKey) {
        SGLabel sGLabel = sGTData.getKeyTitle();
        if (sGLabel == null) {
            sGLabel = this.xLabel_;
        }
        Legend legend = this.pHolder_.findLegend(dataKey.getId());
        sGLabel.setHeightP(legend.getKeyLabelHeightP());
        return sGLabel;
    }

    public void update() {
        SoTRange soTRange;
        SoTValue soTValue;
        Rectangle rectangle = this.pHolder_.getBounds();
        double d = this.pHolder_.getPanelModel().getDpi();
        double d2 = (double)rectangle.width / d;
        double d3 = (double)rectangle.height / d;
        SoTRange soTRange2 = null;
        SoTRange soTRange3 = null;
        SoTPoint soTPoint = null;
        SoTPoint soTPoint2 = null;
        boolean bl = this.getPane().isBatch();
        this.getPane().setBatch(true);
        AxisHolder axisHolder = this.dg_.getXAxisHolder();
        AxisHolder axisHolder2 = this.dg_.getYAxisHolder();
        CartesianGraph cartesianGraph = (CartesianGraph)this.getGraph();
        this.setSizeP(new Dimension2D(d2, d3));
        if (this.inZoom_) {
            soTRange2 = this.xZoomRange_;
            soTRange3 = this.yZoomRange_;
        } else {
            soTRange2 = !axisHolder.isAutoRange() || this.xRange_ == null ? axisHolder.getUserRange() : this.xRange_;
            soTRange3 = !axisHolder2.isAutoRange() || this.yRange_ == null ? axisHolder2.getUserRange() : this.yRange_;
        }
        this.updateTransform(0, soTRange2);
        this.updateTransform(1, soTRange3);
        Margin margin = this.dg_.getMargin();
        if (axisHolder.getAxisPosition() == 4) {
            soTPoint = new SoTPoint(cartesianGraph.getXPtoSoT(axisHolder.getAxisOriginP().x), cartesianGraph.getYPtoSoT(axisHolder.getAxisOriginP().y));
        } else {
            soTValue = null;
            soTRange = null;
            soTRange = axisHolder2.getAxisPosition() == 4 ? (cartesianGraph.getYTransform().isTime() ? new SoTRange.Time(cartesianGraph.getYPtoLongTime(margin.bottom), cartesianGraph.getYPtoLongTime(margin.top)) : new SoTRange.Double(cartesianGraph.getYPtoU(margin.bottom), cartesianGraph.getYPtoU(margin.top))) : soTRange3;
            switch (axisHolder.getAxisPosition()) {
                case 1: {
                    soTValue = soTRange.getStart();
                    break;
                }
                case 0: {
                    soTValue = soTRange.getEnd();
                }
            }
            soTPoint = new SoTPoint(soTRange2.getStart(), soTValue);
        }
        if (axisHolder2.getAxisPosition() == 4) {
            soTPoint2 = new SoTPoint(cartesianGraph.getXPtoSoT(axisHolder2.getAxisOriginP().x), cartesianGraph.getYPtoSoT(axisHolder2.getAxisOriginP().y));
        } else {
            soTValue = null;
            soTRange = null;
            soTRange = axisHolder.getAxisPosition() == 4 ? (cartesianGraph.getXTransform().isTime() ? new SoTRange.Time(cartesianGraph.getXPtoLongTime(margin.left), cartesianGraph.getXPtoLongTime(margin.right)) : new SoTRange.Double(cartesianGraph.getXPtoU(margin.left), cartesianGraph.getXPtoU(margin.right))) : soTRange2;
            switch (axisHolder2.getAxisPosition()) {
                case 2: {
                    soTValue = soTRange.getStart();
                    break;
                }
                case 3: {
                    soTValue = soTRange.getEnd();
                }
            }
            soTPoint2 = new SoTPoint(soTValue, soTRange3.getStart());
        }
        this.updateAxis(0, soTRange2, soTPoint, this.xLabel_);
        this.updateAxis(1, soTRange3, soTPoint2, this.yLabel_);
        this.getPane().setBatch(bl);
    }

    private void updateTransform(int n, SoTRange soTRange) {
        AxisTransform axisTransform;
        AxisHolder axisHolder;
        CartesianGraph cartesianGraph = (CartesianGraph)this.getGraph();
        if (n == 0) {
            axisHolder = this.dg_.getXAxisHolder();
            axisTransform = cartesianGraph.getXTransform();
        } else {
            axisHolder = this.dg_.getYAxisHolder();
            axisTransform = cartesianGraph.getYTransform();
        }
        switch (axisHolder.getTransformType()) {
            case 0: {
                if (axisTransform instanceof LinearTransform) {
                    axisTransform.setRangeU(soTRange);
                    axisTransform.setRangeP(axisHolder.getRangeP());
                    break;
                }
                axisTransform = new LinearTransform(axisHolder.getRangeP(), soTRange);
                cartesianGraph.setXTransform(axisTransform);
                break;
            }
            case 1: {
                if (axisTransform instanceof LogTransform) {
                    axisTransform.setRangeU(soTRange);
                    axisTransform.setRangeP(axisHolder.getRangeP());
                    break;
                }
                axisTransform = new LogTransform(axisHolder.getRangeP(), soTRange);
                cartesianGraph.setXTransform(axisTransform);
                break;
            }
            case 2: {
                axisTransform = this.getReferenceTransform(0, axisHolder.getTransformGroup());
                cartesianGraph.setXTransform(axisTransform);
            }
        }
    }

    private void updateAxis(int n, SoTRange soTRange, SoTPoint soTPoint, SGLabel sGLabel) {
        Selectable selectable;
        AxisTransform axisTransform;
        AxisHolder axisHolder;
        String string;
        Axis axis = null;
        boolean bl = true;
        CartesianGraph cartesianGraph = (CartesianGraph)this.getGraph();
        if (n == 0) {
            string = "X Axis";
            axisHolder = this.dg_.getXAxisHolder();
            axisTransform = cartesianGraph.getXTransform();
        } else {
            string = "Y Axis";
            axisHolder = this.dg_.getYAxisHolder();
            axisTransform = cartesianGraph.getYTransform();
        }
        try {
            axis = cartesianGraph.getXAxis(string);
        }
        catch (AxisNotFoundException axisNotFoundException) {
            axis = null;
        }
        bl = false;
        switch (axisHolder.getAxisType()) {
            case 4: {
                selectable = null;
                if (axis != null) {
                    if (axis instanceof PlainAxis) {
                        selectable = (PlainAxis)axis;
                    } else {
                        selectable = new PlainAxis(string);
                        bl = true;
                    }
                } else {
                    selectable = new PlainAxis(string);
                    bl = true;
                }
                axis = selectable;
                ((Axis)selectable).setRangeP(axisHolder.getRangeP());
                ((SpaceAxis)selectable).setRangeU(soTRange);
                ((SpaceAxis)selectable).setLabelFormat(axisHolder.getLabelFormat());
                ((SpaceAxis)selectable).setLabelInterval(axisHolder.getLabelInterval());
                ((SpaceAxis)selectable).setSignificantDigits(axisHolder.getLabelSignificantDigits());
                break;
            }
            case 3: {
                TimeAxis timeAxis = null;
                if (axis != null) {
                    if (axis instanceof TimeAxis) {
                        timeAxis = (TimeAxis)axis;
                    } else {
                        timeAxis = new TimeAxis(string, axisHolder.getTimeAxisStyle());
                        bl = true;
                    }
                } else {
                    timeAxis = new TimeAxis(string, axisHolder.getTimeAxisStyle());
                    bl = true;
                }
                axis = timeAxis;
                timeAxis.setRangeP(axisHolder.getRangeP());
                timeAxis.setRangeU(soTRange);
                if (axisHolder.getTimeAxisStyle() == 0) break;
                timeAxis.setLabelFormat(axisHolder.getMinorFormat(), axisHolder.getMajorFormat());
                timeAxis.setLabelInterval(axisHolder.getMinorInterval(), axisHolder.getMajorInterval());
                break;
            }
            case 1: {
                LogAxis logAxis = null;
                if (axis != null) {
                    if (axis instanceof LogAxis) {
                        logAxis = (LogAxis)axis;
                    } else {
                        logAxis = new LogAxis(string);
                        bl = true;
                    }
                } else {
                    logAxis = new LogAxis(string);
                    bl = true;
                }
                axis = logAxis;
                logAxis.setRangeP(axisHolder.getRangeP());
                logAxis.setRangeU(soTRange);
                logAxis.setLabelFormat(axisHolder.getLabelFormat());
                logAxis.setLabelInterval(axisHolder.getLabelInterval());
                logAxis.setSignificantDigits(axisHolder.getLabelSignificantDigits());
            }
        }
        if (n == 0) {
            axis.setOrientation(0);
        } else {
            axis.setOrientation(1);
        }
        axis.setLocationU(soTPoint);
        axis.setLineColor(axisHolder.getAxisColor());
        axis.setTicPosition(axisHolder.getTicPosition());
        axis.setLabelColor(axisHolder.getLabelColor());
        axis.setLabelFont(axisHolder.getLabelFont());
        axis.setLabelHeightP(axisHolder.getLabelHeightP());
        axis.setLargeTicHeightP(axisHolder.getLargeTicHeightP());
        axis.setNumberSmallTics(axisHolder.getNumSmallTics());
        axis.setSmallTicHeightP(axisHolder.getSmallTicHeightP());
        axis.setThickTicWidthP(axisHolder.getThickTicWidth());
        axis.setLabelPosition(axisHolder.getLabelPosition());
        axis.setVisible(axisHolder.isVisible());
        if (sGLabel != null && axisHolder.isTitleAuto()) {
            selectable = axisHolder.getTitle();
            sGLabel.setColor(((SGLabel)selectable).getColor());
            sGLabel.setFont(((SGLabel)selectable).getFont());
            sGLabel.setHeightP(((SGLabel)selectable).getHeightP());
            sGLabel.setVisible(((SGLabel)selectable).isVisible());
            axis.setTitle(sGLabel);
        } else {
            axis.setTitle(axisHolder.getTitle());
        }
        axis.register(axisTransform);
        if (n == 0) {
            if (cartesianGraph.getNumberXAxis() > 0 && bl) {
                cartesianGraph.removeAllXAxes();
            }
            if (bl) {
                cartesianGraph.addXAxis(axis);
            }
        } else {
            if (cartesianGraph.getNumberYAxis() > 0 && bl) {
                cartesianGraph.removeAllYAxes();
            }
            if (bl) {
                cartesianGraph.addYAxis(axis);
            }
        }
    }

    public void draw(Graphics graphics) throws PaneNotFoundException {
        super.draw(graphics);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).draw(graphics);
        }
    }

    public void drawDraggableItems(Graphics graphics) throws PaneNotFoundException {
        super.drawDraggableItems(graphics);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).drawDraggableItems(graphics);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setBounds(n, n2, n3, n4);
        }
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setBounds(rectangle);
        }
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setLocation(n, n2);
        }
    }

    public void setLocation(Point point) {
        super.setLocation(point);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setLocation(point);
        }
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setSize(dimension);
        }
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setSize(n, n2);
        }
    }

    public void setSizeP(Dimension2D dimension2D) {
        super.setSizeP(dimension2D);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            ((Layer)this.dataLayers_.get(i)).setSizeP(dimension2D);
        }
    }

    private AxisTransform getReferenceTransform(int n, String string) {
        String string2 = string;
        boolean bl = true;
        int n2 = -1;
        String string3 = null;
        while (bl) {
            DataGroup dataGroup = this.pHolder_.findDataGroup(string2);
            n2 = n == 0 ? dataGroup.getXAxisHolder().getTransformType() : dataGroup.getYAxisHolder().getTransformType();
            if (n2 != 2) {
                CartesianGraph cartesianGraph = null;
                DataGroupLayer dataGroupLayer = null;
                if (n == 0) {
                    dataGroupLayer = this.panel_.findDataGroupLayer(dataGroup.getXAxisHolder().getTransformGroup());
                    cartesianGraph = (CartesianGraph)dataGroupLayer.getGraph();
                    if (cartesianGraph == null) {
                        return null;
                    }
                    return cartesianGraph.getXTransform();
                }
                dataGroupLayer = this.panel_.findDataGroupLayer(dataGroup.getYAxisHolder().getTransformGroup());
                cartesianGraph = (CartesianGraph)dataGroupLayer.getGraph();
                if (cartesianGraph == null) {
                    return null;
                }
                return cartesianGraph.getYTransform();
            }
            string3 = n == 0 ? dataGroup.getXAxisHolder().getTransformGroup() : dataGroup.getYAxisHolder().getTransformGroup();
            string2 = string3;
        }
        return null;
    }

    public void setClipping(boolean bl) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        this.clipping_ = bl;
        this.setAllClipping(this.clipping_);
    }

    void zoomTo(Point point, Rectangle rectangle) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        CartesianGraph cartesianGraph = (CartesianGraph)this.getGraph();
        Rectangle rectangle2 = this.getGraphBounds();
        Rectangle rectangle3 = this.getPanelBounds();
        if (!rectangle2.contains(point)) {
            return;
        }
        this.setClipping(true);
        double d = this.getXDtoP(rectangle.x);
        double d2 = this.getYDtoP(rectangle.y + rectangle.height);
        double d3 = this.getXDtoP(rectangle.x + rectangle.width);
        double d4 = this.getYDtoP(rectangle.y);
        SoTRange soTRange = null;
        SoTRange soTRange2 = null;
        soTRange = cartesianGraph.getXTransform().isTime() ? new SoTRange.Time(cartesianGraph.getXPtoLongTime(d), cartesianGraph.getXPtoLongTime(d3)) : new SoTRange.Double(cartesianGraph.getXPtoU(d), cartesianGraph.getXPtoU(d3));
        soTRange2 = cartesianGraph.getYTransform().isTime() ? new SoTRange.Time(cartesianGraph.getYPtoLongTime(d2), cartesianGraph.getYPtoLongTime(d4)) : new SoTRange.Double(cartesianGraph.getYPtoU(d2), cartesianGraph.getYPtoU(d4));
        this.inZoom_ = true;
        this.setDomain(new SoTDomain(soTRange, soTRange2));
    }

    void resetZoom(int n, int n2) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        Rectangle rectangle = this.getGraphBounds();
        if (!rectangle.contains(n, n2)) {
            return;
        }
        this.inZoom_ = false;
        this.xZoomRange_ = null;
        this.yZoomRange_ = null;
        this.setClipping(false);
        this.update();
    }

    public void resetZoom() {
        this.inZoom_ = false;
        this.xZoomRange_ = null;
        this.yZoomRange_ = null;
        this.setClipping(false);
        this.update();
    }

    public void setDomain(SoTDomain soTDomain) {
        this.setXRange(soTDomain.getXRange(), soTDomain.isXReversed());
        this.setYRange(soTDomain.getYRange(), soTDomain.isYReversed());
        if (this.clipping_) {
            this.clipDomain_ = soTDomain;
            this.setAllClip(soTDomain);
        } else {
            this.clipDomain_ = null;
            this.setAllClipping(false);
        }
        this.update();
    }

    private void setXRange(SoTRange soTRange, boolean bl) {
        this.xZoomRange_ = soTRange.copy();
    }

    private void setYRange(SoTRange soTRange, boolean bl) {
        this.yZoomRange_ = soTRange.copy();
    }

    private void setAllClip(SoTDomain soTDomain) {
        Iterator iterator = this.dataLayers_.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Layer)) continue;
            Layer layer = (Layer)e;
            ((CartesianGraph)layer.getGraph()).setClip(soTDomain.getXRange(), soTDomain.getYRange());
        }
    }

    private void setAllClipping(boolean bl) {
        Iterator iterator = this.dataLayers_.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Layer)) continue;
            Layer layer = (Layer)e;
            ((CartesianGraph)layer.getGraph()).setClipping(bl);
        }
    }

    private Rectangle getPanelBounds() {
        return this.pHolder_.getBounds();
    }

    private Rectangle getGraphBounds() {
        CartesianGraph cartesianGraph = (CartesianGraph)this.getGraph();
        AxisTransform axisTransform = cartesianGraph.getXTransform();
        AxisTransform axisTransform2 = cartesianGraph.getYTransform();
        Range2D range2D = axisTransform.getRangeP();
        Range2D range2D2 = axisTransform2.getRangeP();
        int n = this.getXPtoD(range2D.start);
        int n2 = this.getYPtoD(range2D2.end);
        int n3 = this.getXPtoD(range2D.end) - n;
        int n4 = this.getYPtoD(range2D2.start) - n2;
        return new Rectangle(n, n2, n3, n4);
    }
}

