/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.AxisHolderDragBox;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DragBox;
import gov.noaa.pmel.sgt.beans.Margin;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DataGroupDragBox
extends DragBox
implements ChangeListener {
    private Rectangle boundsD_ = new Rectangle();
    private DataGroup dg_ = null;
    private AxisHolderDragBox xAxDB_ = null;
    private AxisHolderDragBox yAxDB_ = null;

    public DataGroupDragBox(DataGroup dataGroup, PanelHolder panelHolder) {
        super(panelHolder);
        this.dg_ = dataGroup;
        this.dg_.addChangeListener(this);
        for (int i = 0; i < this.handles_.length; ++i) {
            this.handles_[i] = new Rectangle(0, 0, 0, 0);
        }
        this.update("DataGroupDragBox.new()");
    }

    public DataGroup getDataGroup() {
        return this.dg_;
    }

    public void setBounds(Rectangle rectangle) {
        this.boundsD_ = rectangle;
        this.dg_.setMargin(this.computeMargin());
        this.computeHandles();
    }

    private Margin computeMargin() {
        Rectangle rectangle = this.pHolder_.getBounds();
        float f = this.pHolder_.getPanelModel().getDpi();
        float f2 = (float)(this.boundsD_.y - rectangle.y) / f;
        float f3 = (float)(rectangle.y + rectangle.height - (this.boundsD_.y + this.boundsD_.height)) / f;
        float f4 = (float)(this.boundsD_.x - rectangle.x) / f;
        float f5 = (float)(rectangle.x + rectangle.width - (this.boundsD_.x + this.boundsD_.width)) / f;
        return new Margin(f2, f4, f3, f5);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Color color = graphics.getColor();
        if (this.selected_) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.green);
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        float[] fArray = new float[]{4.0f, 4.0f};
        BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0, 10.0f, fArray, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(float_);
        graphics2D.setStroke(stroke);
        if (this.selected_) {
            for (int i = 0; i < this.handles_.length; ++i) {
                Rectangle rectangle2 = this.handles_[i];
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            }
        }
        graphics.setColor(color);
    }

    public void update(String string) {
        Rectangle rectangle = this.pHolder_.getBounds();
        Margin margin = this.dg_.getMargin();
        float f = this.pHolder_.getPanelModel().getDpi();
        int n = (int)(margin.left * f);
        int n2 = (int)(margin.right * f);
        int n3 = (int)(margin.top * f);
        int n4 = (int)(margin.bottom * f);
        this.boundsD_.x = rectangle.x + n;
        this.boundsD_.y = rectangle.y + n3;
        this.boundsD_.width = rectangle.width - (n + n2);
        this.boundsD_.height = rectangle.height - (n3 + n4);
        this.computeHandles();
    }

    public void setLocation(Point point) {
        this.boundsD_.x = point.x;
        this.boundsD_.y = point.y;
        this.dg_.setMargin(this.computeMargin());
        this.computeHandles();
    }

    public Point getLocation() {
        return new Point(this.boundsD_.x, this.boundsD_.y);
    }

    public Rectangle getBounds() {
        return this.boundsD_;
    }

    public String getId() {
        return this.dg_.getId();
    }

    public void setId(String string) {
        this.dg_.setId(string);
    }

    public void setAxisHolderDB(AxisHolderDragBox axisHolderDragBox, AxisHolderDragBox axisHolderDragBox2) {
        this.xAxDB_ = axisHolderDragBox;
        this.yAxDB_ = axisHolderDragBox2;
    }

    public AxisHolderDragBox getXAxisHolderDB() {
        return this.xAxDB_;
    }

    public AxisHolderDragBox getYAxisHolderDB() {
        return this.yAxDB_;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.update("DataGroupDragBox.stateChanged()");
    }
}

