/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.AxisHolder;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PropertyPanel;
import gov.noaa.pmel.sgt.swing.prop.ColorDialog;
import gov.noaa.pmel.sgt.swing.prop.FontDialog;
import gov.noaa.pmel.sgt.swing.prop.SGLabelDialog;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.SoTRange;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AxisHolderPropertyPanel
extends PropertyPanel
implements ActionListener,
FocusListener,
ChangeListener {
    private boolean expert_ = false;
    private String[] pNames_ = new String[]{"AutoScale", "AxisColor", "Axis Position", "Axis Location", "AxisType", "Bounds", "Label Color", "Label Font", "Label Format", "Label Height", "Label Interval", "Label Position", "Label SignificantDigits", "Large TicHeight", "Location At Origin", "Major Format", "Major Interval", "Minor Format", "Minor Interval", "Num Small Tics", "OriginP", "Selectable", "Small TicHeight", "Tic Position", "Time AxisStyle", "Title Auto", "Title", "Transform Type", "User Range", "Visible"};
    private boolean[] expertItem = new boolean[]{false, true, false, true, false, true, true, false, true, false, false, true, false, true, true, true, true, true, true, false, true, true, true, true, false, false, false, false, false, false};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private AxisHolder axHolder_;
    private PanelHolder pHolder_;
    private boolean suppressEvent_ = false;
    private int autoScale;
    private int userRange;
    private int titleAuto;
    private int title;
    private String format_ = "yyyy-MM-dd hh:mm";
    private String[] xAxisPosition = new String[]{"Bottom", "Top", "Manual"};
    private String[] yAxisPosition = new String[]{"Left", "Right", "Manual"};

    public AxisHolderPropertyPanel(AxisHolder axisHolder, boolean bl) {
        this.axHolder_ = axisHolder;
        this.axHolder_.addChangeListener(this);
        this.expert_ = bl;
        this.pHolder_ = this.axHolder_.getDataGroup().getPanelHolder();
        this.create();
    }

    public void setAxisHolder(AxisHolder axisHolder, boolean bl) {
        if (this.axHolder_ != null) {
            this.axHolder_.removeChangeListener(this);
        }
        this.axHolder_ = axisHolder;
        this.axHolder_.addChangeListener(this);
        this.expert_ = bl;
        this.reset();
    }

    void update() {
        int n = -1;
        this.suppressEvent_ = true;
        int n2 = -1;
        ((JCheckBox)this.comps_[++n]).setSelected(this.axHolder_.isAutoRange());
        this.updateColor((JButton)this.comps_[++n], this.axHolder_.getAxisColor());
        switch (this.axHolder_.getAxisPosition()) {
            default: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
            }
        }
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        ((JLabel)this.comps_[++n]).setText(this.format(this.axHolder_.getAxisOriginP(), true));
        switch (this.axHolder_.getAxisType()) {
            default: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
            }
        }
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        ((JLabel)this.comps_[++n]).setText(this.format((Rectangle2D.Double)this.axHolder_.getBoundsP(), true));
        this.updateColor((JButton)this.comps_[++n], this.axHolder_.getLabelColor());
        this.updateFont((JButton)this.comps_[++n], this.axHolder_.getLabelFont());
        ((JTextField)this.comps_[++n]).setText(this.axHolder_.getLabelFormat());
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getLabelHeightP()));
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getLabelInterval()));
        if (this.axHolder_.isLabelPositionAuto()) {
            n2 = 0;
        } else {
            switch (this.axHolder_.getLabelPosition()) {
                default: {
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 0: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                }
            }
        }
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getLabelSignificantDigits()));
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getLargeTicHeightP()));
        ((JCheckBox)this.comps_[++n]).setSelected(this.axHolder_.isLocationAtOrigin());
        ((JTextField)this.comps_[++n]).setText(this.axHolder_.getMajorFormat());
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getMajorInterval()));
        ((JTextField)this.comps_[++n]).setText(this.axHolder_.getMajorFormat());
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getMinorInterval()));
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getNumSmallTics()));
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getAxisOriginP(), true));
        ((JCheckBox)this.comps_[++n]).setSelected(this.axHolder_.isSelectable());
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getSmallTicHeightP()));
        if (this.axHolder_.isTicPositionAuto()) {
            n2 = 0;
        } else {
            switch (this.axHolder_.getTicPosition()) {
                default: {
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 0: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                }
            }
        }
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        switch (this.axHolder_.getTimeAxisStyle()) {
            default: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 5;
            }
        }
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        ((JCheckBox)this.comps_[++n]).setSelected(this.axHolder_.isTitleAuto());
        this.updateSGLabel((JButton)this.comps_[++n], this.axHolder_.getTitle());
        Vector<String> vector = new Vector<String>(5);
        vector.add("LinearTransform");
        vector.add("LogTransform");
        this.addOtherDataGroupTransforms(vector);
        n2 = this.findTransformItem(vector, this.axHolder_.getTransformType(), this.axHolder_.getTransformGroup());
        ((JComboBox)this.comps_[++n]).setSelectedIndex(n2);
        ((JTextField)this.comps_[++n]).setText(this.format(this.axHolder_.getUserRange(), false));
        ((JCheckBox)this.comps_[++n]).setSelected(this.axHolder_.isVisible());
        this.suppressEvent_ = false;
    }

    void create() {
        int n = -1;
        int n2 = -1;
        this.comps_[++n] = this.createCheckBox(this.axHolder_.isAutoRange(), this.pNames_[n], this);
        this.autoScale = n++;
        this.comps_[n] = this.createColor(this.axHolder_.getAxisColor(), this.pNames_[n], this);
        Object[] objectArray = this.axHolder_.getAxisOrientation() == 0 ? this.xAxisPosition : this.yAxisPosition;
        switch (this.axHolder_.getAxisPosition()) {
            default: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
            }
        }
        this.comps_[++n] = this.createComboBox(objectArray, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createLabel(this.format(this.axHolder_.getAxisOriginP(), true));
        Object[] objectArray2 = new String[]{"PlainAxis", "TimeAxis", "LogAxis"};
        switch (this.axHolder_.getAxisType()) {
            default: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
            }
        }
        this.comps_[++n] = this.createComboBox(objectArray2, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createLabel(this.format((Rectangle2D.Double)this.axHolder_.getBoundsP(), true));
        this.comps_[++n] = this.createColor(this.axHolder_.getLabelColor(), this.pNames_[n], this);
        this.comps_[++n] = this.createFont(this.axHolder_.getLabelFont(), this.pNames_[n], this);
        this.comps_[++n] = this.createTextField(this.axHolder_.getLabelFormat(), this.pNames_[n], this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getLabelHeightP()), this.pNames_[n], this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getLabelInterval()), this.pNames_[n], this, true);
        Object[] objectArray3 = new String[]{"Auto", "Negative Side", "Positive Side", "No Label"};
        if (this.axHolder_.isLabelPositionAuto()) {
            n2 = 0;
        } else {
            switch (this.axHolder_.getLabelPosition()) {
                default: {
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 0: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                }
            }
        }
        this.comps_[++n] = this.createComboBox(objectArray3, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getLabelSignificantDigits()), this.pNames_[n], this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getLargeTicHeightP()), this.pNames_[n], this, true);
        this.comps_[++n] = this.createCheckBox(this.axHolder_.isLocationAtOrigin(), this.pNames_[n], this);
        this.comps_[++n] = this.createTextField(this.axHolder_.getMajorFormat(), this.pNames_[n], this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getMajorInterval()), this.pNames_[n], this, true);
        this.comps_[++n] = this.createTextField(this.axHolder_.getMinorFormat(), this.pNames_[n], this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getMinorInterval()), this.pNames_[n], this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getNumSmallTics()), this.pNames_[n], this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getAxisOriginP(), true), this.pNames_[n], this, true);
        this.comps_[++n] = this.createCheckBox(this.axHolder_.isSelectable(), this.pNames_[n], this);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getSmallTicHeightP()), this.pNames_[n], this, true);
        Object[] objectArray4 = new String[]{"Auto", "Negative Side", "Positive Side", "Both Sides"};
        if (this.axHolder_.isTicPositionAuto()) {
            n2 = 0;
        } else {
            switch (this.axHolder_.getTicPosition()) {
                default: {
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 0: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                }
            }
        }
        this.comps_[++n] = this.createComboBox(objectArray4, n2, this.pNames_[n], (ActionListener)this, true);
        Object[] objectArray5 = new String[]{"Auto", "Day-Month", "Hour-Day", "Minute-Hour", "Month-Year", "Year-Decade"};
        switch (this.axHolder_.getTimeAxisStyle()) {
            default: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 5;
            }
        }
        this.comps_[++n] = this.createComboBox(objectArray5, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createCheckBox(this.axHolder_.isTitleAuto(), this.pNames_[n], this);
        this.titleAuto = n++;
        this.comps_[n] = this.createSGLabel(this.axHolder_.getTitle(), this.pNames_[n], this);
        this.title = n++;
        Vector<String> vector = new Vector<String>(5);
        vector.add("LinearTransform");
        vector.add("LogTransform");
        this.addOtherDataGroupTransforms(vector);
        n2 = this.findTransformItem(vector, this.axHolder_.getTransformType(), this.axHolder_.getTransformGroup());
        this.comps_[n] = this.createComboBox(vector, n2, this.pNames_[n], (ActionListener)this, true);
        this.comps_[++n] = this.createTextField(this.format(this.axHolder_.getUserRange(), false), this.pNames_[n], this, true);
        this.userRange = n++;
        this.comps_[n] = this.createCheckBox(this.axHolder_.isVisible(), this.pNames_[n], this);
        this.setFieldsEnabled();
        int n3 = 0;
        for (n = 0; n < this.comps_.length; ++n) {
            if (!this.expert_ && this.expertItem[n]) continue;
            this.addProperty(++n3, this.pNames_[n], this.comps_[n], false);
        }
        this.addProperty(n3 + 1, " ", new JLabel(" "), true);
    }

    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.suppressEvent_) {
            return;
        }
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        this.processEvent(object, string);
        this.setFieldsEnabled();
    }

    private void setFieldsEnabled() {
        ((JTextField)this.comps_[this.userRange]).setEnabled(!((JCheckBox)this.comps_[this.autoScale]).isSelected());
    }

    private void processEvent(Object object, String string) {
        int n = -1;
        String string2 = null;
        SoTRange soTRange = null;
        if (string.equals("AutoScale")) {
            this.axHolder_.setAutoRange(((JCheckBox)object).isSelected());
        } else if (string.equals("AxisColor")) {
            ColorDialog colorDialog = new ColorDialog(this.getFrame(), "Select Axis Color", true);
            colorDialog.setColor(this.axHolder_.getAxisColor());
            colorDialog.setVisible(true);
            Color color = colorDialog.getColor();
            if (color != null) {
                this.axHolder_.setAxisColor(color);
            }
        } else if (string.equals("Axis Position")) {
            string2 = (String)((JComboBox)object).getSelectedItem();
            n = -1;
            if (string2.equals("Bottom")) {
                n = 1;
            } else if (string2.equals("Top")) {
                n = 0;
            } else if (string2.equals("Left")) {
                n = 2;
            } else if (string2.equals("Right")) {
                n = 3;
            } else if (string2.equals("Manual")) {
                n = 4;
            }
            this.axHolder_.setAxisPosition(n);
        } else if (!string.equals("Axis Location")) {
            if (string.equals("AxisType")) {
                string2 = (String)((JComboBox)object).getSelectedItem();
                this.axHolder_.setAxisType(this.axis(string2));
                if (string2.equals("PlainAxis") || string2.equals("TimeAxis")) {
                    this.axHolder_.setTransformType(0);
                } else if (string2.equals("LogAxis")) {
                    this.axHolder_.setTransformType(1);
                }
                if (string2.equals("TimeAxis") && !this.axHolder_.getUserRange().isTime()) {
                    try {
                        soTRange = new SoTRange.Time(new GeoDate("2000-01-01 00:00", this.format_), new GeoDate("2001-01-01 00:00", this.format_), new GeoDate(172800000L));
                    }
                    catch (IllegalTimeValue illegalTimeValue) {
                        illegalTimeValue.printStackTrace();
                    }
                    this.axHolder_.setUserRange(soTRange);
                }
            } else if (string.equals("Bounds")) {
                Rectangle2D rectangle2D = this.parseBounds(((JTextField)object).getText());
                if (rectangle2D != null) {
                    this.axHolder_.setBoundsP(rectangle2D);
                }
            } else if (string.equals("Label Color")) {
                ColorDialog colorDialog = new ColorDialog(this.getFrame(), "Select Label Color", true);
                colorDialog.setColor(this.axHolder_.getAxisColor());
                colorDialog.setVisible(true);
                Color color = colorDialog.getColor();
                if (color != null) {
                    this.axHolder_.setLabelColor(color);
                }
            } else if (string.equals("Label Font")) {
                FontDialog fontDialog = new FontDialog("Label Font");
                int n2 = fontDialog.showDialog(this.axHolder_.getLabelFont());
                if (n2 == FontDialog.OK_RESPONSE) {
                    this.axHolder_.setLabelFont(fontDialog.getFont());
                }
            } else if (string.equals("Label Format")) {
                this.axHolder_.setLabelFormat(((JTextField)object).getText());
            } else if (string.equals("Label Height")) {
                this.axHolder_.setLabelHeightP(Double.parseDouble(((JTextField)object).getText()));
            } else if (string.equals("Label Interval")) {
                this.axHolder_.setLabelInterval(Integer.parseInt(((JTextField)object).getText()));
            } else if (string.equals("Label Position")) {
                string2 = (String)((JComboBox)object).getSelectedItem();
                n = -1;
                if (string2.equals("Auto")) {
                    n = 3;
                } else if (string2.equals("Negative Side")) {
                    n = 1;
                } else if (string2.equals("Positive Side")) {
                    n = 0;
                } else if (string2.equals("No Label")) {
                    n = 2;
                }
                this.axHolder_.setLabelPosition(n);
            } else if (string.equals("Label SignificantDigits")) {
                this.axHolder_.setLabelSignificantDigits(Integer.parseInt(((JTextField)object).getText()));
            } else if (string.equals("Large TicHeight")) {
                this.axHolder_.setLargeTicHeightP(Double.parseDouble(((JTextField)object).getText()));
            } else if (string.equals("Location At Origin")) {
                this.axHolder_.setLocationAtOrigin(((JCheckBox)object).isSelected());
            } else if (string.equals("Major Format")) {
                this.axHolder_.setMajorFormat(((JTextField)object).getText());
            } else if (string.equals("Major Interval")) {
                this.axHolder_.setMajorInterval(Integer.parseInt(((JTextField)object).getText()));
            } else if (string.equals("Minor Format")) {
                this.axHolder_.setMinorFormat(((JTextField)object).getText());
            } else if (string.equals("Minor Interval")) {
                this.axHolder_.setMinorInterval(Integer.parseInt(((JTextField)object).getText()));
            } else if (string.equals("Num Small Tics")) {
                this.axHolder_.setNumSmallTics(Integer.parseInt(((JTextField)object).getText()));
            } else if (string.equals("OriginP")) {
                this.axHolder_.setAxisOriginP(this.parsePoint2D(((JTextField)object).getText()));
            } else if (string.equals("Selectable")) {
                this.axHolder_.setSelectable(((JCheckBox)object).isSelected());
            } else if (string.equals("Small TicHeight")) {
                this.axHolder_.setSmallTicHeightP(Double.parseDouble(((JTextField)object).getText()));
            } else if (string.equals("Tic Position")) {
                string2 = (String)((JComboBox)object).getSelectedItem();
                n = -1;
                if (string2.equals("Auto")) {
                    n = 3;
                } else if (string2.equals("Negative Side")) {
                    n = 1;
                } else if (string2.equals("Positive Side")) {
                    n = 0;
                } else if (string2.equals("Both Sides")) {
                    n = 2;
                }
                this.axHolder_.setTicPosition(n);
            } else if (string.equals("Time AxisStyle")) {
                string2 = (String)((JComboBox)object).getSelectedItem();
                n = -1;
                if (string2.equals("Auto")) {
                    n = 0;
                } else if (string2.equals("Day-Month")) {
                    n = 3;
                } else if (string2.equals("Hour-Day")) {
                    n = 4;
                } else if (string2.equals("Minute-Hour")) {
                    n = 5;
                } else if (string2.equals("Month-Year")) {
                    n = 2;
                } else if (string2.equals("Year-Decade")) {
                    n = 1;
                }
                this.axHolder_.setTimeAxisStyle(n);
            } else if (string.equals("Title Auto")) {
                this.axHolder_.setTitleAuto(((JCheckBox)object).isSelected());
            } else if (string.equals("Title")) {
                SGLabelDialog sGLabelDialog = new SGLabelDialog("Axis Title");
                sGLabelDialog.setSGLabel(this.axHolder_.getTitle());
                sGLabelDialog.setModal(true);
                sGLabelDialog.setVisible(true);
                this.axHolder_.fireStateChanged();
            } else if (string.equals("Transform Type")) {
                string2 = (String)((JComboBox)object).getSelectedItem();
                int n3 = this.transform(string2);
                if (n3 == 2) {
                    this.axHolder_.setTransformGroup(string2.substring(5));
                }
                this.axHolder_.setTransformType(n3);
                if (n3 == 2 && this.circularReference(0, string2.substring(5))) {
                    JOptionPane.showMessageDialog(this, "Creates a circular reference in DataGroup transform", "Error Selecting Transform", 0);
                    this.axHolder_.setTransformType(-1);
                    this.axHolder_.setTransformGroup(null);
                    ((JComboBox)object).setSelectedIndex(-1);
                    return;
                }
            } else if (string.equals("User Range")) {
                soTRange = this.parseRange(((JTextField)object).getText(), this.axHolder_.isTime());
                if (soTRange != null) {
                    this.axHolder_.setUserRange(soTRange);
                }
            } else if (string.equals("Visible")) {
                this.axHolder_.setVisible(((JCheckBox)object).isSelected());
            }
        }
        this.update();
    }

    private int axis(String string) {
        if (string.equals("PlainAxis")) {
            return 4;
        }
        if (string.equals("TimeAxis")) {
            return 3;
        }
        if (string.equals("LogAxis")) {
            return 1;
        }
        return -1;
    }

    private int transform(String string) {
        if (string.equals("LinearTransform")) {
            return 0;
        }
        if (string.equals("LogTransform")) {
            return 1;
        }
        return 2;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            JTextField jTextField = (JTextField)object;
            String string = jTextField.getName();
            this.processEvent(object, string);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.update();
    }

    void addOtherDataGroupTransforms(Vector vector) {
        if (this.pHolder_.getDataGroupSize() <= 1) {
            return;
        }
        Iterator iterator = this.pHolder_.dataGroupIterator();
        while (iterator.hasNext()) {
            DataGroup dataGroup = (DataGroup)iterator.next();
            if (dataGroup.getId().equals(this.axHolder_.getDataGroup().getId())) continue;
            vector.add("Use: " + dataGroup.getId());
        }
    }

    int findTransformItem(Vector vector, int n, String string) {
        int n2 = -1;
        switch (n) {
            default: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                if (vector.size() < 3) break;
                for (int i = 2; i < vector.size(); ++i) {
                    if (!((String)vector.get(i)).endsWith(string)) continue;
                    return i;
                }
            }
        }
        return n2;
    }

    boolean circularReference(int n, String string) {
        String string2 = string;
        boolean bl = true;
        int n2 = -1;
        String string3 = null;
        while (bl) {
            DataGroup dataGroup = this.pHolder_.findDataGroup(string2);
            n2 = n == 0 ? dataGroup.getXAxisHolder().getTransformType() : dataGroup.getYAxisHolder().getTransformType();
            if (n2 != 2) {
                return false;
            }
            string3 = n == 0 ? dataGroup.getXAxisHolder().getTransformGroup() : dataGroup.getYAxisHolder().getTransformGroup();
            if (string.equals(string3)) {
                return true;
            }
            string2 = string3;
        }
        return false;
    }

    public void setExpert(boolean bl) {
        boolean bl2 = this.expert_;
        this.expert_ = bl;
        if (this.expert_ != bl2) {
            this.reset();
        }
    }

    public boolean isExpert() {
        return this.expert_;
    }
}

