/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.Format;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Ruler
implements Cloneable,
LayerChild {
    private String ident_;
    private Layer layer_;
    private int orient_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private SGLabel title_ = null;
    private String labelFormat_ = "";
    protected Range2D uRange_;
    protected Rectangle2D.Double pBounds_;
    protected int numSmallTics_ = 0;
    protected double largeTicHeight_ = 0.1;
    protected double smallTicHeight_ = 0.05;
    protected int ticPosition_ = 1;
    protected int labelPosition_ = 1;
    protected int labelInterval_ = 2;
    protected Font labelFont_ = new Font("Helvetica", 2, 10);
    protected Color labelColor_ = Color.black;
    protected Color lineColor_ = Color.black;
    protected double labelHeight_ = 0.2;
    protected int sigDigits_ = 2;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int POSITIVE_SIDE = 0;
    public static final int NEGATIVE_SIDE = 1;
    public static final int NO_LABEL = 2;
    public static final int BOTH_SIDES = 2;
    static final double TIC_GAP = 0.05;
    static final double TIC_RATIO = 1.3;
    static final double LABEL_RATIO = 1.3;

    protected void drawXTic(Graphics graphics, double d, double d2, double d3) {
        double d4 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d2 + d3 : d2;
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d2 - d3 : d2;
        int n = this.layer_.getXPtoD(d);
        int n2 = this.layer_.getYPtoD(d4);
        int n3 = this.layer_.getYPtoD(d5);
        graphics.drawLine(n, n2, n, n3);
    }

    protected void drawYTic(Graphics graphics, double d, double d2, double d3) {
        double d4 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d + d3 : d;
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d - d3 : d;
        int n = this.layer_.getYPtoD(d2);
        int n2 = this.layer_.getXPtoD(d4);
        int n3 = this.layer_.getXPtoD(d5);
        graphics.drawLine(n2, n, n3, n);
    }

    protected void drawSmallXTics(Graphics graphics, double d, double d2, double d3, double d4) {
        if (this.numSmallTics_ <= 0) {
            return;
        }
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d4 + this.smallTicHeight_ : d4;
        double d6 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d4 - this.smallTicHeight_ : d4;
        int n = this.layer_.getYPtoD(d5);
        int n2 = this.layer_.getYPtoD(d6);
        double d7 = d3 / (double)(this.numSmallTics_ + 1);
        for (int i = 0; i <= this.numSmallTics_; ++i) {
            double d8 = d + d7 * (double)i;
            if (!((d2 - d8) / d3 >= 0.0)) continue;
            int n3 = this.layer_.getXPtoD(d8);
            graphics.drawLine(n3, n, n3, n2);
        }
    }

    protected void drawSmallYTics(Graphics graphics, double d, double d2, double d3, double d4) {
        if (this.numSmallTics_ <= 0) {
            return;
        }
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d + this.smallTicHeight_ : d;
        double d6 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d - this.smallTicHeight_ : d;
        int n = this.layer_.getXPtoD(d5);
        int n2 = this.layer_.getXPtoD(d6);
        double d7 = d4 / (double)(this.numSmallTics_ + 1);
        for (int i = 0; i <= this.numSmallTics_; ++i) {
            double d8 = d2 + d7 * (double)i;
            if (!((d3 - d8) / d4 >= 0.0)) continue;
            int n3 = this.layer_.getYPtoD(d8);
            graphics.drawLine(n, n3, n2, n3);
        }
    }

    public Ruler() {
        this("");
    }

    public Ruler(String string) {
        this.ident_ = string;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
    }

    public LayerChild copy() {
        Ruler ruler;
        try {
            ruler = (Ruler)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ruler = new Ruler();
        }
        return ruler;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public void setSelectable(boolean bl) {
        this.selectable_ = bl;
    }

    public boolean isSelectable() {
        return this.selectable_;
    }

    public void setLargeTicHeightP(double d) {
        if (this.largeTicHeight_ != d) {
            this.largeTicHeight_ = d;
            this.modified("Ruler: setLargeTicHeightP()");
        }
    }

    public double getLargeTicHeightP() {
        return this.largeTicHeight_;
    }

    public void setNumberSmallTics(int n) {
        if (this.numSmallTics_ != n) {
            this.numSmallTics_ = n;
            this.modified("Ruler: setNumberSmallTics()");
        }
    }

    public int getNumberSmallTics() {
        return this.numSmallTics_;
    }

    public void setSmallTicHeightP(double d) {
        if (this.smallTicHeight_ != d) {
            this.smallTicHeight_ = d;
            this.modified("Ruler: setSmallTicHeightP()");
        }
    }

    public double getSmallTicHeightP() {
        return this.smallTicHeight_;
    }

    public void setTicPosition(int n) {
        if (this.ticPosition_ != n) {
            this.ticPosition_ = n;
            this.modified("Ruler: setTicPosition()");
        }
    }

    public int getTicPosition() {
        return this.ticPosition_;
    }

    public void setLabelPosition(int n) {
        if (this.labelPosition_ != n) {
            this.labelPosition_ = n;
            this.modified("Ruler: setLabelPosition()");
        }
    }

    public int getLabelPosition() {
        return this.labelPosition_;
    }

    public void setLabelFont(Font font) {
        if (this.labelFont_ == null || !this.labelFont_.equals(font)) {
            this.labelFont_ = font;
            this.modified("Ruler: setLabelFont()");
        }
    }

    public Font getLabelFont() {
        return this.labelFont_;
    }

    public void setLabelHeightP(double d) {
        if (this.labelHeight_ != d) {
            this.labelHeight_ = d;
            this.modified("Ruler: setLabelHeightP()");
        }
    }

    public double getLabelHeightP() {
        return this.labelHeight_;
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public String getId() {
        return this.ident_;
    }

    public void setLayer(Layer layer) {
        this.layer_ = layer;
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    public void modified(String string) {
        if (this.layer_ != null) {
            this.layer_.modified(string);
        }
    }

    public void setRangeU(Range2D range2D) {
        if (this.uRange_ == null || !this.uRange_.equals(range2D)) {
            this.uRange_ = range2D;
            this.modified("Ruler: setRangeU()");
        }
    }

    public Range2D getRangeU() {
        return this.uRange_;
    }

    public void setBoundsP(Rectangle2D.Double double_) {
        if (this.pBounds_ == null || !this.pBounds_.equals(double_)) {
            this.pBounds_ = double_;
            this.modified("Ruler: setBoundsP()");
        }
    }

    public Rectangle2D.Double getBoundsP() {
        return this.pBounds_;
    }

    public void setOrientation(int n) {
        if (this.orient_ != n) {
            this.orient_ = n;
            this.modified("Ruler: setOrientation()");
        }
    }

    public int getOrientation() {
        return this.orient_;
    }

    public void setTitle(SGLabel sGLabel) {
        if (this.title_ == null || !this.title_.equals(sGLabel)) {
            this.title_ = sGLabel;
            this.modified("Ruler: setTitle()");
        }
    }

    public SGLabel getTitle() {
        return this.title_;
    }

    public Rectangle getBounds() {
        int n = this.layer_.getXPtoD(this.pBounds_.x);
        int n2 = this.layer_.getYPtoD(this.pBounds_.y);
        int n3 = this.layer_.getXPtoD(this.pBounds_.x + this.pBounds_.width) - n;
        int n4 = this.layer_.getYPtoD(this.pBounds_.y - this.pBounds_.height) - n2;
        if (this.orient_ == 1) {
            n2 -= n4;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
    }

    public void draw(Graphics graphics) {
        String string = null;
        if (!this.visible_) {
            return;
        }
        if (this.title_ != null) {
            this.title_.setLayer(this.layer_);
        }
        if (this.lineColor_ == null) {
            graphics.setColor(this.layer_.getPane().getComponent().getForeground());
        } else {
            graphics.setColor(this.lineColor_);
        }
        Format format = this.labelFormat_.length() <= 0 ? new Format(Format.computeFormat(this.uRange_.start, this.uRange_.end, this.sigDigits_)) : new Format(this.labelFormat_);
        if (this.orient_ == 1) {
            double d;
            double d2;
            int n;
            int n2;
            LinearTransform linearTransform = new LinearTransform(this.pBounds_.x, this.pBounds_.x + this.pBounds_.width, this.uRange_.start, this.uRange_.end);
            int n3 = this.layer_.getYPtoD(this.pBounds_.y);
            double d3 = this.pBounds_.y;
            int n4 = this.layer_.getXPtoD(linearTransform.getTransP(this.uRange_.start));
            int n5 = this.layer_.getXPtoD(linearTransform.getTransP(this.uRange_.end));
            graphics.drawLine(n4, n3, n5, n3);
            double d4 = this.uRange_.delta > 0.0 ? 1.0 : -1.0;
            double d5 = (double)((int)(this.uRange_.start / this.uRange_.delta + (d4 * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * this.uRange_.delta;
            if (d4 * d5 < d4 * this.uRange_.start) {
                d5 += this.uRange_.delta;
            }
            int n6 = (int)((this.uRange_.end - d5) / this.uRange_.delta + 1.0E-5);
            double d6 = d5;
            double d7 = linearTransform.getTransP(d6);
            this.drawSmallXTics(graphics, d6, this.uRange_.start, -this.uRange_.delta, d3);
            this.drawXTic(graphics, d7, d3, this.largeTicHeight_);
            for (n2 = 0; n2 < n6; ++n2) {
                this.drawSmallXTics(graphics, d6, this.uRange_.end, this.uRange_.delta, d3);
                d7 = linearTransform.getTransP(d6 += this.uRange_.delta);
                this.drawXTic(graphics, d7, d3, this.largeTicHeight_);
            }
            this.drawSmallXTics(graphics, d6, this.uRange_.end, this.uRange_.delta, d3);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            if (this.labelPosition_ == 0) {
                n = 2;
                d2 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d3 + 1.3 * this.largeTicHeight_ : d3 + 0.05;
                d = d2 + 1.3 * this.labelHeight_;
            } else {
                n = 0;
                d2 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d3 - 1.3 * this.largeTicHeight_ : d3 - 0.05;
                d = d2 - 1.3 * this.labelHeight_;
            }
            d6 = d4 * this.uRange_.start <= 0.0 && d4 * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (this.uRange_.delta * (double)this.labelInterval_) - 1.0E-5)) * this.uRange_.delta * (double)this.labelInterval_ : d5;
            n6 = (int)((this.uRange_.end - d6) / (this.uRange_.delta * (double)this.labelInterval_) + 1.0E-5);
            for (n2 = 0; n2 <= n6; ++n2) {
                d5 = linearTransform.getTransP(d6);
                string = format.form(d6);
                SGLabel sGLabel = new SGLabel("coordinate", string, new Point2D.Double(d5, d2));
                sGLabel.setFont(this.labelFont_);
                sGLabel.setHeightP(this.labelHeight_);
                sGLabel.setAlign(n, 1);
                sGLabel.setLayer(this.layer_);
                sGLabel.setColor(this.labelColor_);
                try {
                    sGLabel.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
                d6 += this.uRange_.delta * (double)this.labelInterval_;
            }
            if (this.title_ != null) {
                double d8 = (this.uRange_.end + this.uRange_.start) * 0.5;
                d2 = d;
                d5 = linearTransform.getTransP(d8);
                this.title_.setLocationP(new Point2D.Double(d5, d2));
                this.title_.setAlign(n, 1);
                this.title_.setOrientation(0);
                try {
                    this.title_.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        } else {
            double d;
            double d9;
            int n;
            int n7;
            LinearTransform linearTransform = new LinearTransform(this.pBounds_.y, this.pBounds_.y + this.pBounds_.height, this.uRange_.start, this.uRange_.end);
            int n8 = this.layer_.getXPtoD(this.pBounds_.x);
            double d10 = this.pBounds_.x;
            int n9 = this.layer_.getYPtoD(linearTransform.getTransP(this.uRange_.start));
            int n10 = this.layer_.getYPtoD(linearTransform.getTransP(this.uRange_.end));
            graphics.drawLine(n8, n9, n8, n10);
            double d11 = this.uRange_.delta > 0.0 ? 1.0 : -1.0;
            double d12 = (double)((int)(this.uRange_.start / this.uRange_.delta + (d11 * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * this.uRange_.delta;
            if (d11 * d12 < d11 * this.uRange_.start) {
                d12 += this.uRange_.delta;
            }
            int n11 = (int)((this.uRange_.end - d12) / this.uRange_.delta + 1.0E-5);
            double d13 = d12;
            double d14 = linearTransform.getTransP(d13);
            this.drawSmallYTics(graphics, d10, d13, this.uRange_.start, -this.uRange_.delta);
            this.drawYTic(graphics, d10, d14, this.largeTicHeight_);
            for (n7 = 0; n7 < n11; ++n7) {
                this.drawSmallYTics(graphics, d10, d13, this.uRange_.end, this.uRange_.delta);
                d14 = linearTransform.getTransP(d13 += this.uRange_.delta);
                this.drawYTic(graphics, d10, d14, this.largeTicHeight_);
            }
            this.drawSmallYTics(graphics, d10, d13, this.uRange_.end, this.uRange_.delta);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            if (this.labelPosition_ == 1) {
                n = 2;
                d9 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d10 - 1.3 * this.largeTicHeight_ : d10 - 0.05;
                d = d9 - 1.3 * this.labelHeight_;
            } else {
                n = 0;
                d9 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d10 + 1.3 * this.largeTicHeight_ : d10 + 0.05;
                d = d9 + 1.3 * this.labelHeight_;
            }
            d13 = d11 * this.uRange_.start <= 0.0 && d11 * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (this.uRange_.delta * (double)this.labelInterval_) - 1.0E-5)) * this.uRange_.delta * (double)this.labelInterval_ : d12;
            n11 = (int)((this.uRange_.end - d13) / (this.uRange_.delta * (double)this.labelInterval_) + 1.0E-5);
            for (n7 = 0; n7 <= n11; ++n7) {
                d12 = linearTransform.getTransP(d13);
                string = format.form(d13);
                SGLabel sGLabel = new SGLabel("coordinate", string, new Point2D.Double(d9, d12));
                sGLabel.setAlign(n, 1);
                sGLabel.setOrientation(1);
                sGLabel.setFont(this.labelFont_);
                sGLabel.setHeightP(this.labelHeight_);
                sGLabel.setLayer(this.layer_);
                try {
                    sGLabel.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
                d13 += this.uRange_.delta * (double)this.labelInterval_;
            }
            if (this.title_ != null) {
                double d15 = (this.uRange_.end + this.uRange_.start) * 0.5;
                d12 = linearTransform.getTransP(d15);
                d9 = d;
                this.title_.setLocationP(new Point2D.Double(d9, d12));
                this.title_.setAlign(n, 1);
                this.title_.setOrientation(1);
                try {
                    this.title_.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean bl) {
        if (this.visible_ != bl) {
            this.visible_ = bl;
            this.modified("Ruler: setVisible()");
        }
    }

    public int getLabelInterval() {
        return this.labelInterval_;
    }

    public void setLabelInterval(int n) {
        this.labelInterval_ = n;
    }

    public int getSignificantDigits() {
        return this.sigDigits_;
    }

    public void setSignificantDigits(int n) {
        this.sigDigits_ = n;
    }

    public String getLabelFormat() {
        return this.labelFormat_;
    }

    public void setLabelFormat(String string) {
        this.labelFormat_ = string;
    }

    public Color getLabelColor() {
        return this.labelColor_;
    }

    public void setLabelColor(Color color) {
        this.labelColor_ = color;
    }

    public Color getLineColor() {
        return this.lineColor_;
    }

    public void setLineColor(Color color) {
        this.lineColor_ = color;
    }
}

