/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.DataKey;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.MethodNotImplementedError;
import gov.noaa.pmel.sgt.Moveable;
import gov.noaa.pmel.sgt.PlotMark;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.SGException;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Vector;

public class PointCollectionKey
implements Cloneable,
DataKey,
Moveable,
PropertyChangeListener {
    private String ident_;
    private Layer layer_;
    private Vector points_;
    private Vector label_;
    private int columns_;
    private int style_;
    private int valign_;
    private int halign_;
    private Point2D.Double porigin_;
    private double lineLengthP_;
    private int maxLabelLength_;
    private int maxLabelHeight_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private boolean moveable_;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private static final int VERTICAL_BORDER_ = 3;
    private static final int HORIZONTAL_BORDER_ = 15;
    private static final int COLUMN_SPACE_ = 10;
    private static final int ROW_SPACE_ = 3;
    private static final int LABEL_SPACE_ = 15;
    public static final int PLAIN_LINE = 0;
    public static final int RAISED = 1;
    public static final int NO_BORDER = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public PointCollectionKey() {
        this(new Point2D.Double(0.0, 0.0), 2, 0);
    }

    public PointCollectionKey(Point2D.Double double_, int n, int n2) {
        this.porigin_ = double_;
        this.valign_ = n;
        this.halign_ = n2;
        this.points_ = new Vector(2, 2);
        this.label_ = new Vector(2, 2);
        this.style_ = 0;
        this.columns_ = 1;
        this.ident_ = "";
        this.lineLengthP_ = 0.3f;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
        this.moveable_ = true;
    }

    public LayerChild copy() {
        PointCollectionKey pointCollectionKey;
        try {
            pointCollectionKey = (PointCollectionKey)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            pointCollectionKey = new PointCollectionKey();
        }
        pointCollectionKey.points_ = new Vector(2, 2);
        pointCollectionKey.label_ = new Vector(2, 2);
        return pointCollectionKey;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public void setSelectable(boolean bl) {
        this.selectable_ = bl;
    }

    public boolean isSelectable() {
        return this.selectable_;
    }

    public boolean isMoveable() {
        return this.moveable_;
    }

    public void setMoveable(boolean bl) {
        this.moveable_ = bl;
    }

    public void setLayer(Layer layer) {
        this.layer_ = layer;
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    public void modified(String string) {
        if (this.layer_ != null) {
            this.layer_.modified(string);
        }
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public String getId() {
        return this.ident_;
    }

    public void setLineLengthP(double d) {
        if (this.lineLengthP_ != d) {
            this.lineLengthP_ = d;
            this.modified("PointCollectionKey: setLineLengthP()");
        }
    }

    public double getLineLengthP() {
        return this.lineLengthP_;
    }

    public void setColumns(int n) {
        if (this.columns_ != n) {
            this.columns_ = n;
            this.modified("PointCollectionKey: setColumms()");
        }
    }

    public int getColumns() {
        return this.columns_;
    }

    public void setBorderStyle(int n) {
        if (this.style_ != n) {
            this.style_ = n;
            this.modified("PointCollectionKey: setBorderStyle()");
        }
    }

    public int getBorderStyle() {
        return this.style_;
    }

    public void setAlign(int n, int n2) {
        if (this.valign_ != n || this.halign_ != n2) {
            this.valign_ = n;
            this.halign_ = n2;
            this.modified("PointCollectionKey: setAlign()");
        }
    }

    public void setVAlign(int n) {
        if (this.valign_ != n) {
            this.valign_ = n;
            this.modified("PointCollectionKey: setVAlign()");
        }
    }

    public void setHAlign(int n) {
        if (this.halign_ != n) {
            this.halign_ = n;
            this.modified("PointCollectionKey: setHAlign()");
        }
    }

    public int getVAlign() {
        return this.valign_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    public void setLocationP(Point2D.Double double_) {
        if (this.porigin_ == null || !this.porigin_.equals(double_)) {
            Point2D.Double double_2 = this.porigin_;
            this.porigin_ = double_;
            this.changes_.firePropertyChange("location", double_2, this.porigin_);
            this.modified("PointCollectionKey: setLocationP()");
        }
    }

    public void setBoundsP(Rectangle2D.Double double_) {
        this.setLocationP(new Point2D.Double(double_.x, double_.y));
    }

    public Rectangle2D.Double getBoundsP() {
        throw new MethodNotImplementedError();
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    public void addPointGraph(PointCartesianRenderer pointCartesianRenderer, SGLabel sGLabel) {
        this.points_.addElement(pointCartesianRenderer);
        sGLabel.setLayer(this.layer_);
        sGLabel.setMoveable(false);
        sGLabel.setSelectable(false);
        this.label_.addElement(sGLabel);
        ((PointAttribute)pointCartesianRenderer.getAttribute()).addPropertyChangeListener(this);
        this.modified("PointCollectionKey: addPointGraph()");
    }

    public void addGraph(CartesianRenderer cartesianRenderer, SGLabel sGLabel) throws IllegalArgumentException {
        if (!(cartesianRenderer instanceof PointCartesianRenderer)) {
            throw new IllegalArgumentException("Renderer is not a PointCartesianRenderer");
        }
        this.addPointGraph((PointCartesianRenderer)cartesianRenderer, sGLabel);
    }

    public void removePointGraph(SGLabel sGLabel) {
    }

    public void removePointRenderer(PointCartesianRenderer pointCartesianRenderer) {
    }

    public void removePointGraph(String string) {
    }

    public void clearAll() {
        Enumeration enumeration = this.points_.elements();
        while (enumeration.hasMoreElements()) {
            PointAttribute pointAttribute = (PointAttribute)((PointCartesianRenderer)enumeration.nextElement()).getAttribute();
            pointAttribute.removePropertyChangeListener(this);
        }
        this.points_.removeAllElements();
        this.label_.removeAllElements();
        this.modified("PointCollectionKey: clearAll()");
    }

    public void clear(String string) {
        int n = -1;
        Enumeration enumeration = this.points_.elements();
        while (enumeration.hasMoreElements()) {
            ++n;
            PointCartesianRenderer pointCartesianRenderer = (PointCartesianRenderer)enumeration.nextElement();
            Collection collection = pointCartesianRenderer.getCollection();
            if (!collection.getId().equals(string)) continue;
            pointCartesianRenderer.getAttribute().removePropertyChangeListener(this);
            this.points_.removeElement(pointCartesianRenderer);
            this.label_.removeElementAt(n);
            this.modified("PointCollectionKey: clear()");
        }
    }

    public SGLabel getSGLabel(String string) {
        int n = -1;
        Enumeration enumeration = this.points_.elements();
        while (enumeration.hasMoreElements()) {
            ++n;
            PointCartesianRenderer pointCartesianRenderer = (PointCartesianRenderer)enumeration.nextElement();
            Collection collection = pointCartesianRenderer.getCollection();
            if (!collection.getId().equals(string)) continue;
            return (SGLabel)this.label_.elementAt(n);
        }
        return null;
    }

    public int getRowHeight() {
        Rectangle rectangle = this.getBounds();
        return 3 + this.maxLabelHeight_;
    }

    public void draw(Graphics graphics) {
        int n;
        PointCartesianRenderer pointCartesianRenderer = null;
        PointAttribute pointAttribute = null;
        int n2 = this.points_.size();
        if (n2 <= 0 || !this.visible_) {
            return;
        }
        int n3 = n2 / this.columns_;
        if (n2 % this.columns_ != 0) {
            ++n3;
        }
        double[] dArray = new double[this.columns_];
        int[] nArray = new int[this.columns_];
        double[] dArray2 = new double[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[2];
        int[] nArray4 = new int[2];
        graphics.setColor(this.layer_.getPane().getComponent().getForeground());
        Rectangle rectangle = this.getBounds();
        int n4 = this.layer_.getXPtoD(this.lineLengthP_) - this.layer_.getXPtoD(0.0);
        double d = this.layer_.getXDtoP(15) - this.layer_.getXDtoP(0);
        nArray2[0] = rectangle.y + 3 + this.maxLabelHeight_;
        dArray2[0] = this.layer_.getYDtoP(nArray2[0]);
        for (n = 1; n < n3; ++n) {
            nArray2[n] = nArray2[n - 1] + 3 + this.maxLabelHeight_;
            dArray2[n] = this.layer_.getYDtoP(nArray2[n]);
        }
        nArray[0] = rectangle.x + 15;
        dArray[0] = this.layer_.getXDtoP(nArray[0]);
        for (n = 1; n < this.columns_; ++n) {
            nArray[n] = nArray[n - 1] + 10 + n4 + 15 + this.maxLabelLength_;
            dArray[n] = this.layer_.getXDtoP(nArray[n]);
        }
        int n5 = 0;
        int n6 = 0;
        Enumeration enumeration = this.label_.elements();
        Enumeration enumeration2 = this.points_.elements();
        while (enumeration2.hasMoreElements()) {
            Object e = enumeration2.nextElement();
            pointCartesianRenderer = (PointCartesianRenderer)e;
            pointAttribute = (PointAttribute)pointCartesianRenderer.getAttribute();
            SGLabel sGLabel = (SGLabel)enumeration.nextElement();
            graphics.setColor(pointAttribute.getColor());
            nArray3[0] = nArray[n6];
            nArray3[1] = nArray3[0] + n4;
            nArray4[0] = nArray2[n5] - this.maxLabelHeight_ / 2;
            nArray4[1] = nArray4[0];
            int n7 = nArray4[0];
            PlotMark plotMark = new PlotMark(pointAttribute);
            plotMark.setMarkHeightP(sGLabel.getHeightP());
            plotMark.paintMark(graphics, this.layer_, nArray3[0], n7);
            plotMark.paintMark(graphics, this.layer_, nArray3[1], n7);
            double d2 = dArray[n6] + this.lineLengthP_ + d;
            sGLabel.setLocationP(new Point2D.Double(d2, dArray2[n5]));
            try {
                sGLabel.draw(graphics);
            }
            catch (SGException sGException) {
                // empty catch block
            }
            if (++n6 < this.columns_) continue;
            n6 = 0;
            ++n5;
        }
        switch (this.style_) {
            case 0: {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public Rectangle getBounds() {
        int n = this.points_.size();
        if (n <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.maxLabelLength_ = 0;
        this.maxLabelHeight_ = 0;
        Enumeration enumeration = this.label_.elements();
        while (enumeration.hasMoreElements()) {
            SGLabel sGLabel = (SGLabel)enumeration.nextElement();
            Rectangle rectangle = sGLabel.getBounds();
            this.maxLabelLength_ = Math.max(this.maxLabelLength_, rectangle.width);
            this.maxLabelHeight_ = Math.max(this.maxLabelHeight_, rectangle.height);
        }
        int n2 = n / this.columns_;
        if (n % this.columns_ != 0) {
            ++n2;
        }
        int n3 = this.layer_.getXPtoD(this.lineLengthP_) - this.layer_.getXPtoD(0.0);
        int n4 = 30 + this.columns_ * (n3 + 15 + this.maxLabelLength_) + (this.columns_ - 1) * 10;
        int n5 = 6 + n2 * this.maxLabelHeight_ + (n2 - 1) * 3;
        n5 += 5;
        int n6 = this.layer_.getXPtoD(this.porigin_.x);
        int n7 = this.layer_.getYPtoD(this.porigin_.y);
        switch (this.halign_) {
            case 2: {
                n6 -= n4;
                break;
            }
            case 1: {
                n6 -= n4 / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                n7 -= n5;
                break;
            }
            case 1: {
                n7 -= n5 / 2;
            }
        }
        return new Rectangle(n6, n7, n4, n5);
    }

    public Point getLocation() {
        Rectangle rectangle = this.getBounds();
        return new Point(rectangle.x, rectangle.y);
    }

    public void setLocation(Point point) {
        Rectangle rectangle = this.getBounds();
        this.setBounds(point.x, point.y, rectangle.width, rectangle.height);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        switch (this.halign_) {
            case 2: {
                n += n3;
                break;
            }
            case 1: {
                n += n3 / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                n2 += n4;
                break;
            }
            case 1: {
                n2 += n4 / 2;
            }
        }
        double d = this.layer_.getXDtoP(n);
        double d2 = this.layer_.getYDtoP(n2);
        if (this.porigin_.x != d || this.porigin_.y != d2) {
            Point2D.Double double_ = this.porigin_;
            this.porigin_.x = d;
            this.porigin_.y = d2;
            this.changes_.firePropertyChange("location", double_, new Point2D.Double(d, d2));
            this.modified("PointCollectionKey: setBounds()");
        }
    }

    Object getObjectAt(Point point) {
        int n;
        int n2 = this.points_.size();
        if (n2 <= 0) {
            return null;
        }
        int n3 = n2 / this.columns_;
        if (n2 % this.columns_ != 0) {
            ++n3;
        }
        int[] nArray = new int[this.columns_];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[2];
        int[] nArray4 = new int[2];
        Rectangle rectangle = this.getBounds();
        int n4 = this.layer_.getXPtoD(this.lineLengthP_) - this.layer_.getXPtoD(0.0);
        double d = this.layer_.getXDtoP(15) - this.layer_.getXDtoP(0);
        nArray2[0] = rectangle.y + 3 + this.maxLabelHeight_;
        for (n = 1; n < n3; ++n) {
            nArray2[n] = nArray2[n - 1] + 3 + this.maxLabelHeight_;
        }
        nArray[0] = rectangle.x + 15;
        for (n = 1; n < this.columns_; ++n) {
            nArray[n] = nArray[n - 1] + 10 + n4 + 15 + this.maxLabelLength_;
        }
        int n5 = 0;
        int n6 = 0;
        Enumeration enumeration = this.points_.elements();
        while (enumeration.hasMoreElements()) {
            PointCartesianRenderer pointCartesianRenderer = (PointCartesianRenderer)enumeration.nextElement();
            nArray3[0] = nArray[n6];
            nArray3[1] = nArray3[0] + n4 + 15;
            nArray4[0] = nArray2[n5] - this.maxLabelHeight_;
            nArray4[1] = nArray2[n5];
            Rectangle rectangle2 = new Rectangle(nArray3[0], nArray4[0], nArray3[1] - nArray3[0], nArray4[1] - nArray4[0]);
            if (rectangle2.contains(point)) {
                return pointCartesianRenderer;
            }
            if (++n6 < this.columns_) continue;
            n6 = 0;
            ++n5;
        }
        if (rectangle.contains(point)) {
            return this;
        }
        return null;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean bl) {
        if (this.visible_ != bl) {
            this.visible_ = bl;
            this.modified("PointCollectionKey: setVisible()");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("PointCollectionKey: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }
}

