/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.PlotMark;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.util.Point2D;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class PointCartesianRenderer
extends CartesianRenderer {
    private PointAttribute attr_ = null;
    private SGTPoint point_ = null;
    private Collection collection_ = null;

    public Attribute getAttribute() {
        return this.attr_;
    }

    private void drawPoint(Graphics graphics, SGTPoint sGTPoint, PlotMark plotMark) {
        if (plotMark.getMark() == 0) {
            return;
        }
        int n = sGTPoint.isXTime() ? this.cg_.getXUtoD(sGTPoint.getLongTime()) : this.cg_.getXUtoD(sGTPoint.getX());
        int n2 = sGTPoint.isYTime() ? this.cg_.getYUtoD(sGTPoint.getLongTime()) : this.cg_.getYUtoD(sGTPoint.getY());
        if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE) {
            return;
        }
        plotMark.paintMark(graphics, this.cg_.getLayer(), n, n2);
    }

    private void drawLabel(Graphics graphics, SGTPoint sGTPoint, PointAttribute pointAttribute) {
        int n;
        int n2;
        Layer layer = this.cg_.getLayer();
        double d = sGTPoint.isXTime() ? this.cg_.getXUtoP(sGTPoint.getLongTime()) : this.cg_.getXUtoP(sGTPoint.getX());
        double d2 = sGTPoint.isYTime() ? this.cg_.getYUtoP(sGTPoint.getLongTime()) : this.cg_.getYUtoP(sGTPoint.getY());
        double d3 = pointAttribute.getMarkHeightP() / 2.0;
        double d4 = 0.0;
        double d5 = 0.0;
        switch (pointAttribute.getLabelPosition()) {
            case 0: {
                n2 = 1;
                n = 1;
                break;
            }
            case 1: {
                n2 = 2;
                n = 1;
                d5 = d3;
                break;
            }
            default: {
                n2 = 2;
                n = 0;
                d5 = d3;
                d4 = d3;
                break;
            }
            case 3: {
                n2 = 1;
                n = 0;
                d4 = d3;
                break;
            }
            case 4: {
                n2 = 0;
                n = 0;
                d5 = -d3;
                d4 = d3;
                break;
            }
            case 5: {
                n2 = 0;
                n = 1;
                d5 = -d3;
                break;
            }
            case 6: {
                n2 = 0;
                n = 2;
                d5 = -d3;
                d4 = -d3;
                break;
            }
            case 7: {
                n2 = 1;
                n = 2;
                d4 = -d3;
                break;
            }
            case 8: {
                n2 = 2;
                n = 2;
                d5 = d3;
                d4 = -d3;
            }
        }
        SGLabel sGLabel = new SGLabel("point", sGTPoint.getTitle(), pointAttribute.getLabelHeightP(), new Point2D.Double(d + d4, d2 + d5), n2, n);
        sGLabel.setColor(pointAttribute.getLabelColor());
        sGLabel.setFont(pointAttribute.getLabelFont());
        sGLabel.setLayer(layer);
        try {
            sGLabel.draw(graphics);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
    }

    public PointCartesianRenderer(CartesianGraph cartesianGraph) {
        this(cartesianGraph, (SGTPoint)null, null);
    }

    public PointCartesianRenderer(CartesianGraph cartesianGraph, SGTPoint sGTPoint) {
        this(cartesianGraph, sGTPoint, null);
        this.cg_ = cartesianGraph;
        this.point_ = sGTPoint;
    }

    public PointCartesianRenderer(CartesianGraph cartesianGraph, SGTPoint sGTPoint, PointAttribute pointAttribute) {
        this.cg_ = cartesianGraph;
        this.point_ = sGTPoint;
        this.attr_ = pointAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public PointCartesianRenderer(CartesianGraph cartesianGraph, Collection collection, PointAttribute pointAttribute) {
        this.cg_ = cartesianGraph;
        this.collection_ = collection;
        this.attr_ = pointAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public void draw(Graphics graphics) {
        if (this.cg_.clipping_) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.cg_.xTransform_.isSpace()) {
                n8 = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                n8 = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                n6 = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                n5 = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                n6 = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                n5 = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (n8 < n7) {
                n4 = n8;
                n3 = n7 - n8;
            } else {
                n4 = n7;
                n3 = n8 - n7;
            }
            if (n6 < n5) {
                n2 = n6;
                n = n5 - n6;
            } else {
                n2 = n5;
                n = n6 - n5;
            }
            graphics.setClip(n4, n2, n3, n);
        }
        PointAttribute pointAttribute = this.attr_ == null ? new PointAttribute(2, this.cg_.layer_.getPane().getComponent().getForeground()) : this.attr_;
        PlotMark plotMark = new PlotMark(pointAttribute);
        if (this.collection_ == null) {
            graphics.setColor(pointAttribute.getColor());
            this.drawPoint(graphics, this.point_, plotMark);
            if (pointAttribute.isDrawLabel()) {
                this.drawLabel(graphics, this.point_, pointAttribute);
            }
        } else {
            Enumeration enumeration = this.collection_.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof SGTPoint)) continue;
                graphics.setColor(pointAttribute.getColor());
                this.drawPoint(graphics, (SGTPoint)e, plotMark);
                if (!pointAttribute.isDrawLabel()) continue;
                this.drawLabel(graphics, (SGTPoint)e, pointAttribute);
            }
        }
        Rectangle rectangle = this.cg_.getLayer().getPane().getBounds();
        graphics.setClip(rectangle);
    }

    public void setPointAttribute(PointAttribute pointAttribute) {
        if (this.attr_ != null) {
            this.attr_.removePropertyChangeListener(this);
        }
        this.attr_ = pointAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public PointAttribute getPointAttribute() {
        return this.attr_;
    }

    public boolean hasCollection() {
        return this.collection_ != null;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public SGTPoint getPoint() {
        return this.point_;
    }

    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("PointCartesianRenderer: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    public SGTData getDataAt(Point point) {
        return null;
    }
}

