/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerControl;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.Moveable;
import gov.noaa.pmel.sgt.PaneNotFoundException;
import gov.noaa.pmel.sgt.Selectable;
import gov.noaa.pmel.sgt.StrokeDrawer;
import gov.noaa.pmel.sgt.StrokeDrawer1;
import gov.noaa.pmel.sgt.StrokeDrawer2;
import gov.noaa.pmel.sgt.beans.Panel;
import gov.noaa.pmel.sgt.swing.Draggable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;

class PaneProxy {
    public static String SGTVersion = "3.0";
    public static boolean Java2D = false;
    public static StrokeDrawer strokeDrawer = null;
    private Container pane_;
    private String ident_;
    private Dimension panesize_;
    private Image offscreen_;
    private Dimension pagesize_;
    private Point pageOrigin_ = new Point(0, 0);
    private boolean printer_ = false;
    private boolean opaque_ = true;
    private int halign_ = 1;
    private int valign_ = 1;
    private int printMode_ = 2;
    private Object selectedobject_;
    private Object old_selectedobject_ = null;
    private Rectangle selectedRect_;
    private Rectangle zoom_rect_ = new Rectangle(0, 0, 0, 0);
    private Rectangle old_zoom_rect_;
    private Point zoom_start_ = new Point(0, 0);
    private boolean in_zoom_ = false;
    private boolean in_select_ = false;
    private boolean in_move_ = false;
    private boolean moved_ = false;
    private boolean draggable_ = false;
    private boolean moveable_ = false;
    private Point move_ref_;
    private boolean batch_ = true;
    private boolean modified_ = false;
    private boolean ignoreModified_ = false;
    private boolean firstDraw_ = true;
    private boolean mouseEventsEnabled_ = true;
    private PropertyChangeSupport changes_ = null;

    public PaneProxy(Container container, String string, Dimension dimension) {
        this.ident_ = string;
        this.panesize_ = dimension;
        this.pane_ = container;
        this.changes_ = new PropertyChangeSupport(this.pane_);
        this.testJava2D();
    }

    public static String getVersion() {
        return SGTVersion;
    }

    private void testJava2D() {
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("java.awt.Graphics2D");
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        Java2D = bl;
        strokeDrawer = Java2D ? new StrokeDrawer2() : new StrokeDrawer1();
    }

    public Dimension getSize() {
        return this.panesize_;
    }

    void draw() {
        this.ignoreModified_ = true;
        this.printer_ = false;
        Graphics graphics = this.pane_.getGraphics();
        if (graphics == null) {
            this.ignoreModified_ = false;
            return;
        }
        if (this.firstDraw_) {
            ((AbstractPane)((Object)this.pane_)).init();
            this.firstDraw_ = false;
        }
        Dimension dimension = this.pane_.getSize();
        if (this.offscreen_ == (Image)null) {
            this.offscreen_ = this.pane_.createImage(dimension.width, dimension.height);
        } else if (dimension.width != this.panesize_.width || dimension.height != this.panesize_.height) {
            this.offscreen_ = this.pane_.createImage(dimension.width, dimension.height);
        }
        this.panesize_ = dimension;
        Graphics graphics2 = this.offscreen_.getGraphics();
        Rectangle rectangle = this.pane_.getBounds();
        graphics2.setClip(0, 0, rectangle.width, rectangle.height);
        this.drawLayers(graphics2);
        graphics.drawImage(this.offscreen_, 0, 0, this.pane_);
        this.drawDraggableItems(graphics);
        this.modified_ = false;
        this.ignoreModified_ = false;
        this.pane_.repaint();
    }

    void draw(Graphics graphics) {
        Rectangle rectangle = this.pane_.getBounds();
        this.draw(graphics, rectangle.width, rectangle.height);
    }

    void draw(Graphics graphics, int n, int n2) {
        this.ignoreModified_ = true;
        if (graphics instanceof PrintGraphics) {
            this.printer_ = true;
            this.pagesize_ = ((PrintGraphics)((Object)graphics)).getPrintJob().getPageDimension();
        } else {
            this.printer_ = false;
            this.pagesize_ = null;
        }
        graphics.setClip(0, 0, n, n2);
        this.drawLayers(graphics);
        this.drawDraggableItems(graphics);
        this.modified_ = false;
        this.ignoreModified_ = false;
    }

    void drawPage(Graphics graphics, double d, double d2) {
        this.ignoreModified_ = true;
        this.printer_ = true;
        Color color = graphics.getColor();
        graphics.setColor(this.pane_.getBackground());
        Rectangle rectangle = this.pane_.getBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        this.drawLayers(graphics);
        this.drawDraggableItems(graphics);
        this.modified_ = false;
        this.ignoreModified_ = false;
        this.printer_ = false;
    }

    void setOpaque(boolean bl) {
        this.opaque_ = bl;
    }

    boolean isOpaque() {
        return this.opaque_;
    }

    void drawLayers(Graphics graphics) {
        Object object;
        if (!this.printer_) {
            if (this.opaque_) {
                object = this.pane_.getBounds();
                graphics.setColor(this.pane_.getBackground());
                graphics.fillRect(0, 0, object.width, object.height);
            }
            graphics.setColor(this.pane_.getForeground());
        }
        object = this.pane_.getComponents();
        for (int i = 0; i < ((Component[])object).length; ++i) {
            try {
                if (object[i] instanceof Layer) {
                    ((Layer)object[i]).draw(graphics);
                    continue;
                }
                if (!(object[i] instanceof LayerControl)) continue;
                ((LayerControl)((Object)object[i])).draw(graphics);
                continue;
            }
            catch (PaneNotFoundException paneNotFoundException) {
                // empty catch block
            }
        }
    }

    void drawDraggableItems(Graphics graphics) {
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            try {
                if (!(componentArray[i] instanceof LayerControl)) continue;
                ((LayerControl)((Object)componentArray[i])).drawDraggableItems(graphics);
                continue;
            }
            catch (PaneNotFoundException paneNotFoundException) {
                // empty catch block
            }
        }
    }

    void paint(Graphics graphics) {
        Dimension dimension = this.pane_.getSize();
        if (dimension.width != this.panesize_.width || dimension.height != this.panesize_.height) {
            this.offscreen_ = null;
        }
        if (this.offscreen_ != null && !this.modified_) {
            graphics.drawImage(this.offscreen_, 0, 0, this.pane_);
            this.drawDraggableItems(graphics);
        } else {
            this.draw();
        }
        this.modified_ = false;
    }

    String getId() {
        return this.ident_;
    }

    void setId(String string) {
        this.ident_ = string;
    }

    void setPageAlign(int n, int n2) {
        this.valign_ = n;
        this.halign_ = n2;
    }

    void setPageVAlign(int n) {
        this.valign_ = n;
    }

    void setPageHAlign(int n) {
        this.halign_ = n;
    }

    int getPageVAlign() {
        return this.valign_;
    }

    int getPageHAlign() {
        return this.halign_;
    }

    void setPageOrigin(Point point) {
        this.pageOrigin_ = point;
    }

    Point getPageOrigin() {
        return this.pageOrigin_;
    }

    boolean isPrinter() {
        return this.printer_;
    }

    Dimension getPageSize() {
        return this.pagesize_;
    }

    void setSize(Dimension dimension) {
        this.panesize_ = dimension;
        this.offscreen_ = null;
    }

    Layer getFirstLayer() {
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer)) continue;
            return (Layer)componentArray[i];
        }
        return null;
    }

    Layer getLayer(String string) throws LayerNotFoundException {
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Layer) {
                if (((Layer)componentArray[i]).getId() != string) continue;
                return (Layer)componentArray[i];
            }
            if (!(componentArray[i] instanceof Panel) || !((Panel)componentArray[i]).hasLayer(string)) continue;
            return ((Panel)componentArray[i]).getLayer(string);
        }
        throw new LayerNotFoundException();
    }

    Layer getLayerFromDataId(String string) throws LayerNotFoundException {
        Component[] componentArray = this.pane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Layer) {
                if (!((Layer)componentArray[i]).isDataInLayer(string)) continue;
                return (Layer)componentArray[i];
            }
            if (!(componentArray[i] instanceof Panel) || !((Panel)componentArray[i]).isDataInPanel(string)) continue;
            return ((Panel)componentArray[i]).getLayerFromDataId(string);
        }
        throw new LayerNotFoundException();
    }

    Object getSelectedObject() {
        return this.selectedobject_;
    }

    void setSelectedObject(Object object) {
        this.old_selectedobject_ = this.selectedobject_;
        this.selectedobject_ = object;
    }

    Rectangle getZoomBounds() {
        return this.zoom_rect_;
    }

    Point getZoomStart() {
        return this.zoom_start_;
    }

    Object getObjectAt(int n, int n2) {
        Object object = null;
        Component[] componentArray = this.pane_.getComponents();
        if (componentArray.length != 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Layer ? (object = ((Layer)componentArray[i]).getObjectAt(n, n2, false)) != null : componentArray[i] instanceof Panel && (object = ((Panel)componentArray[i]).getObjectAt(n, n2, false)) != null)) continue;
                return object;
            }
        }
        return object;
    }

    Object[] getObjectsAt(int n, int n2) {
        Vector<Object> vector = new Vector<Object>();
        Object object = null;
        Component[] componentArray = this.pane_.getComponents();
        if (componentArray.length != 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof Layer) {
                    object = ((Layer)componentArray[i]).getObjectAt(n, n2, false);
                    if (object == null) continue;
                    vector.addElement(object);
                    continue;
                }
                if (!(componentArray[i] instanceof Panel) || (object = ((Panel)componentArray[i]).getObjectAt(n, n2, false)) == null) continue;
                vector.addElement(object);
            }
        }
        return vector.toArray();
    }

    boolean processMouseEvent(MouseEvent mouseEvent) {
        boolean bl = false;
        if (!this.mouseEventsEnabled_) {
            return bl;
        }
        if (mouseEvent.getID() == 500) {
            bl = this.Pane_MouseClicked(mouseEvent);
        } else if (mouseEvent.getID() == 501) {
            bl = this.Pane_MouseDown(mouseEvent);
        } else if (mouseEvent.getID() == 502) {
            bl = this.Pane_MouseUp(mouseEvent);
        }
        return bl;
    }

    boolean processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl = false;
        if (!this.mouseEventsEnabled_) {
            return bl;
        }
        if (mouseEvent.getID() == 506) {
            bl = this.Pane_MouseDrag(mouseEvent);
        } else if (mouseEvent.getID() == 503) {
            bl = this.Pane_MouseMoved(mouseEvent);
        }
        return bl;
    }

    private boolean Pane_MouseClicked(MouseEvent mouseEvent) {
        Selectable selectable = null;
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 0) {
            return false;
        }
        this.in_zoom_ = false;
        this.in_select_ = false;
        if (!this.moved_ && this.selectedobject_ instanceof Selectable && ((Selectable)this.selectedobject_).isSelected()) {
            selectable = (Selectable)this.selectedobject_;
            Graphics graphics = this.pane_.getGraphics();
            if (this.moveable_) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.blue);
            }
            graphics.setXORMode(this.pane_.getBackground());
            graphics.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
            graphics.setPaintMode();
            selectable.setSelected(false);
            this.pane_.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        this.selectedobject_ = null;
        Component[] componentArray = this.pane_.getComponents();
        if (componentArray.length != 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                Object object;
                if (componentArray[i] instanceof Layer) {
                    object = ((Layer)componentArray[i]).getObjectAt(mouseEvent.getX(), mouseEvent.getY());
                    if (object == null) continue;
                    this.selectedobject_ = object;
                    break;
                }
                if (!(componentArray[i] instanceof Panel) || (object = ((Panel)componentArray[i]).getObjectAt(mouseEvent.getX(), mouseEvent.getY(), false)) == null) continue;
                this.selectedobject_ = object;
                break;
            }
            if (this.selectedobject_ instanceof Selectable) {
                if (!this.selectedobject_.equals(selectable) && ((Selectable)this.selectedobject_).isSelectable()) {
                    ((Selectable)this.selectedobject_).setSelected(true);
                    this.in_select_ = true;
                    if (!this.in_move_) {
                        this.selectedRect_ = new Rectangle(((Selectable)this.selectedobject_).getBounds());
                        Graphics graphics = this.pane_.getGraphics();
                        if (this.moveable_) {
                            graphics.setColor(Color.red);
                        } else {
                            graphics.setColor(Color.blue);
                        }
                        graphics.setXORMode(this.pane_.getBackground());
                        graphics.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                        graphics.setPaintMode();
                    }
                    this.in_move_ = false;
                    this.changes_.firePropertyChange("objectSelected", this.old_selectedobject_, this.selectedobject_);
                }
            } else if (this.selectedobject_ != null) {
                this.changes_.firePropertyChange("objectSelected", this.old_selectedobject_, this.selectedobject_);
            }
        }
        return false;
    }

    private boolean Pane_MouseMoved(MouseEvent mouseEvent) {
        if (this.in_select_) {
            if (this.selectedRect_.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.pane_.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                this.pane_.setCursor(Cursor.getPredefinedCursor(0));
            }
            return true;
        }
        this.pane_.setCursor(Cursor.getPredefinedCursor(0));
        return false;
    }

    private boolean Pane_MouseDown(MouseEvent mouseEvent) {
        Selectable selectable = null;
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return false;
        }
        this.old_zoom_rect_ = new Rectangle(this.zoom_rect_);
        this.zoom_rect_.x = 0;
        this.zoom_rect_.y = 0;
        this.zoom_rect_.width = 0;
        this.zoom_rect_.height = 0;
        if (mouseEvent.isShiftDown()) {
            this.in_zoom_ = true;
            this.zoom_start_.x = mouseEvent.getX();
            this.zoom_start_.y = mouseEvent.getY();
            this.zoom_rect_.x = mouseEvent.getX();
            this.zoom_rect_.y = mouseEvent.getY();
            this.zoom_rect_.width = 1;
            this.zoom_rect_.height = 1;
            Graphics graphics = this.pane_.getGraphics();
            graphics.setColor(this.pane_.getForeground());
            graphics.setXORMode(this.pane_.getBackground());
            graphics.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
            graphics.setPaintMode();
            return true;
        }
        if (mouseEvent.isControlDown()) {
            return false;
        }
        if (this.in_select_ && this.moveable_ && this.selectedRect_.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.in_move_ = true;
            this.moved_ = false;
            this.move_ref_ = new Point(mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        if (this.in_select_ && !this.moveable_ && this.selectedRect_.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.in_move_ = false;
            this.moved_ = false;
            return true;
        }
        selectable = this.selectedobject_ instanceof Selectable ? (Selectable)this.selectedobject_ : null;
        this.selectedobject_ = null;
        Component[] componentArray = this.pane_.getComponents();
        if (componentArray.length != 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                Object object;
                if (componentArray[i] instanceof Layer) {
                    object = ((Layer)componentArray[i]).getObjectAt(mouseEvent.getX(), mouseEvent.getY());
                    if (object == null) continue;
                    this.selectedobject_ = object;
                    break;
                }
                if (!(componentArray[i] instanceof Panel) || (object = ((Panel)componentArray[i]).getObjectAt(mouseEvent.getX(), mouseEvent.getY(), false)) == null) continue;
                this.selectedobject_ = object;
                break;
            }
            if (this.selectedobject_ instanceof Selectable && ((Selectable)this.selectedobject_).isSelectable()) {
                this.draggable_ = this.selectedobject_ instanceof Draggable;
                this.moveable_ = this.selectedobject_ instanceof Moveable ? ((Moveable)this.selectedobject_).isMoveable() : false;
                this.in_move_ = this.moveable_ || this.draggable_;
                this.moved_ = false;
                ((Selectable)this.selectedobject_).setSelected(false);
                this.selectedRect_ = new Rectangle(((Selectable)this.selectedobject_).getBounds());
                if (!this.draggable_ && this.moveable_) {
                    Graphics graphics = this.pane_.getGraphics();
                    graphics.setColor(Color.red);
                    graphics.setXORMode(this.pane_.getBackground());
                    graphics.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                    graphics.setPaintMode();
                }
                if (!this.draggable_) {
                    this.pane_.setCursor(Cursor.getPredefinedCursor(13));
                }
                this.move_ref_ = new Point(mouseEvent.getX(), mouseEvent.getY());
                return true;
            }
        }
        this.in_zoom_ = true;
        this.zoom_start_.x = mouseEvent.getX();
        this.zoom_start_.y = mouseEvent.getY();
        this.zoom_rect_.x = mouseEvent.getX();
        this.zoom_rect_.y = mouseEvent.getY();
        this.zoom_rect_.width = 1;
        this.zoom_rect_.height = 1;
        Graphics graphics = this.pane_.getGraphics();
        graphics.setColor(this.pane_.getForeground());
        graphics.setXORMode(this.pane_.getBackground());
        graphics.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
        graphics.setPaintMode();
        return true;
    }

    private boolean Pane_MouseDrag(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.in_zoom_) {
            bl = true;
            Graphics graphics = this.pane_.getGraphics();
            graphics.setColor(this.pane_.getForeground());
            graphics.setXORMode(this.pane_.getBackground());
            graphics.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
            this.zoom_rect_.width = mouseEvent.getX() - this.zoom_start_.x;
            if (this.zoom_rect_.width < 0) {
                this.zoom_rect_.x = mouseEvent.getX();
                this.zoom_rect_.width = Math.abs(this.zoom_rect_.width);
            } else {
                this.zoom_rect_.x = this.zoom_start_.x;
            }
            this.zoom_rect_.height = mouseEvent.getY() - this.zoom_start_.y;
            if (this.zoom_rect_.height < 0) {
                this.zoom_rect_.y = mouseEvent.getY();
                this.zoom_rect_.height = Math.abs(this.zoom_rect_.height);
            } else {
                this.zoom_rect_.y = this.zoom_start_.y;
            }
            graphics.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
            graphics.setPaintMode();
        } else if (this.in_move_) {
            bl = true;
            this.moved_ = true;
            Graphics graphics = this.pane_.getGraphics();
            if (!this.draggable_ && this.moveable_) {
                graphics.setColor(Color.red);
                graphics.setXORMode(this.pane_.getBackground());
                graphics.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
            } else if (this.draggable_) {
                ((LayerChild)this.selectedobject_).setVisible(false);
                Rectangle rectangle = ((LayerChild)this.selectedobject_).getBounds();
                this.pane_.repaint(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            }
            this.selectedRect_.x += mouseEvent.getX() - this.move_ref_.x;
            this.selectedRect_.y += mouseEvent.getY() - this.move_ref_.y;
            if (!this.draggable_ && this.moveable_) {
                graphics.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                graphics.setPaintMode();
            } else if (this.draggable_) {
                try {
                    ((LayerChild)this.selectedobject_).setVisible(true);
                    ((Draggable)this.selectedobject_).setLocation(new Point(this.selectedRect_.x, this.selectedRect_.y), false);
                    ((LayerChild)this.selectedobject_).draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
            this.move_ref_ = new Point(mouseEvent.getX(), mouseEvent.getY());
        }
        return bl;
    }

    private boolean Pane_MouseUp(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return false;
        }
        if (this.in_zoom_) {
            this.in_zoom_ = false;
            Graphics graphics = this.pane_.getGraphics();
            graphics.setColor(this.pane_.getForeground());
            graphics.setXORMode(this.pane_.getBackground());
            graphics.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
            this.changes_.firePropertyChange("zoomRectangle", this.old_zoom_rect_, this.zoom_rect_);
            return false;
        }
        if (this.in_move_ && this.moved_) {
            Graphics graphics = this.pane_.getGraphics();
            if (!this.draggable_ && this.moveable_) {
                graphics.setColor(Color.red);
                graphics.setXORMode(this.pane_.getBackground());
                graphics.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                graphics.setPaintMode();
            }
            Point point = new Point(this.selectedRect_.x, this.selectedRect_.y);
            if (this.draggable_) {
                ((Draggable)this.selectedobject_).setLocation(point);
                this.paint(graphics);
            } else if (this.moveable_) {
                ((Moveable)this.selectedobject_).setLocation(point);
                this.modified_ = true;
                this.pane_.repaint();
            }
            this.in_move_ = false;
            this.in_select_ = false;
            this.moved_ = false;
            this.draggable_ = false;
            this.moveable_ = false;
            ((Selectable)this.selectedobject_).setSelected(false);
            this.pane_.setCursor(Cursor.getPredefinedCursor(0));
            return true;
        }
        return false;
    }

    Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    Dimension getMinimumSize() {
        return new Dimension(this.panesize_.width, this.panesize_.height);
    }

    Dimension getPreferredSize() {
        return new Dimension(this.panesize_.width, this.panesize_.height);
    }

    public String toString() {
        String string = this.pane_.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    void setBatch(boolean bl, String string) {
        this.batch_ = bl;
        if (!this.batch_ && this.modified_) {
            this.pane_.repaint();
        }
    }

    boolean isBatch() {
        return this.batch_;
    }

    void setIgnoreModified(boolean bl) {
        this.ignoreModified_ = bl;
    }

    void clearModified() {
        this.modified_ = false;
    }

    void setModified(boolean bl, String string) {
        if (this.ignoreModified_) {
            return;
        }
        this.modified_ = bl;
        if (this.modified_ && !this.batch_) {
            this.pane_.repaint();
        }
    }

    boolean isModified() {
        return this.modified_;
    }

    void setMouseEventsEnabled(boolean bl) {
        this.mouseEventsEnabled_ = bl;
    }

    boolean isMouseEventsEnabled() {
        return this.mouseEventsEnabled_;
    }

    void setPageScaleMode(int n) {
        this.printMode_ = n;
    }

    int getPageScaleMode() {
        return this.printMode_;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }
}

