/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.TimeAxisStyle;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.TimeRange;

class MonthYearAxis
implements TimeAxisStyle {
    static final int YEAR_TEST__ = 31;
    static final String defaultMinorLabelFormat__ = "MMM";
    static final String defaultMajorLabelFormat__ = "yyyy";
    static final int defaultNumSmallTics__ = 0;
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 2;

    public double computeLocation(double d, double d2) {
        return (d + d2) * 0.5;
    }

    public void computeDefaults(GeoDate geoDate) {
        this.defaultMinorLabelInterval_ = geoDate.getTime() / 86400000L > 240L ? 2 : 1;
    }

    public int getMinorValue(GeoDate geoDate) {
        return geoDate.getGMTMonth();
    }

    public int getMajorValue(GeoDate geoDate) {
        return geoDate.getGMTYear();
    }

    public boolean isRoomForMajorLabel(GeoDate geoDate) {
        return geoDate.getTime() / 86400000L > 31L;
    }

    public boolean isStartOfMinor(GeoDate geoDate) {
        return geoDate.getGMTMonth() == 1;
    }

    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    public int getDefaultNumSmallTics() {
        return 0;
    }

    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    public GeoDate getStartTime(TimeRange timeRange) {
        GeoDate geoDate = null;
        boolean bl = timeRange.end.after(timeRange.start);
        try {
            if (bl) {
                geoDate = new GeoDate(timeRange.start.getGMTMonth(), 1, timeRange.start.getGMTYear(), 0, 0, 0, 0);
                if (!geoDate.equals(timeRange.start)) {
                    geoDate.increment(1.0, 2);
                }
            } else {
                geoDate = new GeoDate(timeRange.end.getGMTMonth(), 1, timeRange.end.getGMTYear(), 0, 0, 0, 0);
                if (!geoDate.equals(timeRange.end)) {
                    geoDate.increment(1.0, 2);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return geoDate;
    }

    public double getIncrementValue() {
        return 1.0;
    }

    public int getIncrementUnits() {
        return 2;
    }

    public String toString() {
        return "MonthYearAxis";
    }
}

