/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PaneProxy;
import gov.noaa.pmel.sgt.PlotMark;
import gov.noaa.pmel.sgt.StrokeDrawer;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class LineCartesianRenderer
extends CartesianRenderer {
    private LineAttribute attr_ = null;
    private SGTLine line_ = null;
    private Collection collection_ = null;
    private StrokeDrawer stroke_ = null;

    public Attribute getAttribute() {
        return this.attr_;
    }

    private void drawLine(Graphics graphics, SGTLine sGTLine, LineAttribute lineAttribute) {
        int[] nArray;
        int n;
        int[] nArray2;
        int n2;
        if (sGTLine.isXTime()) {
            long[] lArray = sGTLine.getGeoDateArray().getTime();
            n2 = lArray.length;
            nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[n] = this.cg_.getXUtoD(lArray[n]);
            }
        } else {
            double[] dArray = sGTLine.getXArray();
            n2 = dArray.length;
            nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[n] = this.cg_.getXUtoD(dArray[n]);
            }
        }
        if (sGTLine.isYTime()) {
            long[] lArray = sGTLine.getGeoDateArray().getTime();
            n2 = lArray.length;
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.cg_.getYUtoD(lArray[n]);
            }
        } else {
            double[] dArray = sGTLine.getYArray();
            n2 = dArray.length;
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.cg_.getYUtoD(dArray[n]);
            }
        }
        int n3 = 0;
        int n4 = 0;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        block12: while (n3 < n2) {
            int n5 = -1;
            for (n = n3; n < n2; ++n) {
                if (nArray2[n] != Integer.MIN_VALUE && nArray[n] != Integer.MIN_VALUE) {
                    nArray3[++n5] = nArray2[n];
                    nArray4[n5] = nArray[n];
                    continue;
                }
                if (n5 >= 0) break;
            }
            n3 = n + 1;
            n4 = n5 + 1;
            if (n4 <= 0) {
                return;
            }
            switch (lineAttribute.getStyle()) {
                case 4: {
                    this.drawMark(graphics, nArray3, nArray4, n4, lineAttribute);
                    continue block12;
                }
                case 3: {
                    this.stroke_.drawHighlight(graphics, nArray3, nArray4, n4, lineAttribute);
                    continue block12;
                }
                case 2: {
                    this.stroke_.drawHeavy(graphics, nArray3, nArray4, n4, lineAttribute);
                    continue block12;
                }
                case 1: {
                    this.stroke_.drawDashed(graphics, nArray3, nArray4, n4, lineAttribute);
                    continue block12;
                }
                case 6: {
                    this.stroke_.drawStroke(graphics, nArray3, nArray4, n4, lineAttribute);
                    continue block12;
                }
                case 5: {
                    this.drawMark(graphics, nArray3, nArray4, n4, lineAttribute);
                }
            }
            graphics.drawPolyline(nArray3, nArray4, n4);
        }
    }

    protected void drawMark(Graphics graphics, int[] nArray, int[] nArray2, int n, LineAttribute lineAttribute) {
        Layer layer = this.cg_.getLayer();
        PlotMark plotMark = new PlotMark(lineAttribute);
        for (int i = 0; i < n; ++i) {
            plotMark.paintMark(graphics, layer, nArray[i], nArray2[i]);
        }
    }

    public LineCartesianRenderer(CartesianGraph cartesianGraph) {
        this(cartesianGraph, (SGTLine)null, null);
    }

    public LineCartesianRenderer(CartesianGraph cartesianGraph, SGTLine sGTLine) {
        this(cartesianGraph, sGTLine, null);
        this.cg_ = cartesianGraph;
        this.line_ = sGTLine;
    }

    public LineCartesianRenderer(CartesianGraph cartesianGraph, SGTLine sGTLine, LineAttribute lineAttribute) {
        this.cg_ = cartesianGraph;
        this.line_ = sGTLine;
        this.attr_ = lineAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
        this.stroke_ = PaneProxy.strokeDrawer;
    }

    public LineCartesianRenderer(CartesianGraph cartesianGraph, Collection collection, LineAttribute lineAttribute) {
        this.cg_ = cartesianGraph;
        this.collection_ = collection;
        this.attr_ = lineAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
        this.stroke_ = PaneProxy.strokeDrawer;
    }

    public void draw(Graphics graphics) {
        if (this.cg_.clipping_) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.cg_.xTransform_.isSpace()) {
                n8 = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                n8 = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                n6 = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                n5 = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                n6 = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                n5 = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (n8 < n7) {
                n4 = n8;
                n3 = n7 - n8;
            } else {
                n4 = n7;
                n3 = n8 - n7;
            }
            if (n6 < n5) {
                n2 = n6;
                n = n5 - n6;
            } else {
                n2 = n5;
                n = n6 - n5;
            }
            graphics.setClip(n4, n2, n3, n);
        }
        LineAttribute lineAttribute = this.attr_ == null ? new LineAttribute(0, this.cg_.getPane().getComponent().getForeground()) : this.attr_;
        graphics.setColor(lineAttribute.getColor());
        if (this.collection_ == null) {
            this.drawLine(graphics, this.line_, lineAttribute);
        } else {
            Enumeration enumeration = this.collection_.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof SGTLine)) continue;
                this.drawLine(graphics, (SGTLine)e, lineAttribute);
            }
        }
        Rectangle rectangle = this.cg_.getLayer().getPane().getBounds();
        graphics.setClip(rectangle);
    }

    public void setLineAttribute(LineAttribute lineAttribute) {
        if (this.attr_ != null) {
            this.attr_.removePropertyChangeListener(this);
        }
        this.attr_ = lineAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public LineAttribute getLineAttribute() {
        return this.attr_;
    }

    public boolean hasCollection() {
        return this.collection_ != null;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public SGTLine getLine() {
        return this.line_;
    }

    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("LineCartesianRenderer: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    public SGTData getDataAt(Point point) {
        return null;
    }
}

