/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.AttributeChangeEvent;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class LineAttribute
implements Attribute,
Cloneable {
    protected transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private boolean batch_ = false;
    private boolean local_ = true;
    private boolean modified_ = false;
    private String id_ = null;
    private Color color_ = Color.black;
    private int style_;
    private int mark_ = 1;
    private double markHeightP_ = 0.2;
    private float width_ = 2.0f;
    private float[] dashes_ = new float[]{12.0f, 12.0f};
    private float dashPhase_ = 0.0f;
    private int cap_style_ = 2;
    private int miter_style_ = 0;
    private float miter_limit_ = 10.0f;
    private static float HEAVY_WIDTH = 2.0f;
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int HEAVY = 2;
    public static final int HIGHLIGHT = 3;
    public static final int MARK = 4;
    public static final int MARK_LINE = 5;
    public static final int STROKE = 6;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;

    public LineAttribute() {
        this(0, Color.red);
    }

    public LineAttribute(int n) {
        this.style_ = n;
        if (this.style_ == 2) {
            this.width_ = HEAVY_WIDTH;
        }
    }

    public LineAttribute(int n, Color color) {
        this(n, 1, color);
    }

    public LineAttribute(int n, int n2, Color color) {
        this.style_ = n;
        this.mark_ = n2;
        this.color_ = color;
    }

    public Object copy() {
        LineAttribute lineAttribute;
        try {
            lineAttribute = (LineAttribute)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            lineAttribute = new LineAttribute();
        }
        return lineAttribute;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LineAttribute)) {
            return false;
        }
        LineAttribute lineAttribute = (LineAttribute)object;
        if (this.id_ != lineAttribute.getId() || !this.color_.equals(lineAttribute.getColor()) || this.style_ != lineAttribute.getStyle()) {
            return false;
        }
        if (!(this.style_ != 4 && this.style_ != 5 || this.mark_ == lineAttribute.getMark() && this.markHeightP_ == lineAttribute.getMarkHeightP())) {
            return false;
        }
        if (this.style_ == 2 && this.width_ != lineAttribute.getWidth()) {
            return false;
        }
        if (this.style_ == 6) {
            if (this.width_ != lineAttribute.getWidth()) {
                return false;
            }
            if (this.dashes_.length != lineAttribute.getDashArray().length) {
                return false;
            }
            float[] fArray = lineAttribute.getDashArray();
            for (int i = 0; i < this.dashes_.length; ++i) {
                if (this.dashes_[i] == fArray[i]) continue;
                return false;
            }
            if (this.dashPhase_ != lineAttribute.getDashPhase() || this.cap_style_ != lineAttribute.getCapStyle() || this.miter_style_ != lineAttribute.getMiterStyle() || this.miter_limit_ != lineAttribute.getMiterLimit()) {
                return false;
            }
        }
        return true;
    }

    public void setMarkHeightP(double d) {
        if (this.markHeightP_ != d) {
            Double d2 = new Double(this.markHeightP_);
            this.markHeightP_ = d;
            this.firePropertyChange("markHeightP", d2, new Double(this.markHeightP_));
        }
    }

    public double getMarkHeightP() {
        return this.markHeightP_;
    }

    public void setStyle(int n) {
        if (this.style_ != n) {
            Integer n2 = new Integer(this.style_);
            this.style_ = n;
            this.firePropertyChange("style", n2, new Integer(this.style_));
        }
    }

    public void setColor(Color color) {
        if (!this.color_.equals(color)) {
            Color color2 = this.color_;
            this.color_ = color;
            this.firePropertyChange("color", color2, this.color_);
        }
    }

    public void setWidth(float f) {
        if (this.width_ != f) {
            Float f2 = new Float(this.width_);
            this.width_ = f;
            this.firePropertyChange("width", f2, new Float(this.width_));
        }
    }

    public void setDashArray(float[] fArray) {
        if (fArray == null) {
            return;
        }
        boolean bl = false;
        if (this.dashes_.length != fArray.length) {
            bl = true;
        } else {
            for (int i = 0; i < this.dashes_.length; ++i) {
                if (this.dashes_[i] == fArray[i]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            float[] fArray2 = this.dashes_;
            this.dashes_ = fArray;
            this.firePropertyChange("dashArray", fArray2, this.dashes_);
        }
    }

    public float[] getDashArray() {
        return this.dashes_;
    }

    public void setDashPhase(float f) {
        if (this.dashPhase_ != f) {
            Float f2 = new Float(this.dashPhase_);
            this.dashPhase_ = f;
            this.firePropertyChange("dashPhase", f2, new Float(this.dashPhase_));
        }
    }

    public float getDashPhase() {
        return this.dashPhase_;
    }

    public int getStyle() {
        return this.style_;
    }

    public Color getColor() {
        return this.color_;
    }

    public float getWidth() {
        return this.width_;
    }

    public void setMark(int n) {
        if (this.mark_ != n) {
            Integer n2 = new Integer(this.mark_);
            if (n <= 0) {
                n = 1;
            }
            if (n > 51) {
                n = 51;
            }
            this.mark_ = n;
            this.firePropertyChange("mark", n2, new Integer(this.mark_));
        }
    }

    public int getMark() {
        return this.mark_;
    }

    public void setCapStyle(int n) {
        if (this.cap_style_ != n) {
            Integer n2 = new Integer(this.cap_style_);
            this.cap_style_ = n;
            this.firePropertyChange("capStyle", n2, new Integer(this.cap_style_));
        }
    }

    public int getCapStyle() {
        return this.cap_style_;
    }

    public void setMiterStyle(int n) {
        if (this.miter_style_ != n) {
            Integer n2 = new Integer(this.miter_style_);
            this.miter_style_ = n;
            this.firePropertyChange("miterStyle", n2, new Integer(this.miter_style_));
        }
    }

    public int getMiterStyle() {
        return this.miter_style_;
    }

    public void setMiterLimit(float f) {
        if (this.miter_limit_ != f) {
            Float f2 = new Float(this.miter_limit_);
            this.miter_limit_ = f;
            this.firePropertyChange("miterLimit", f2, new Float(this.miter_limit_));
        }
    }

    public float getMiterLimit() {
        return this.miter_limit_;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void setId(String string) {
        this.id_ = string;
    }

    public String getId() {
        return this.id_;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.batch_) {
            this.modified_ = true;
            return;
        }
        AttributeChangeEvent attributeChangeEvent = new AttributeChangeEvent(this, string, object, object2, this.local_);
        this.changes_.firePropertyChange(attributeChangeEvent);
        this.modified_ = false;
    }

    public void setBatch(boolean bl) {
        this.setBatch(bl, true);
    }

    public void setBatch(boolean bl, boolean bl2) {
        this.local_ = bl2;
        this.batch_ = bl;
        if (!bl && this.modified_) {
            this.firePropertyChange("batch", Boolean.TRUE, Boolean.FALSE);
        }
    }

    public boolean isBatch() {
        return this.batch_;
    }
}

