/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ChildNotFoundException;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerControl;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.LineKey;
import gov.noaa.pmel.sgt.PaneNotFoundException;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.PointCollectionKey;
import gov.noaa.pmel.sgt.VectorKey;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.swing.Draggable;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class Layer
extends Component
implements Cloneable,
LayerControl {
    private String ident_;
    private Graph graph_;
    private Vector children_;
    private double pWidth_;
    private double pHeight_;
    private double ax_;
    private double ay_;
    private int xoff_;
    private int yoff_;
    private double xoff2_;
    private double yoff2_;
    protected AbstractPane pane_;

    private void computeScale() {
        boolean bl = this.getGraphics() instanceof Graphics2D;
        Rectangle rectangle = this.pane_.getBounds();
        Rectangle rectangle2 = this.getBounds();
        if (this.pane_.isPrinter()) {
            this.ay_ = this.ax_ = 72.0;
            this.xoff2_ = ((double)rectangle2.width - this.ax_ * this.pWidth_) / 2.0 + (double)rectangle2.x;
            this.yoff2_ = (double)rectangle2.height - ((double)rectangle2.height - this.ay_ * this.pHeight_) / 2.0 + (double)rectangle2.y;
        } else {
            this.ax_ = (double)rectangle2.width / this.pWidth_;
            this.ay_ = (double)rectangle2.height / this.pHeight_;
            if (this.ax_ > this.ay_) {
                this.ax_ = this.ay_;
            } else if (this.ay_ > this.ax_) {
                this.ay_ = this.ax_;
            }
            this.xoff2_ = ((double)rectangle2.width - this.ax_ * this.pWidth_) / 2.0 + (double)rectangle2.x - (double)rectangle.x;
            this.yoff2_ = (double)rectangle2.height - ((double)rectangle2.height - this.ay_ * this.pHeight_) / 2.0 + (double)rectangle2.y - (double)rectangle.y;
        }
        this.xoff_ = (int)this.xoff2_;
        this.yoff_ = (int)this.yoff2_;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.computeScale();
        this.modified("Layer: setSize(Dimension)");
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.computeScale();
        this.modified("Layer: setSize(int,int)");
    }

    public void setLocation(Point point) {
        super.setLocation(point);
        this.computeScale();
        this.modified("Layer: setLocation(Point)");
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        this.computeScale();
        this.modified("Layer: setLocation(int,int)");
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.computeScale();
        this.modified("Layer: setBounds(int,int,int,int)");
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.computeScale();
        this.modified("Layer: setBounds(Rectangle)");
    }

    public int getXPtoD(double d) {
        return (int)(this.ax_ * d) + this.xoff_;
    }

    public int getYPtoD(double d) {
        return this.yoff_ - (int)(this.ay_ * d);
    }

    public double getXPtoD2(double d) {
        return this.ax_ * d + this.xoff2_;
    }

    public double getYPtoD2(double d) {
        return this.yoff2_ - this.ay_ * d;
    }

    protected double getXSlope() {
        return this.ax_;
    }

    protected double getYSlope() {
        return this.ay_;
    }

    protected double getXOffset() {
        return this.xoff2_;
    }

    protected double getYOffset() {
        return this.yoff2_;
    }

    public double getXDtoP(int n) {
        return ((double)n - this.xoff2_) / this.ax_;
    }

    public double getYDtoP(int n) {
        return (this.yoff2_ - (double)n) / this.ay_;
    }

    public Layer(String string) {
        this(string, new Dimension2D(1.0, 1.0));
    }

    public Layer(String string, Dimension2D dimension2D) {
        this.ident_ = string;
        this.pWidth_ = dimension2D.width;
        this.pHeight_ = dimension2D.height;
        this.children_ = new Vector(5, 5);
    }

    public Layer() {
        this("");
    }

    public Layer copy() {
        Object object;
        Layer layer;
        try {
            layer = (Layer)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            layer = new Layer(this.ident_, new Dimension2D(this.pWidth_, this.pHeight_));
        }
        layer.children_ = new Vector(5, 5);
        if (!this.children_.isEmpty()) {
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                object = ((LayerChild)enumeration.nextElement()).copy();
                layer.addChild((LayerChild)object);
            }
        }
        if (this.graph_ != (Graph)null) {
            object = this.graph_.copy();
            layer.setGraph((Graph)object);
        }
        return layer;
    }

    public void draw(Graphics graphics) throws PaneNotFoundException {
        if (this.pane_ == null) {
            throw new PaneNotFoundException();
        }
        this.computeScale();
        if (this.graph_ != (Graph)null) {
            this.graph_.draw(graphics);
        }
        if (!this.children_.isEmpty()) {
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                LayerChild layerChild = (LayerChild)enumeration.nextElement();
                if (layerChild instanceof Draggable) continue;
                try {
                    layerChild.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        }
    }

    public void drawDraggableItems(Graphics graphics) throws PaneNotFoundException {
        if (this.pane_ == null) {
            throw new PaneNotFoundException();
        }
        if (!this.children_.isEmpty()) {
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                LayerChild layerChild = (LayerChild)enumeration.nextElement();
                if (!(layerChild instanceof Draggable)) continue;
                try {
                    layerChild.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        }
    }

    public boolean setGraph(Graph graph) {
        this.graph_ = graph;
        this.graph_.setLayer(this);
        this.modified("Layer: setGraph()");
        return true;
    }

    public Graph getGraph() {
        return this.graph_;
    }

    public void addChild(LayerChild layerChild) {
        layerChild.setLayer(this);
        this.children_.addElement(layerChild);
        this.modified("Layer: addChild()");
    }

    public void removeChild(LayerChild layerChild) throws ChildNotFoundException {
        if (!this.children_.isEmpty()) {
            boolean bl = false;
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                LayerChild layerChild2 = (LayerChild)enumeration.nextElement();
                if (!layerChild2.equals(layerChild)) continue;
                this.children_.removeElement(layerChild);
                bl = true;
                this.modified("Layer: removeChild(LayerChild)");
            }
            if (!bl) {
                throw new ChildNotFoundException();
            }
        } else {
            throw new ChildNotFoundException();
        }
    }

    public void removeChild(String string) throws ChildNotFoundException {
        if (!this.children_.isEmpty()) {
            boolean bl = false;
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                LayerChild layerChild = (LayerChild)enumeration.nextElement();
                if (!layerChild.getId().equals(string)) continue;
                this.children_.removeElement(layerChild);
                bl = true;
                this.modified("Layer: removeChild(String)");
            }
            if (!bl) {
                throw new ChildNotFoundException();
            }
        } else {
            throw new ChildNotFoundException();
        }
    }

    public LayerChild findChild(String string) {
        LayerChild layerChild = null;
        Enumeration enumeration = this.children_.elements();
        while (enumeration.hasMoreElements()) {
            layerChild = (LayerChild)enumeration.nextElement();
            if (!layerChild.getId().equals(string)) continue;
            return layerChild;
        }
        return null;
    }

    public boolean isChildAttached(LayerChild layerChild) {
        boolean bl = false;
        if (!this.children_.isEmpty()) {
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                LayerChild layerChild2 = (LayerChild)enumeration.nextElement();
                if (!layerChild2.equals(layerChild)) continue;
                this.children_.removeElement(layerChild);
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void removeAllChildren() {
        this.children_.removeAllElements();
        this.modified("Layer: removeAllChildren()");
    }

    public LayerChild getChild(String string) throws ChildNotFoundException {
        if (!this.children_.isEmpty()) {
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                LayerChild layerChild = (LayerChild)enumeration.nextElement();
                if (layerChild.getId() != string) continue;
                return layerChild;
            }
            throw new ChildNotFoundException();
        }
        throw new ChildNotFoundException();
    }

    public Enumeration childElements() {
        return this.children_.elements();
    }

    public Iterator childIterator() {
        return this.children_.iterator();
    }

    public LayerChild[] getChildren() {
        LayerChild[] layerChildArray = new LayerChild[]{};
        layerChildArray = this.children_.toArray(layerChildArray);
        return layerChildArray;
    }

    public void setSizeP(Dimension2D dimension2D) {
        this.pWidth_ = dimension2D.width;
        this.pHeight_ = dimension2D.height;
        this.computeScale();
        this.modified("Layer: setSizeP()");
    }

    public Dimension2D getSizeP() {
        return new Dimension2D(this.pWidth_, this.pHeight_);
    }

    public Rectangle2D.Double getBoundsP() {
        return new Rectangle2D.Double(0.0, 0.0, this.pWidth_, this.pHeight_);
    }

    public String getId() {
        return this.ident_;
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public void setPane(AbstractPane abstractPane) {
        this.pane_ = abstractPane;
        this.computeScale();
        this.modified("Layer: setPane()");
    }

    public AbstractPane getPane() {
        return this.pane_;
    }

    public void modified(String string) {
        if (this.pane_ != null) {
            this.pane_.setModified(true, string);
        }
    }

    public Object getObjectAt(int n, int n2, boolean bl) {
        return this.getObjectAt(new Point(n, n2), bl);
    }

    public Object getObjectAt(int n, int n2) {
        return this.getObjectAt(new Point(n, n2), true);
    }

    public Object getObjectAt(Point point, boolean bl) {
        Object object;
        if (!this.children_.isEmpty()) {
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                LayerChild layerChild = (LayerChild)enumeration.nextElement();
                Rectangle rectangle = layerChild.getBounds();
                if (!rectangle.contains(point) || bl && !layerChild.isSelectable() || !layerChild.isVisible()) continue;
                if (layerChild instanceof LineKey) {
                    return ((LineKey)layerChild).getObjectAt(point);
                }
                if (layerChild instanceof PointCollectionKey) {
                    return ((PointCollectionKey)layerChild).getObjectAt(point);
                }
                if (layerChild instanceof VectorKey) {
                    return ((VectorKey)layerChild).getObjectAt(point);
                }
                return layerChild;
            }
        }
        if (this.graph_ != null && (object = this.graph_.getObjectAt(point)) != null) {
            return object;
        }
        return null;
    }

    public Object[] getObjectsAt(int n, int n2, boolean bl) {
        Point point = new Point(n, n2);
        Vector<Object> vector = new Vector<Object>();
        Object object = null;
        if (!this.children_.isEmpty()) {
            Enumeration enumeration = this.children_.elements();
            while (enumeration.hasMoreElements()) {
                LayerChild layerChild = (LayerChild)enumeration.nextElement();
                Rectangle rectangle = layerChild.getBounds();
                if (!rectangle.contains(point) || bl && !layerChild.isSelectable() || !layerChild.isVisible()) continue;
                if (layerChild instanceof LineKey) {
                    object = ((LineKey)layerChild).getObjectAt(point);
                    if (object == null) continue;
                    vector.add(object);
                    continue;
                }
                if (layerChild instanceof PointCollectionKey) {
                    object = ((PointCollectionKey)layerChild).getObjectAt(point);
                    if (object == null) continue;
                    vector.add(object);
                    continue;
                }
                if (layerChild instanceof VectorKey) {
                    object = ((VectorKey)layerChild).getObjectAt(point);
                    if (object == null) continue;
                    vector.add(object);
                    continue;
                }
                if (layerChild == null) continue;
                vector.add(layerChild);
            }
        }
        if (this.graph_ != null && (object = this.graph_.getObjectAt(point)) != null) {
            vector.add(object);
        }
        return vector.toArray();
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDataInLayer(String string) {
        if (!(this.graph_ instanceof CartesianGraph)) return false;
        CartesianRenderer cartesianRenderer = ((CartesianGraph)this.graph_).getRenderer();
        if (cartesianRenderer instanceof LineCartesianRenderer) {
            if (!((LineCartesianRenderer)cartesianRenderer).hasCollection()) return ((LineCartesianRenderer)cartesianRenderer).getLine().getId().equals(string);
            Collection collection = ((LineCartesianRenderer)cartesianRenderer).getCollection();
            if (!collection.getId().equals(string)) return false;
            return true;
        }
        if (cartesianRenderer instanceof GridCartesianRenderer) {
            return ((GridCartesianRenderer)cartesianRenderer).getGrid().getId().equals(string);
        }
        if (!(cartesianRenderer instanceof PointCartesianRenderer)) return false;
        if (!((PointCartesianRenderer)cartesianRenderer).hasCollection()) return ((PointCartesianRenderer)cartesianRenderer).getPoint().getId().equals(string);
        Collection collection = ((PointCartesianRenderer)cartesianRenderer).getCollection();
        if (!collection.getId().equals(string)) return false;
        return true;
    }
}

