/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.IndexedColor;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Transform;
import gov.noaa.pmel.sgt.TransformAccess;
import gov.noaa.pmel.util.Range2D;
import java.awt.Color;
import java.beans.PropertyChangeListener;

public class IndexedColorMap
extends ColorMap
implements Cloneable,
PropertyChangeListener,
IndexedColor,
TransformAccess {
    protected Color[] colors_;
    private Transform iTrans_ = new LinearTransform(0.0, 1.0, 0.0, 1.0);

    public IndexedColorMap(int[] nArray, int[] nArray2, int[] nArray3) {
        this.colors_ = new Color[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.colors_[i] = new Color(nArray[i], nArray2[i], nArray3[i]);
        }
        this.iTrans_.setRangeP(0.0, this.colors_.length);
    }

    public IndexedColorMap(float[] fArray, float[] fArray2, float[] fArray3) {
        this.colors_ = new Color[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.colors_[i] = new Color(fArray[i], fArray2[i], fArray3[i]);
        }
        this.iTrans_.setRangeP(0.0, this.colors_.length);
    }

    public IndexedColorMap(Color[] colorArray) {
        this.colors_ = colorArray;
        this.iTrans_.setRangeP(0.0, this.colors_.length);
    }

    public ColorMap copy() {
        ColorMap colorMap;
        try {
            colorMap = (ColorMap)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            colorMap = new IndexedColorMap(this.colors_);
        }
        return colorMap;
    }

    public Color getColorByIndex(int n) {
        return this.colors_[n];
    }

    public Color getColor(double d) {
        double d2 = d;
        int n = (int)Math.round(this.iTrans_.getTransP(d2));
        if (n < 0) {
            n = 0;
        }
        if (n > this.colors_.length - 1) {
            n = this.colors_.length - 1;
        }
        return this.colors_[n];
    }

    public void setRange(Range2D range2D) {
        this.iTrans_.setRangeU(range2D);
    }

    public Range2D getRange() {
        return this.iTrans_.getRangeU();
    }

    public void setColor(int n, Color color) {
        this.setColor(n, color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setColor(int n, int n2, int n3, int n4) {
        if (n < 0 || n > this.colors_.length) {
            return;
        }
        Color color = new Color(n2, n3, n4);
        if (!this.colors_[n].equals(color)) {
            Color color2 = this.colors_[n];
            this.colors_[n] = color;
            this.firePropertyChange("color", color2, color);
        }
    }

    public int getMaximumIndex() {
        return this.colors_.length - 1;
    }

    public void setTransform(Transform transform) {
        if (!transform.equals(this.iTrans_)) {
            Transform transform2 = this.iTrans_;
            if (this.iTrans_ != null) {
                this.iTrans_.removePropertyChangeListener(this);
            }
            this.iTrans_ = transform;
            this.iTrans_.setRangeP(0.0, this.colors_.length);
            this.firePropertyChange("transform", transform2, this.iTrans_);
            this.iTrans_.addPropertyChangeListener(this);
        }
    }

    public Transform getTransform() {
        return this.iTrans_;
    }

    public boolean equals(ColorMap colorMap) {
        if (colorMap == null || !(colorMap instanceof IndexedColorMap)) {
            return false;
        }
        if (!this.iTrans_.equals(((IndexedColorMap)colorMap).iTrans_)) {
            return false;
        }
        if (this.colors_.length != ((IndexedColorMap)colorMap).colors_.length) {
            return false;
        }
        for (int i = 0; i < this.colors_.length; ++i) {
            if (this.colors_[i].equals(((IndexedColorMap)colorMap).colors_[i])) continue;
            return false;
        }
        return true;
    }
}

