/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.TimeAxisStyle;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.TimeRange;

class HourDayAxis
implements TimeAxisStyle {
    static final int HOUR_TEST__ = 4;
    static final String defaultMinorLabelFormat__ = "HH";
    static final String defaultMajorLabelFormat__ = "yyyy-MM-dd";
    static final int defaultNumSmallTics__ = 0;
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 5;

    public double computeLocation(double d, double d2) {
        return d;
    }

    public void computeDefaults(GeoDate geoDate) {
        long l = geoDate.getTime() / 86400000L;
        long l2 = geoDate.getTime() % 86400000L;
        this.defaultMinorLabelInterval_ = l > 2L ? 6 : (l > 0L || l2 > 43200000L ? 2 : 1);
    }

    public int getMinorValue(GeoDate geoDate) {
        return geoDate.getGMTHours();
    }

    public int getMajorValue(GeoDate geoDate) {
        return geoDate.getGMTDay();
    }

    public boolean isRoomForMajorLabel(GeoDate geoDate) {
        return 24.0 * ((double)geoDate.getTime() / 8.64E7) > 4.0;
    }

    public boolean isStartOfMinor(GeoDate geoDate) {
        return geoDate.getGMTHours() == 0;
    }

    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    public int getDefaultNumSmallTics() {
        return 0;
    }

    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    public GeoDate getStartTime(TimeRange timeRange) {
        GeoDate geoDate = null;
        boolean bl = timeRange.end.after(timeRange.start);
        try {
            if (bl) {
                geoDate = new GeoDate(timeRange.start.getGMTMonth(), timeRange.start.getGMTDay(), timeRange.start.getGMTYear(), timeRange.start.getGMTHours(), 0, 0, 0);
                if (!geoDate.equals(timeRange.start)) {
                    geoDate.increment(1.0f, 5);
                }
            } else {
                geoDate = new GeoDate(timeRange.end.getGMTMonth(), timeRange.end.getGMTDay(), timeRange.end.getGMTYear(), timeRange.end.getGMTHours(), 0, 0, 0);
                if (!geoDate.equals(timeRange.end)) {
                    geoDate.increment(1.0f, 5);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return geoDate;
    }

    public double getIncrementValue() {
        return 1.0;
    }

    public int getIncrementUnits() {
        return 5;
    }

    public String toString() {
        return "HourDayAxis";
    }
}

