/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.Format;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.IndexedColor;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.contour.Contour;
import gov.noaa.pmel.sgt.contour.ContourLine;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class GridCartesianRenderer
extends CartesianRenderer {
    private SGTGrid grid_;
    private GridAttribute attr_ = null;
    private Contour con_ = null;

    private void drawRaster(Graphics graphics) {
        int[] nArray;
        int n;
        int n2;
        int[] nArray2;
        int n3;
        GeoDate[] geoDateArray;
        if (this.grid_.isXTime()) {
            if (this.grid_.getTimeArray().length <= 2) {
                return;
            }
            if (this.grid_.hasXEdges()) {
                geoDateArray = this.grid_.getTimeEdges();
                n3 = geoDateArray.length;
                nArray2 = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray2[n2] = this.cg_.getXUtoD(geoDateArray[n2]);
                }
            } else {
                geoDateArray = this.grid_.getTimeArray();
                n3 = geoDateArray.length;
                nArray2 = new int[n3 + 1];
                nArray2[0] = this.cg_.getXUtoD(geoDateArray[0].subtract(geoDateArray[1].subtract(geoDateArray[0]).divide(2.0)));
                for (n2 = 1; n2 < n3; ++n2) {
                    nArray2[n2] = this.cg_.getXUtoD(geoDateArray[n2 - 1].add(geoDateArray[n2]).divide(2.0));
                }
                nArray2[n3] = this.cg_.getXUtoD(geoDateArray[n3 - 1].add(geoDateArray[n3 - 1].subtract(geoDateArray[n3 - 2]).divide(2.0)));
            }
        } else {
            double[] dArray;
            if (this.grid_.getXArray().length <= 2) {
                return;
            }
            if (this.grid_.hasXEdges()) {
                dArray = this.grid_.getXEdges();
                n3 = dArray.length;
                nArray2 = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray2[n2] = this.cg_.getXUtoD(dArray[n2]);
                }
            } else {
                dArray = this.grid_.getXArray();
                n3 = dArray.length;
                nArray2 = new int[n3 + 1];
                nArray2[0] = this.cg_.getXUtoD(dArray[0] - (dArray[1] - dArray[0]) * 0.5);
                for (n2 = 1; n2 < n3; ++n2) {
                    nArray2[n2] = this.cg_.getXUtoD((dArray[n2 - 1] + dArray[n2]) * 0.5);
                }
                nArray2[n3] = this.cg_.getXUtoD(dArray[n3 - 1] + (dArray[n3 - 1] - dArray[n3 - 2]) * 0.5);
            }
        }
        if (this.grid_.isYTime()) {
            if (this.grid_.getTimeArray().length <= 2) {
                return;
            }
            if (this.grid_.hasYEdges()) {
                geoDateArray = this.grid_.getTimeEdges();
                n = geoDateArray.length;
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = this.cg_.getYUtoD(geoDateArray[n2]);
                }
            } else {
                geoDateArray = this.grid_.getTimeArray();
                n = geoDateArray.length;
                nArray = new int[n + 1];
                nArray[0] = this.cg_.getYUtoD(geoDateArray[0].subtract(geoDateArray[1].subtract(geoDateArray[0]).divide(2.0)));
                for (n2 = 1; n2 < n; ++n2) {
                    nArray[n2] = this.cg_.getYUtoD(geoDateArray[n2 - 1].add(geoDateArray[n2]).divide(2.0));
                }
                nArray[n] = this.cg_.getYUtoD(geoDateArray[n - 1].add(geoDateArray[n - 1].subtract(geoDateArray[n - 2]).divide(2.0)));
            }
        } else {
            double[] dArray;
            if (this.grid_.getYArray().length <= 2) {
                return;
            }
            if (this.grid_.hasYEdges()) {
                dArray = this.grid_.getYEdges();
                n = dArray.length;
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = this.cg_.getYUtoD(dArray[n2]);
                }
            } else {
                dArray = this.grid_.getYArray();
                n = dArray.length;
                nArray = new int[n + 1];
                nArray[0] = this.cg_.getYUtoD(dArray[0] - (dArray[1] - dArray[0]) * 0.5);
                for (n2 = 1; n2 < n; ++n2) {
                    nArray[n2] = this.cg_.getYUtoD((dArray[n2 - 1] + dArray[n2]) * 0.5);
                }
                nArray[n] = this.cg_.getYUtoD(dArray[n - 1] + (dArray[n - 1] - dArray[n - 2]) * 0.5);
            }
        }
        double[] dArray = this.grid_.getZArray();
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = dArray[n2];
                if (!Double.isNaN(d)) {
                    Color color = this.attr_.getColorMap().getColor(d);
                    graphics.setColor(color);
                    this.drawRect(graphics, nArray2[i], nArray[j], nArray2[i + 1], nArray[j + 1]);
                }
                ++n2;
            }
        }
    }

    public Attribute getAttribute() {
        return this.attr_;
    }

    public void setAttribute(GridAttribute gridAttribute) {
        if (this.attr_ != null) {
            this.attr_.removePropertyChangeListener(this);
        }
        this.attr_ = gridAttribute;
        this.attr_.addPropertyChangeListener(this);
    }

    private void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n < n3) {
            n8 = n;
            n7 = n3 - n;
        } else {
            n8 = n3;
            n7 = n - n3;
        }
        if (n2 < n4) {
            n6 = n2;
            n5 = n4 - n2;
        } else {
            n6 = n4;
            n5 = n2 - n4;
        }
        graphics.fillRect(n8, n6, n7, n5);
    }

    public GridCartesianRenderer(CartesianGraph cartesianGraph) {
        this(cartesianGraph, null, null);
    }

    public GridCartesianRenderer(CartesianGraph cartesianGraph, SGTGrid sGTGrid) {
        this(cartesianGraph, sGTGrid, null);
    }

    public GridCartesianRenderer(CartesianGraph cartesianGraph, SGTGrid sGTGrid, GridAttribute gridAttribute) {
        this.cg_ = cartesianGraph;
        this.grid_ = sGTGrid;
        this.attr_ = gridAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public void draw(Graphics graphics) {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.cg_.clipping_) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.cg_.xTransform_.isSpace()) {
                n8 = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                n8 = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                n6 = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                n4 = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                n6 = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                n4 = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (n8 < n7) {
                n3 = n8;
                n2 = n7 - n8;
            } else {
                n3 = n7;
                n2 = n8 - n7;
            }
            if (n6 < n4) {
                n = n6;
                n5 = n4 - n6;
            } else {
                n = n4;
                n5 = n6 - n4;
            }
            graphics.setClip(n3, n, n2, n5);
        }
        if (this.attr_.isRaster()) {
            this.drawRaster(graphics);
        }
        if (this.attr_.isAreaFill()) {
            double[] dArray = this.xArrayP();
            double[] dArray2 = this.yArrayP();
            double[] dArray3 = this.grid_.getZArray();
            n = dArray.length;
            n2 = dArray2.length;
            double[] dArray4 = new double[5];
            object = new double[5];
            double[] dArray5 = new double[5];
            for (n4 = 0; n4 < n - 1; ++n4) {
                for (n3 = 0; n3 < n2 - 1; ++n3) {
                    dArray4[0] = dArray[n4];
                    object[0] = dArray2[n3];
                    dArray5[0] = dArray3[n3 + n4 * n2];
                    dArray4[1] = dArray[n4 + 1];
                    object[1] = dArray2[n3];
                    dArray5[1] = dArray3[n3 + (n4 + 1) * n2];
                    dArray4[2] = dArray[n4 + 1];
                    object[2] = dArray2[n3 + 1];
                    dArray5[2] = dArray3[n3 + 1 + (n4 + 1) * n2];
                    dArray4[3] = dArray4[0];
                    object[3] = object[2];
                    dArray5[3] = dArray3[n3 + 1 + n4 * n2];
                    dArray4[4] = dArray4[0];
                    object[4] = object[0];
                    dArray5[4] = dArray5[0];
                    this.fillSquare(graphics, dArray4, (double[])object, dArray5);
                }
            }
        }
        if (this.attr_.isContour()) {
            Range2D range2D = this.computeRange(10);
            this.con_ = new Contour(this.cg_, this.grid_, this.attr_.getContourLevels());
            ContourLevels contourLevels = this.con_.getContourLevels();
            for (int i = 0; i < contourLevels.size(); ++i) {
                try {
                    double d = contourLevels.getLevel(i);
                    DefaultContourLineAttribute defaultContourLineAttribute = contourLevels.getDefaultContourLineAttribute(i);
                    if (!defaultContourLineAttribute.isAutoLabel()) continue;
                    Format format = defaultContourLineAttribute.getLabelFormat().length() <= 0 ? new Format(Format.computeFormat(range2D.start, range2D.end, defaultContourLineAttribute.getSignificantDigits())) : new Format(defaultContourLineAttribute.getLabelFormat());
                    String string = format.form(d);
                    defaultContourLineAttribute.setLabelText(string);
                    continue;
                }
                catch (ContourLevelNotFoundException contourLevelNotFoundException) {
                    System.out.println(contourLevelNotFoundException);
                }
            }
            this.con_.generateContourLines();
            this.con_.generateContourLabels(graphics);
            Enumeration enumeration = this.con_.elements();
            while (enumeration.hasMoreElements()) {
                object = (ContourLine)enumeration.nextElement();
                ((ContourLine)object).draw(graphics);
            }
        }
        Rectangle rectangle = this.cg_.getLayer().getPane().getBounds();
        graphics.setClip(rectangle);
    }

    private void fillSquare(Graphics graphics, double[] dArray, double[] dArray2, double[] dArray3) {
        ContourLevels contourLevels = this.attr_.getContourLevels();
        IndexedColor indexedColor = (IndexedColor)((Object)this.attr_.getColorMap());
        double[] dArray4 = new double[20];
        double[] dArray5 = new double[20];
        double d = Math.min(dArray3[0], dArray3[1]);
        double d2 = Math.max(dArray3[0], dArray3[1]);
        for (int i = 2; i <= 3; ++i) {
            d = Math.min(d, dArray3[i]);
            d2 = Math.max(d2, dArray3[i]);
        }
        if (Double.isNaN(d2)) {
            return;
        }
        int n = contourLevels.getMaximumIndex();
        for (int i = -1; i <= n; ++i) {
            double d3;
            double d4;
            try {
                d4 = i == -1 ? -1.7976931348623157E308 : contourLevels.getLevel(i);
                d3 = i == n ? Double.MAX_VALUE : contourLevels.getLevel(i + 1);
            }
            catch (ContourLevelNotFoundException contourLevelNotFoundException) {
                System.out.println(contourLevelNotFoundException);
                break;
            }
            Color color = indexedColor.getColorByIndex(i + 1);
            if (d > d3 || d2 < d4) continue;
            if (d >= d4 && d2 <= d3) {
                this.fillPolygon(graphics, color, dArray, dArray2, 4);
                return;
            }
            int n2 = -1;
            for (int j = 0; j < 4; ++j) {
                double d5;
                if (dArray3[j] < d4) {
                    if (dArray3[j + 1] > d3) {
                        d5 = (dArray3[j] - d4) / (dArray3[j] - dArray3[j + 1]);
                        dArray4[++n2] = dArray[j] - d5 * (dArray[j] - dArray[j + 1]);
                        dArray5[n2] = dArray2[j] - d5 * (dArray2[j] - dArray2[j + 1]);
                        d5 = (dArray3[j] - d3) / (dArray3[j] - dArray3[j + 1]);
                        dArray4[++n2] = dArray[j] - d5 * (dArray[j] - dArray[j + 1]);
                        dArray5[n2] = dArray2[j] - d5 * (dArray2[j] - dArray2[j + 1]);
                        continue;
                    }
                    if (!(dArray3[j + 1] >= d4) || !(dArray3[j + 1] <= d3)) continue;
                    d5 = (dArray3[j] - d4) / (dArray3[j] - dArray3[j + 1]);
                    dArray4[++n2] = dArray[j] - d5 * (dArray[j] - dArray[j + 1]);
                    dArray5[n2] = dArray2[j] - d5 * (dArray2[j] - dArray2[j + 1]);
                    dArray4[++n2] = dArray[j + 1];
                    dArray5[n2] = dArray2[j + 1];
                    continue;
                }
                if (dArray3[j] > d3) {
                    if (dArray3[j + 1] < d4) {
                        d5 = (dArray3[j] - d3) / (dArray3[j] - dArray3[j + 1]);
                        dArray4[++n2] = dArray[j] - d5 * (dArray[j] - dArray[j + 1]);
                        dArray5[n2] = dArray2[j] - d5 * (dArray2[j] - dArray2[j + 1]);
                        d5 = (dArray3[j] - d4) / (dArray3[j] - dArray3[j + 1]);
                        dArray4[++n2] = dArray[j] - d5 * (dArray[j] - dArray[j + 1]);
                        dArray5[n2] = dArray2[j] - d5 * (dArray2[j] - dArray2[j + 1]);
                        continue;
                    }
                    if (!(dArray3[j + 1] >= d4) || !(dArray3[j + 1] <= d3)) continue;
                    d5 = (dArray3[j] - d3) / (dArray3[j] - dArray3[j + 1]);
                    dArray4[++n2] = dArray[j] - d5 * (dArray[j] - dArray[j + 1]);
                    dArray5[n2] = dArray2[j] - d5 * (dArray2[j] - dArray2[j + 1]);
                    dArray4[++n2] = dArray[j + 1];
                    dArray5[n2] = dArray2[j + 1];
                    continue;
                }
                if (dArray3[j + 1] > d3) {
                    d5 = (dArray3[j] - d3) / (dArray3[j] - dArray3[j + 1]);
                    dArray4[++n2] = dArray[j] - d5 * (dArray[j] - dArray[j + 1]);
                    dArray5[n2] = dArray2[j] - d5 * (dArray2[j] - dArray2[j + 1]);
                    continue;
                }
                if (dArray3[j + 1] < d4) {
                    d5 = (dArray3[j] - d4) / (dArray3[j] - dArray3[j + 1]);
                    dArray4[++n2] = dArray[j] - d5 * (dArray[j] - dArray[j + 1]);
                    dArray5[n2] = dArray2[j] - d5 * (dArray2[j] - dArray2[j + 1]);
                    continue;
                }
                dArray4[++n2] = dArray[j + 1];
                dArray5[n2] = dArray2[j + 1];
            }
            this.fillPolygon(graphics, color, dArray4, dArray5, n2 + 1);
        }
    }

    private void fillPolygon(Graphics graphics, Color color, double[] dArray, double[] dArray2, int n) {
        Layer layer = this.cg_.getLayer();
        int[] nArray = new int[20];
        int[] nArray2 = new int[20];
        graphics.setColor(color);
        for (int i = 0; i < n; ++i) {
            nArray[i] = layer.getXPtoD(dArray[i]);
            nArray2[i] = layer.getYPtoD(dArray2[i]);
        }
        graphics.fillPolygon(nArray, nArray2, n);
    }

    private double[] xArrayP() {
        double[] dArray;
        if (this.grid_.isXTime()) {
            GeoDate[] geoDateArray = this.grid_.getTimeArray();
            dArray = new double[geoDateArray.length];
            for (int i = 0; i < geoDateArray.length; ++i) {
                dArray[i] = this.cg_.getXUtoP(geoDateArray[i]);
            }
        } else {
            double[] dArray2 = this.grid_.getXArray();
            dArray = new double[dArray2.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray[i] = this.cg_.getXUtoP(dArray2[i]);
            }
        }
        return dArray;
    }

    private double[] yArrayP() {
        double[] dArray;
        if (this.grid_.isYTime()) {
            GeoDate[] geoDateArray = this.grid_.getTimeArray();
            dArray = new double[geoDateArray.length];
            for (int i = 0; i < geoDateArray.length; ++i) {
                dArray[i] = this.cg_.getYUtoP(geoDateArray[i]);
            }
        } else {
            double[] dArray2 = this.grid_.getYArray();
            dArray = new double[dArray2.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray[i] = this.cg_.getYUtoP(dArray2[i]);
            }
        }
        return dArray;
    }

    private Range2D computeRange(int n) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double[] dArray = this.grid_.getZArray();
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            d = Math.min(d, dArray[i]);
            d2 = Math.max(d2, dArray[i]);
        }
        Range2D range2D = Graph.computeRange(d, d2, n);
        return range2D;
    }

    public SGTGrid getGrid() {
        return this.grid_;
    }

    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("GridCartesianRenderer: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    public SGTData getDataAt(Point point) {
        return null;
    }
}

