/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.AttributeChangeEvent;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevels;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class GridAttribute
implements Attribute,
Cloneable,
PropertyChangeListener {
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private static final long serialVersionUID = 3822340406728567524L;
    private boolean batch_ = false;
    private boolean local_ = true;
    private boolean modified_ = false;
    private String id_ = null;
    private ColorMap cmap_;
    private ContourLevels clev_;
    private int style_;
    public static final int RASTER = 0;
    public static final int AREA_FILL = 1;
    public static final int CONTOUR = 2;
    public static final int RASTER_CONTOUR = 3;
    public static final int AREA_FILL_CONTOUR = 4;

    public GridAttribute() {
        this(0, null);
    }

    public GridAttribute(int n, ColorMap colorMap) {
        this.style_ = n;
        this.cmap_ = colorMap;
        if (this.cmap_ != null) {
            this.cmap_.addPropertyChangeListener(this);
        }
    }

    public GridAttribute(ContourLevels contourLevels) {
        this.style_ = 2;
        this.cmap_ = null;
        this.clev_ = contourLevels;
    }

    public void setContourLevels(ContourLevels contourLevels) {
        if (this.clev_ == null || !this.clev_.equals(contourLevels)) {
            ContourLevels contourLevels2 = this.clev_;
            this.clev_ = contourLevels;
            this.firePropertyChange("contourLevels", contourLevels2, this.clev_);
        }
    }

    public ContourLevels getContourLevels() {
        return this.clev_;
    }

    public GridAttribute copy() {
        GridAttribute gridAttribute;
        try {
            gridAttribute = (GridAttribute)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            gridAttribute = new GridAttribute();
        }
        return gridAttribute;
    }

    public void setStyle(int n) {
        if (this.style_ != n) {
            Integer n2 = new Integer(this.style_);
            this.style_ = n;
            this.firePropertyChange("style", n2, new Integer(this.style_));
        }
    }

    public int getStyle() {
        return this.style_;
    }

    public boolean isRaster() {
        return this.style_ == 0 || this.style_ == 3;
    }

    public boolean isContour() {
        return this.style_ == 2 || this.style_ == 3 || this.style_ == 4;
    }

    public boolean isAreaFill() {
        return this.style_ == 1 || this.style_ == 4;
    }

    public ColorMap getColorMap() {
        return this.cmap_;
    }

    public void setColorMap(ColorMap colorMap) {
        if (this.cmap_ == null && colorMap == null) {
            return;
        }
        if (this.cmap_ != null) {
            this.cmap_.removePropertyChangeListener(this);
        }
        if (this.cmap_ == null || !this.cmap_.equals(colorMap)) {
            ColorMap colorMap2 = this.cmap_;
            this.cmap_ = colorMap;
            this.firePropertyChange("colorMap", colorMap2, this.cmap_);
            this.cmap_.addPropertyChangeListener(this);
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changes_.firePropertyChange(propertyChangeEvent);
    }

    public void setId(String string) {
        this.id_ = string;
    }

    public String getId() {
        return this.id_;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.batch_) {
            this.modified_ = true;
            return;
        }
        AttributeChangeEvent attributeChangeEvent = new AttributeChangeEvent(this, string, object, object2, this.local_);
        this.changes_.firePropertyChange(attributeChangeEvent);
        this.modified_ = false;
    }

    public void setBatch(boolean bl) {
        this.setBatch(bl, true);
    }

    public void setBatch(boolean bl, boolean bl2) {
        this.local_ = bl2;
        this.batch_ = bl;
        if (!bl && this.modified_) {
            this.firePropertyChange("batch", Boolean.TRUE, Boolean.FALSE);
        }
    }

    public boolean isBatch() {
        return this.batch_;
    }
}

