/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLineAttribute;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.MethodNotImplementedError;
import gov.noaa.pmel.util.Range2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ContourLevels
implements Cloneable {
    private DefaultContourLineAttribute defaultAttr_ = new DefaultContourLineAttribute();
    private Vector levels_ = new Vector();
    private Hashtable lineAttrMap_ = new Hashtable();
    private boolean sorted_ = false;
    private static ContourLineAttribute solid_ = new ContourLineAttribute(0);
    private static ContourLineAttribute heavy_ = new ContourLineAttribute(2);
    private static ContourLineAttribute dashed_ = new ContourLineAttribute(1);
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private ContourLineAttribute lnkLineAttribute;

    public static ContourLevels getDefault(double[] dArray) {
        ContourLevels contourLevels = new ContourLevels();
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            contourLevels.addLevel(dArray[i]);
        }
        return contourLevels;
    }

    public static ContourLevels getDefault(Range2D range2D) {
        ContourLevels contourLevels = new ContourLevels();
        for (double d = range2D.start; d <= range2D.end; d += range2D.delta) {
            contourLevels.addLevel(d);
        }
        return contourLevels;
    }

    public ContourLevels copy() {
        ContourLevels contourLevels;
        try {
            contourLevels = (ContourLevels)this.clone();
            contourLevels.levels_ = (Vector)this.levels_.clone();
            contourLevels.lineAttrMap_ = (Hashtable)this.lineAttrMap_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            contourLevels = null;
        }
        return contourLevels;
    }

    public Enumeration levelElements() {
        if (!this.sorted_) {
            this.sort();
        }
        return this.levels_.elements();
    }

    public void setContourLineAttribute(double d, ContourLineAttribute contourLineAttribute) throws ContourLevelNotFoundException {
        throw new MethodNotImplementedError();
    }

    public void setContourLineAttribute(int n, ContourLineAttribute contourLineAttribute) throws ContourLevelNotFoundException {
        throw new MethodNotImplementedError();
    }

    public ContourLineAttribute getContourLineAttribute(double d) throws ContourLevelNotFoundException {
        ContourLineAttribute contourLineAttribute = (ContourLineAttribute)this.lineAttrMap_.get(new Double(d));
        if (contourLineAttribute == null) {
            throw new ContourLevelNotFoundException();
        }
        return contourLineAttribute;
    }

    public ContourLineAttribute getContourLineAttribute(int n) throws ContourLevelNotFoundException {
        if (!this.sorted_) {
            this.sort();
        }
        return this.getContourLineAttribute(this.getLevel(n));
    }

    public DefaultContourLineAttribute getDefaultContourLineAttribute() {
        return this.defaultAttr_;
    }

    public DefaultContourLineAttribute getDefaultContourLineAttribute(int n) throws ContourLevelNotFoundException {
        if (!this.sorted_) {
            this.sort();
        }
        return this.defaultAttr_.setContourLineAttribute(this.getContourLineAttribute(this.getLevel(n)));
    }

    public DefaultContourLineAttribute getDefaultContourLineAttribute(double d) throws ContourLevelNotFoundException {
        if (!this.sorted_) {
            this.sort();
        }
        return this.defaultAttr_.setContourLineAttribute(this.getContourLineAttribute(d));
    }

    public void setDefaultContourLineAttribute(DefaultContourLineAttribute defaultContourLineAttribute) {
        this.defaultAttr_ = defaultContourLineAttribute;
    }

    public void addLevel(double d) {
        ContourLineAttribute contourLineAttribute = null;
        contourLineAttribute = d < 0.0 ? (ContourLineAttribute)dashed_.copy() : (d > 0.0 ? (ContourLineAttribute)solid_.copy() : (ContourLineAttribute)heavy_.copy());
        contourLineAttribute.setStyleOverridden(true);
        this.addLevel(d, contourLineAttribute);
    }

    public void addLevel(double d, ContourLineAttribute contourLineAttribute) {
        Double d2 = new Double(d);
        this.levels_.addElement(d2);
        this.lineAttrMap_.put(d2, contourLineAttribute);
        this.sorted_ = false;
    }

    public double getLevel(int n) throws ContourLevelNotFoundException {
        if (n < 0 || n >= this.levels_.size()) {
            throw new ContourLevelNotFoundException();
        }
        if (!this.sorted_) {
            this.sort();
        }
        Double d = (Double)this.levels_.elementAt(n);
        return d;
    }

    public void removeLevel(double d) throws ContourLevelNotFoundException {
        throw new MethodNotImplementedError();
    }

    public void removeLevel(int n) throws ContourLevelNotFoundException {
        throw new MethodNotImplementedError();
    }

    public int getIndex(Double d) {
        if (!this.sorted_) {
            this.sort();
        }
        return this.levels_.indexOf(d);
    }

    public int getIndex(double d) {
        if (!this.sorted_) {
            this.sort();
        }
        return this.getIndex(new Double(d));
    }

    public int getMaximumIndex() {
        return this.levels_.size() - 1;
    }

    public Range2D getRange() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < this.levels_.size(); ++i) {
            double d3 = (Double)this.levels_.get(i);
            d = Math.min(d, d3);
            d2 = Math.max(d2, d3);
        }
        return new Range2D(d, d2);
    }

    public int size() {
        return this.levels_.size();
    }

    private void sort() {
        int n;
        int n2 = this.levels_.size();
        int[] nArray = new int[n2];
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        while (bl) {
            bl = false;
            for (n = 0; n < n2 - 1; ++n) {
                Double d = (Double)this.levels_.elementAt(nArray[n]);
                Double d2 = (Double)this.levels_.elementAt(nArray[n + 1]);
                if (!(d > d2)) continue;
                int n3 = nArray[n];
                nArray[n] = nArray[n + 1];
                nArray[n + 1] = n3;
                bl = true;
            }
        }
        Vector vector = this.levels_;
        this.levels_ = new Vector(n2);
        for (n = 0; n < n2; ++n) {
            this.levels_.addElement(vector.elementAt(nArray[n]));
        }
        this.sorted_ = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }
}

