/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisNotFoundException;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.MethodNotImplementedError;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Vector;

public class CartesianGraph
extends Graph {
    protected Vector xAxis_ = new Vector(2, 2);
    protected Vector yAxis_ = new Vector(2, 2);
    protected AxisTransform xTransform_;
    protected AxisTransform yTransform_;
    protected boolean clipping_ = false;
    protected Range2D xClipRange_;
    protected Range2D yClipRange_;
    protected SoTRange.Time tClipRange_;
    private CartesianRenderer renderer_;

    public CartesianGraph() {
        this("");
    }

    public CartesianGraph(String string) {
        this(string, new LinearTransform(0.0, 1.0, 0.0, 1.0), new LinearTransform(0.0, 1.0, 0.0, 1.0));
    }

    public CartesianGraph(String string, AxisTransform axisTransform, AxisTransform axisTransform2) {
        super(string);
        this.xTransform_ = axisTransform;
        if (this.xTransform_ != null) {
            this.xTransform_.addPropertyChangeListener(this);
        }
        this.yTransform_ = axisTransform2;
        if (this.yTransform_ != null) {
            this.yTransform_.addPropertyChangeListener(this);
        }
    }

    public Graph copy() {
        throw new MethodNotImplementedError();
    }

    public void setData(SGTData sGTData, Attribute attribute) {
        this.renderer_ = CartesianRenderer.getRenderer(this, sGTData, attribute);
        sGTData.addPropertyChangeListener(this);
    }

    public CartesianRenderer getRenderer() {
        return this.renderer_;
    }

    public void setRenderer(CartesianRenderer cartesianRenderer) {
        this.renderer_ = cartesianRenderer;
    }

    public void draw(Graphics graphics) {
        Enumeration enumeration;
        if (this.renderer_ != null) {
            this.renderer_.draw(graphics);
        }
        if (!this.xAxis_.isEmpty()) {
            enumeration = this.xAxis_.elements();
            while (enumeration.hasMoreElements()) {
                ((Axis)enumeration.nextElement()).draw(graphics);
            }
        }
        if (!this.yAxis_.isEmpty()) {
            enumeration = this.yAxis_.elements();
            while (enumeration.hasMoreElements()) {
                ((Axis)enumeration.nextElement()).draw(graphics);
            }
        }
    }

    public void setClip(double d, double d2, double d3, double d4) {
        if (this.xTransform_.isSpace() && this.yTransform_.isSpace()) {
            this.clipping_ = true;
            this.xClipRange_ = new Range2D(d, d2);
            this.yClipRange_ = new Range2D(d3, d4);
        } else {
            this.clipping_ = false;
        }
    }

    public void setClip(GeoDate geoDate, GeoDate geoDate2, double d, double d2) {
        if (this.xTransform_.isTime() || this.yTransform_.isTime()) {
            this.clipping_ = true;
            this.tClipRange_ = new SoTRange.Time(geoDate.getTime(), geoDate2.getTime());
            if (this.xTransform_.isTime()) {
                this.yClipRange_ = new Range2D(d, d2);
            } else {
                this.xClipRange_ = new Range2D(d, d2);
            }
        } else {
            this.clipping_ = false;
        }
    }

    public void setClip(long l, long l2, double d, double d2) {
        if (this.xTransform_.isTime() || this.yTransform_.isTime()) {
            this.clipping_ = true;
            this.tClipRange_ = new SoTRange.Time(l, l2);
            if (this.xTransform_.isTime()) {
                this.yClipRange_ = new Range2D(d, d2);
            } else {
                this.xClipRange_ = new Range2D(d, d2);
            }
        } else {
            this.clipping_ = false;
        }
    }

    public void setClip(SoTRange soTRange, SoTRange soTRange2) {
        if (soTRange.isTime() || soTRange2.isTime()) {
            SoTRange.Double double_;
            long l;
            long l2;
            if (soTRange.isTime()) {
                l2 = soTRange.getStart().getLongTime();
                l = soTRange.getEnd().getLongTime();
                double_ = (SoTRange.Double)soTRange2;
            } else {
                l2 = soTRange2.getStart().getLongTime();
                l = soTRange2.getEnd().getLongTime();
                double_ = (SoTRange.Double)soTRange;
            }
            this.setClip(l2, l, double_.start, double_.end);
        } else {
            SoTRange.Double double_ = (SoTRange.Double)soTRange;
            SoTRange.Double double_2 = (SoTRange.Double)soTRange2;
            this.setClip(double_.start, double_.end, double_2.start, double_2.end);
        }
    }

    public void setClipping(boolean bl) {
        this.clipping_ = bl;
    }

    public boolean isClipping() {
        return this.clipping_;
    }

    public void addXAxis(String string, Axis axis) {
        if (string.length() != 0) {
            axis.setId(string);
        }
        this.addXAxis(axis);
    }

    public void addXAxis(Axis axis) {
        axis.setOrientation(0);
        axis.setGraph(this);
        this.xAxis_.addElement(axis);
    }

    public Axis getXAxis(String string) throws AxisNotFoundException {
        if (!this.xAxis_.isEmpty()) {
            Enumeration enumeration = this.xAxis_.elements();
            while (enumeration.hasMoreElements()) {
                Axis axis = (Axis)enumeration.nextElement();
                if (axis.getId() != string) continue;
                return axis;
            }
            throw new AxisNotFoundException();
        }
        throw new AxisNotFoundException();
    }

    public void removeXAxis(String string) throws AxisNotFoundException {
        if (!this.xAxis_.isEmpty()) {
            Enumeration enumeration = this.xAxis_.elements();
            while (enumeration.hasMoreElements()) {
                Axis axis = (Axis)enumeration.nextElement();
                if (axis.getId() != string) continue;
                this.xAxis_.removeElement(axis);
            }
            throw new AxisNotFoundException();
        }
        throw new AxisNotFoundException();
    }

    public void removeXAxis(Axis axis) throws AxisNotFoundException {
        if (!this.xAxis_.isEmpty()) {
            Enumeration enumeration = this.xAxis_.elements();
            while (enumeration.hasMoreElements()) {
                Axis axis2 = (Axis)enumeration.nextElement();
                if (!axis2.equals(axis)) continue;
                this.xAxis_.removeElement(axis2);
            }
            throw new AxisNotFoundException();
        }
        throw new AxisNotFoundException();
    }

    public void removeAllXAxes() {
        this.xAxis_.removeAllElements();
    }

    public int getNumberXAxis() {
        return this.xAxis_.size();
    }

    public Enumeration xAxisElements() {
        return this.xAxis_.elements();
    }

    public void addYAxis(String string, Axis axis) {
        if (string.length() != 0) {
            axis.setId(string);
        }
        this.addYAxis(axis);
    }

    public void addYAxis(Axis axis) {
        axis.setOrientation(1);
        axis.setGraph(this);
        this.yAxis_.addElement(axis);
    }

    public Axis getYAxis(String string) throws AxisNotFoundException {
        if (!this.yAxis_.isEmpty()) {
            Enumeration enumeration = this.yAxis_.elements();
            while (enumeration.hasMoreElements()) {
                Axis axis = (Axis)enumeration.nextElement();
                if (axis.getId() != string) continue;
                return axis;
            }
            throw new AxisNotFoundException();
        }
        throw new AxisNotFoundException();
    }

    public void removeYAxis(String string) throws AxisNotFoundException {
        if (!this.yAxis_.isEmpty()) {
            Enumeration enumeration = this.yAxis_.elements();
            while (enumeration.hasMoreElements()) {
                Axis axis = (Axis)enumeration.nextElement();
                if (axis.getId() != string) continue;
                this.yAxis_.removeElement(axis);
            }
            throw new AxisNotFoundException();
        }
        throw new AxisNotFoundException();
    }

    public void removeYAxis(Axis axis) throws AxisNotFoundException {
        if (!this.yAxis_.isEmpty()) {
            Enumeration enumeration = this.yAxis_.elements();
            while (enumeration.hasMoreElements()) {
                Axis axis2 = (Axis)enumeration.nextElement();
                if (!axis2.equals(axis)) continue;
                this.yAxis_.removeElement(axis2);
            }
            throw new AxisNotFoundException();
        }
        throw new AxisNotFoundException();
    }

    public void removeAllYAxes() {
        this.yAxis_.removeAllElements();
    }

    public int getNumberYAxis() {
        return this.yAxis_.size();
    }

    public Enumeration yAxisElements() {
        return this.yAxis_.elements();
    }

    public void setXTransform(AxisTransform axisTransform) {
        if (this.xTransform_ != null) {
            this.xTransform_.removePropertyChangeListener(this);
        }
        this.xTransform_ = axisTransform;
        this.xTransform_.addPropertyChangeListener(this);
    }

    public AxisTransform getXTransform() {
        return this.xTransform_;
    }

    public void setYTransform(AxisTransform axisTransform) {
        if (this.yTransform_ != null) {
            this.yTransform_.removePropertyChangeListener(this);
        }
        this.yTransform_ = axisTransform;
        this.yTransform_.addPropertyChangeListener(this);
    }

    public AxisTransform getYTransform() {
        return this.yTransform_;
    }

    Object getObjectAt(Point point) {
        SGLabel sGLabel;
        Rectangle rectangle;
        Axis axis;
        Enumeration enumeration;
        if (!this.xAxis_.isEmpty()) {
            enumeration = this.xAxis_.elements();
            while (enumeration.hasMoreElements()) {
                axis = (Axis)enumeration.nextElement();
                rectangle = axis.getBounds();
                if (rectangle.contains(point)) {
                    return axis;
                }
                sGLabel = axis.getTitle();
                if (sGLabel == null || sGLabel.getLayer() == null || !(rectangle = sGLabel.getBounds()).contains(point)) continue;
                return sGLabel;
            }
        }
        if (!this.yAxis_.isEmpty()) {
            enumeration = this.yAxis_.elements();
            while (enumeration.hasMoreElements()) {
                axis = (Axis)enumeration.nextElement();
                rectangle = axis.getBounds();
                if (rectangle.contains(point)) {
                    return axis;
                }
                sGLabel = axis.getTitle();
                if (sGLabel == null || !(rectangle = sGLabel.getBounds()).contains(point)) continue;
                return sGLabel;
            }
        }
        return null;
    }

    public double getXUtoP(double d) {
        return this.xTransform_.getTransP(d);
    }

    public int getXUtoD(double d) {
        if (Double.isNaN(d)) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getXPtoD(this.xTransform_.getTransP(d));
    }

    public double getXUtoD2(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        return this.getLayer().getXPtoD2(this.xTransform_.getTransP(d));
    }

    public double getXUtoP(GeoDate geoDate) {
        return this.xTransform_.getTransP(geoDate);
    }

    public double getXUtoP(long l) {
        return this.xTransform_.getTransP(l);
    }

    public int getXUtoD(GeoDate geoDate) {
        if (geoDate == null) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getXPtoD(this.xTransform_.getTransP(geoDate));
    }

    public int getXUtoD(long l) {
        if (l == Long.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getXPtoD(this.xTransform_.getTransP(l));
    }

    public double getXUtoD2(GeoDate geoDate) {
        if (geoDate == null) {
            return Double.NaN;
        }
        return this.getLayer().getXPtoD2(this.xTransform_.getTransP(geoDate));
    }

    public double getXUtoD2(long l) {
        if (l == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return this.getLayer().getXPtoD2(this.xTransform_.getTransP(l));
    }

    public int getXUtoD(SoTValue soTValue) {
        if (soTValue.isTime()) {
            return this.getXUtoD(soTValue.getLongTime());
        }
        return this.getXUtoD(((SoTValue.Double)soTValue).getValue());
    }

    public int getYUtoD(SoTValue soTValue) {
        if (soTValue.isTime()) {
            return this.getYUtoD(soTValue.getLongTime());
        }
        return this.getYUtoD(((SoTValue.Double)soTValue).getValue());
    }

    public double getXUtoD2(SoTValue soTValue) {
        if (soTValue.isTime()) {
            return this.getXUtoD2(soTValue.getLongTime());
        }
        return this.getXUtoD2(((SoTValue.Double)soTValue).getValue());
    }

    public double getYUtoD2(SoTValue soTValue) {
        if (soTValue.isTime()) {
            return this.getYUtoD2(soTValue.getLongTime());
        }
        return this.getYUtoD2(((SoTValue.Double)soTValue).getValue());
    }

    public double getXUtoP(SoTValue soTValue) {
        if (soTValue.isTime()) {
            return this.getXUtoP(soTValue.getLongTime());
        }
        return this.getXUtoP(((SoTValue.Double)soTValue).getValue());
    }

    public double getYUtoP(SoTValue soTValue) {
        if (soTValue.isTime()) {
            return this.getYUtoP(soTValue.getLongTime());
        }
        return this.getYUtoP(((SoTValue.Double)soTValue).getValue());
    }

    public SoTValue getXPtoSoT(double d) {
        if (this.xTransform_.isTime()) {
            return new SoTValue.Time(this.xTransform_.getLongTimeTransU(d));
        }
        return new SoTValue.Double(this.xTransform_.getTransU(d));
    }

    public double getXPtoU(double d) {
        return this.xTransform_.getTransU(d);
    }

    public GeoDate getXPtoTime(double d) {
        return this.xTransform_.getTimeTransU(d);
    }

    public long getXPtoLongTime(double d) {
        return this.xTransform_.getLongTimeTransU(d);
    }

    public SoTPoint getPtoU(Point2D.Double double_) {
        SoTValue soTValue = this.xTransform_.isTime() ? new SoTValue.Time(this.getXPtoLongTime(double_.x)) : new SoTValue.Double(this.getXPtoU(double_.x));
        SoTValue soTValue2 = this.yTransform_.isTime() ? new SoTValue.Time(this.getYPtoLongTime(double_.y)) : new SoTValue.Double(this.getYPtoU(double_.y));
        return new SoTPoint(soTValue, soTValue2);
    }

    public double getYUtoP(double d) {
        return this.yTransform_.getTransP(d);
    }

    public int getYUtoD(double d) {
        if (Double.isNaN(d)) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getYPtoD(this.yTransform_.getTransP(d));
    }

    public double getYUtoD2(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        return this.getLayer().getYPtoD2(this.yTransform_.getTransP(d));
    }

    public double getYUtoP(GeoDate geoDate) {
        return this.yTransform_.getTransP(geoDate);
    }

    public double getYUtoP(long l) {
        if (l == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return this.yTransform_.getTransP(l);
    }

    public int getYUtoD(GeoDate geoDate) {
        if (geoDate == null) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getYPtoD(this.yTransform_.getTransP(geoDate));
    }

    public int getYUtoD(long l) {
        if (l == Long.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getYPtoD(this.yTransform_.getTransP(l));
    }

    public double getYUtoD2(GeoDate geoDate) {
        if (geoDate == null) {
            return Double.NaN;
        }
        return this.getLayer().getYPtoD2(this.yTransform_.getTransP(geoDate));
    }

    public double getYUtoD2(long l) {
        if (l == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return this.getLayer().getYPtoD2(this.yTransform_.getTransP(l));
    }

    public SoTValue getYPtoSoT(double d) {
        if (this.yTransform_.isTime()) {
            return new SoTValue.Time(this.yTransform_.getLongTimeTransU(d));
        }
        return new SoTValue.Double(this.yTransform_.getTransU(d));
    }

    public double getYPtoU(double d) {
        return this.yTransform_.getTransU(d);
    }

    public GeoDate getYPtoTime(double d) {
        return this.yTransform_.getTimeTransU(d);
    }

    public long getYPtoLongTime(double d) {
        return this.yTransform_.getLongTimeTransU(d);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("CartesianGraph: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    public SGTData getDataAt(Point point) {
        return this.renderer_.getDataAt(point);
    }
}

