/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLevelsAccess;
import gov.noaa.pmel.sgt.IndexedColor;
import gov.noaa.pmel.util.Range2D;
import java.awt.Color;
import java.beans.PropertyChangeListener;

public class CLIndexedColorMap
extends ColorMap
implements Cloneable,
PropertyChangeListener,
IndexedColor,
ContourLevelsAccess {
    protected Color[] colors_;
    protected ContourLevels cl_ = null;

    public CLIndexedColorMap(int[] nArray, int[] nArray2, int[] nArray3) {
        this.colors_ = new Color[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.colors_[i] = new Color(nArray[i], nArray2[i], nArray3[i]);
        }
    }

    public CLIndexedColorMap(float[] fArray, float[] fArray2, float[] fArray3) {
        this.colors_ = new Color[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.colors_[i] = new Color(fArray[i], fArray2[i], fArray3[i]);
        }
    }

    public CLIndexedColorMap(Color[] colorArray) {
        this.colors_ = colorArray;
    }

    public ColorMap copy() {
        ColorMap colorMap;
        try {
            colorMap = (ColorMap)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            colorMap = new CLIndexedColorMap(this.colors_);
        }
        return colorMap;
    }

    public Color getColorByIndex(int n) {
        if (this.cl_ != null) {
            try {
                return this.getColor(this.cl_.getLevel(n));
            }
            catch (ContourLevelNotFoundException contourLevelNotFoundException) {
                return this.colors_[this.colors_.length - 1];
            }
        }
        return Color.white;
    }

    public Color getColor(double d) {
        double d2 = d;
        int n = this.cl_.getIndex(d2);
        if (n < 0) {
            n = 0;
        }
        if (n > this.colors_.length - 1) {
            n = this.colors_.length - 1;
        }
        return this.colors_[n];
    }

    public Range2D getRange() {
        return this.cl_.getRange();
    }

    public void setColor(int n, Color color) {
        this.setColor(n, color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setColor(int n, int n2, int n3, int n4) {
        if (n < 0 || n > this.colors_.length) {
            return;
        }
        Color color = new Color(n2, n3, n4);
        if (!this.colors_[n].equals(color)) {
            Color color2 = this.colors_[n];
            this.colors_[n] = color;
            this.firePropertyChange("color", color2, color);
        }
    }

    public int getMaximumIndex() {
        return this.colors_.length - 1;
    }

    public void setContourLevels(ContourLevels contourLevels) {
        if (this.cl_ == null || !this.cl_.equals(contourLevels)) {
            ContourLevels contourLevels2 = this.cl_;
            this.cl_ = contourLevels;
            this.firePropertyChange("contourLevels", contourLevels2, this.cl_);
        }
    }

    public ContourLevels getContourLevels() {
        return this.cl_;
    }

    public boolean equals(ColorMap colorMap) {
        if (colorMap == null || !(colorMap instanceof CLIndexedColorMap)) {
            return false;
        }
        if (this.cl_ == null || !this.cl_.equals(((CLIndexedColorMap)colorMap).cl_)) {
            return false;
        }
        if (this.colors_.length != ((CLIndexedColorMap)colorMap).colors_.length) {
            return false;
        }
        for (int i = 0; i < this.colors_.length; ++i) {
            if (this.colors_[i].equals(((CLIndexedColorMap)colorMap).colors_[i])) continue;
            return false;
        }
        return true;
    }
}

